/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api;

import java.nio.ByteBuffer;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.IEssentiaTransport;

public class ThaumcraftApiHelper {
    public static boolean areItemsEqual(ItemStack s1, ItemStack s2) {
        if (s1.func_77984_f() && s2.func_77984_f()) {
            return s1.func_77973_b() == s2.func_77973_b();
        }
        return s1.func_77973_b() == s2.func_77973_b() && s1.func_77952_i() == s2.func_77952_i();
    }

    public static void markRunicDirty(Entity entity) {
        ThaumcraftApi.internalMethods.markRunicDirty(entity);
    }

    public static boolean containsMatch(boolean strict, ItemStack[] inputs, List<ItemStack> targets) {
        for (ItemStack input : inputs) {
            for (ItemStack target : targets) {
                if (!OreDictionary.itemMatches((ItemStack)target, (ItemStack)input, (boolean)strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean areItemStacksEqualForCrafting(ItemStack stack0, Object in) {
        if (stack0 == null && in != null) {
            return false;
        }
        if (stack0 != null && in == null) {
            return false;
        }
        if (stack0 == null && in == null) {
            return true;
        }
        if (in instanceof Object[]) {
            return true;
        }
        if (in instanceof String) {
            List l = OreDictionary.getOres((String)((String)in));
            return ThaumcraftApiHelper.containsMatch(false, new ItemStack[]{stack0}, l);
        }
        if (in instanceof ItemStack) {
            boolean t1 = ThaumcraftApiHelper.areItemStackTagsEqualForCrafting(stack0, (ItemStack)in);
            if (!t1) {
                return false;
            }
            return OreDictionary.itemMatches((ItemStack)((ItemStack)in), (ItemStack)stack0, (boolean)false);
        }
        return false;
    }

    public static boolean areItemStackTagsEqualForCrafting(ItemStack slotItem, ItemStack recipeItem) {
        if (recipeItem == null || slotItem == null) {
            return false;
        }
        if (recipeItem.func_77978_p() != null && slotItem.func_77978_p() == null) {
            return false;
        }
        if (recipeItem.func_77978_p() == null) {
            return true;
        }
        for (String s : recipeItem.func_77978_p().func_150296_c()) {
            if (slotItem.func_77978_p().func_74764_b(s)) {
                if (slotItem.func_77978_p().func_74781_a(s).toString().equals(recipeItem.func_77978_p().func_74781_a(s).toString())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static TileEntity getConnectableTile(World world, BlockPos pos, EnumFacing face) {
        TileEntity te = world.func_175625_s(pos.func_177972_a(face));
        if (te instanceof IEssentiaTransport && ((IEssentiaTransport)te).isConnectable(face.func_176734_d())) {
            return te;
        }
        return null;
    }

    public static TileEntity getConnectableTile(IBlockAccess world, BlockPos pos, EnumFacing face) {
        TileEntity te = world.func_175625_s(pos.func_177972_a(face));
        if (te instanceof IEssentiaTransport && ((IEssentiaTransport)te).isConnectable(face.func_176734_d())) {
            return te;
        }
        return null;
    }

    public static MovingObjectPosition rayTraceIgnoringSource(World world, Vec3 v1, Vec3 v2, boolean bool1, boolean bool2, boolean bool3) {
        if (!(Double.isNaN(v1.field_72450_a) || Double.isNaN(v1.field_72448_b) || Double.isNaN(v1.field_72449_c))) {
            if (!(Double.isNaN(v2.field_72450_a) || Double.isNaN(v2.field_72448_b) || Double.isNaN(v2.field_72449_c))) {
                int i = MathHelper.func_76128_c((double)v2.field_72450_a);
                int j = MathHelper.func_76128_c((double)v2.field_72448_b);
                int k = MathHelper.func_76128_c((double)v2.field_72449_c);
                int l = MathHelper.func_76128_c((double)v1.field_72450_a);
                int i1 = MathHelper.func_76128_c((double)v1.field_72448_b);
                int j1 = MathHelper.func_76128_c((double)v1.field_72449_c);
                IBlockState block = world.func_180495_p(new BlockPos(l, i1, j1));
                MovingObjectPosition movingobjectposition2 = null;
                int k1 = 200;
                while (k1-- >= 0) {
                    EnumFacing enumfacing;
                    if (Double.isNaN(v1.field_72450_a) || Double.isNaN(v1.field_72448_b) || Double.isNaN(v1.field_72449_c)) {
                        return null;
                    }
                    if (l == i && i1 == j && j1 == k) continue;
                    boolean flag6 = true;
                    boolean flag3 = true;
                    boolean flag4 = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (i > l) {
                        d0 = (double)l + 1.0;
                    } else if (i < l) {
                        d0 = (double)l + 0.0;
                    } else {
                        flag6 = false;
                    }
                    if (j > i1) {
                        d1 = (double)i1 + 1.0;
                    } else if (j < i1) {
                        d1 = (double)i1 + 0.0;
                    } else {
                        flag3 = false;
                    }
                    if (k > j1) {
                        d2 = (double)j1 + 1.0;
                    } else if (k < j1) {
                        d2 = (double)j1 + 0.0;
                    } else {
                        flag4 = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = v2.field_72450_a - v1.field_72450_a;
                    double d7 = v2.field_72448_b - v1.field_72448_b;
                    double d8 = v2.field_72449_c - v1.field_72449_c;
                    if (flag6) {
                        d3 = (d0 - v1.field_72450_a) / d6;
                    }
                    if (flag3) {
                        d4 = (d1 - v1.field_72448_b) / d7;
                    }
                    if (flag4) {
                        d5 = (d2 - v1.field_72449_c) / d8;
                    }
                    if (d3 == -0.0) {
                        d3 = -1.0E-4;
                    }
                    if (d4 == -0.0) {
                        d4 = -1.0E-4;
                    }
                    if (d5 == -0.0) {
                        d5 = -1.0E-4;
                    }
                    if (d3 < d4 && d3 < d5) {
                        enumfacing = i > l ? EnumFacing.WEST : EnumFacing.EAST;
                        v1 = new Vec3(d0, v1.field_72448_b + d7 * d3, v1.field_72449_c + d8 * d3);
                    } else if (d4 < d5) {
                        enumfacing = j > i1 ? EnumFacing.DOWN : EnumFacing.UP;
                        v1 = new Vec3(v1.field_72450_a + d6 * d4, d1, v1.field_72449_c + d8 * d4);
                    } else {
                        enumfacing = k > j1 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                        v1 = new Vec3(v1.field_72450_a + d6 * d5, v1.field_72448_b + d7 * d5, d2);
                    }
                    l = MathHelper.func_76128_c((double)v1.field_72450_a) - (enumfacing == EnumFacing.EAST ? 1 : 0);
                    i1 = MathHelper.func_76128_c((double)v1.field_72448_b) - (enumfacing == EnumFacing.UP ? 1 : 0);
                    j1 = MathHelper.func_76128_c((double)v1.field_72449_c) - (enumfacing == EnumFacing.SOUTH ? 1 : 0);
                    IBlockState block1 = world.func_180495_p(new BlockPos(l, i1, j1));
                    if (bool2 && block1.func_177230_c().func_180640_a(world, new BlockPos(l, i1, j1), block1) == null) continue;
                    if (block1.func_177230_c().func_176209_a(block1, bool1)) {
                        MovingObjectPosition movingobjectposition1 = block1.func_177230_c().func_180636_a(world, new BlockPos(l, i1, j1), v1, v2);
                        if (movingobjectposition1 == null) continue;
                        return movingobjectposition1;
                    }
                    movingobjectposition2 = new MovingObjectPosition(MovingObjectPosition.MovingObjectType.MISS, v1, enumfacing, new BlockPos(l, i1, j1));
                }
                return bool3 ? movingobjectposition2 : null;
            }
            return null;
        }
        return null;
    }

    public static Object getNBTDataFromId(NBTTagCompound nbt, byte id, String key) {
        switch (id) {
            case 1: {
                return nbt.func_74771_c(key);
            }
            case 2: {
                return nbt.func_74765_d(key);
            }
            case 3: {
                return nbt.func_74762_e(key);
            }
            case 4: {
                return nbt.func_74763_f(key);
            }
            case 5: {
                return Float.valueOf(nbt.func_74760_g(key));
            }
            case 6: {
                return nbt.func_74769_h(key);
            }
            case 7: {
                return nbt.func_74770_j(key);
            }
            case 8: {
                return nbt.func_74779_i(key);
            }
            case 9: {
                return nbt.func_150295_c(key, 10);
            }
            case 10: {
                return nbt.func_74781_a(key);
            }
            case 11: {
                return nbt.func_74759_k(key);
            }
        }
        return null;
    }

    public static int setByteInInt(int data, byte b, int index) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(0, data);
        bb.put(index, b);
        return bb.getInt(0);
    }

    public static byte getByteInInt(int data, int index) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(0, data);
        return bb.get(index);
    }

    public static long setByteInLong(long data, byte b, int index) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.putLong(0, data);
        bb.put(index, b);
        return bb.getLong(0);
    }

    public static byte getByteInLong(long data, int index) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.putLong(0, data);
        return bb.get(index);
    }

    public static int setNibbleInInt(int data, int nibble, int nibbleIndex) {
        int shift = nibbleIndex * 4;
        return data & ~(15 << shift) | nibble << shift;
    }

    public static int getNibbleInInt(int data, int nibbleIndex) {
        return data >> (nibbleIndex << 2) & 0xF;
    }
}

