/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.fx.particles;

import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.lib.utils.TCVec3;

public class FXGeneric
extends EntityFX {
    int layer = 0;
    boolean loop = false;
    protected float particleScaleMod = 0.0f;
    float rotationSpeed = 0.0f;
    float rotation = 0.0f;
    int delay = 0;
    int startParticle = 0;
    int numParticles = 1;
    int particleInc = 1;
    float particleAlphaMod = 0.0f;
    double slowDown = 0.98f;
    int gridSize = 16;
    double windX;
    double windZ;

    public FXGeneric(World world, double x, double y, double z, double xx, double yy, double zz) {
        super(world, x, y, z, xx, yy, zz);
        this.func_70105_a(0.1f, 0.1f);
        this.func_70107_b(x, y, z);
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70142_S = x;
        this.field_70137_T = y;
        this.field_70136_U = z;
        this.field_70548_b = 0.0f;
        this.field_70549_c = 0.0f;
        this.field_70159_w = xx;
        this.field_70181_x = yy;
        this.field_70179_y = zz;
        this.field_70145_X = true;
    }

    public void setLayer(int layer) {
        this.layer = layer;
    }

    public int func_70537_b() {
        return this.layer;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public void setScale(float scale) {
        this.field_70544_f = scale;
    }

    public void setScale(float scale, float end) {
        this.field_70544_f = scale;
        this.particleScaleMod = (scale - end) / (float)this.field_70547_e;
    }

    public void setRotationSpeed(float rot) {
        this.rotationSpeed = rot;
    }

    public void setRotationSpeed(float start, float rot) {
        this.rotation = start;
        this.rotationSpeed = rot;
    }

    public void setMaxAge(int max, int delay) {
        this.field_70547_e = max;
        this.field_70547_e += delay;
        this.delay = delay;
    }

    public void setParticles(int startParticle, int numParticles, int particleInc) {
        this.startParticle = startParticle;
        this.numParticles = numParticles;
        this.particleInc = particleInc;
        this.func_70536_a(startParticle);
    }

    public void func_82338_g(float a1) {
        super.func_82338_g(a1);
        this.particleAlphaMod = 0.0f;
    }

    public void setAlphaF(float a1, float a2) {
        super.func_82338_g(a1);
        this.particleAlphaMod = (a1 - a2) / (float)this.field_70547_e;
    }

    public void setSlowDown(double slowDown) {
        this.slowDown = slowDown;
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_70106_y();
        }
        this.rotation += this.rotationSpeed;
        this.field_70181_x -= 0.04 * (double)this.field_70545_g;
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= this.slowDown;
        this.field_70181_x *= this.slowDown;
        this.field_70179_y *= this.slowDown;
        this.field_70159_w += this.windX;
        this.field_70179_y += this.windZ;
        if (this.field_70122_E && this.slowDown != 1.0) {
            this.field_70159_w *= (double)0.7f;
            this.field_70179_y *= (double)0.7f;
        }
    }

    public void setGravity(float g) {
        this.field_70545_g = g;
    }

    public void func_70536_a(int p_70536_1_) {
        this.field_94054_b = p_70536_1_ % this.gridSize;
        this.field_94055_c = p_70536_1_ / this.gridSize;
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    public void func_180434_a(WorldRenderer wr, Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        if (this.loop) {
            this.func_70536_a(this.startParticle + this.field_70546_d / this.particleInc % this.numParticles);
        } else {
            float fs = (float)this.field_70546_d / (float)this.field_70547_e;
            this.func_70536_a((int)((float)this.startParticle + Math.min((float)this.numParticles * fs, (float)(this.numParticles - 1))));
        }
        if (this.field_70546_d < this.delay) {
            return;
        }
        this.field_82339_as -= this.particleAlphaMod;
        float t = this.field_82339_as;
        if (this.field_70546_d <= 1 || this.field_70546_d >= this.field_70547_e - 1) {
            this.field_82339_as = t / 2.0f;
        }
        if (this.field_82339_as < 0.0f) {
            this.field_82339_as = 0.0f;
        }
        if (this.field_82339_as > 1.0f) {
            this.field_82339_as = 1.0f;
        }
        this.field_70544_f -= this.particleScaleMod;
        if (this.field_70544_f < 0.0f) {
            this.field_70544_f = 0.0f;
        }
        this.draw(wr, entity, f, f1, f2, f3, f4, f5);
        this.field_82339_as = t;
    }

    public void draw(WorldRenderer wr, Entity p_180434_2_, float pticks, float p_180434_4_, float p_180434_5_, float p_180434_6_, float p_180434_7_, float p_180434_8_) {
        float f6 = (float)this.field_94054_b / (float)this.gridSize;
        float f7 = f6 + 1.0f / (float)this.gridSize;
        float f8 = (float)this.field_94055_c / (float)this.gridSize;
        float f9 = f8 + 1.0f / (float)this.gridSize;
        float f10 = 0.1f * this.field_70544_f;
        if (this.field_70550_a != null) {
            f6 = this.field_70550_a.func_94209_e();
            f7 = this.field_70550_a.func_94212_f();
            f8 = this.field_70550_a.func_94206_g();
            f9 = this.field_70550_a.func_94210_h();
        }
        Tessellator.func_178181_a().func_78381_a();
        GL11.glPushMatrix();
        float f11 = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)pticks - field_70556_an);
        float f12 = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)pticks - field_70554_ao);
        float f13 = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)pticks - field_70555_ap);
        GL11.glTranslated((double)f11, (double)f12, (double)f13);
        GL11.glPushMatrix();
        UtilsFX.rotateToPlayer();
        GL11.glRotatef((float)(this.rotation + pticks * this.rotationSpeed), (float)0.0f, (float)0.0f, (float)1.0f);
        int i = this.func_70070_b(pticks);
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        wr.func_181668_a(7, DefaultVertexFormats.field_181704_d);
        wr.func_181662_b((double)(-f10), (double)(-f10), 0.0).func_181673_a((double)f7, (double)f9).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_181671_a(j, k).func_181675_d();
        wr.func_181662_b((double)(-f10), (double)f10, 0.0).func_181673_a((double)f7, (double)f8).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_181671_a(j, k).func_181675_d();
        wr.func_181662_b((double)f10, (double)f10, 0.0).func_181673_a((double)f6, (double)f8).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_181671_a(j, k).func_181675_d();
        wr.func_181662_b((double)f10, (double)(-f10), 0.0).func_181673_a((double)f6, (double)f9).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_181671_a(j, k).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        wr.func_181668_a(7, DefaultVertexFormats.field_181704_d);
    }

    public void setWind(double d) {
        int m = this.field_70170_p.func_72853_d();
        TCVec3 vsource = TCVec3.createVectorHelper(0.0, 0.0, 0.0);
        TCVec3 vtar = TCVec3.createVectorHelper(0.1, 0.0, 0.0);
        vtar.rotateAroundY((float)(m * (40 + this.field_70170_p.field_73012_v.nextInt(10))) / 180.0f * (float)Math.PI);
        TCVec3 vres = vsource.addVector(vtar.xCoord, vtar.yCoord, vtar.zCoord);
        this.windX = vres.xCoord * d;
        this.windZ = vres.zCoord * d;
    }
}

