/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.lib.models;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ISmartBlockModel;
import net.minecraftforge.client.model.ISmartItemModel;
import thaumcraft.client.lib.models.IInitializeBakedModel;
import thaumcraft.client.lib.models.MeshLoader;
import thaumcraft.client.lib.models.MeshModel;

public class CustomMeshModel
implements ISmartItemModel,
ISmartBlockModel,
IInitializeBakedModel {
    String variant;
    ResourceLocation model;
    ItemCameraTransforms transforms;
    List<BakedQuad> faceQuads;
    List<BakedQuad> generalQuads;
    MeshModel sourceMesh;
    TextureAtlasSprite iconSprite;

    public CustomMeshModel(String variant) {
        this.variant = variant;
        this.model = new ResourceLocation("Thaumcraft", "models/obj/" + variant + ".obj");
        this.faceQuads = new ArrayList<BakedQuad>();
        this.generalQuads = new ArrayList<BakedQuad>();
        try {
            this.generalQuads.clear();
            this.sourceMesh = new MeshLoader().loadFromResource(this.model);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize(ItemCameraTransforms cameraTransforms, ResourceLocation icon, ModelManager modelManager) {
        this.transforms = cameraTransforms;
        this.iconSprite = modelManager.func_174952_b().func_110572_b(icon.toString());
        this.generalQuads = this.sourceMesh.bakeModel(modelManager);
    }

    public IBakedModel handleItemState(ItemStack stack) {
        return this;
    }

    public IBakedModel handleBlockState(IBlockState state) {
        return this;
    }

    public List func_177551_a(EnumFacing face) {
        return this.faceQuads;
    }

    public List func_177550_a() {
        return this.generalQuads;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_177553_d() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.iconSprite;
    }

    public ItemCameraTransforms func_177552_f() {
        return this.transforms;
    }
}

