/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.lib.models;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.util.IRegistry;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thaumcraft.client.lib.models.IInitializeBakedModel;

public class ModelRegistrationHelper {
    protected List<ResourceLocation> itemTextures = new ArrayList<ResourceLocation>();
    protected List<ResourceLocation> blockTextures = new ArrayList<ResourceLocation>();
    protected Map<ResourceLocation, IBakedModel> itemsToInject = new Hashtable<ResourceLocation, IBakedModel>();
    protected Map<ResourceLocation, IBakedModel> blocksToInject = new Hashtable<ResourceLocation, IBakedModel>();

    public ModelRegistrationHelper() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void registerCustomItemModel(ResourceLocation resourceLocation, IBakedModel bakedModel, String itemName) {
        this.itemsToInject.put(resourceLocation, bakedModel);
    }

    public void registerCustomBlockModel(ResourceLocation resourceLocation, IBakedModel bakedModel, String blockName) {
        this.blocksToInject.put(resourceLocation, bakedModel);
    }

    public void registerItemSprite(ResourceLocation resourceLocation) {
        if (!this.itemTextures.contains(resourceLocation)) {
            this.itemTextures.add(resourceLocation);
        }
    }

    public void registerBlockSprite(ResourceLocation resourceLocation) {
        if (!this.blockTextures.contains(resourceLocation)) {
            this.blockTextures.add(resourceLocation);
        }
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent event) {
        if (event.map == Minecraft.func_71410_x().func_147117_R()) {
            this.registerSprites(event.map, this.blockTextures);
        } else {
            this.registerSprites(event.map, this.itemTextures);
        }
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        this.registerCustomBakedModels(event.modelManager, event.modelRegistry, event.modelBakery);
    }

    protected void registerCustomBakedModels(ModelManager modelManager, IRegistry modelRegistry, ModelBakery modelBakery) {
        ModelBlock modelblock;
        ResourceLocation icon;
        ItemCameraTransforms transforms;
        IInitializeBakedModel initializeModel;
        IBakedModel model;
        ResourceLocation loc;
        for (Map.Entry<ResourceLocation, IBakedModel> entry : this.itemsToInject.entrySet()) {
            loc = entry.getKey();
            model = entry.getValue();
            if (model instanceof IInitializeBakedModel) {
                initializeModel = (IInitializeBakedModel)model;
                transforms = ItemCameraTransforms.field_178357_a;
                icon = new ResourceLocation(loc.func_110624_b(), "item/" + loc.func_110623_a());
                if (loc.func_110623_a().contains("wand") || loc.func_110623_a().contains("focus") || loc.func_110623_a().contains("sceptre")) {
                    icon = new ResourceLocation(loc.func_110624_b(), "item/wand");
                } else if (loc.func_110623_a().contains("staff")) {
                    icon = new ResourceLocation(loc.func_110624_b(), "item/staff");
                }
                modelblock = this.loadModelResource(icon);
                if (modelblock != null) {
                    transforms = new ItemCameraTransforms(modelblock.func_181682_g());
                }
                initializeModel.initialize(transforms, icon, modelManager);
            }
            modelRegistry.func_82595_a((Object)loc, (Object)model);
        }
        for (Map.Entry<ResourceLocation, IBakedModel> entry : this.blocksToInject.entrySet()) {
            loc = entry.getKey();
            model = entry.getValue();
            if (model instanceof IInitializeBakedModel) {
                initializeModel = (IInitializeBakedModel)model;
                transforms = ItemCameraTransforms.field_178357_a;
                icon = new ResourceLocation(loc.func_110624_b(), "block/" + loc.func_110623_a());
                modelblock = this.loadModelResource(icon);
                if (modelblock != null) {
                    transforms = new ItemCameraTransforms(modelblock.func_181682_g());
                }
                initializeModel.initialize(transforms, icon, modelManager);
            }
            modelRegistry.func_82595_a((Object)loc, (Object)model);
        }
    }

    protected void registerSprites(TextureMap map, List<ResourceLocation> texturesToRegister) {
        for (ResourceLocation loc : texturesToRegister) {
            map.func_174942_a(loc);
        }
    }

    protected ResourceLocation getModelLocation(ResourceLocation loc) {
        return new ResourceLocation(loc.func_110624_b(), "models/" + loc.func_110623_a() + ".json");
    }

    protected ModelBlock loadModelResource(Map<ResourceLocation, ModelBlock> map, ResourceLocation loc) {
        InputStreamReader reader = null;
        ModelBlock modelblock = map.get(loc);
        if (modelblock != null) {
            return modelblock;
        }
        if (loc.func_110623_a().startsWith("builtin/")) {
            return null;
        }
        try {
            IResource iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(this.getModelLocation(loc));
            if (iresource != null) {
                ModelBlock parentModel;
                reader = new InputStreamReader(iresource.func_110527_b(), Charsets.UTF_8);
                modelblock = ModelBlock.func_178307_a((Reader)reader);
                modelblock.field_178317_b = loc.toString();
                map.put(loc, modelblock);
                ResourceLocation parentLoc = modelblock.func_178305_e();
                if (parentLoc != null && (parentModel = this.loadModelResource(map, parentLoc)) != null) {
                    modelblock.func_178299_a(map);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return modelblock;
    }

    public ModelBlock loadModelResource(ResourceLocation loc) {
        return this.loadModelResource(new Hashtable<ResourceLocation, ModelBlock>(), loc);
    }
}

