/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.tile;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.client.lib.models.AdvancedModelLoader;
import thaumcraft.client.lib.models.IModelCustom;
import thaumcraft.common.tiles.devices.TileNodeStabilizer;

@SideOnly(value=Side.CLIENT)
public class TileNodeStabilizerRenderer
extends TileEntitySpecialRenderer {
    private IModelCustom model = AdvancedModelLoader.loadModel(MODEL);
    private static final ResourceLocation MODEL = new ResourceLocation("thaumcraft", "models/obj/node_stabilizer.obj");
    private static final ResourceLocation TEX = new ResourceLocation("thaumcraft", "textures/models/node_stabilizer.png");
    private static final ResourceLocation OVER = new ResourceLocation("thaumcraft", "textures/models/node_stabilizer_over.png");
    private static final ResourceLocation BUBBLE = new ResourceLocation("thaumcraft", "textures/misc/node_bubble.png");

    public void renderTileEntityAt(TileNodeStabilizer tile, double par2, double par4, double par6, float par8) {
        int bright = 20;
        if (tile.func_145831_w() != null) {
            bright = tile.func_145838_q().func_176207_c((IBlockAccess)tile.func_145831_w(), tile.func_174877_v());
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)par2 + 0.5f), (float)((float)par4), (float)((float)par6 + 0.5f));
        GL11.glRotatef((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_147499_a(TEX);
        this.model.renderPart("lock");
        for (int a = 0; a < 4; ++a) {
            GL11.glPushMatrix();
            if (tile.func_145831_w() != null) {
                int j = bright;
                int k = j % 65536;
                int l = j / 65536;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)k / 1.0f), (float)((float)l / 1.0f));
            }
            GL11.glRotatef((float)(90 * a), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)tile.count / 100.0f));
            this.func_147499_a(TEX);
            this.model.renderPart("piston");
            if (tile.func_145831_w() != null) {
                float scale = MathHelper.func_76126_a((float)((float)(Minecraft.func_71410_x().func_175606_aa().field_70173_aa + a * 5) / 3.0f)) * 0.1f + 0.9f;
                int j = 50 + (int)(170.0f * ((float)tile.count / 37.0f * scale));
                int k = j % 65536;
                int l = j / 65536;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)k / 1.0f), (float)((float)l / 1.0f));
            }
            this.func_147499_a(OVER);
            this.model.renderPart("piston");
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        if (tile.count > 0) {
            GL11.glPushMatrix();
            GL11.glAlphaFunc((int)516, (float)0.003921569f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glDepthMask((boolean)false);
            float alpha = MathHelper.func_76126_a((float)((float)Minecraft.func_71410_x().func_175606_aa().field_70173_aa / 8.0f)) * 0.1f + 0.5f;
            this.func_147499_a(BUBBLE);
            UtilsFX.renderFacingQuad((double)tile.func_174877_v().func_177958_n() + 0.5, (double)tile.func_174877_v().func_177956_o() + 1.5, (double)tile.func_174877_v().func_177952_p() + 0.5, 1, 1, 0, 0.9f, 0xFFFFFF, (float)tile.count / 37.0f * alpha, 771, par8);
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glPopMatrix();
        }
    }

    public void func_180535_a(TileEntity par1TileEntity, double par2, double par4, double par6, float par8, int q) {
        this.renderTileEntityAt((TileNodeStabilizer)par1TileEntity, par2, par4, par6, par8);
    }
}

