/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks.devices;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.blocks.ILabelable;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.blocks.BlockTCDevice;
import thaumcraft.common.tiles.crafting.TileAlembic;

public class BlockAlembic
extends BlockTCDevice
implements ILabelable {
    public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", AlembicType.class);

    public BlockAlembic() {
        super(Material.field_151575_d, null);
        this.func_149672_a(Block.field_149766_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)((Object)AlembicType.NORMAL)));
    }

    @Override
    public TileEntity func_149915_a(World world, int metadata) {
        if (metadata == 0) {
            return new TileAlembic();
        }
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)AlembicType.values()[meta]));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((AlembicType)((Object)state.func_177229_b((IProperty)TYPE))).ordinal();
    }

    @Override
    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{TYPE});
    }

    @Override
    public String getStateName(IBlockState state, boolean fullName) {
        AlembicType type = (AlembicType)((Object)state.func_177229_b((IProperty)TYPE));
        return "alembic_" + type.func_176610_l();
    }

    @Override
    public IProperty[] getProperties() {
        return new IProperty[]{TYPE};
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float fx, float fy, float fz) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileAlembic && player.func_70093_af() && ((TileAlembic)te).aspectFilter != null && side.ordinal() == ((TileAlembic)te).facing) {
            ((TileAlembic)te).aspectFilter = null;
            ((TileAlembic)te).facing = EnumFacing.DOWN.ordinal();
            te.func_70296_d();
            world.func_175689_h(pos);
            if (world.field_72995_K) {
                world.func_72980_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, "thaumcraft:page", 1.0f, 1.0f, false);
            } else {
                world.func_72838_d((Entity)new EntityItem(world, (double)((float)pos.func_177958_n() + 0.5f + (float)side.func_82601_c() / 3.0f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f + (float)side.func_82599_e() / 3.0f), new ItemStack(ItemsTC.label)));
            }
        } else if (te != null && te instanceof TileAlembic && player.func_70093_af() && player.func_70694_bm() == null && (((TileAlembic)te).aspectFilter == null || side.ordinal() != ((TileAlembic)te).facing)) {
            ((TileAlembic)te).aspect = null;
            if (world.field_72995_K) {
                world.func_72980_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, "thaumcraft:jar", 0.4f, 1.0f, false);
                world.func_72980_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, "game.neutral.swim", 0.5f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.3f, false);
            } else {
                AuraHelper.pollute(world, pos, ((TileAlembic)te).amount, true);
            }
            ((TileAlembic)te).amount = 0;
            te.func_70296_d();
            world.func_175689_h(pos);
        }
        return true;
    }

    public void func_180654_a(IBlockAccess world, BlockPos pos) {
        this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 1.0f, 0.875f);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_180641_l(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileAlembic) {
            float r = (float)((TileAlembic)tile).amount / (float)((TileAlembic)tile).maxAmount;
            return MathHelper.func_76141_d((float)(r * 14.0f)) + (((TileAlembic)tile).amount > 0 ? 1 : 0);
        }
        return super.func_180641_l(world, pos);
    }

    @Override
    public boolean applyLabel(EntityPlayer player, BlockPos pos, EnumFacing side, ItemStack labelstack) {
        TileEntity te = player.field_70170_p.func_175625_s(pos);
        if (te != null && te instanceof TileAlembic && side.ordinal() > 1 && ((TileAlembic)te).aspectFilter == null) {
            Aspect la = null;
            if (((IEssentiaContainerItem)labelstack.func_77973_b()).getAspects(labelstack) != null) {
                la = ((IEssentiaContainerItem)labelstack.func_77973_b()).getAspects(labelstack).getAspects()[0];
            }
            if (((TileAlembic)te).amount == 0 && la == null) {
                return false;
            }
            Aspect aspect = null;
            if (((TileAlembic)te).amount == 0 && la != null) {
                aspect = la;
            }
            if (((TileAlembic)te).amount > 0) {
                aspect = ((TileAlembic)te).aspect;
            }
            if (aspect == null) {
                return false;
            }
            this.func_180633_a(player.field_70170_p, pos, player.field_70170_p.func_180495_p(pos), (EntityLivingBase)player, null);
            ((TileAlembic)te).aspectFilter = aspect;
            ((TileAlembic)te).facing = side.ordinal();
            te.func_70296_d();
            player.field_70170_p.func_175689_h(pos);
            player.field_70170_p.func_72908_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, "thaumcraft:page", 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public static enum AlembicType implements IStringSerializable
    {
        NORMAL;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

