/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks.devices;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.BlockTCDevice;
import thaumcraft.common.tiles.devices.TileAuraTotem;
import thaumcraft.common.tiles.devices.TileAuraTotemPole;
import thaumcraft.common.tiles.devices.TileAuraTotemPull;
import thaumcraft.common.tiles.devices.TileAuraTotemPush;

public class BlockAuraTotem
extends BlockTCDevice {
    public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", TotemType.class);

    public BlockAuraTotem() {
        super(Material.field_151575_d, TileAuraTotemPush.class);
        this.func_149711_c(0.5f);
        this.func_149752_b(5.0f);
        this.func_149672_a(Block.field_149766_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)((Object)TotemType.PUSH)));
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        switch (meta) {
            case 0: {
                return new TileAuraTotemPush();
            }
            case 1: {
                return new TileAuraTotemPull();
            }
        }
        return new TileAuraTotemPole();
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (((TotemType)((Object)state.func_177229_b((IProperty)TYPE))).isPole) {
            worldIn.func_175713_t(pos);
        } else {
            super.func_180663_b(worldIn, pos, state);
        }
    }

    public void func_180654_a(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (((TotemType)((Object)state.func_177229_b((IProperty)TYPE))).isPole) {
            this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 1.0f, 0.875f);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void func_180638_a(World worldIn, BlockPos pos, IBlockState state, AxisAlignedBB mask, List list, Entity collidingEntity) {
        this.func_180654_a((IBlockAccess)worldIn, pos);
        super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)TotemType.values()[meta]));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((TotemType)((Object)state.func_177229_b((IProperty)TYPE))).ordinal();
    }

    @Override
    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{TYPE});
    }

    @Override
    public String getStateName(IBlockState state, boolean fullName) {
        TotemType type = (TotemType)((Object)state.func_177229_b((IProperty)TYPE));
        return (fullName ? "aura_totem_" : "") + type.func_176610_l();
    }

    @Override
    public IProperty[] getProperties() {
        return new IProperty[]{TYPE};
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT_MIPPED;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180662_a(IBlockAccess worldIn, BlockPos pos, int renderPass) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileAuraTotem) {
            if (((TileAuraTotem)te).type >= 0) {
                Aspect a = ((TileAuraTotem)te).getAspect();
                return a == null ? 0xF0F0F0 : a.getColor();
            }
            return 0x101010;
        }
        return super.func_180662_a(worldIn, pos, renderPass);
    }

    @Override
    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null && tile instanceof TileAuraTotem) {
            ((TileAuraTotem)tile).checkPoles();
            worldIn.func_175641_c(pos, (Block)this, 1, 1);
        } else {
            worldIn.func_180496_d(pos.func_177984_a(), (Block)this);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70694_bm() != null && Block.func_149634_a((Item)player.func_70694_bm().func_77973_b()) == this) {
            return false;
        }
        if (!((TotemType)((Object)state.func_177229_b((IProperty)TYPE))).isPole) {
            player.openGui((Object)Thaumcraft.instance, 8, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        } else {
            IBlockState bs = world.func_180495_p(pos.func_177984_a());
            if (bs.func_177230_c() == this) {
                return bs.func_177230_c().func_180639_a(world, pos.func_177984_a(), bs, player, side, hitX, hitY, hitZ);
            }
        }
        return true;
    }

    public static enum TotemType implements IStringSerializable
    {
        PUSH(false),
        PULL(false),
        POLE_OUTER(true),
        POLE_INNER(true),
        POLE_PURE(true);

        private final boolean isPole;

        private TotemType(Boolean b) {
            this.isPole = b;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

