/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks.devices;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.wands.IWand;
import thaumcraft.common.blocks.BlockTCDevice;
import thaumcraft.common.entities.EntitySpecialItem;
import thaumcraft.common.tiles.crafting.TileCrucible;

public class BlockCrucible
extends BlockTCDevice {
    private int delay = 0;

    public BlockCrucible() {
        super(Material.field_151573_f, TileCrucible.class);
        this.func_149672_a(Block.field_149777_j);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K) {
            TileCrucible tile = (TileCrucible)world.func_175625_s(pos);
            if (tile != null && entity instanceof EntityItem && !(entity instanceof EntitySpecialItem) && tile.heat > 150 && tile.tank.getFluidAmount() > 0) {
                tile.attemptSmelt((EntityItem)entity);
            } else {
                ++this.delay;
                if (this.delay < 10) {
                    return;
                }
                this.delay = 0;
                if (entity instanceof EntityLivingBase && tile != null && tile.heat > 150 && tile.tank.getFluidAmount() > 0) {
                    entity.func_70097_a(DamageSource.field_76372_a, 1.0f);
                    world.func_72908_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, "random.fizz", 0.4f, 2.0f + world.field_73012_v.nextFloat() * 0.4f);
                }
            }
        }
        super.func_180634_a(world, pos, state, entity);
    }

    public void func_180638_a(World worldIn, BlockPos pos, IBlockState state, AxisAlignedBB mask, List list, Entity collidingEntity) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.3125f, 1.0f);
        super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
        float f = 0.125f;
        this.func_149676_a(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
        super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
        super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
        this.func_149676_a(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
        this.func_149676_a(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
        super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
    }

    public void func_180654_a(IBlockAccess worldIn, BlockPos pos) {
        this.func_149683_g();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180646_a(World world, BlockPos pos) {
        return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n() + 1.0, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 1.0);
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileCrucible) {
            ((TileCrucible)te).spillRemnants();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileEntity te;
            FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)player.field_71071_by.func_70448_g());
            if (fs != null && fs.isFluidEqual(new FluidStack(FluidRegistry.WATER, 1000))) {
                int volume = fs.amount;
                TileEntity te2 = world.func_175625_s(pos);
                if (te2 != null && te2 instanceof TileCrucible) {
                    TileCrucible tile = (TileCrucible)te2;
                    if (tile.tank.getFluidAmount() < tile.tank.getCapacity()) {
                        FluidContainerRegistry.FluidContainerData[] fcs;
                        tile.fill(EnumFacing.UP, FluidContainerRegistry.getFluidForFilledItem((ItemStack)player.field_71071_by.func_70448_g()), true);
                        ItemStack emptyContainer = null;
                        for (FluidContainerRegistry.FluidContainerData fcd : fcs = FluidContainerRegistry.getRegisteredFluidContainerData()) {
                            if (!fcd.filledContainer.func_77969_a(player.field_71071_by.func_70448_g())) continue;
                            emptyContainer = fcd.emptyContainer.func_77946_l();
                        }
                        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                        if (emptyContainer != null && !player.field_71071_by.func_70441_a(emptyContainer)) {
                            player.func_71019_a(emptyContainer, false);
                        }
                        player.field_71069_bz.func_75142_b();
                        te2.func_70296_d();
                        world.func_175689_h(pos);
                        world.func_72908_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, "game.neutral.swim", 0.33f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.3f);
                        return true;
                    }
                }
            } else if (player.field_71071_by.func_70448_g() != null && !player.func_70093_af() && !(player.func_71045_bC().func_77973_b() instanceof IWand) && side == EnumFacing.UP && (te = world.func_175625_s(pos)) != null && te instanceof TileCrucible) {
                TileCrucible tile = (TileCrucible)te;
                ItemStack ti = player.field_71071_by.func_70448_g().func_77946_l();
                ti.field_77994_a = 1;
                if (tile.heat > 150 && tile.tank.getFluidAmount() > 0 && tile.attemptSmelt(ti, player.func_70005_c_()) == null) {
                    player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                    return true;
                }
            }
        } else {
            return true;
        }
        return super.func_180639_a(world, pos, state, player, side, hitX, hitY, hitZ);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_180641_l(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileCrucible) {
            float f = ((TileCrucible)te).aspects.visSize();
            ((TileCrucible)te).getClass();
            float r = f / 100.0f;
            return MathHelper.func_76141_d((float)(r * 14.0f)) + (((TileCrucible)te).aspects.visSize() > 0 ? 1 : 0);
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World w, BlockPos pos, IBlockState state, Random r) {
        TileEntity te;
        if (r.nextInt(10) == 0 && (te = w.func_175625_s(pos)) != null && te instanceof TileCrucible && ((TileCrucible)te).tank.getFluidAmount() > 0 && ((TileCrucible)te).heat > 150) {
            w.func_72980_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), "liquid.lavapop", 0.1f + r.nextFloat() * 0.1f, 1.2f + r.nextFloat() * 0.2f, false);
        }
    }
}

