/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks.devices;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.client.fx.particles.FXDigging;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.utils.InventoryUtils;
import thaumcraft.common.tiles.devices.TileHungryChest;

public class BlockHungryChest
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private final Random rand = new Random();

    public BlockHungryChest() {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149711_c(2.5f);
        this.func_149672_a(field_149766_f);
        this.func_149647_a(Thaumcraft.tabTC);
        this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        int i = target.func_178782_a().func_177958_n();
        int j = target.func_178782_a().func_177956_o();
        int k = target.func_178782_a().func_177952_p();
        float f = 0.1f;
        double d0 = (double)i + this.rand.nextDouble() * (this.func_149753_y() - this.func_149704_x() - (double)(f * 2.0f)) + (double)f + this.func_149704_x();
        double d1 = (double)j + this.rand.nextDouble() * (this.func_149669_A() - this.func_149665_z() - (double)(f * 2.0f)) + (double)f + this.func_149665_z();
        double d2 = (double)k + this.rand.nextDouble() * (this.func_149693_C() - this.func_149706_B() - (double)(f * 2.0f)) + (double)f + this.func_149706_B();
        if (target.field_178784_b == EnumFacing.DOWN) {
            d1 = (double)j + this.func_149665_z() - (double)f;
        }
        if (target.field_178784_b == EnumFacing.UP) {
            d1 = (double)j + this.func_149669_A() + (double)f;
        }
        if (target.field_178784_b == EnumFacing.NORTH) {
            d2 = (double)k + this.func_149706_B() - (double)f;
        }
        if (target.field_178784_b == EnumFacing.SOUTH) {
            d2 = (double)k + this.func_149693_C() + (double)f;
        }
        if (target.field_178784_b == EnumFacing.WEST) {
            d0 = (double)i + this.func_149704_x() - (double)f;
        }
        if (target.field_178784_b == EnumFacing.EAST) {
            d0 = (double)i + this.func_149753_y() + (double)f;
        }
        effectRenderer.func_78873_a((EntityFX)new FXDigging(worldObj, d0, d1, d2, 0.0, 0.0, 0.0, BlocksTC.plank.func_176223_P()).func_174846_a(target.func_178782_a()));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, EffectRenderer effectRenderer) {
        int b0 = 4;
        for (int i = 0; i < b0; ++i) {
            for (int j = 0; j < b0; ++j) {
                for (int k = 0; k < b0; ++k) {
                    double d0 = (double)pos.func_177958_n() + ((double)i + 0.5) / (double)b0;
                    double d1 = (double)pos.func_177956_o() + ((double)j + 0.5) / (double)b0;
                    double d2 = (double)pos.func_177952_p() + ((double)k + 0.5) / (double)b0;
                    effectRenderer.func_78873_a((EntityFX)new FXDigging(world, d0, d1, d2, d0 - (double)pos.func_177958_n() - 0.5, d1 - (double)pos.func_177956_o() - 0.5, d2 - (double)pos.func_177952_p() - 0.5, BlocksTC.plank.func_176223_P()).func_174846_a(pos));
                }
            }
        }
        return true;
    }

    public void func_180654_a(IBlockAccess worldIn, BlockPos pos) {
        this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        float var5 = 0.0625f;
        return AxisAlignedBB.func_178781_a((double)((float)pos.func_177958_n() + var5), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + var5), (double)((float)(pos.func_177958_n() + 1) - var5), (double)((float)(pos.func_177956_o() + 1) - var5), (double)((float)(pos.func_177952_p() + 1) - var5));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
        state = state.func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        worldIn.func_180501_a(pos, state, 3);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof IInventory) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof IInventory) {
            playerIn.func_71007_a((IInventory)tileentity);
        }
        return true;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileHungryChest var10 = (TileHungryChest)world.func_175625_s(pos);
        if (var10 == null) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        if (entity instanceof EntityItem && !entity.field_70128_L) {
            ItemStack leftovers = InventoryUtils.placeItemStackIntoInventory(((EntityItem)entity).func_92059_d(), (IInventory)var10, EnumFacing.UP, true);
            if (leftovers == null || leftovers.field_77994_a != ((EntityItem)entity).func_92059_d().field_77994_a) {
                world.func_72956_a(entity, "random.eat", 0.25f, (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                world.func_175641_c(pos, BlocksTC.hungryChest, 2, 2);
            }
            if (leftovers != null) {
                ((EntityItem)entity).func_92058_a(leftovers);
            } else {
                entity.func_70106_y();
            }
            var10.func_70296_d();
        }
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_180641_l(World worldIn, BlockPos pos) {
        TileEntity var10 = worldIn.func_175625_s(pos);
        if (var10 instanceof TileHungryChest) {
            return Container.func_94526_b((IInventory)((IInventory)var10));
        }
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{FACING});
    }

    public TileEntity func_149915_a(World par1World, int m) {
        return new TileHungryChest();
    }
}

