/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks.misc;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.entities.IEldritchMob;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXSpark;
import thaumcraft.common.blocks.BlockTC;

public class BlockEffect
extends BlockTC {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", EffType.class);

    public BlockEffect() {
        super(Material.field_151579_a);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EffType.SHOCK)));
        this.field_149781_w = 999.0f;
        this.func_149715_a(0.5f);
        this.func_149647_a(null);
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return super.getLightValue(world, pos);
        }
        if ((EffType)((Object)world.func_180495_p(pos).func_177229_b((IProperty)VARIANT)) == EffType.GLIMMER) {
            return 15;
        }
        return super.getLightValue(world, pos);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if ((EffType)((Object)world.func_180495_p(pos).func_177229_b((IProperty)VARIANT)) == EffType.SHOCK) {
            entity.func_70097_a(DamageSource.field_76376_m, (float)(1 + world.field_73012_v.nextInt(2)));
            if (entity instanceof EntityLivingBase) {
                PotionEffect pe = new PotionEffect(Potion.field_76421_d.field_76415_H, 20, 0, true, true);
                ((EntityLivingBase)entity).func_70690_d(pe);
            }
            if (!world.field_72995_K && world.field_73012_v.nextInt(100) == 0) {
                world.func_175698_g(pos);
            }
        } else if ((EffType)((Object)world.func_180495_p(pos).func_177229_b((IProperty)VARIANT)) == EffType.SAPPING && !(entity instanceof IEldritchMob) && entity instanceof EntityLivingBase && !((EntityLivingBase)entity).func_70644_a(Potion.field_82731_v)) {
            PotionEffect pe0 = new PotionEffect(Potion.field_82731_v.field_76415_H, 40, 0, true, true);
            ((EntityLivingBase)entity).func_70690_d(pe0);
            PotionEffect pe1 = new PotionEffect(Potion.field_76421_d.field_76415_H, 40, 1, true, true);
            ((EntityLivingBase)entity).func_70690_d(pe1);
            PotionEffect pe2 = new PotionEffect(Potion.field_76438_s.field_76415_H, 40, 1, true, true);
            ((EntityLivingBase)entity).func_70690_d(pe2);
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        if (!(worldIn.field_72995_K || (EffType)((Object)state.func_177229_b((IProperty)VARIANT)) != EffType.SAPPING && (EffType)((Object)state.func_177229_b((IProperty)VARIANT)) != EffType.SHOCK)) {
            worldIn.func_175698_g(pos);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World w, BlockPos pos, IBlockState state, Random r) {
        if ((EffType)((Object)state.func_177229_b((IProperty)VARIANT)) == EffType.SAPPING || (EffType)((Object)state.func_177229_b((IProperty)VARIANT)) == EffType.SHOCK) {
            float h = r.nextFloat() * 0.33f;
            FXSpark ef = new FXSpark(w, (float)pos.func_177958_n() + w.field_73012_v.nextFloat(), (float)pos.func_177956_o() + 0.1515f + h / 2.0f, (float)pos.func_177952_p() + w.field_73012_v.nextFloat(), 0.33f + h);
            if ((EffType)((Object)state.func_177229_b((IProperty)VARIANT)) == EffType.SHOCK) {
                ef.func_70538_b(0.65f + w.field_73012_v.nextFloat() * 0.1f, 1.0f, 1.0f);
                ef.func_82338_g(0.8f);
            } else {
                ef.func_70538_b(0.3f - w.field_73012_v.nextFloat() * 0.1f, 0.0f, 0.5f + w.field_73012_v.nextFloat() * 0.2f);
            }
            ParticleEngine.instance.addEffect(w, ef);
            if (r.nextInt(50) == 0) {
                w.func_72980_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), "thaumcraft:jacobs", 0.5f, 1.0f + (r.nextFloat() - r.nextFloat()) * 0.2f, false);
            }
        }
    }

    public boolean isAir(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_176193_a(World worldIn, BlockPos pos, EnumFacing side, ItemStack stack) {
        return true;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos) {
        return null;
    }

    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing o) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        return null;
    }

    public boolean func_176209_a(IBlockState state, boolean hitIfLiquid) {
        return false;
    }

    public AxisAlignedBB func_180646_a(World worldIn, BlockPos pos) {
        return AxisAlignedBB.func_178781_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    }

    public boolean func_149662_c() {
        return false;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150899_d((int)0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EffType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((EffType)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
        return meta;
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{VARIANT});
    }

    @Override
    public IProperty[] getProperties() {
        return new IProperty[]{VARIANT};
    }

    @Override
    public String getStateName(IBlockState state, boolean fullName) {
        EffType type = (EffType)((Object)state.func_177229_b((IProperty)VARIANT));
        return type.func_176610_l();
    }

    public static enum EffType implements IStringSerializable
    {
        SHOCK,
        SAPPING,
        GLIMMER;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

