/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.config;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.potion.PotionHelper;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftEnchantments;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.potions.PotionFluxTaint;
import thaumcraft.api.potions.PotionVisExhaust;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigRecipes;
import thaumcraft.common.entities.EntityFallingTaint;
import thaumcraft.common.entities.construct.EntityOwnedConstruct;
import thaumcraft.common.entities.monster.EntityEldritchCrab;
import thaumcraft.common.entities.monster.EntityEldritchGuardian;
import thaumcraft.common.entities.monster.EntityInhabitedZombie;
import thaumcraft.common.entities.monster.EntityPech;
import thaumcraft.common.entities.monster.EntityWisp;
import thaumcraft.common.entities.monster.boss.EntityCultistLeader;
import thaumcraft.common.entities.monster.boss.EntityCultistPortalGreater;
import thaumcraft.common.entities.monster.boss.EntityEldritchGolem;
import thaumcraft.common.entities.monster.boss.EntityEldritchWarden;
import thaumcraft.common.entities.monster.cult.EntityCultistCleric;
import thaumcraft.common.entities.monster.cult.EntityCultistKnight;
import thaumcraft.common.entities.monster.cult.EntityCultistPortalLesser;
import thaumcraft.common.items.baubles.ItemAmuletVis;
import thaumcraft.common.lib.enchantment.EnchantmentHaste;
import thaumcraft.common.lib.enchantment.EnchantmentRepair;
import thaumcraft.common.lib.potions.PotionBlurredVision;
import thaumcraft.common.lib.potions.PotionDeathGaze;
import thaumcraft.common.lib.potions.PotionInfectiousVisExhaust;
import thaumcraft.common.lib.potions.PotionSunScorned;
import thaumcraft.common.lib.potions.PotionThaumarhia;
import thaumcraft.common.lib.potions.PotionUnnaturalHunger;
import thaumcraft.common.lib.potions.PotionWarpWard;
import thaumcraft.common.lib.utils.CropUtils;
import thaumcraft.common.lib.utils.Utils;
import thaumcraft.common.lib.world.biomes.BiomeGenEerie;
import thaumcraft.common.lib.world.biomes.BiomeGenEldritch;
import thaumcraft.common.lib.world.biomes.BiomeGenMagicalForest;
import thaumcraft.common.lib.world.biomes.BiomeGenTaint;
import thaumcraft.common.lib.world.biomes.BiomeHandler;

public class Config {
    public static Configuration config;
    public static final String CATEGORY_GRAPHICS = "Graphics";
    public static final String CATEGORY_ENCH = "Enchantments";
    public static final String CATEGORY_ENTITIES = "Entities";
    public static final String CATEGORY_BIOMES = "Biomes";
    public static final String CATEGORY_RESEARCH = "Research";
    public static final String CATEGORY_WORLD = "World_Generation";
    public static final String CATEGORY_REGEN = "World_Regeneration";
    public static final String CATEGORY_SPAWN = "Monster_Spawning";
    public static final String CATEGORY_RUNIC = "Runic_Shielding";
    public static int overworldDim;
    public static int biomeTaintID;
    public static int biomeMagicalForestID;
    public static int biomeEerieID;
    public static int biomeEldritchID;
    public static int biomeTaintWeight;
    public static int biomeMagicalForestWeight;
    public static float taintSpreadRate;
    public static boolean wuss;
    public static int dimensionOuterId;
    public static boolean championMobs;
    public static int AURABASE;
    public static int oreDensity;
    public static int dustDegrade;
    public static boolean soilToDirt;
    public static int shieldRecharge;
    public static int shieldWait;
    public static int shieldCost;
    public static boolean largeTagText;
    public static boolean colorBlind;
    public static boolean shaders;
    public static boolean nostress;
    public static boolean crooked;
    public static boolean showTags;
    public static boolean blueBiome;
    public static boolean allowMirrors;
    public static boolean dialBottom;
    public static boolean showGolemEmotes;
    public static int nodeRefresh;
    public static final float auraSize = 4.0f;
    public static boolean genAura;
    public static boolean genStructure;
    public static boolean genCinnibar;
    public static boolean genAmber;
    public static boolean genCrystals;
    public static boolean genTrees;
    public static boolean genTaint;
    public static boolean regenAura;
    public static boolean regenStructure;
    public static boolean regenCinnibar;
    public static boolean regenAmber;
    public static boolean regenCrystals;
    public static boolean regenTrees;
    public static boolean regenTaint;
    public static String regenKey;
    public static boolean wardedStone;
    public static boolean allowCheatSheet;
    public static boolean golemChestInteract;
    public static int nodeRarity;
    public static int specialNodeRarity;
    public static int researchDifficulty;
    public static int researchAmount;
    public static int CAURABASE;
    public static boolean CwardedStone;
    public static boolean CallowCheatSheet;
    public static boolean CallowMirrors;
    public static boolean ChardNode;
    public static boolean Cwuss;
    public static int CresearchDifficulty;
    public static int CresearchAmount;
    public static boolean spawnAngryZombie;
    public static boolean spawnFireBat;
    public static boolean spawnTaintacle;
    public static boolean spawnWisp;
    public static boolean spawnTaintSpore;
    public static boolean spawnPech;
    public static boolean spawnElder;
    public static Enchantment enchHaste;
    public static Enchantment enchRepair;
    public static ArrayList<Aspect> aspectOrder;
    public static boolean foundCopperIngot;
    public static boolean foundTinIngot;
    public static boolean foundSilverIngot;
    public static boolean foundLeadIngot;
    public static boolean foundCopperOre;
    public static boolean foundTinOre;
    public static boolean foundSilverOre;
    public static boolean foundLeadOre;

    public static void initialize(File file) {
        config = new Configuration(file);
        config.addCustomCategoryComment(CATEGORY_GRAPHICS, CATEGORY_GRAPHICS);
        config.addCustomCategoryComment(CATEGORY_ENCH, "Custom enchantments");
        config.addCustomCategoryComment(CATEGORY_SPAWN, "Will these mobs spawn");
        config.addCustomCategoryComment(CATEGORY_RESEARCH, "Various research related things.");
        config.addCustomCategoryComment(CATEGORY_WORLD, "Settings to turn certain world-gen on or off.");
        config.addCustomCategoryComment(CATEGORY_REGEN, "If a chunk is encountered that skipped TC worldgen, then the game will attempt to regenerate certain world features if they are set to true. CAUTION: Best used for worlds created before you added this mod, and only if you know what you are doing. Backups are advised.");
        config.addCustomCategoryComment(CATEGORY_BIOMES, "Biomes and effects");
        config.addCustomCategoryComment(CATEGORY_RUNIC, "Runic Shielding");
        config.load();
        Config.syncConfigurable();
        Property biomeTaintProp = config.get(CATEGORY_BIOMES, "biome_taint", biomeTaintID);
        biomeTaintProp.comment = "Taint biome id";
        biomeTaintID = biomeTaintProp.getInt();
        if (BiomeGenBase.func_150565_n()[biomeTaintID] != null) {
            biomeTaintID = BiomeHandler.getFirstFreeBiomeSlot(biomeTaintID);
            biomeTaintProp.set(biomeTaintID);
        }
        try {
            BiomeHandler.biomeTaint = new BiomeGenTaint(biomeTaintID);
        }
        catch (Exception e) {
            Thaumcraft.log.fatal("Could not register Taint Biome");
        }
        Property mfcp = config.get(CATEGORY_BIOMES, "magical_forest_biome_weight", 3);
        mfcp.comment = "higher values increases number of magical forest biomes. If you are using biome addon mods you probably want to increase this weight quite a bit";
        biomeMagicalForestWeight = mfcp.getInt();
        Property biomeMFProp = config.get(CATEGORY_BIOMES, "biome_magical_forest", biomeMagicalForestID);
        biomeMFProp.comment = "Magical Forest biome id";
        biomeMagicalForestID = biomeMFProp.getInt();
        if (BiomeGenBase.func_150565_n()[biomeMagicalForestID] != null) {
            biomeMagicalForestID = BiomeHandler.getFirstFreeBiomeSlot(biomeMagicalForestID);
            biomeMFProp.set(biomeMagicalForestID);
        }
        try {
            BiomeHandler.biomeMagicalForest = new BiomeGenMagicalForest(biomeMagicalForestID);
        }
        catch (Exception e) {
            Thaumcraft.log.fatal("Could not register Magical Forest Biome");
        }
        Property biomeEerieProp = config.get(CATEGORY_BIOMES, "biome_eerie", biomeEerieID);
        biomeEerieProp.comment = "Eerie biome id";
        biomeEerieID = biomeEerieProp.getInt();
        if (BiomeGenBase.func_150565_n()[biomeEerieID] != null) {
            biomeEerieID = BiomeHandler.getFirstFreeBiomeSlot(biomeEerieID);
            biomeEerieProp.set(biomeEerieID);
        }
        try {
            BiomeHandler.biomeEerie = new BiomeGenEerie(biomeEerieID);
        }
        catch (Exception e) {
            Thaumcraft.log.fatal("Could not register Eerie Biome");
        }
        Property biomeEldritchProp = config.get(CATEGORY_BIOMES, "biome_eldritch", biomeEldritchID);
        biomeEldritchProp.comment = "Eldritch Lands biome id";
        biomeEldritchID = biomeEldritchProp.getInt();
        if (BiomeGenBase.func_150565_n()[biomeEldritchID] != null) {
            biomeEldritchID = BiomeHandler.getFirstFreeBiomeSlot(biomeEldritchID);
            biomeEldritchProp.set(biomeEldritchID);
        }
        try {
            BiomeHandler.biomeEldritchLands = new BiomeGenEldritch(biomeEldritchID);
        }
        catch (Exception e) {
            Thaumcraft.log.fatal("Could not register Eldritch Lands Biome");
        }
        Property dimEldritch = config.get(CATEGORY_BIOMES, "outer_lands_dim", dimensionOuterId);
        dimensionOuterId = dimEldritch.getInt();
        Property mdim = config.get(CATEGORY_BIOMES, "main_dim", overworldDim);
        mdim.comment = "The dimension considered to be your 'overworld'. Certain TC structures will only spawn in this dim.";
        overworldDim = mdim.getInt();
        int encIdx = 150;
        Property enchHas = config.get(CATEGORY_ENCH, "ench_haste", encIdx++);
        enchHaste = new EnchantmentHaste(enchHas.getInt(), 3);
        ThaumcraftEnchantments.HASTE = enchHas.getInt();
        Enchantment.addToBookList((Enchantment)enchHaste);
        Property enchRep = config.get(CATEGORY_ENCH, "ench_repair", encIdx++);
        enchRepair = new EnchantmentRepair(enchRep.getInt(), 2);
        ThaumcraftEnchantments.REPAIR = enchRep.getInt();
        Enchantment.addToBookList((Enchantment)enchRepair);
        config.save();
    }

    public static void save() {
        config.save();
    }

    public static void initPotions() {
        PotionFluxTaint.instance = new PotionFluxTaint(true, 0x663377);
        PotionFluxTaint.init();
        PotionVisExhaust.instance = new PotionVisExhaust(true, 0x664477);
        PotionVisExhaust.init();
        PotionInfectiousVisExhaust.instance = new PotionInfectiousVisExhaust(true, 0x665577);
        PotionInfectiousVisExhaust.init();
        PotionUnnaturalHunger.instance = new PotionUnnaturalHunger(true, 0x446633);
        PotionUnnaturalHunger.init();
        PotionWarpWard.instance = new PotionWarpWard(false, 14742263);
        PotionWarpWard.init();
        PotionDeathGaze.instance = new PotionDeathGaze(true, 0x664433);
        PotionDeathGaze.init();
        PotionBlurredVision.instance = new PotionBlurredVision(true, 0x808080);
        PotionBlurredVision.init();
        PotionSunScorned.instance = new PotionSunScorned(true, 16308330);
        PotionSunScorned.init();
        PotionThaumarhia.instance = new PotionThaumarhia(true, 0x664477);
        PotionThaumarhia.init();
    }

    public static void syncConfigurable() {
        Property cb = config.get(CATEGORY_GRAPHICS, "color_blind", colorBlind);
        cb.comment = "Setting this to true will make certain colors higher contrast or darker to prevent them from being 'invisible' to color blind people.";
        colorBlind = cb.getBoolean(false);
        Property ltt = config.get(CATEGORY_GRAPHICS, "large_tag_text", largeTagText);
        ltt.comment = "Setting this to true will make the amount text in aspect tags twice as large. Useful for certain resolutions and custom fonts.";
        largeTagText = ltt.getBoolean(false);
        Property shad = config.get(CATEGORY_GRAPHICS, "shaders", shaders);
        shad.comment = "This setting will disable certain thaumcraft shaders for those who experience FPS drops.";
        shaders = shad.getBoolean(false);
        Property nost = config.get(CATEGORY_GRAPHICS, "no_stress", nostress);
        nost.comment = "Set to true to disable anxiety triggers like the heartbeat sound.";
        nostress = nost.getBoolean(false);
        Property ocd = config.get(CATEGORY_GRAPHICS, "crooked", crooked);
        ocd.comment = "Hate crooked labels, kittens, puppies and all things awesome? If yes, set this to false.";
        crooked = ocd.getBoolean(true);
        Property dbp = config.get(CATEGORY_GRAPHICS, "wand_dial_bottom", dialBottom);
        dbp.comment = "Set to true to have the wand dial display in the bottom left instead of the top left.";
        dialBottom = dbp.getBoolean(false);
        Property showtags = config.get(CATEGORY_GRAPHICS, "display_aspects", false);
        showtags.comment = "Item aspects are hidden by default and pressing shift reveals them. Changing this setting to 'true' will reverse this behaviour and always display aspects unless shift is pressed.";
        showTags = showtags.getBoolean(false);
        Property blueb = config.get(CATEGORY_GRAPHICS, "blue_magical_forest", blueBiome);
        blueb.comment = "Set this to true to get the old blue magical forest back.";
        blueBiome = blueb.getBoolean(false);
        Property sge = config.get(CATEGORY_GRAPHICS, "show_golem_emotes", showGolemEmotes);
        sge.comment = "Will golems display emote particles if they recieve orders or encounter problems";
        showGolemEmotes = sge.getBoolean(true);
        genAura = config.get(CATEGORY_WORLD, "generate_aura_nodes", true).getBoolean(true);
        genStructure = config.get(CATEGORY_WORLD, "generate_structures", true).getBoolean(true);
        genCinnibar = config.get(CATEGORY_WORLD, "generate_cinnibar_ore", true).getBoolean(true);
        genAmber = config.get(CATEGORY_WORLD, "generate_amber_ore", true).getBoolean(true);
        genCrystals = config.get(CATEGORY_WORLD, "generate_vis_crystals", true).getBoolean(true);
        genTrees = config.get(CATEGORY_WORLD, "generate_trees", true).getBoolean(true);
        Property gt = config.get(CATEGORY_WORLD, "generate_taint", genTaint);
        gt.comment = "Can taint biomes generate at worldgen";
        genTaint = gt.getBoolean(true);
        Property aurasize = config.get(CATEGORY_WORLD, "aura_base", AURABASE);
        aurasize.comment = "The default base value of an aura that is used to generate the aura in each chunk. Default value is 100.";
        CAURABASE = AURABASE = aurasize.getInt();
        Property nodRare = config.get(CATEGORY_WORLD, "node_rarity", nodeRarity);
        nodRare.comment = "How rare nodes are in the world. The number means there will be (on average) one node per N chunks.";
        nodeRarity = nodRare.getInt();
        Property nodSpec = config.get(CATEGORY_WORLD, "special_node_rarity", specialNodeRarity);
        nodSpec.comment = "The chance of a node being special (pure, dark, unstable, etc.). The number means roughly 1 in N nodes will be special, so setting the number to 5 will mean 1 in 5 nodes may be special.";
        specialNodeRarity = nodSpec.getInt();
        if (specialNodeRarity < 3) {
            specialNodeRarity = 3;
        }
        Property regKey = config.get(CATEGORY_REGEN, "regen_key", "DEFAULT");
        regKey.comment = "This key is used to keep track of which chunk have been generated/regenerated. Changing it will cause the regeneration code to run again, so only change it if you want it to happen. Useful to regen only one world feature at a time.";
        regenKey = regKey.getString();
        regenAura = config.get(CATEGORY_REGEN, "aura_nodes", false).getBoolean(false);
        regenStructure = config.get(CATEGORY_REGEN, "structures", false).getBoolean(false);
        regenCinnibar = config.get(CATEGORY_REGEN, "cinnibar_ore", false).getBoolean(false);
        regenAmber = config.get(CATEGORY_REGEN, "amber_ore", false).getBoolean(false);
        regenCrystals = config.get(CATEGORY_REGEN, "vis_crystals", false).getBoolean(false);
        regenTrees = config.get(CATEGORY_REGEN, "trees", false).getBoolean(false);
        regenTaint = config.get(CATEGORY_REGEN, "taint", false).getBoolean(false);
        Property resDif = config.get(CATEGORY_RESEARCH, "research_difficulty", 0);
        resDif.comment = "0 = normal, -1 = easy (all research items are directly purchased with levels), 1 = Hard (all research items need to be solved via the research table)";
        CresearchDifficulty = researchDifficulty = resDif.getInt(0);
        Property resAmt = config.get(CATEGORY_RESEARCH, "research_amount", 1);
        resAmt.comment = "This setting is useful for cooperative or team play. When a research is completed this is the amount of discoveries that will be created (default 1, max 64) Setting it less than 1 will create a discovery that will not be used up when learned.";
        if (resAmt.getInt(0) > 64) {
            resAmt.set(64);
        }
        if (resAmt.getInt(0) < 0) {
            resAmt.set(0);
        }
        CresearchAmount = researchAmount = resAmt.getInt(1);
        spawnAngryZombie = config.get(CATEGORY_SPAWN, "spawn_angry_zombies", true).getBoolean(true);
        spawnFireBat = config.get(CATEGORY_SPAWN, "spawn_fire_bats", true).getBoolean(true);
        spawnWisp = config.get(CATEGORY_SPAWN, "spawn_wisps", true).getBoolean(true);
        spawnTaintacle = config.get(CATEGORY_SPAWN, "spawn_taintacles", true).getBoolean(true);
        spawnTaintSpore = config.get(CATEGORY_SPAWN, "spawn_taint_spores", true).getBoolean(true);
        spawnPech = config.get(CATEGORY_SPAWN, "spawn_pechs", true).getBoolean(true);
        spawnElder = config.get(CATEGORY_SPAWN, "spawn_eldercreatures", true).getBoolean(true);
        Property cm = config.get(CATEGORY_SPAWN, "champion_mobs", championMobs);
        cm.comment = "Setting this to false will disable spawning champion mobs. Even when false they will still have a greatly reduced chance of spawning in certain dangerous places.";
        championMobs = cm.getBoolean(true);
        Property am = config.get("general", "allow_mirrors", allowMirrors);
        am.comment = "Setting this to false will disable arcane mirror research and crafting recipes.";
        CallowMirrors = allowMirrors = am.getBoolean(true);
        Property wm = config.get("general", "wuss_mode", wuss);
        wm.comment = "Setting this to true disables Warp, Taint spread and similar mechanics. You wuss.";
        Cwuss = wuss = wm.getBoolean(false);
        Property cheatsheet = config.get("general", "allow_cheat_sheet", false);
        cheatsheet.comment = "Enables a version of the Thauminomicon in creative mode that grants you all the research when you first use it.";
        CallowCheatSheet = allowCheatSheet = cheatsheet.getBoolean(false);
        Property wardstone = config.get("general", "allow_warded_stone", true);
        wardstone.comment = "If set to false, warded stone, doors and glass will just be cosmetic in nature and not have its hardened properties (everyone will be able to break it with equal ease).";
        CwardedStone = wardedStone = wardstone.getBoolean(false);
        Property ts = config.get("general", "taint_spread", (int)(taintSpreadRate * 100.0f));
        ts.comment = "The % chance of taint spread costing flux from the aura.";
        taintSpreadRate = (float)ts.getInt() / 100.0f;
        Property od = config.get(CATEGORY_WORLD, "ore_density", oreDensity);
        od.comment = "The % of normal ore amounts that will be spawned. For example 50 will spawn half the ores while 200 will spawn double. Default 100";
        oreDensity = Math.max(1, od.getInt());
        Property dd = config.get(CATEGORY_WORLD, "dust_degrade", dustDegrade);
        dd.comment = "The 1 in N chance of degraded taint dust levels lowering each block update. In other words - if you want to have dust go away faster set this lower. Default 25";
        dustDegrade = Math.max(1, dd.getInt());
        Property std = config.get("general", "tainted_soil_to_dirt", false);
        std.comment = "If set to true, tainted soil will turn into dirt, not degraded dust. Default false.";
        soilToDirt = std.getBoolean(false);
        Property rss = config.get(CATEGORY_RUNIC, "runic_shield_recharge_speed", shieldRecharge);
        rss.comment = "How many milliseconds passes between runic shielding recharge ticks. Lower values equals faster recharge. Minimum of 500.";
        shieldRecharge = Math.max(500, rss.getInt());
        Property rsd = config.get(CATEGORY_RUNIC, "runic_shield_recharge_delay", shieldWait);
        rsd.comment = "How many milliseconds passes after a shield has been reduced to zero before it can start recharging again. Minimum of 0.";
        shieldWait = Math.max(0, rsd.getInt());
        Property rsc = config.get(CATEGORY_RUNIC, "runic_shield_cost", shieldCost);
        rsc.comment = "How much aer and terra vis it costs to reacharge a single unit of shielding. Minimum of 0.";
        shieldCost = Math.max(0, rsc.getInt());
    }

    public static void initLoot() {
        Random rand = new Random(System.currentTimeMillis());
        ItemStack amulet = new ItemStack(ItemsTC.amuletVis, 1, 0);
        ItemAmuletVis ai = (ItemAmuletVis)amulet.func_77973_b();
        for (Aspect a : Aspect.getPrimalAspects()) {
            ai.addVis(amulet, a, rand.nextInt(5), true);
        }
        ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.coin, 1), 2500, 0);
        ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.coin, 2), 2250, 1);
        ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.coin, 3), 2000, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.primordialPearl), 1, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151156_bN), 1, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151045_i), 10, 0);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151045_i), 50, 1, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151166_bC), 15, 0);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151166_bC), 75, 1, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151043_k), 100, 0, 1, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151079_bi), 100, 0, 1, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.knowledgeFragment), 25, 0, 1, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.baubles, 1, 0), 10, 0);
        ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.baubles, 1, 1), 10, 0);
        ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.baubles, 1, 2), 10, 0);
        for (int a = 3; a <= 8; ++a) {
            ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.baubles, 1, a), 5, 1);
            ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.baubles, 1, a), 7, 2);
        }
        ThaumcraftApi.addLootBagItem(amulet.func_77946_l(), 6, 1, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.ringRunic, 1, 0), 5, 1, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151062_by), 5, 0);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151062_by), 10, 1);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151062_by), 20, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151153_ao, 1, 1), 1, 0);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151153_ao, 1, 1), 2, 1);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151153_ao, 1, 1), 3, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151153_ao, 1, 0), 3, 0);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151153_ao, 1, 0), 6, 1);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151153_ao, 1, 0), 9, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151122_aG), 10, 0, 1, 2);
        for (int i = 0; i <= 15; ++i) {
            for (int j = 0; j <= 1; ++j) {
                int k = j == 0 ? i | 0x2000 : i | 0x4000;
                for (int l = 0; l <= 2; ++l) {
                    List list1;
                    int i1 = k;
                    if (l != 0) {
                        if (l == 1) {
                            i1 = k | 0x20;
                        } else if (l == 2) {
                            i1 = k | 0x40;
                        }
                    }
                    if ((list1 = PotionHelper.func_77917_b((int)i1, (boolean)false)) == null || list1.isEmpty()) continue;
                    ThaumcraftApi.addLootBagItem(new ItemStack((Item)Items.field_151068_bn, 1, i1), l + 1, 0, 1, 2);
                }
            }
        }
        ItemStack[] commonLoot = new ItemStack[]{new ItemStack(ItemsTC.lootBag, 1, 0), new ItemStack(ItemsTC.ingots), new ItemStack(ItemsTC.amber)};
        ItemStack[] uncommonLoot = new ItemStack[]{new ItemStack(ItemsTC.lootBag, 1, 1), new ItemStack(ItemsTC.baubles, 1, 0), new ItemStack(ItemsTC.baubles, 1, 1), new ItemStack(ItemsTC.baubles, 1, 2), new ItemStack(ItemsTC.knowledgeFragment)};
        ItemStack[] rareLoot = new ItemStack[]{new ItemStack(ItemsTC.lootBag, 1, 2), new ItemStack(ItemsTC.thaumonomicon), new ItemStack(ItemsTC.thaumiumSword), new ItemStack(ItemsTC.thaumiumAxe), new ItemStack(ItemsTC.thaumiumHoe), new ItemStack(ItemsTC.thaumiumPick), new ItemStack(ItemsTC.ringRunic), new ItemStack(ItemsTC.baubles, 1, 3), new ItemStack(ItemsTC.baubles, 1, 4), new ItemStack(ItemsTC.baubles, 1, 5), new ItemStack(ItemsTC.baubles, 1, 6), new ItemStack(ItemsTC.baubles, 1, 7), new ItemStack(ItemsTC.baubles, 1, 8), amulet};
        for (ItemStack is : commonLoot) {
            ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(is, 1, 3, 5));
            ChestGenHooks.addItem((String)"pyramidJungleChest", (WeightedRandomChestContent)new WeightedRandomChestContent(is, 1, 3, 5));
            ChestGenHooks.addItem((String)"pyramidDesertyChest", (WeightedRandomChestContent)new WeightedRandomChestContent(is, 1, 3, 5));
            ChestGenHooks.addItem((String)"mineshaftCorridor", (WeightedRandomChestContent)new WeightedRandomChestContent(is, 1, 3, 4));
            ChestGenHooks.addItem((String)"strongholdCorridor", (WeightedRandomChestContent)new WeightedRandomChestContent(is, 1, 3, 4));
            ChestGenHooks.addItem((String)"strongholdCrossing", (WeightedRandomChestContent)new WeightedRandomChestContent(is, 1, 3, 4));
            ChestGenHooks.addItem((String)"strongholdLibrary", (WeightedRandomChestContent)new WeightedRandomChestContent(is, 1, 3, 4));
        }
        for (ItemStack is : uncommonLoot) {
            ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(is, 1, 2, 4));
            ChestGenHooks.addItem((String)"pyramidJungleChest", (WeightedRandomChestContent)new WeightedRandomChestContent(is, 1, 2, 4));
            ChestGenHooks.addItem((String)"pyramidDesertyChest", (WeightedRandomChestContent)new WeightedRandomChestContent(is, 1, 2, 4));
            ChestGenHooks.addItem((String)"mineshaftCorridor", (WeightedRandomChestContent)new WeightedRandomChestContent(is, 1, 2, 3));
            ChestGenHooks.addItem((String)"strongholdCorridor", (WeightedRandomChestContent)new WeightedRandomChestContent(is, 1, 2, 3));
            ChestGenHooks.addItem((String)"strongholdCrossing", (WeightedRandomChestContent)new WeightedRandomChestContent(is, 1, 2, 3));
            ChestGenHooks.addItem((String)"strongholdLibrary", (WeightedRandomChestContent)new WeightedRandomChestContent(is, 1, 2, 3));
        }
        ChestGenHooks.addItem((String)"strongholdLibrary", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(ItemsTC.knowledgeFragment), 3, 6, 20));
        for (ItemStack is : rareLoot) {
            ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(is, 1, 1, 1));
            ChestGenHooks.addItem((String)"pyramidJungleChest", (WeightedRandomChestContent)new WeightedRandomChestContent(is, 1, 1, 1));
            ChestGenHooks.addItem((String)"pyramidDesertyChest", (WeightedRandomChestContent)new WeightedRandomChestContent(is, 1, 1, 1));
            ChestGenHooks.addItem((String)"mineshaftCorridor", (WeightedRandomChestContent)new WeightedRandomChestContent(is, 1, 1, 1));
            ChestGenHooks.addItem((String)"strongholdCorridor", (WeightedRandomChestContent)new WeightedRandomChestContent(is, 1, 1, 1));
            ChestGenHooks.addItem((String)"strongholdCrossing", (WeightedRandomChestContent)new WeightedRandomChestContent(is, 1, 1, 1));
            ChestGenHooks.addItem((String)"strongholdLibrary", (WeightedRandomChestContent)new WeightedRandomChestContent(is, 1, 1, 1));
        }
        ChestGenHooks.addItem((String)"villageBlacksmith", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(ItemsTC.ingots), 1, 3, 10));
    }

    public static void initModCompatibility() {
        String[] ores;
        for (String ore : ores = OreDictionary.getOreNames()) {
            if (ore == null) continue;
            if (ore.equals("oreCopper") && OreDictionary.getOres((String)ore).size() > 0) {
                foundCopperOre = true;
                for (ItemStack is : OreDictionary.getOres((String)ore)) {
                    Utils.addSpecialMiningResult(is, new ItemStack(ItemsTC.clusters, 1, 2), 1.0f);
                }
            }
            if (ore.equals("oreTin") && OreDictionary.getOres((String)ore).size() > 0) {
                foundTinOre = true;
                for (ItemStack is : OreDictionary.getOres((String)ore)) {
                    Utils.addSpecialMiningResult(is, new ItemStack(ItemsTC.clusters, 1, 3), 1.0f);
                }
            }
            if (ore.equals("oreSilver") && OreDictionary.getOres((String)ore).size() > 0) {
                foundSilverOre = true;
                for (ItemStack is : OreDictionary.getOres((String)ore)) {
                    Utils.addSpecialMiningResult(is, new ItemStack(ItemsTC.clusters, 1, 4), 1.0f);
                }
            }
            if (ore.equals("oreLead") && OreDictionary.getOres((String)ore).size() > 0) {
                foundLeadOre = true;
                for (ItemStack is : OreDictionary.getOres((String)ore)) {
                    Utils.addSpecialMiningResult(is, new ItemStack(ItemsTC.clusters, 1, 5), 1.0f);
                }
            }
            if (ore.equals("ingotCopper")) {
                boolean first = true;
                for (ItemStack is : OreDictionary.getOres((String)ore)) {
                    if (is.field_77994_a > 1) {
                        is.field_77994_a = 1;
                    }
                    foundCopperIngot = true;
                    CraftingManager.func_77594_a().func_92103_a(new ItemStack(ItemsTC.nuggets, 9, 1), new Object[]{"#", Character.valueOf('#'), is});
                    if (!first) continue;
                    first = false;
                    FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(ItemsTC.clusters, 1, 2), new ItemStack(is.func_77973_b(), 2, is.func_77952_i()), 1.0f);
                    ConfigRecipes.oreDictRecipe(is, new Object[]{"###", "###", "###", Character.valueOf('#'), new ItemStack(ItemsTC.nuggets, 1, 1)});
                }
                continue;
            }
            if (ore.equals("ingotTin")) {
                boolean first = true;
                for (ItemStack is : OreDictionary.getOres((String)ore)) {
                    if (is.field_77994_a > 1) {
                        is.field_77994_a = 1;
                    }
                    foundTinIngot = true;
                    CraftingManager.func_77594_a().func_92103_a(new ItemStack(ItemsTC.nuggets, 9, 2), new Object[]{"#", Character.valueOf('#'), is});
                    if (!first) continue;
                    first = false;
                    FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(ItemsTC.clusters, 1, 3), new ItemStack(is.func_77973_b(), 2, is.func_77952_i()), 1.0f);
                    ConfigRecipes.oreDictRecipe(is, new Object[]{"###", "###", "###", Character.valueOf('#'), new ItemStack(ItemsTC.nuggets, 1, 2)});
                }
                continue;
            }
            if (ore.equals("ingotSilver")) {
                boolean first = true;
                for (ItemStack is : OreDictionary.getOres((String)ore)) {
                    if (is.field_77994_a > 1) {
                        is.field_77994_a = 1;
                    }
                    foundSilverIngot = true;
                    CraftingManager.func_77594_a().func_92103_a(new ItemStack(ItemsTC.nuggets, 9, 3), new Object[]{"#", Character.valueOf('#'), is});
                    if (!first) continue;
                    first = false;
                    FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(ItemsTC.clusters, 1, 4), new ItemStack(is.func_77973_b(), 2, is.func_77952_i()), 1.0f);
                    ConfigRecipes.oreDictRecipe(is, new Object[]{"###", "###", "###", Character.valueOf('#'), new ItemStack(ItemsTC.nuggets, 1, 3)});
                }
                continue;
            }
            if (ore.equals("oreUranium") || ore.equals("itemDropUranium") || ore.equals("ingotUranium")) {
                for (ItemStack is : OreDictionary.getOres((String)ore)) {
                    ThaumcraftApi.registerObjectTag(is, new AspectList().add(Aspect.METAL, 2).add(Aspect.DEATH, 1).add(Aspect.ENERGY, 2));
                }
                continue;
            }
            if (ore.equals("ingotBrass") || ore.equals("ingotBronze")) {
                for (ItemStack is : OreDictionary.getOres((String)ore)) {
                    ThaumcraftApi.registerObjectTag(is, new AspectList().add(Aspect.METAL, 3).add(Aspect.TOOL, 1));
                }
                continue;
            }
            if (ore.equals("dustBrass") || ore.equals("dustBronze")) {
                for (ItemStack is : OreDictionary.getOres((String)ore)) {
                    ThaumcraftApi.registerObjectTag(is, new AspectList().add(Aspect.METAL, 2).add(Aspect.ENTROPY, 1).add(Aspect.TOOL, 1));
                }
                continue;
            }
            if (ore.equals("gemRuby") || ore.equals("gemGreenSapphire") || ore.equals("gemSapphire")) {
                for (ItemStack is : OreDictionary.getOres((String)ore)) {
                    ThaumcraftApi.registerObjectTag(is, new AspectList().add(Aspect.CRYSTAL, 2).add(Aspect.DESIRE, 2));
                }
                continue;
            }
            if (ore.equals("woodRubber")) {
                for (ItemStack is : OreDictionary.getOres((String)ore)) {
                    ThaumcraftApi.registerObjectTag(is, new AspectList().add(Aspect.PLANT, 3).add(Aspect.TOOL, 1));
                }
                continue;
            }
            if (ore.equals("itemRubber")) {
                for (ItemStack is : OreDictionary.getOres((String)ore)) {
                    ThaumcraftApi.registerObjectTag(is, new AspectList().add(Aspect.MOTION, 2).add(Aspect.TOOL, 2));
                }
                continue;
            }
            if (ore.equals("ingotSteel")) {
                for (ItemStack is : OreDictionary.getOres((String)ore)) {
                    ThaumcraftApi.registerObjectTag(is, new AspectList().add(Aspect.METAL, 3).add(Aspect.ORDER, 1));
                }
                continue;
            }
            if (ore.equals("crystalQuartz")) {
                for (ItemStack is : OreDictionary.getOres((String)ore)) {
                    ThaumcraftApi.registerObjectTag(is, new AspectList().add(Aspect.CRYSTAL, 1).add(Aspect.ENERGY, 1));
                }
                continue;
            }
            if (!ore.equals("ingotLead")) continue;
            boolean first = true;
            for (ItemStack is : OreDictionary.getOres((String)ore)) {
                if (is.field_77994_a > 1) {
                    is.field_77994_a = 1;
                }
                foundLeadIngot = true;
                CraftingManager.func_77594_a().func_92103_a(new ItemStack(ItemsTC.nuggets, 9, 4), new Object[]{"#", Character.valueOf('#'), is});
                if (!first) continue;
                first = false;
                FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(ItemsTC.clusters, 1, 5), new ItemStack(is.func_77973_b(), 2, is.func_77952_i()), 1.0f);
                ConfigRecipes.oreDictRecipe(is, new Object[]{"###", "###", "###", Character.valueOf('#'), new ItemStack(ItemsTC.nuggets, 1, 4)});
            }
        }
        Thaumcraft.log.info("Adding entities to MFR safari net blacklist.");
        Config.registerSafariNetBlacklist(EntityOwnedConstruct.class);
        Config.registerSafariNetBlacklist(EntityFallingTaint.class);
        Config.registerSafariNetBlacklist(EntityWisp.class);
        Config.registerSafariNetBlacklist(EntityPech.class);
        Config.registerSafariNetBlacklist(EntityEldritchGuardian.class);
        Config.registerSafariNetBlacklist(EntityEldritchWarden.class);
        Config.registerSafariNetBlacklist(EntityEldritchGolem.class);
        Config.registerSafariNetBlacklist(EntityCultistCleric.class);
        Config.registerSafariNetBlacklist(EntityCultistKnight.class);
        Config.registerSafariNetBlacklist(EntityCultistLeader.class);
        Config.registerSafariNetBlacklist(EntityCultistPortalGreater.class);
        Config.registerSafariNetBlacklist(EntityCultistPortalLesser.class);
        Config.registerSafariNetBlacklist(EntityEldritchCrab.class);
        Config.registerSafariNetBlacklist(EntityInhabitedZombie.class);
    }

    public static void registerSafariNetBlacklist(Class<?> blacklistedEntity) {
        try {
            Class<?> registry = Class.forName("powercrystals.minefactoryreloaded.MFRRegistry");
            if (registry != null) {
                Method reg = registry.getMethod("registerSafariNetBlacklist", Class.class);
                reg.invoke(registry, blacklistedEntity);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void initMisc() {
        for (Item item : GameData.getItemRegistry().typeSafeIterable()) {
            IBlockState bs;
            if (item == null || !(item instanceof IPlantable) || (bs = ((IPlantable)item).getPlant(null, null)) == null) continue;
            ThaumcraftApi.registerSeed(bs.func_177230_c(), new ItemStack(item));
        }
        CropUtils.addStandardCrop(Blocks.field_150440_ba, Short.MAX_VALUE);
        CropUtils.addStandardCrop(Blocks.field_150423_aK, Short.MAX_VALUE);
        CropUtils.addStackedCrop((Block)Blocks.field_150436_aH, Short.MAX_VALUE);
        CropUtils.addStackedCrop((Block)Blocks.field_150434_aF, Short.MAX_VALUE);
        CropUtils.addStandardCrop(Blocks.field_150388_bm, 3);
        ThaumcraftApi.registerSeed(Blocks.field_150375_by, new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BROWN.func_176767_b()));
        Utils.addSpecialMiningResult(new ItemStack(Blocks.field_150366_p), new ItemStack(ItemsTC.clusters, 1, 0), 1.0f);
        Utils.addSpecialMiningResult(new ItemStack(Blocks.field_150352_o), new ItemStack(ItemsTC.clusters, 1, 1), 1.0f);
        Utils.addSpecialMiningResult(new ItemStack(BlocksTC.oreCinnabar), new ItemStack(ItemsTC.clusters, 1, 6), 1.0f);
        Collection<Aspect> pa = Aspect.aspects.values();
        for (Aspect aspect : pa) {
            aspectOrder.add(aspect);
        }
    }

    static {
        overworldDim = 0;
        biomeTaintID = 192;
        biomeMagicalForestID = 193;
        biomeEerieID = 194;
        biomeEldritchID = 195;
        biomeTaintWeight = 2;
        biomeMagicalForestWeight = 5;
        taintSpreadRate = 0.05f;
        wuss = false;
        dimensionOuterId = -42;
        championMobs = true;
        AURABASE = 100;
        oreDensity = 100;
        dustDegrade = 25;
        soilToDirt = false;
        shieldRecharge = 2000;
        shieldWait = 4000;
        shieldCost = 1;
        largeTagText = false;
        colorBlind = false;
        shaders = true;
        nostress = false;
        crooked = true;
        showTags = false;
        blueBiome = false;
        allowMirrors = true;
        dialBottom = false;
        showGolemEmotes = true;
        nodeRefresh = 10;
        genAura = true;
        genStructure = true;
        genCinnibar = true;
        genAmber = true;
        genCrystals = true;
        genTrees = true;
        genTaint = true;
        regenAura = false;
        regenStructure = false;
        regenCinnibar = false;
        regenAmber = false;
        regenCrystals = false;
        regenTrees = false;
        regenTaint = false;
        regenKey = "DEFAULT";
        wardedStone = true;
        allowCheatSheet = true;
        golemChestInteract = true;
        nodeRarity = 33;
        specialNodeRarity = 10;
        researchDifficulty = 0;
        researchAmount = 1;
        CAURABASE = 100;
        CwardedStone = true;
        CallowCheatSheet = true;
        CallowMirrors = true;
        ChardNode = true;
        Cwuss = false;
        CresearchDifficulty = 0;
        CresearchAmount = 1;
        spawnAngryZombie = true;
        spawnFireBat = true;
        spawnTaintacle = true;
        spawnWisp = true;
        spawnTaintSpore = true;
        spawnPech = true;
        spawnElder = true;
        enchHaste = null;
        enchRepair = null;
        aspectOrder = new ArrayList();
        foundCopperIngot = false;
        foundTinIngot = false;
        foundSilverIngot = false;
        foundLeadIngot = false;
        foundCopperOre = false;
        foundTinOre = false;
        foundSilverOre = false;
        foundLeadOre = false;
    }
}

