/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct;

import com.google.common.base.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.entities.IEldritchMob;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.entities.construct.EntityTurretFocus;

public class EntityTurretEldritch
extends EntityTurretFocus
implements IEldritchMob {
    private static final Predicate attackEntitySelector = new Predicate(){

        public boolean func_180027_a(Entity p_180027_1_) {
            return p_180027_1_ instanceof EntityLivingBase && !(p_180027_1_ instanceof IEldritchMob) && ((EntityLivingBase)p_180027_1_).func_70668_bt() != EnumCreatureAttribute.UNDEAD;
        }

        public boolean apply(Object p_apply_1_) {
            return this.func_180027_a((Entity)p_apply_1_);
        }
    };

    public EntityTurretEldritch(World worldIn) {
        super(worldIn);
        this.field_70715_bh.field_75782_a.clear();
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 5, true, false, attackEntitySelector));
        this.maxVis = 50;
        this.field_70728_aV = 10;
    }

    public EntityTurretEldritch(World worldIn, BlockPos pos, EnumFacing face) {
        super(worldIn, pos, face);
    }

    @Override
    public boolean func_70686_a(Class clazz) {
        return !IEldritchMob.class.isAssignableFrom(clazz);
    }

    @Override
    public boolean func_142014_c(EntityLivingBase otherEntity) {
        return otherEntity instanceof IEldritchMob || this.func_142012_a(otherEntity.func_96124_cp());
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(55.0);
    }

    @Override
    public int func_70658_aO() {
        return 8;
    }

    @Override
    protected void doUpdateStuff() {
        if (this.func_70638_az() != null && this.func_70638_az() instanceof IEldritchMob) {
            this.func_70624_b(null);
        }
    }

    @Override
    protected void dropFocus() {
    }

    public IEntityLivingData func_180482_a(DifficultyInstance diff, IEntityLivingData data) {
        for (Aspect aspect : Aspect.getPrimalAspects()) {
            this.vis.add(aspect, 10 + this.field_70146_Z.nextInt(10));
        }
        switch (this.field_70146_Z.nextInt(10)) {
            case 4: 
            case 5: {
                this.func_70062_b(0, new ItemStack(ItemsTC.focusShock));
                break;
            }
            case 6: 
            case 7: {
                this.func_70062_b(0, new ItemStack(ItemsTC.focusFrost));
                break;
            }
            case 8: 
            case 9: {
                this.func_70062_b(0, new ItemStack(ItemsTC.focusFire));
                break;
            }
            default: {
                this.func_70062_b(0, new ItemStack(ItemsTC.focusShard));
            }
        }
        this.updateFocus();
        return super.func_180482_a(diff, data);
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        return false;
    }

    @Override
    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        float b = (float)p_70628_2_ * 0.15f;
        if (this.field_70146_Z.nextFloat() < 0.3f + b) {
            this.func_70099_a(new ItemStack(ItemsTC.brain), 0.5f);
        }
        if (this.field_70146_Z.nextFloat() < 0.3f + b) {
            this.func_70099_a(new ItemStack(ItemsTC.ingots, 1, 1), 0.5f);
        }
        if (this.field_70146_Z.nextFloat() < 0.3f + b) {
            this.func_70099_a(new ItemStack(ItemsTC.ingots, 1, 1), 0.5f);
        }
        if (this.field_70146_Z.nextFloat() < 0.15f + b / 2.0f && this.func_70694_bm() != null) {
            this.func_70099_a(this.func_70694_bm(), 0.5f);
        }
    }
}

