/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct.golem.seals;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.golems.EnumGolemTrait;
import thaumcraft.api.golems.GolemHelper;
import thaumcraft.api.golems.IGolemAPI;
import thaumcraft.api.golems.seals.ISealConfigArea;
import thaumcraft.api.golems.seals.ISealConfigToggles;
import thaumcraft.api.golems.seals.ISealEntity;
import thaumcraft.api.golems.tasks.Task;
import thaumcraft.common.entities.construct.golem.gui.SealBaseContainer;
import thaumcraft.common.entities.construct.golem.gui.SealBaseGUI;
import thaumcraft.common.entities.construct.golem.seals.SealFiltered;
import thaumcraft.common.entities.construct.golem.tasks.TaskHandler;
import thaumcraft.common.lib.utils.BlockUtils;

public class SealBreaker
extends SealFiltered
implements ISealConfigArea,
ISealConfigToggles {
    int delay = new Random(System.nanoTime()).nextInt(42);
    int count = 0;
    HashMap<Integer, Long> cache = new HashMap();
    ResourceLocation icon = new ResourceLocation("thaumcraft", "items/seals/seal_breaker");
    protected ISealConfigToggles.SealToggle[] props = new ISealConfigToggles.SealToggle[]{new ISealConfigToggles.SealToggle(true, "pmeta", "golem.prop.meta")};

    @Override
    public String getKey() {
        return "Thaumcraft:breaker";
    }

    @Override
    public void tickSeal(World world, ISealEntity seal) {
        if (this.delay % 100 == 0) {
            Iterator<Integer> it = this.cache.keySet().iterator();
            while (it.hasNext()) {
                Task t = TaskHandler.getTask(world.field_73011_w.func_177502_q(), it.next());
                if (t != null) continue;
                it.remove();
            }
        }
        if (this.delay++ % 5 != 0) {
            return;
        }
        ++this.count;
        BlockPos p = GolemHelper.getPosInArea(seal, this.count);
        if (!this.cache.containsValue(p.func_177986_g()) && this.isValidBlock(world, p)) {
            Task task = new Task(seal.getSealPos(), p);
            task.setPriority(seal.getPriority());
            task.setData((int)(world.func_180495_p(p).func_177230_c().func_176195_g(world, p) / 3.0f));
            TaskHandler.addTask(world.field_73011_w.func_177502_q(), task);
            this.cache.put(task.getId(), p.func_177986_g());
        }
    }

    private boolean isValidBlock(World world, BlockPos p) {
        IBlockState bs = world.func_180495_p(p);
        if (!world.func_175623_d(p) && bs.func_177230_c().func_176195_g(world, p) >= 0.0f) {
            int m1 = bs.func_177230_c().func_176201_c(bs);
            ItemStack ts = this.getFilterSlot(0);
            if (ts != null) {
                ItemStack fs = new ItemStack(bs.func_177230_c(), 1, !this.getToggles()[0].value ? Short.MAX_VALUE : m1);
                if (this.isBlacklist() ? OreDictionary.itemMatches((ItemStack)fs, (ItemStack)this.getFilterSlot(0), (boolean)this.getToggles()[0].value) : !OreDictionary.itemMatches((ItemStack)fs, (ItemStack)this.getFilterSlot(0), (boolean)this.getToggles()[0].value)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onTaskCompletion(World world, IGolemAPI golem, Task task) {
        IBlockState bs = world.func_180495_p(task.getPos());
        if (this.cache.containsKey(task.getId()) && this.isValidBlock(world, task.getPos())) {
            FakePlayer fp = FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)new GameProfile((UUID)null, "FakeThaumcraftGolem"));
            fp.func_70107_b(golem.getGolemEntity().field_70165_t, golem.getGolemEntity().field_70163_u, golem.getGolemEntity().field_70161_v);
            golem.swingArm();
            if (task.getData() > 0) {
                float bh = bs.func_177230_c().func_176195_g(world, task.getPos()) / 3.0f;
                world.func_72908_a((double)((float)task.getPos().func_177958_n() + 0.5f), (double)((float)task.getPos().func_177956_o() + 0.5f), (double)((float)task.getPos().func_177952_p() + 0.5f), bs.func_177230_c().field_149762_H.func_150495_a(), (bs.func_177230_c().field_149762_H.func_150497_c() + 0.7f) / 8.0f, bs.func_177230_c().field_149762_H.func_150494_d() * 0.5f);
                BlockUtils.destroyBlockPartially(world, golem.getGolemEntity().func_145782_y(), task.getPos(), (int)(9.0f * (1.0f - (float)task.getData() / bh)));
                task.setLifespan((short)Math.max(task.getLifespan(), 10L));
                task.setData(task.getData() - 1);
                return false;
            }
            BlockUtils.harvestBlock(world, (EntityPlayer)fp, task.getPos(), false, 0, true);
            golem.addRankXp(1);
            this.cache.remove(task.getId());
        }
        task.setSuspended(true);
        return true;
    }

    @Override
    public boolean canGolemPerformTask(IGolemAPI golem, Task task) {
        if (this.cache.containsKey(task.getId()) && this.isValidBlock(golem.getGolemWorld(), task.getPos())) {
            return true;
        }
        task.setSuspended(true);
        return false;
    }

    @Override
    public void onTaskSuspension(World world, Task task) {
        this.cache.remove(task.getId());
    }

    @Override
    public boolean canPlaceAt(World world, BlockPos pos, EnumFacing side) {
        return !world.func_175623_d(pos);
    }

    @Override
    public ResourceLocation getSealIcon() {
        return this.icon;
    }

    @Override
    public void onRemoval(World world, BlockPos pos, EnumFacing side) {
    }

    @Override
    public Object returnContainer(World world, EntityPlayer player, BlockPos pos, EnumFacing side, ISealEntity seal) {
        return new SealBaseContainer(player.field_71071_by, world, seal);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object returnGui(World world, EntityPlayer player, BlockPos pos, EnumFacing side, ISealEntity seal) {
        return new SealBaseGUI(player.field_71071_by, world, seal);
    }

    @Override
    public int[] getGuiCategories() {
        return new int[]{2, 1, 3, 0, 4};
    }

    @Override
    public EnumGolemTrait[] getRequiredTags() {
        return new EnumGolemTrait[]{EnumGolemTrait.BREAKER};
    }

    @Override
    public EnumGolemTrait[] getForbiddenTags() {
        return null;
    }

    @Override
    public void onTaskStarted(World world, IGolemAPI golem, Task task) {
    }

    @Override
    public ISealConfigToggles.SealToggle[] getToggles() {
        return this.props;
    }

    @Override
    public void setToggle(int indx, boolean value) {
        this.props[indx].setValue(value);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        super.readCustomNBT(nbt);
        for (ISealConfigToggles.SealToggle prop : this.getToggles()) {
            if (!nbt.func_74764_b(prop.getKey())) continue;
            prop.setValue(nbt.func_74767_n(prop.getKey()));
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        super.writeCustomNBT(nbt);
        for (ISealConfigToggles.SealToggle prop : this.getToggles()) {
            nbt.func_74757_a(prop.getKey(), prop.getValue());
        }
    }
}

