/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct.golem.seals;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thaumcraft.api.golems.EnumGolemTrait;
import thaumcraft.api.golems.IGolemAPI;
import thaumcraft.api.golems.seals.ISealConfigToggles;
import thaumcraft.api.golems.seals.ISealEntity;
import thaumcraft.api.golems.tasks.Task;
import thaumcraft.common.entities.construct.golem.seals.SealFiltered;
import thaumcraft.common.entities.construct.golem.tasks.TaskHandler;
import thaumcraft.common.lib.utils.InventoryUtils;

public class SealEmpty
extends SealFiltered {
    int delay = new Random(System.nanoTime()).nextInt(30);
    int filterInc = 0;
    HashMap<Integer, ItemStack> cache = new HashMap();
    ResourceLocation icon = new ResourceLocation("thaumcraft", "items/seals/seal_empty");
    protected ISealConfigToggles.SealToggle[] props = new ISealConfigToggles.SealToggle[]{new ISealConfigToggles.SealToggle(true, "pmeta", "golem.prop.meta"), new ISealConfigToggles.SealToggle(true, "pnbt", "golem.prop.nbt"), new ISealConfigToggles.SealToggle(false, "pore", "golem.prop.ore"), new ISealConfigToggles.SealToggle(false, "pmod", "golem.prop.mod")};

    @Override
    public String getKey() {
        return "Thaumcraft:empty";
    }

    @Override
    public void tickSeal(World world, ISealEntity seal) {
        ItemStack stack;
        if (this.delay % 100 == 0) {
            Iterator<Integer> it = this.cache.keySet().iterator();
            while (it.hasNext()) {
                Task t = TaskHandler.getTask(world.field_73011_w.func_177502_q(), it.next());
                if (t != null) continue;
                it.remove();
            }
        }
        if (this.delay++ % 20 != 0) {
            return;
        }
        TileEntity te = world.func_175625_s(seal.getSealPos().pos);
        if (te != null && te instanceof IInventory && (stack = InventoryUtils.findFirstMatchFromFilter(this.getInv(this.filterInc), this.isBlacklist(), (IInventory)te, seal.getSealPos().face, !this.props[0].value, !this.props[1].value, this.props[2].value, this.props[3].value)) != null) {
            Task task = new Task(seal.getSealPos(), seal.getSealPos().pos);
            task.setPriority(seal.getPriority());
            task.setLifespan((short)5);
            TaskHandler.addTask(world.field_73011_w.func_177502_q(), task);
            this.cache.put(task.getId(), stack);
        }
    }

    @Override
    public boolean onTaskCompletion(World world, IGolemAPI golem, Task task) {
        TileEntity te = world.func_175625_s(task.getSealPos().pos);
        if (te != null && te instanceof IInventory) {
            ItemStack stack = this.cache.get(task.getId());
            if (stack != null && golem.canCarry(stack, true)) {
                ItemStack q;
                ItemStack s = golem.holdItem(InventoryUtils.extractStack((IInventory)te, stack.func_77946_l(), task.getSealPos().face, !this.props[0].value, !this.props[1].value, this.props[2].value, this.props[3].value, true));
                if (s != null && (q = InventoryUtils.placeItemStackIntoInventory(s, (IInventory)te, task.getSealPos().face, true)) != null) {
                    ((Entity)golem).func_70099_a(q, 0.25f);
                }
                world.func_72956_a((Entity)golem, "random.pop", 0.125f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                golem.addRankXp(1);
                golem.swingArm();
            }
            this.cache.remove(task.getId());
            ++this.filterInc;
        }
        task.setSuspended(true);
        return true;
    }

    @Override
    public boolean canGolemPerformTask(IGolemAPI golem, Task task) {
        ItemStack stack = this.cache.get(task.getId());
        return stack != null && golem.canCarry(stack, true);
    }

    @Override
    public boolean canPlaceAt(World world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        return te != null && te instanceof IInventory;
    }

    public ItemStack[] getInv(int c) {
        return super.getInv();
    }

    @Override
    public ResourceLocation getSealIcon() {
        return this.icon;
    }

    @Override
    public int[] getGuiCategories() {
        return new int[]{1, 0, 4};
    }

    @Override
    public EnumGolemTrait[] getRequiredTags() {
        return null;
    }

    @Override
    public EnumGolemTrait[] getForbiddenTags() {
        return new EnumGolemTrait[]{EnumGolemTrait.CLUMSY};
    }

    @Override
    public void onTaskStarted(World world, IGolemAPI golem, Task task) {
    }

    @Override
    public void onTaskSuspension(World world, Task task) {
        this.cache.remove(task.getId());
    }

    @Override
    public void onRemoval(World world, BlockPos pos, EnumFacing side) {
    }
}

