/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct.golem.seals;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.golems.seals.ISeal;
import thaumcraft.api.golems.seals.ISealConfigArea;
import thaumcraft.api.golems.seals.ISealEntity;
import thaumcraft.api.golems.seals.SealPos;
import thaumcraft.common.entities.construct.golem.seals.SealHandler;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.misc.PacketSealToClient;

public class SealEntity
implements ISealEntity {
    SealPos sealPos;
    ISeal seal;
    byte priority = 0;
    byte color = 0;
    boolean locked = false;
    String owner = "";
    private BlockPos area = new BlockPos(1, 1, 1);

    public SealEntity() {
    }

    public SealEntity(World world, SealPos sealPos, ISeal seal) {
        this.sealPos = sealPos;
        this.seal = seal;
        if (seal instanceof ISealConfigArea) {
            int x = sealPos.face.func_82601_c() == 0 ? 3 : 1;
            int y = sealPos.face.func_96559_d() == 0 ? 3 : 1;
            int z = sealPos.face.func_82599_e() == 0 ? 3 : 1;
            this.area = new BlockPos(x, y, z);
        }
    }

    @Override
    public void tickSealEntity(World world) {
        if (this.seal != null) {
            this.seal.tickSeal(world, this);
        }
    }

    @Override
    public ISeal getSeal() {
        return this.seal;
    }

    @Override
    public SealPos getSealPos() {
        return this.sealPos;
    }

    @Override
    public byte getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(byte priority) {
        this.priority = priority;
    }

    @Override
    public byte getColor() {
        return this.color;
    }

    @Override
    public void setColor(byte color) {
        this.color = color;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        BlockPos p = BlockPos.func_177969_a((long)nbt.func_74763_f("pos"));
        EnumFacing face = EnumFacing.field_82609_l[nbt.func_74771_c("face")];
        this.sealPos = new SealPos(p, face);
        this.setPriority(nbt.func_74771_c("priority"));
        this.setColor(nbt.func_74771_c("color"));
        this.setLocked(nbt.func_74767_n("locked"));
        this.setOwner(nbt.func_74779_i("owner"));
        try {
            this.seal = (ISeal)SealHandler.getSeal(nbt.func_74779_i("type")).getClass().newInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.seal != null) {
            this.seal.readCustomNBT(nbt);
            if (this.seal instanceof ISealConfigArea) {
                this.area = BlockPos.func_177969_a((long)nbt.func_74763_f("area"));
            }
        }
    }

    @Override
    public NBTTagCompound writeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74772_a("pos", this.sealPos.pos.func_177986_g());
        nbt.func_74774_a("face", (byte)this.sealPos.face.ordinal());
        nbt.func_74778_a("type", this.seal.getKey());
        nbt.func_74774_a("priority", this.getPriority());
        nbt.func_74774_a("color", this.getColor());
        nbt.func_74757_a("locked", this.isLocked());
        nbt.func_74778_a("owner", this.getOwner());
        if (this.seal != null) {
            this.seal.writeCustomNBT(nbt);
            if (this.seal instanceof ISealConfigArea) {
                nbt.func_74772_a("area", this.area.func_177986_g());
            }
        }
        return nbt;
    }

    @Override
    public void syncToClient(World world) {
        if (!world.field_72995_K) {
            PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketSealToClient(this), world.field_73011_w.func_177502_q());
        }
    }

    @Override
    public BlockPos getArea() {
        return this.area;
    }

    @Override
    public void setArea(BlockPos v) {
        this.area = v;
    }
}

