/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct.golem.seals;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thaumcraft.api.golems.EnumGolemTrait;
import thaumcraft.api.golems.IGolemAPI;
import thaumcraft.api.golems.seals.ISealConfigToggles;
import thaumcraft.api.golems.seals.ISealEntity;
import thaumcraft.api.golems.tasks.Task;
import thaumcraft.common.entities.construct.golem.seals.SealFiltered;
import thaumcraft.common.entities.construct.golem.seals.SealHandler;
import thaumcraft.common.entities.construct.golem.tasks.TaskHandler;
import thaumcraft.common.lib.utils.InventoryUtils;

public class SealFill
extends SealFiltered {
    int delay = new Random(System.nanoTime()).nextInt(50);
    int watchedTask = Integer.MIN_VALUE;
    protected ISealConfigToggles.SealToggle[] props = new ISealConfigToggles.SealToggle[]{new ISealConfigToggles.SealToggle(true, "pmeta", "golem.prop.meta"), new ISealConfigToggles.SealToggle(true, "pnbt", "golem.prop.nbt"), new ISealConfigToggles.SealToggle(false, "pore", "golem.prop.ore"), new ISealConfigToggles.SealToggle(false, "pmod", "golem.prop.mod")};
    ResourceLocation icon = new ResourceLocation("thaumcraft", "items/seals/seal_fill");

    @Override
    public String getKey() {
        return "Thaumcraft:fill";
    }

    @Override
    public void tickSeal(World world, ISealEntity seal) {
        if (this.delay++ % 20 != 0) {
            return;
        }
        Task oldTask = TaskHandler.getTask(world.field_73011_w.func_177502_q(), this.watchedTask);
        if (oldTask == null || oldTask.isReserved() || oldTask.isSuspended() || oldTask.isCompleted()) {
            Task task = new Task(seal.getSealPos(), seal.getSealPos().pos);
            task.setPriority(seal.getPriority());
            TaskHandler.addTask(world.field_73011_w.func_177502_q(), task);
            this.watchedTask = task.getId();
        }
    }

    @Override
    public void onTaskStarted(World world, IGolemAPI golem, Task task) {
        ISealEntity se = SealHandler.getSealEntity(world.field_73011_w.func_177502_q(), task.getSealPos());
        if (se != null) {
            Task newTask = new Task(task.getSealPos(), task.getSealPos().pos);
            newTask.setPriority(se.getPriority());
            TaskHandler.addTask(world.field_73011_w.func_177502_q(), newTask);
            this.watchedTask = newTask.getId();
        }
    }

    @Override
    public boolean onTaskCompletion(World world, IGolemAPI golem, Task task) {
        TileEntity te = world.func_175625_s(task.getSealPos().pos);
        if (te != null && te instanceof IInventory) {
            ItemStack stack = InventoryUtils.findFirstMatchFromFilter(this.getInv(), this.isBlacklist(), golem.getCarrying(), !this.props[0].value, !this.props[1].value, this.props[2].value, this.props[3].value);
            if (stack != null) {
                ItemStack s = golem.dropItem(stack);
                golem.holdItem(InventoryUtils.placeItemStackIntoInventory(s, (IInventory)te, task.getSealPos().face, true));
                world.func_72956_a((Entity)golem, "random.pop", 0.125f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 1.0f);
                golem.addRankXp(1);
                golem.swingArm();
            }
        } else {
            ItemStack stack = InventoryUtils.findFirstMatchFromFilter(this.getInv(), this.isBlacklist(), golem.getCarrying(), !this.props[0].value, !this.props[1].value, this.props[2].value, this.props[3].value);
            if (stack != null) {
                ItemStack s = golem.dropItem(stack);
                EntityItem ie = new EntityItem(world, (double)task.getSealPos().pos.func_177958_n() + 0.5 + (double)task.getSealPos().face.func_82601_c(), (double)task.getSealPos().pos.func_177956_o() + 0.5 + (double)task.getSealPos().face.func_96559_d(), (double)task.getSealPos().pos.func_177952_p() + 0.5 + (double)task.getSealPos().face.func_82599_e(), s);
                ie.field_70159_w /= 5.0;
                ie.field_70181_x /= 2.0;
                ie.field_70179_y /= 5.0;
                world.func_72838_d((Entity)ie);
                world.func_72956_a((Entity)golem, "random.pop", 0.125f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 1.0f);
                golem.addRankXp(1);
                golem.swingArm();
            }
        }
        task.setSuspended(true);
        return true;
    }

    @Override
    public boolean canGolemPerformTask(IGolemAPI golem, Task task) {
        TileEntity te = golem.getGolemWorld().func_175625_s(task.getSealPos().pos);
        if (te != null && te instanceof IInventory) {
            ItemStack stack = InventoryUtils.findFirstMatchFromFilter(this.getInv(), this.isBlacklist(), golem.getCarrying(), !this.props[0].value, !this.props[1].value, this.props[2].value, this.props[3].value);
            return stack != null && InventoryUtils.hasRoomFor(stack, (IInventory)te, task.getSealPos().face);
        }
        ItemStack stack = InventoryUtils.findFirstMatchFromFilter(this.getInv(), this.isBlacklist(), golem.getCarrying(), !this.props[0].value, !this.props[1].value, this.props[2].value, this.props[3].value);
        return stack != null;
    }

    @Override
    public boolean canPlaceAt(World world, BlockPos pos, EnumFacing side) {
        return !world.func_175623_d(pos);
    }

    @Override
    public ResourceLocation getSealIcon() {
        return this.icon;
    }

    @Override
    public int[] getGuiCategories() {
        return new int[]{1, 0, 4};
    }

    @Override
    public EnumGolemTrait[] getRequiredTags() {
        return null;
    }

    @Override
    public EnumGolemTrait[] getForbiddenTags() {
        return new EnumGolemTrait[]{EnumGolemTrait.CLUMSY};
    }

    @Override
    public void onTaskSuspension(World world, Task task) {
    }

    @Override
    public void onRemoval(World world, BlockPos pos, EnumFacing side) {
    }
}

