/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct.golem.seals;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.golems.EnumGolemTrait;
import thaumcraft.api.golems.GolemHelper;
import thaumcraft.api.golems.IGolemAPI;
import thaumcraft.api.golems.seals.ISeal;
import thaumcraft.api.golems.seals.ISealConfigArea;
import thaumcraft.api.golems.seals.ISealConfigToggles;
import thaumcraft.api.golems.seals.ISealEntity;
import thaumcraft.api.golems.seals.ISealGui;
import thaumcraft.api.golems.tasks.Task;
import thaumcraft.common.entities.construct.golem.gui.SealBaseContainer;
import thaumcraft.common.entities.construct.golem.gui.SealBaseGUI;
import thaumcraft.common.entities.construct.golem.seals.SealHandler;
import thaumcraft.common.entities.construct.golem.tasks.TaskHandler;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.utils.CropUtils;

public class SealHarvest
implements ISeal,
ISealGui,
ISealConfigArea,
ISealConfigToggles {
    int delay = new Random(System.nanoTime()).nextInt(33);
    int count = 0;
    HashMap<Integer, Long> harvestTasks = new HashMap();
    HashMap<Long, ReplantInfo> replantTasks = new HashMap();
    ResourceLocation icon = new ResourceLocation("thaumcraft", "items/seals/seal_harvest");
    protected ISealConfigToggles.SealToggle[] props = new ISealConfigToggles.SealToggle[]{new ISealConfigToggles.SealToggle(true, "prep", "golem.prop.replant"), new ISealConfigToggles.SealToggle(false, "ppro", "golem.prop.provision")};

    @Override
    public String getKey() {
        return "Thaumcraft:harvest";
    }

    @Override
    public void tickSeal(World world, ISealEntity seal) {
        Task t;
        if (this.delay % 100 == 0) {
            Iterator<Integer> it = this.harvestTasks.keySet().iterator();
            while (it.hasNext()) {
                t = TaskHandler.getTask(world.field_73011_w.func_177502_q(), it.next());
                if (t != null) continue;
                it.remove();
            }
            AxisAlignedBB area = GolemHelper.getBoundsForArea(seal);
            Iterator<Long> rt = this.replantTasks.keySet().iterator();
            while (rt.hasNext()) {
                Task tt;
                BlockPos pp = BlockPos.func_177969_a((long)rt.next());
                if (area.func_72318_a(new Vec3((double)pp.func_177958_n() + 0.5, (double)pp.func_177956_o() + 0.5, (double)pp.func_177952_p() + 0.5))) continue;
                if (this.replantTasks.get(rt) != null && (tt = TaskHandler.getTask(world.field_73011_w.func_177502_q(), this.replantTasks.get(rt).taskid)) != null) {
                    tt.setSuspended(true);
                }
                rt.remove();
            }
        }
        if (this.delay++ % 5 != 0) {
            return;
        }
        ++this.count;
        BlockPos p = GolemHelper.getPosInArea(seal, this.count);
        if (!this.harvestTasks.containsValue(p.func_177986_g())) {
            if (CropUtils.isGrownCrop(world, p)) {
                Task task = new Task(seal.getSealPos(), p);
                task.setPriority(seal.getPriority());
                this.harvestTasks.put(task.getId(), p.func_177986_g());
                TaskHandler.addTask(world.field_73011_w.func_177502_q(), task);
            } else if (this.getToggles()[0].value && this.replantTasks.containsKey(p.func_177986_g()) && world.func_175623_d(p) && (t = TaskHandler.getTask(world.field_73011_w.func_177502_q(), this.replantTasks.get((Object)Long.valueOf((long)p.func_177986_g())).taskid)) == null) {
                Task tt = new Task(seal.getSealPos(), this.replantTasks.get((Object)Long.valueOf((long)p.func_177986_g())).pos);
                tt.setPriority((byte)(seal.getPriority() + 1));
                TaskHandler.addTask(world.field_73011_w.func_177502_q(), tt);
                this.replantTasks.get((Object)Long.valueOf((long)p.func_177986_g())).taskid = tt.getId();
            }
        }
    }

    @Override
    public boolean onTaskCompletion(World world, IGolemAPI golem, Task task) {
        if (this.harvestTasks.containsKey(task.getId()) && CropUtils.isGrownCrop(world, task.getPos())) {
            FakePlayer fp = FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)new GameProfile((UUID)null, "FakeThaumcraftGolem"));
            fp.func_70107_b(golem.getGolemEntity().field_70165_t, golem.getGolemEntity().field_70163_u, golem.getGolemEntity().field_70161_v);
            EnumFacing face = BlockPistonBase.func_180695_a((World)world, (BlockPos)task.getPos(), (EntityLivingBase)golem.getGolemEntity());
            IBlockState bs = world.func_180495_p(task.getPos());
            if (CropUtils.clickableCrops.contains(bs.func_177230_c().func_149739_a() + bs.func_177230_c().func_176201_c(bs))) {
                bs.func_177230_c().func_180639_a(world, task.getPos(), bs, (EntityPlayer)fp, face, 0.0f, 0.0f, 0.0f);
                golem.addRankXp(1);
                golem.swingArm();
            } else {
                ItemStack seed;
                BlockUtils.harvestBlock(world, (EntityPlayer)fp, task.getPos(), false, 0, true);
                golem.addRankXp(1);
                golem.swingArm();
                if (this.getToggles()[0].value && (seed = ThaumcraftApi.getSeed(bs.func_177230_c())) != null) {
                    IBlockState bb = world.func_180495_p(task.getPos().func_177977_b());
                    EnumFacing rf = null;
                    if (seed.func_77973_b() instanceof IPlantable && bb.func_177230_c().canSustainPlant((IBlockAccess)world, task.getPos().func_177977_b(), EnumFacing.UP, (IPlantable)seed.func_77973_b())) {
                        rf = EnumFacing.DOWN;
                    } else if (!(seed.func_77973_b() instanceof IPlantable) && bs.func_177230_c() instanceof BlockDirectional) {
                        rf = (EnumFacing)bs.func_177229_b((IProperty)BlockDirectional.field_176387_N);
                    }
                    if (rf != null) {
                        Task tt = new Task(task.getSealPos(), task.getPos());
                        tt.setPriority((byte)(task.getPriority() + 1));
                        tt.setLifespan((short)300);
                        this.replantTasks.put(tt.getPos().func_177986_g(), new ReplantInfo(tt.getPos(), rf, tt.getId(), seed.func_77946_l()));
                        TaskHandler.addTask(world.field_73011_w.func_177502_q(), tt);
                    }
                }
                this.harvestTasks.remove(task.getId());
            }
        } else if (this.replantTasks.containsKey(task.getPos().func_177986_g()) && this.replantTasks.get((Object)Long.valueOf((long)task.getPos().func_177986_g())).taskid == task.getId() && world.func_175623_d(task.getPos()) && golem.isCarrying(this.replantTasks.get((Object)Long.valueOf((long)task.getPos().func_177986_g())).stack)) {
            FakePlayer fp = FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)new GameProfile((UUID)null, "FakeThaumcraftGolem"));
            fp.func_70107_b(golem.getGolemEntity().field_70165_t, golem.getGolemEntity().field_70163_u, golem.getGolemEntity().field_70161_v);
            ItemStack seed = this.replantTasks.get((Object)Long.valueOf((long)task.getPos().func_177986_g())).stack.func_77946_l();
            seed.field_77994_a = 1;
            if (seed.func_77973_b().func_180614_a(seed.func_77946_l(), (EntityPlayer)fp, world, task.getPos().func_177972_a(this.replantTasks.get((Object)Long.valueOf((long)task.getPos().func_177986_g())).face), this.replantTasks.get((Object)Long.valueOf((long)task.getPos().func_177986_g())).face.func_176734_d(), 0.5f, 0.5f, 0.5f)) {
                world.func_175718_b(2001, task.getPos(), Block.func_176210_f((IBlockState)world.func_180495_p(task.getPos())));
                golem.dropItem(seed);
                golem.addRankXp(1);
                golem.swingArm();
            }
        }
        task.setSuspended(true);
        return true;
    }

    @Override
    public boolean canGolemPerformTask(IGolemAPI golem, Task task) {
        if (this.harvestTasks.containsKey(task.getId())) {
            return true;
        }
        if (this.replantTasks.containsKey(task.getPos().func_177986_g()) && this.replantTasks.get((Object)Long.valueOf((long)task.getPos().func_177986_g())).taskid == task.getId()) {
            ISealEntity se;
            boolean carry = golem.isCarrying(this.replantTasks.get((Object)Long.valueOf((long)task.getPos().func_177986_g())).stack);
            if (!carry && this.getToggles()[1].value && (se = SealHandler.getSealEntity(golem.getGolemWorld().field_73011_w.func_177502_q(), task.getSealPos())) != null) {
                GolemHelper.requestProvisioning(golem.getGolemWorld(), se, this.replantTasks.get((Object)Long.valueOf((long)task.getPos().func_177986_g())).stack);
            }
            return carry;
        }
        return false;
    }

    @Override
    public void onTaskSuspension(World world, Task task) {
        this.harvestTasks.remove(task.getId());
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        NBTTagList nbttaglist = nbt.func_150295_c("replant", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            long loc = nbttagcompound1.func_74763_f("taskloc");
            byte face = nbttagcompound1.func_74771_c("taskface");
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
            this.replantTasks.put(loc, new ReplantInfo(BlockPos.func_177969_a((long)loc), EnumFacing.field_82609_l[face], 0, stack));
        }
        for (ISealConfigToggles.SealToggle prop : this.getToggles()) {
            prop.setValue(nbt.func_74767_n(prop.getKey()));
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        if (this.getToggles()[0].value) {
            NBTTagList nbttaglist = new NBTTagList();
            for (Long key : this.replantTasks.keySet()) {
                ReplantInfo info = this.replantTasks.get(key);
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74772_a("taskloc", info.pos.func_177986_g());
                nbttagcompound1.func_74774_a("taskface", (byte)info.face.ordinal());
                info.stack.func_77955_b(nbttagcompound1);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbt.func_74782_a("replant", (NBTBase)nbttaglist);
        }
        for (ISealConfigToggles.SealToggle prop : this.getToggles()) {
            nbt.func_74757_a(prop.getKey(), prop.getValue());
        }
    }

    @Override
    public boolean canPlaceAt(World world, BlockPos pos, EnumFacing side) {
        return !world.func_175623_d(pos);
    }

    @Override
    public ResourceLocation getSealIcon() {
        return this.icon;
    }

    @Override
    public void onRemoval(World world, BlockPos pos, EnumFacing side) {
    }

    @Override
    public Object returnContainer(World world, EntityPlayer player, BlockPos pos, EnumFacing side, ISealEntity seal) {
        return new SealBaseContainer(player.field_71071_by, world, seal);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object returnGui(World world, EntityPlayer player, BlockPos pos, EnumFacing side, ISealEntity seal) {
        return new SealBaseGUI(player.field_71071_by, world, seal);
    }

    @Override
    public int[] getGuiCategories() {
        return new int[]{2, 3, 0, 4};
    }

    @Override
    public ISealConfigToggles.SealToggle[] getToggles() {
        return this.props;
    }

    @Override
    public void setToggle(int indx, boolean value) {
        this.props[indx].setValue(value);
    }

    @Override
    public EnumGolemTrait[] getRequiredTags() {
        return new EnumGolemTrait[]{EnumGolemTrait.DEFT, EnumGolemTrait.SMART};
    }

    @Override
    public EnumGolemTrait[] getForbiddenTags() {
        return null;
    }

    @Override
    public void onTaskStarted(World world, IGolemAPI golem, Task task) {
    }

    private class ReplantInfo {
        EnumFacing face;
        BlockPos pos;
        int taskid;
        ItemStack stack;

        public ReplantInfo(BlockPos pos, EnumFacing face, int taskid, ItemStack stack) {
            this.pos = pos;
            this.face = face;
            this.taskid = taskid;
            this.stack = stack;
        }
    }
}

