/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.armor;

import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.items.IGoggles;
import thaumcraft.api.items.IRepairable;
import thaumcraft.api.items.IRevealer;
import thaumcraft.api.items.IRunicArmor;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.client.renderers.models.gear.ModelFortressArmor;

public class ItemFortressArmor
extends ItemArmor
implements IRepairable,
IRunicArmor,
ISpecialArmor,
IGoggles,
IRevealer {
    public static ItemArmor.ArmorMaterial ARMORMAT_FORTRESS = EnumHelper.addArmorMaterial((String)"FORTRESS", (String)"FORTRESS", (int)40, (int[])new int[]{3, 7, 6, 3}, (int)25);
    ModelBiped model1 = null;
    ModelBiped model2 = null;
    ModelBiped model = null;

    public ItemFortressArmor(ItemArmor.ArmorMaterial material, int renderIndex, int armorType) {
        super(material, renderIndex, armorType);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        int type = ((ItemArmor)itemStack.func_77973_b()).field_77881_a;
        if (this.model1 == null) {
            this.model1 = new ModelFortressArmor(1.0f);
        }
        if (this.model2 == null) {
            this.model2 = new ModelFortressArmor(0.5f);
        }
        this.model = type == 1 || type == 3 ? this.model1 : this.model2;
        if (this.model != null) {
            this.model.field_78116_c.field_78806_j = armorSlot == 0;
            this.model.field_178720_f.field_78806_j = armorSlot == 0;
            this.model.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
            this.model.field_178723_h.field_78806_j = armorSlot == 1;
            this.model.field_178724_i.field_78806_j = armorSlot == 1;
            this.model.field_178721_j.field_78806_j = armorSlot == 2;
            this.model.field_178722_k.field_78806_j = armorSlot == 2;
            this.model.field_78117_n = entityLiving.func_70093_af();
            this.model.field_78093_q = entityLiving.func_70115_ae();
            this.model.field_78091_s = entityLiving.func_70631_g_();
            this.model.field_78118_o = false;
            int n = this.model.field_78120_m = entityLiving.func_70694_bm() != null ? 1 : 0;
            if (entityLiving instanceof EntityPlayer && ((EntityPlayer)entityLiving).func_71057_bx() > 0) {
                EnumAction enumaction = ((EntityPlayer)entityLiving).func_71011_bu().func_77975_n();
                if (enumaction == EnumAction.BLOCK) {
                    this.model.field_78120_m = 3;
                } else if (enumaction == EnumAction.BOW) {
                    this.model.field_78118_o = true;
                }
            }
        }
        return this.model;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "thaumcraft:textures/models/armor/fortress_armor.png";
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.RARE;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("goggles")) {
            list.add(EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"item.goggles.name"));
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("mask")) {
            list.add(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)("item.fortress_helm.mask." + stack.func_77978_p().func_74762_e("mask"))));
        }
        super.func_77624_a(stack, player, list, par4);
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return par2ItemStack.func_77969_a(new ItemStack(ItemsTC.ingots, 1, 0)) ? true : super.func_82789_a(par1ItemStack, par2ItemStack);
    }

    @Override
    public int getRunicCharge(ItemStack itemstack) {
        return 0;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        int priority = 0;
        double ratio = (double)this.field_77879_b / 25.0;
        if (source.func_82725_o()) {
            priority = 1;
            ratio = (double)this.field_77879_b / 35.0;
        } else if (source.func_76347_k() || source.func_94541_c()) {
            priority = 1;
            ratio = (double)this.field_77879_b / 20.0;
        } else if (source.func_76363_c()) {
            priority = 0;
            ratio = 0.0;
        }
        if (player instanceof EntityPlayer) {
            double set = 0.875;
            for (int a = 1; a < 4; ++a) {
                ItemStack piece = ((EntityPlayer)player).field_71071_by.field_70460_b[a];
                if (piece == null || !(piece.func_77973_b() instanceof ItemFortressArmor)) continue;
                set += 0.125;
                if (!piece.func_77942_o() || !piece.func_77978_p().func_74764_b("mask")) continue;
                set += 0.05;
            }
            ratio *= set;
        }
        return new ISpecialArmor.ArmorProperties(priority, ratio, armor.func_77958_k() + 1 - armor.func_77952_i());
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return this.field_77879_b;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (source != DamageSource.field_76379_h) {
            stack.func_77972_a(damage, entity);
        }
    }

    @Override
    public boolean showNodes(ItemStack itemstack, EntityLivingBase player) {
        return itemstack.func_77942_o() && itemstack.func_77978_p().func_74764_b("goggles");
    }

    @Override
    public boolean showIngamePopups(ItemStack itemstack, EntityLivingBase player) {
        return itemstack.func_77942_o() && itemstack.func_77978_p().func_74764_b("goggles");
    }
}

