/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.resources;

import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.items.ItemGenericVariants;

public class ItemShard
extends ItemGenericVariants {
    public ItemShard() {
        super(new String[]{"base", "base", "base", "base", "base", "base", "flux", "balanced"});
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int par2) {
        if (stack.func_77952_i() == 7) {
            return super.func_82790_a(stack, par2);
        }
        if (stack.func_77952_i() == 6) {
            return Aspect.FLUX.getColor();
        }
        return ShardType.byMetadata(stack.func_77952_i()).getAspect().getColor();
    }

    @Override
    public String func_77667_c(ItemStack par1ItemStack) {
        return par1ItemStack.func_77952_i() == 7 ? super.func_77658_a() + ".balanced" : (par1ItemStack.func_77952_i() == 6 ? super.func_77658_a() + ".flux" : super.func_77658_a() + "." + (Object)((Object)ShardType.byMetadata(par1ItemStack.func_77952_i())));
    }

    public static enum ShardType {
        AIR(0, "air", Aspect.AIR, BlocksTC.crystalAir),
        FIRE(1, "fire", Aspect.FIRE, BlocksTC.crystalFire),
        WATER(2, "water", Aspect.WATER, BlocksTC.crystalWater),
        EARTH(3, "earth", Aspect.EARTH, BlocksTC.crystalEarth),
        ORDER(4, "order", Aspect.ORDER, BlocksTC.crystalOrder),
        ENTROPY(5, "entropy", Aspect.ENTROPY, BlocksTC.crystalEntropy),
        FLUX(6, "flux", Aspect.FLUX, BlocksTC.crystalTaint);

        private static final ShardType[] METADATA_LOOKUP;
        private final int metadata;
        private final String name;
        private final Aspect aspect;
        private final Block ore;

        private ShardType(int metadata, String unlocalizedName, Aspect aspect, Block ore) {
            this.metadata = metadata;
            this.name = unlocalizedName;
            this.aspect = aspect;
            this.ore = ore;
        }

        public int getMetadata() {
            return this.metadata;
        }

        public Aspect getAspect() {
            return this.aspect;
        }

        public Block getOre() {
            return this.ore;
        }

        public String getUnlocalizedName() {
            return this.name;
        }

        public String toString() {
            return this.getUnlocalizedName();
        }

        public static int getMetaByAspect(Aspect a) {
            ShardType[] var0 = ShardType.values();
            int var1 = var0.length;
            for (int var2 = 0; var2 < var1; ++var2) {
                if (var0[var2].getAspect() != a) continue;
                return var2;
            }
            return -1;
        }

        public static ShardType byMetadata(int metadata) {
            if (metadata < 0 || metadata >= METADATA_LOOKUP.length) {
                metadata = 0;
            }
            return METADATA_LOOKUP[metadata];
        }

        public String getName() {
            return this.name;
        }

        static {
            METADATA_LOOKUP = new ShardType[ShardType.values().length];
            ShardType[] var0 = ShardType.values();
            int var1 = var0.length;
            for (int var2 = 0; var2 < var1; ++var2) {
                ShardType var3;
                ShardType.METADATA_LOOKUP[var3.getMetadata()] = var3 = var0[var2];
            }
        }
    }
}

