/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.tools;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ScanningManager;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.items.ISubItems;
import thaumcraft.common.lib.aura.AuraChunk;
import thaumcraft.common.lib.aura.AuraHandler;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.misc.PacketAuraToClient;
import thaumcraft.common.lib.utils.EntityUtils;

public class ItemThaumometer
extends Item
implements ISubItems {
    public ItemThaumometer() {
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77627_a(true);
        this.func_77637_a(Thaumcraft.tabTC);
    }

    @Override
    public int[] getSubItems() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack((Item)this, 1, 0));
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.UNCOMMON;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(stack, player, list, par4);
        String text = StatCollector.func_74838_a((String)"tc.thaumometer");
        try {
            text = text.replace("$s", Keyboard.getKeyName((int)Thaumcraft.proxy.getKeyBindings().keyF.func_151463_i()));
            list.add(EnumChatFormatting.DARK_PURPLE + text);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer p) {
        if (world.field_72995_K) {
            this.drawFX(world, p);
            p.field_70170_p.func_72980_b(p.field_70165_t, p.field_70163_u, p.field_70161_v, "thaumcraft:scan", 0.5f, 1.0f, false);
        } else {
            this.doScan(world, p);
        }
        return stack;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        block3: {
            block4: {
                if (isSelected && !world.field_72995_K && entity.field_70173_aa % 20 == 0 && entity instanceof EntityPlayerMP) {
                    this.updateAura(stack, world, entity);
                }
                if (!isSelected || !world.field_72995_K || entity.field_70173_aa % 5 != 0 || !(entity instanceof EntityPlayer)) break block3;
                Entity target = EntityUtils.getPointedEntity(world, entity, 1.0, 16.0, 5.0f, true);
                if (target == null || !ScanningManager.isThingStillScannable((EntityPlayer)entity, target)) break block4;
                for (int a = 0; a < Thaumcraft.proxy.getFX().particleCount(2); ++a) {
                    Thaumcraft.proxy.getFX().scanHighlight((float)target.field_70165_t + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * (target.field_70130_N * 0.7f), (float)target.field_70163_u + world.field_73012_v.nextFloat() * target.field_70131_O, (float)target.field_70161_v + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * (target.field_70130_N * 0.7f));
                }
                break block3;
            }
            MovingObjectPosition mop = this.getMovingObjectPositionFromPlayerWild(world, (EntityPlayer)entity, true);
            if (mop == null || mop.func_178782_a() == null || !ScanningManager.isThingStillScannable((EntityPlayer)entity, mop.func_178782_a())) break block3;
            for (int a = 0; a < Thaumcraft.proxy.getFX().particleCount(2); ++a) {
                Thaumcraft.proxy.getFX().scanHighlight((float)mop.func_178782_a().func_177958_n() - 0.3f + world.field_73012_v.nextFloat() * 1.6f, (float)mop.func_178782_a().func_177956_o() - 0.3f + world.field_73012_v.nextFloat() * 1.6f, (float)mop.func_178782_a().func_177952_p() - 0.3f + world.field_73012_v.nextFloat() * 1.6f);
            }
        }
    }

    protected MovingObjectPosition getMovingObjectPositionFromPlayerWild(World worldIn, EntityPlayer playerIn, boolean useLiquids) {
        float f = playerIn.field_70127_C + (playerIn.field_70125_A - playerIn.field_70127_C) + (float)worldIn.field_73012_v.nextInt(20) - (float)worldIn.field_73012_v.nextInt(20);
        float f1 = playerIn.field_70126_B + (playerIn.field_70177_z - playerIn.field_70126_B) + (float)worldIn.field_73012_v.nextInt(20) - (float)worldIn.field_73012_v.nextInt(20);
        double d0 = playerIn.field_70169_q + (playerIn.field_70165_t - playerIn.field_70169_q);
        double d1 = playerIn.field_70167_r + (playerIn.field_70163_u - playerIn.field_70167_r) + (double)playerIn.func_70047_e();
        double d2 = playerIn.field_70166_s + (playerIn.field_70161_v - playerIn.field_70166_s);
        Vec3 vec3 = new Vec3(d0, d1, d2);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d3 = 16.0;
        Vec3 vec31 = vec3.func_72441_c((double)f6 * d3, (double)f5 * d3, (double)f7 * d3);
        return worldIn.func_147447_a(vec3, vec31, useLiquids, !useLiquids, false);
    }

    private void updateAura(ItemStack stack, World world, Entity entity) {
        AuraChunk ac = AuraHandler.getAuraChunk(world.field_73011_w.func_177502_q(), (int)entity.field_70165_t >> 4, (int)entity.field_70161_v >> 4);
        if (ac != null) {
            short b = ac.getBase();
            AspectList c = ac.getCurrentAspects();
            AspectList r = new AspectList();
            for (Aspect aspect : AspectHelper.getAuraAspects(ac.getCurrentAspects()).getAspects()) {
                if (this.getAspect(stack.func_77952_i()) != null) {
                    r.add(Aspect.CRYSTAL, b);
                    if (this.getAspect(stack.func_77952_i()) != aspect) continue;
                    r.add(Aspect.VOID, (int)((float)b * 1.1f));
                } else {
                    r.add(Aspect.VOID, c.getAmount(aspect));
                }
                r.add(aspect, c.getAmount(aspect));
            }
            PacketHandler.INSTANCE.sendTo((IMessage)new PacketAuraToClient(r), (EntityPlayerMP)entity);
        }
    }

    private void drawFX(World worldIn, EntityPlayer playerIn) {
        block3: {
            block2: {
                Entity target = EntityUtils.getPointedEntity(worldIn, (Entity)playerIn, 1.0, 9.0, 0.0f, true);
                if (target == null) break block2;
                for (int a = 0; a < Thaumcraft.proxy.getFX().particleCount(5); ++a) {
                    Thaumcraft.proxy.getFX().blockRunes(target.field_70165_t - 0.5, target.field_70163_u + (double)(target.func_70047_e() / 2.0f), target.field_70161_v - 0.5, 0.3f + worldIn.field_73012_v.nextFloat() * 0.7f, 0.0f, 0.3f + worldIn.field_73012_v.nextFloat() * 0.7f, (int)(target.field_70131_O * 15.0f), 0.03f);
                }
                break block3;
            }
            MovingObjectPosition mop = this.func_77621_a(worldIn, playerIn, true);
            if (mop == null || mop.func_178782_a() == null) break block3;
            for (int a = 0; a < Thaumcraft.proxy.getFX().particleCount(5); ++a) {
                Thaumcraft.proxy.getFX().blockRunes(mop.func_178782_a().func_177958_n(), (double)mop.func_178782_a().func_177956_o() + 0.25, mop.func_178782_a().func_177952_p(), 0.3f + worldIn.field_73012_v.nextFloat() * 0.7f, 0.0f, 0.3f + worldIn.field_73012_v.nextFloat() * 0.7f, 15, 0.03f);
            }
        }
    }

    private Aspect getAspect(int b) {
        switch (b) {
            default: {
                return null;
            }
            case 1: {
                return Aspect.AIR;
            }
            case 2: {
                return Aspect.FIRE;
            }
            case 3: {
                return Aspect.WATER;
            }
            case 4: {
                return Aspect.EARTH;
            }
            case 5: {
                return Aspect.ORDER;
            }
            case 6: {
                return Aspect.ENTROPY;
            }
            case 7: 
        }
        return Aspect.FLUX;
    }

    public void doScan(World worldIn, EntityPlayer playerIn) {
        if (!worldIn.field_72995_K) {
            Entity target = EntityUtils.getPointedEntity(worldIn, (Entity)playerIn, 1.0, 9.0, 0.0f, true);
            if (target != null) {
                ScanningManager.scanTheThing(playerIn, target);
            } else {
                MovingObjectPosition mop = this.func_77621_a(worldIn, playerIn, true);
                if (mop != null && mop.func_178782_a() != null) {
                    ScanningManager.scanTheThing(playerIn, mop.func_178782_a());
                } else {
                    ScanningManager.scanTheThing(playerIn, null);
                }
            }
        }
    }

    public static void changeVis(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        int d = itemStackIn.func_77952_i() + 1;
        if (d > 7) {
            d = 0;
        }
        itemStackIn.func_77964_b(d);
        if (!worldIn.field_72995_K) {
            if (d > 0) {
                playerIn.func_145747_a((IChatComponent)new ChatComponentText(String.format(StatCollector.func_74838_a((String)"tc.dioptra.1"), ((ItemThaumometer)itemStackIn.func_77973_b()).getAspect(d).getName())));
            } else {
                playerIn.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"tc.dioptra.3")));
            }
            ((ItemThaumometer)itemStackIn.func_77973_b()).updateAura(itemStackIn, worldIn, (Entity)playerIn);
        }
    }
}

