/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.wands;

import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.wands.IWand;
import thaumcraft.api.wands.IWandTriggerManager;
import thaumcraft.common.blocks.IBlockEnabled;
import thaumcraft.common.blocks.IBlockFacingHorizontal;
import thaumcraft.common.blocks.basic.BlockPillar;
import thaumcraft.common.blocks.devices.BlockGolemBuilder;
import thaumcraft.common.blocks.misc.BlockPlaceholder;
import thaumcraft.common.entities.EntitySpecialItem;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXBlockSparkle;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.tiles.crafting.TileInfusionMatrix;
import thaumcraft.common.tiles.crafting.TilePedestal;
import thaumcraft.common.tiles.misc.TileEldritchAltar;
import thaumcraft.common.tiles.misc.TileEldritchPortal;

public class WandTriggers
implements IWandTriggerManager {
    @Override
    public boolean performTrigger(World world, ItemStack wand, EntityPlayer player, BlockPos pos, EnumFacing side, int event) {
        switch (event) {
            case 0: {
                return WandTriggers.createThaumonomicon(wand, player, world, pos);
            }
            case 1: {
                return WandTriggers.createCrucible(wand, player, world, pos);
            }
            case 2: {
                if (!ResearchManager.isResearchComplete(player.func_70005_c_(), "INFERNALFURNACE")) break;
                return WandTriggers.createInfernalFurnace(wand, player, world, pos);
            }
            case 3: {
                if (!ResearchManager.isResearchComplete(player.func_70005_c_(), "INFUSION")) break;
                return WandTriggers.createInfusionAltar(wand, player, world, pos);
            }
            case 4: 
            case 5: {
                if (!ResearchManager.isResearchComplete(player.func_70005_c_(), "THAUMATORIUM")) break;
                return WandTriggers.createThaumatorium(wand, player, world, pos, side);
            }
            case 6: {
                if (!ResearchManager.isResearchComplete(player.func_70005_c_(), "OCULUS")) break;
                return WandTriggers.createOculus(wand, player, world, pos);
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                if (!ResearchManager.isResearchComplete(player.func_70005_c_(), "MINDCLOCKWORK")) break;
                return WandTriggers.createGolemPress(wand, player, world, pos);
            }
        }
        return false;
    }

    public static boolean createGolemPress(ItemStack itemstack, EntityPlayer player, World world, BlockPos pos) {
        if (!world.field_72995_K) {
            BlockPos start = null;
            block0: for (int yy = -1; yy < 2; ++yy) {
                for (int xx = -1; xx < 2; ++xx) {
                    for (int zz = -1; zz < 2; ++zz) {
                        if (world.func_180495_p(pos.func_177982_a(xx, yy, zz)) != Blocks.field_150331_J.func_176223_P().func_177226_a((IProperty)BlockPistonBase.field_176321_a, (Comparable)EnumFacing.UP)) continue;
                        start = pos.func_177982_a(xx, yy, zz);
                        break block0;
                    }
                }
            }
            if (start == null) {
                return false;
            }
            if (world.func_180495_p(start.func_177984_a()).func_177230_c() != Blocks.field_150411_aY) {
                return false;
            }
            EnumFacing face = null;
            for (EnumFacing f : EnumFacing.field_176754_o) {
                if (world.func_180495_p(start.func_177972_a(f)).func_177230_c() != BlocksTC.tableStone) continue;
                face = f;
                break;
            }
            if (face == null) {
                return false;
            }
            if (world.func_180495_p(start.func_177972_a(face).func_177972_a(face.func_176746_e())).func_177230_c() != Blocks.field_150467_bQ) {
                return false;
            }
            if (world.func_180495_p(start.func_177972_a(face).func_177972_a(face.func_176746_e()).func_177972_a(face.func_176746_e().func_176746_e())).func_177230_c() != Blocks.field_150383_bp) {
                return false;
            }
            IWand wand = (IWand)itemstack.func_77973_b();
            if (wand.consumeAllVis(itemstack, player, new AspectList().add(Aspect.FIRE, 50).add(Aspect.ORDER, 50).add(Aspect.AIR, 50), true, true)) {
                WandTriggers.setBlockSparkle(world, start.func_177984_a(), BlocksTC.placeholder.func_176203_a(2));
                WandTriggers.setBlockSparkle(world, start.func_177972_a(face).func_177972_a(face.func_176746_e()), BlocksTC.placeholder.func_176203_a(3));
                WandTriggers.setBlockSparkle(world, start.func_177972_a(face).func_177972_a(face.func_176746_e()).func_177972_a(face.func_176746_e().func_176746_e()), BlocksTC.placeholder.func_176203_a(4));
                WandTriggers.setBlockSparkle(world, start.func_177972_a(face), BlocksTC.placeholder.func_176203_a(5));
                WandTriggers.setBlockSparkle(world, start, BlocksTC.golemBuilder.func_176223_P().func_177226_a((IProperty)BlockGolemBuilder.FACING, (Comparable)face));
                world.func_72908_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, "thaumcraft:wand", 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    public static boolean createThaumonomicon(ItemStack itemstack, EntityPlayer player, World world, BlockPos pos) {
        if (!world.field_72995_K) {
            IWand wand = (IWand)itemstack.func_77973_b();
            if (wand.getFocus(itemstack) != null) {
                return false;
            }
            world.func_175698_g(pos);
            EntitySpecialItem entityItem = new EntitySpecialItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.3, (double)pos.func_177952_p() + 0.5, new ItemStack(ItemsTC.thaumonomicon));
            entityItem.field_70181_x = 0.0;
            entityItem.field_70159_w = 0.0;
            entityItem.field_70179_y = 0.0;
            world.func_72838_d((Entity)entityItem);
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockSparkle(pos, -9999), new NetworkRegistry.TargetPoint(world.field_73011_w.func_177502_q(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 32.0));
            world.func_72908_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, "thaumcraft:wand", 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public static boolean createCrucible(ItemStack is, EntityPlayer player, World world, BlockPos pos) {
        IWand wand = (IWand)is.func_77973_b();
        if (!world.field_72995_K) {
            world.func_175698_g(pos);
            world.func_175656_a(pos, BlocksTC.crucible.func_176223_P());
            world.func_175685_c(pos, BlocksTC.crucible);
            world.func_175689_h(pos);
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockSparkle(pos, -9999), new NetworkRegistry.TargetPoint(world.field_73011_w.func_177502_q(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 32.0));
            world.func_72908_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, "thaumcraft:wand", 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public static boolean createInfusionAltar(ItemStack itemstack, EntityPlayer player, World world, BlockPos pos) {
        IWand wand = (IWand)itemstack.func_77973_b();
        if (WandTriggers.fitInfusionAltar(world, pos) && wand.consumeAllVis(itemstack, player, new AspectList().add(Aspect.FIRE, 75).add(Aspect.EARTH, 75).add(Aspect.ORDER, 75).add(Aspect.AIR, 75).add(Aspect.ENTROPY, 75).add(Aspect.WATER, 75), true, true)) {
            if (!world.field_72995_K) {
                WandTriggers.replaceInfusionAltar(world, pos);
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean fitInfusionAltar(World world, BlockPos pos) {
        Block br1 = BlocksTC.stone;
        Block[][][] blueprint = new Block[][][]{{{br1, null, br1}, {null, null, null}, {br1, null, br1}}, {{br1, null, br1}, {null, null, null}, {br1, null, br1}}};
        IBlockState j = world.func_180495_p(pos.func_177982_a(-1, -2, -1));
        if (j != world.func_180495_p(pos.func_177982_a(1, -2, -1)) || j != world.func_180495_p(pos.func_177982_a(1, -2, 1)) || j != world.func_180495_p(pos.func_177982_a(-1, -2, 1))) {
            return false;
        }
        int meta = -1;
        for (int yy = 0; yy < 2; ++yy) {
            for (int xx = 0; xx < 3; ++xx) {
                for (int zz = 0; zz < 3; ++zz) {
                    BlockPos cp = pos.func_177982_a(xx - 1, -(yy + 1), zz - 1);
                    if (blueprint[yy][xx][zz] == null) {
                        if (xx == 1 && zz == 1 && yy == 1) {
                            TileEntity t = world.func_175625_s(cp);
                            if (t != null && t instanceof TilePedestal) continue;
                            return false;
                        }
                        if (world.func_175623_d(cp)) continue;
                        return false;
                    }
                    IBlockState b = world.func_180495_p(cp);
                    if (b.func_177230_c() != blueprint[yy][xx][zz]) {
                        return false;
                    }
                    int m = b.func_177230_c().func_176201_c(b);
                    if (meta < 0) {
                        meta = b.func_177230_c().func_176201_c(b);
                    } else if (m != 0 && m != 2 && m != 4 || meta != m) {
                        return false;
                    }
                    if (yy != 2 || b == world.func_180495_p(cp.func_177984_a())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static void replaceInfusionAltar(World world, BlockPos pos) {
        IBlockState j = world.func_180495_p(pos.func_177982_a(-1, -2, -1));
        BlockPillar.PillarType p = BlockPillar.PillarType.NORMAL;
        switch (j.func_177230_c().func_176201_c(j)) {
            case 2: {
                p = BlockPillar.PillarType.ANCIENT;
                break;
            }
            case 4: {
                p = BlockPillar.PillarType.ELDRITCH;
            }
        }
        WandTriggers.setBlockSparkle(world, pos.func_177982_a(-1, -1, -1), Blocks.field_150350_a.func_176223_P());
        WandTriggers.setBlockSparkle(world, pos.func_177982_a(1, -1, -1), Blocks.field_150350_a.func_176223_P());
        WandTriggers.setBlockSparkle(world, pos.func_177982_a(1, -1, 1), Blocks.field_150350_a.func_176223_P());
        WandTriggers.setBlockSparkle(world, pos.func_177982_a(-1, -1, 1), Blocks.field_150350_a.func_176223_P());
        WandTriggers.setBlockSparkle(world, pos.func_177982_a(-1, -2, -1), BlocksTC.pillar.func_176223_P().func_177226_a((IProperty)BlockPillar.TYPE, (Comparable)((Object)p)).func_177226_a((IProperty)BlockPillar.FACING, (Comparable)EnumFacing.EAST));
        WandTriggers.setBlockSparkle(world, pos.func_177982_a(1, -2, -1), BlocksTC.pillar.func_176223_P().func_177226_a((IProperty)BlockPillar.TYPE, (Comparable)((Object)p)).func_177226_a((IProperty)BlockPillar.FACING, (Comparable)EnumFacing.SOUTH));
        WandTriggers.setBlockSparkle(world, pos.func_177982_a(1, -2, 1), BlocksTC.pillar.func_176223_P().func_177226_a((IProperty)BlockPillar.TYPE, (Comparable)((Object)p)).func_177226_a((IProperty)BlockPillar.FACING, (Comparable)EnumFacing.WEST));
        WandTriggers.setBlockSparkle(world, pos.func_177982_a(-1, -2, 1), BlocksTC.pillar.func_176223_P().func_177226_a((IProperty)BlockPillar.TYPE, (Comparable)((Object)p)).func_177226_a((IProperty)BlockPillar.FACING, (Comparable)EnumFacing.NORTH));
        TileInfusionMatrix tis = (TileInfusionMatrix)world.func_175625_s(pos);
        tis.active = true;
        world.func_175689_h(pos);
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockSparkle(pos, -9999), new NetworkRegistry.TargetPoint(world.field_73011_w.func_177502_q(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 32.0));
        world.func_72908_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() - 0.5, (double)pos.func_177952_p() + 0.5, "thaumcraft:wand", 1.0f, 1.0f);
    }

    private static void setBlockSparkle(World world, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, state);
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockSparkle(pos, -9999), new NetworkRegistry.TargetPoint(world.field_73011_w.func_177502_q(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 32.0));
    }

    public static boolean createThaumatorium(ItemStack itemstack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        IWand wand = (IWand)itemstack.func_77973_b();
        if (world.func_180495_p(pos.func_177984_a()) != BlocksTC.metal.func_176223_P() || world.func_180495_p(pos.func_177977_b()) != BlocksTC.crucible.func_176223_P()) {
            if (world.func_180495_p(pos.func_177977_b()) == BlocksTC.metal.func_176223_P() && world.func_180495_p(pos.func_177979_c(2)) == BlocksTC.crucible.func_176223_P()) {
                pos = pos.func_177977_b();
            } else if (world.func_180495_p(pos.func_177984_a()) == BlocksTC.metal.func_176223_P() && world.func_180495_p(pos.func_177981_b(2)) == BlocksTC.metal.func_176223_P()) {
                pos = pos.func_177984_a();
            } else {
                return false;
            }
        }
        if (wand.consumeAllVis(itemstack, player, new AspectList().add(Aspect.FIRE, 50).add(Aspect.ORDER, 100).add(Aspect.WATER, 100), true, true) && !world.field_72995_K) {
            world.func_180501_a(pos, BlocksTC.thaumatorium.func_176223_P().func_177226_a((IProperty)IBlockFacingHorizontal.FACING, (Comparable)side).func_177226_a((IProperty)IBlockEnabled.ENABLED, (Comparable)Boolean.valueOf(true)), 0);
            world.func_180501_a(pos.func_177984_a(), BlocksTC.thaumatorium.func_176223_P().func_177226_a((IProperty)IBlockFacingHorizontal.FACING, (Comparable)side).func_177226_a((IProperty)IBlockEnabled.ENABLED, (Comparable)Boolean.valueOf(false)), 0);
            world.func_175689_h(pos);
            world.func_175689_h(pos.func_177984_a());
            world.func_175685_c(pos, BlocksTC.thaumatorium);
            world.func_175685_c(pos.func_177984_a(), BlocksTC.thaumatorium);
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockSparkle(pos, -9999), new NetworkRegistry.TargetPoint(world.field_73011_w.func_177502_q(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 32.0));
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockSparkle(pos.func_177984_a(), -9999), new NetworkRegistry.TargetPoint(world.field_73011_w.func_177502_q(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 32.0));
            world.func_72908_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), "thaumcraft:wand", 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public static boolean createInfernalFurnace(ItemStack itemstack, EntityPlayer player, World world, BlockPos pos) {
        IWand wand = (IWand)itemstack.func_77973_b();
        for (int xx = -2; xx <= 0; ++xx) {
            for (int yy = -2; yy <= 0; ++yy) {
                for (int zz = -2; zz <= 0; ++zz) {
                    BlockPos p2 = pos.func_177982_a(xx, yy, zz);
                    if (!WandTriggers.fitInfernalFurnace(world, p2) || !wand.consumeAllVis(itemstack, player, new AspectList().add(Aspect.FIRE, 50).add(Aspect.EARTH, 50), true, true)) continue;
                    if (!world.field_72995_K) {
                        WandTriggers.replaceInfernalFurnace(world, p2);
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    public static boolean fitInfernalFurnace(World world, BlockPos pos) {
        Block bo = Blocks.field_150343_Z;
        Block bn = Blocks.field_150385_bj;
        Block bf = Blocks.field_150411_aY;
        BlockStaticLiquid bl = Blocks.field_150353_l;
        Block[][][] blueprint = new Block[][][]{{{bn, bo, bn}, {bo, Blocks.field_150350_a, bo}, {bn, bo, bn}}, {{bn, bo, bn}, {bo, bl, bo}, {bn, bo, bn}}, {{bn, bo, bn}, {bo, bo, bo}, {bn, bo, bn}}};
        boolean barsfound = false;
        for (int yy = 0; yy < 3; ++yy) {
            for (int xx = 0; xx < 3; ++xx) {
                for (int zz = 0; zz < 3; ++zz) {
                    IBlockState bs = world.func_180495_p(pos.func_177982_a(xx, -yy + 2, zz));
                    Block block = bs.func_177230_c();
                    if (world.func_175623_d(pos.func_177982_a(xx, -yy + 2, zz))) {
                        block = Blocks.field_150350_a;
                    }
                    if (block == blueprint[yy][xx][zz]) continue;
                    if (!(yy != 1 || barsfound || block != bf || xx == zz || xx != 1 && zz != 1)) {
                        barsfound = true;
                        continue;
                    }
                    return false;
                }
            }
        }
        return barsfound;
    }

    public static void replaceInfernalFurnace(World world, BlockPos pos) {
        int[][][] blueprint = new int[][][]{new int[][]{{0, 1, 0}, {1, 1, 1}, {0, 1, 0}}, new int[][]{{0, 1, 0}, {1, 3, 1}, {0, 1, 0}}, new int[][]{{0, 1, 0}, {1, 4, 1}, {0, 1, 0}}};
        BlockPos p1 = pos.func_177982_a(1, 1, 1);
        for (EnumFacing face : EnumFacing.field_176754_o) {
            if (world.func_180495_p(p1.func_177972_a(face)).func_177230_c() != Blocks.field_150411_aY) continue;
            WandTriggers.setBlockSparkle(world, p1, BlocksTC.infernalFurnace.func_176223_P().func_177226_a((IProperty)IBlockFacingHorizontal.FACING, (Comparable)face.func_176734_d()));
            break;
        }
        for (int yy = 0; yy < 3; ++yy) {
            for (int zz = 0; zz < 3; ++zz) {
                for (int xx = 0; xx < 3; ++xx) {
                    BlockPos p2 = pos.func_177982_a(xx, yy, zz);
                    if (world.func_180495_p(p2).func_177230_c() == Blocks.field_150411_aY) {
                        world.func_175698_g(p2);
                        continue;
                    }
                    if (blueprint[yy][xx][zz] == 0) {
                        WandTriggers.setBlockSparkle(world, p2, BlocksTC.placeholder.func_176223_P().func_177226_a((IProperty)BlockPlaceholder.VARIANT, (Comparable)((Object)BlockPlaceholder.PlaceholderType.FURNACE_BRICK)));
                    }
                    if (blueprint[yy][xx][zz] != 1) continue;
                    WandTriggers.setBlockSparkle(world, p2, BlocksTC.placeholder.func_176223_P().func_177226_a((IProperty)BlockPlaceholder.VARIANT, (Comparable)((Object)BlockPlaceholder.PlaceholderType.FURNACE_OBSIDIAN)));
                }
            }
        }
        world.func_72908_a((double)pos.func_177958_n() + 1.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 1.5, "thaumcraft:wand", 1.0f, 1.0f);
    }

    private static boolean createOculus(ItemStack itemstack, EntityPlayer player, World world, BlockPos pos) {
        if (!world.field_72995_K) {
            IWand wand;
            TileEntity tile = world.func_175625_s(pos);
            TileEntity portal = world.func_175625_s(pos.func_177984_a());
            if (tile != null && portal != null && tile instanceof TileEldritchAltar && ((TileEldritchAltar)tile).getEyes() == 4 && !((TileEldritchAltar)tile).isOpen() && portal instanceof TileEldritchPortal && !((TileEldritchPortal)portal).open && ((TileEldritchAltar)tile).checkForMaze() && (wand = (IWand)itemstack.func_77973_b()).consumeAllVis(itemstack, player, new AspectList().add(Aspect.AIR, 500).add(Aspect.FIRE, 500).add(Aspect.EARTH, 500).add(Aspect.WATER, 500).add(Aspect.ORDER, 500).add(Aspect.ENTROPY, 500), true, true)) {
                world.func_72908_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, "thaumcraft:wand", 1.0f, 1.0f);
                ((TileEldritchAltar)tile).setOpen(true);
                ((TileEldritchPortal)portal).open = true;
                portal.func_70296_d();
                world.func_175689_h(pos.func_177984_a());
                tile.func_70296_d();
                world.func_175689_h(pos);
            }
        }
        return false;
    }
}

