/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.aura;

import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ResearchHelper;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.lib.aura.AuraChunk;
import thaumcraft.common.lib.aura.AuraWorld;
import thaumcraft.common.lib.aura.EntityAuraNode;
import thaumcraft.common.lib.utils.PosXY;
import thaumcraft.common.lib.world.biomes.BiomeHandler;

public class AuraHandler {
    static ConcurrentHashMap<Integer, AuraWorld> auras = new ConcurrentHashMap();
    public static ConcurrentHashMap<Integer, CopyOnWriteArrayList<PosXY>> dirtyChunks = new ConcurrentHashMap();
    public static ConcurrentHashMap<Integer, BlockPos> taintTrigger = new ConcurrentHashMap();

    public static AuraWorld getAuraWorld(int dim) {
        return auras.get(dim);
    }

    public static AuraChunk getAuraChunk(int dim, int x, int y) {
        if (auras.containsKey(dim)) {
            return auras.get(dim).getAuraChunkAt(x, y);
        }
        return null;
    }

    public static void addAuraWorld(int dim) {
        if (!auras.containsKey(dim)) {
            auras.put(dim, new AuraWorld(dim));
            Thaumcraft.log.info("Creating aura cache for world " + dim);
        }
    }

    public static void removeAuraWorld(int dim) {
        auras.remove(dim);
        Thaumcraft.log.info("Removing aura cache for world " + dim);
    }

    public static void addAuraChunk(int dim, Chunk chunk, short base, AspectList currentAspects) {
        AuraWorld aw = auras.get(dim);
        if (aw == null) {
            aw = new AuraWorld(dim);
        }
        aw.getAuraChunks().put(new PosXY(chunk.field_76635_g, chunk.field_76647_h), new AuraChunk(chunk, base, currentAspects));
        auras.put(dim, aw);
    }

    public static void removeAuraChunk(int dim, int x, int y) {
        AuraWorld aw = auras.get(dim);
        if (aw != null) {
            aw.getAuraChunks().remove(new PosXY(x, y));
        }
    }

    public static boolean drainAura(World world, BlockPos pos, AspectList al) {
        for (Aspect aspect : al.getAspects()) {
            if (aspect == null || AuraHandler.drainAura(world, pos, aspect, al.getAmount(aspect), false)) continue;
            return false;
        }
        for (Aspect aspect : al.getAspects()) {
            if (aspect == null) continue;
            AuraHandler.drainAura(world, pos, aspect, al.getAmount(aspect), true);
        }
        return true;
    }

    public static boolean drainAura(World world, BlockPos pos, Aspect aspect, int amount) {
        return AuraHandler.drainAura(world, pos, aspect, amount, true);
    }

    public static int drainAuraAvailable(World world, BlockPos pos, Aspect aspect, int amount) {
        return AuraHandler.drainAuraAvailable(world, pos, aspect, amount, true);
    }

    public static boolean drainAura(World world, BlockPos pos, Aspect aspect, int amount, boolean doit) {
        AuraChunk ac = AuraHandler.getAuraChunk(world.field_73011_w.func_177502_q(), pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        return AuraHandler.modifyAuraChunk(ac, aspect, -amount, doit);
    }

    public static int getAuraCurrent(World world, BlockPos pos, Aspect aspect) {
        AuraChunk ac = AuraHandler.getAuraChunk(world.field_73011_w.func_177502_q(), pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        return ac != null ? ac.getCurrentAspects().getAmount(aspect) : 0;
    }

    public static int getAuraBase(World world, BlockPos pos) {
        AuraChunk ac = AuraHandler.getAuraChunk(world.field_73011_w.func_177502_q(), pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        return ac != null ? ac.getBase() : (short)0;
    }

    public static boolean shouldPreserveAura(World world, EntityPlayer player, BlockPos pos, Aspect aspect) {
        return (player == null || ResearchHelper.isResearchComplete(player.func_70005_c_(), "AURAPRESERVE")) && (double)((float)AuraHandler.getAuraCurrent(world, pos, aspect) / (float)AuraHandler.getAuraBase(world, pos)) < 0.1;
    }

    public static int drainAuraAvailable(World world, BlockPos pos, Aspect aspect, int amount, boolean doit) {
        boolean didit = false;
        try {
            AuraChunk ac = AuraHandler.getAuraChunk(world.field_73011_w.func_177502_q(), pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            if (amount > ac.getCurrentAspects().getAmount(aspect)) {
                amount = ac.getCurrentAspects().getAmount(aspect);
            }
            didit = AuraHandler.modifyAuraChunk(ac, aspect, -amount, doit);
        }
        catch (Exception e) {
            // empty catch block
        }
        return didit ? amount : 0;
    }

    private static boolean modifyAuraChunk(AuraChunk ac, Aspect aspect, int amount, boolean doit) {
        if (ac != null) {
            if (amount < 0) {
                if (Math.abs(amount) > ac.getCurrentAspects().getAmount(aspect)) {
                    return false;
                }
                if (doit) {
                    ac.getCurrentAspects().reduce(aspect, Math.abs(amount));
                }
            } else if (doit) {
                ac.getCurrentAspects().add(aspect, amount);
            }
            return true;
        }
        return false;
    }

    public static void addNodeRechargeTicket(EntityAuraNode node, Aspect aspect, int strength) {
        PosXY pos = new PosXY(MathHelper.func_76128_c((double)node.field_70165_t) >> 4, MathHelper.func_76128_c((double)node.field_70161_v) >> 4);
        AuraHandler.addRechargeTicket(node.field_70170_p.field_73011_w.func_177502_q(), pos, aspect, strength);
    }

    public static void addRechargeTicket(World world, BlockPos bp, Aspect aspect) {
        PosXY pos = new PosXY(bp.func_177958_n() >> 4, bp.func_177952_p() >> 4);
        AuraHandler.addRechargeTicket(world.field_73011_w.func_177502_q(), pos, aspect, 1);
    }

    public static void addRechargeTicket(World world, BlockPos bp, Aspect aspect, int amt) {
        PosXY pos = new PosXY(bp.func_177958_n() >> 4, bp.func_177952_p() >> 4);
        AuraHandler.addRechargeTicket(world.field_73011_w.func_177502_q(), pos, aspect, amt);
    }

    public static void addRechargeTicket(int dim, PosXY pos, Aspect aspect, int amt) {
        AuraWorld aw = auras.get(dim);
        if (aw != null) {
            if (!aw.getNodeTickets().containsKey(pos)) {
                aw.getNodeTickets().put(pos, new AspectList());
            }
            AspectList al = aw.getNodeTickets().get(pos);
            if (al != null) {
                al.add(aspect, amt);
            }
        }
    }

    public static void generateAura(Chunk chunk, Random rand) {
        BiomeGenBase bgb = chunk.func_177412_p().func_180494_b(new BlockPos(chunk.field_76635_g * 16 + 8, 50, chunk.field_76647_h * 16 + 8));
        if (BiomeHandler.getBiomeBlacklist(bgb.field_76756_M) != -1) {
            return;
        }
        float life = BiomeHandler.getBiomeAuraModifier(bgb);
        for (int a = 0; a < 4; ++a) {
            EnumFacing dir = EnumFacing.func_176731_b((int)a);
            BiomeGenBase bgb2 = chunk.func_177412_p().func_180494_b(new BlockPos((chunk.field_76635_g + dir.func_82601_c()) * 16 + 8, 50, (chunk.field_76647_h + dir.func_82599_e()) * 16 + 8));
            life += BiomeHandler.getBiomeAuraModifier(bgb2);
        }
        life /= 5.0f;
        Aspect auraBonus = BiomeHandler.getRandomBiomeTag(bgb.field_76756_M, rand);
        short base = 0;
        AspectList current = new AspectList();
        for (Aspect aspect : Aspect.getPrimalAspects()) {
            float noise = aspect == auraBonus ? 1.0f : 0.5f + (rand.nextFloat() - rand.nextFloat()) * 0.1f;
            short b = (short)(life * (float)Config.AURABASE * noise);
            if (b > base) {
                base = b;
            }
            current.add(aspect, (int)((double)life * ((double)Config.AURABASE * (0.8 + (double)(rand.nextFloat() * 0.2f))) * (double)noise));
        }
        AuraHandler.addAuraChunk(chunk.func_177412_p().field_73011_w.func_177502_q(), chunk, base, current);
    }
}

