/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.aura;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.lib.aura.AuraChunk;
import thaumcraft.common.lib.aura.AuraHandler;
import thaumcraft.common.lib.aura.AuraWorld;
import thaumcraft.common.lib.utils.PosXY;

public class AuraThread
implements Runnable {
    private final long INTERVAL = 500L;
    private boolean stop = false;
    Random rand = new Random(System.currentTimeMillis());

    @Override
    public void run() {
        Thaumcraft.log.info("Starting aura thread");
        while (!this.stop) {
            if (AuraHandler.auras.isEmpty()) {
                Thaumcraft.log.warn("No auras found!");
                break;
            }
            long startTime = System.currentTimeMillis();
            for (AuraWorld auraWorld : AuraHandler.auras.values()) {
                for (AuraChunk auraChunk : auraWorld.auraChunks.values()) {
                    this.processAuraChunk(auraWorld, auraChunk);
                }
            }
            long executionTime = System.currentTimeMillis() - startTime;
            try {
                if (executionTime > 500L) {
                    Thaumcraft.log.warn("AURAS TAKING " + (executionTime - 500L) + " ms LONGER THAN NORMAL");
                }
                Thread.sleep(Math.max(1L, 500L - executionTime));
            }
            catch (InterruptedException e) {}
        }
        Thaumcraft.log.info("Stopping aura thread");
        Thaumcraft.proxy.setAuraThread(null);
    }

    private void processAuraChunk(AuraWorld auraWorld, AuraChunk auraChunk) {
        int flux;
        Aspect[] aspects;
        List<Integer> directions = Arrays.asList(0, 1, 2, 3);
        Collections.shuffle(directions, this.rand);
        int x = auraChunk.loc.x;
        int y = auraChunk.loc.y;
        short base = auraChunk.getBase();
        AspectList current = auraChunk.getCurrentAspects();
        AspectList ticketaura = AuraWorld.getNodeTickets().get(auraChunk.loc);
        boolean dirty = false;
        if (ticketaura != null) {
            Aspect[] aspects2;
            float smallbase = (float)base * 0.1f;
            for (Aspect aspect : aspects2 = ticketaura.copy().getAspects()) {
                int i;
                int amount;
                int change = amount = current.getAmount(aspect);
                int len = ticketaura.getAmount(aspect);
                ticketaura.reduce(aspect, len);
                if (len > 10) {
                    i = len / 10;
                    len = 10;
                } else {
                    i = 1;
                }
                int modify = aspect == Aspect.FLUX ? 2 : 1;
                for (int c = 0; c < len; ++c) {
                    if (change > base) {
                        float f = (float)(change - base) / smallbase / (float)modify;
                        if (this.rand.nextFloat() > f) {
                            change += i;
                            continue;
                        }
                        if (!((double)this.rand.nextFloat() > 0.33)) continue;
                        this.updateRandomChunk(aspect, auraWorld, auraChunk, i);
                        continue;
                    }
                    change += i;
                }
                int total = change - amount;
                if (total == 0) continue;
                current.add(aspect, total);
                dirty = true;
            }
        }
        for (Aspect aspect : aspects = current.getAspects()) {
            int m;
            AspectList neighbourCurrent;
            int neighbouramount;
            int currentAvailableAmount = current.getAmount(aspect);
            AuraChunk neighbour = null;
            int lowest = Integer.MAX_VALUE;
            for (Integer a : directions) {
                EnumFacing dir = EnumFacing.func_176731_b((int)a);
                AuraChunk n = auraWorld.getAuraChunkAt(x + dir.func_82601_c(), y + dir.func_82599_e());
                if (n == null) continue;
                int currentamount = n.getCurrentAspects().getAmount(aspect);
                if (neighbour != null && lowest <= currentamount || currentamount >= n.getBase() || currentAvailableAmount <= currentamount) continue;
                neighbour = n;
                lowest = currentamount;
            }
            if (neighbour != null && (neighbouramount = (neighbourCurrent = neighbour.getCurrentAspects()).getAmount(aspect)) < currentAvailableAmount - (m = (int)Math.max((double)(Config.AURABASE / 20), Math.min((double)(Config.AURABASE / 5), (double)neighbouramount * (aspect == Aspect.FLUX ? 0.66 : 0.25)))) && neighbouramount < neighbour.getBase()) {
                neighbourCurrent.add(aspect, 1);
                current.reduce(aspect, 1);
                dirty = true;
                this.markChunkAsDirty(neighbour, auraWorld.dim);
            }
            if (aspect == Aspect.FLUX || !((float)currentAvailableAmount < (float)base / 15.0f) || !(this.rand.nextFloat() < ((float)base / 15.0f - (float)currentAvailableAmount) / ((float)base * 75.0f))) continue;
            current.add(Aspect.FLUX, 1);
            dirty = true;
        }
        if (dirty) {
            this.markChunkAsDirty(auraChunk, auraWorld.dim);
        }
        if ((double)(flux = current.getAmount(Aspect.FLUX)) > (double)base * 0.75 && this.rand.nextFloat() < (float)flux / (float)(Config.AURABASE * 100)) {
            AuraHandler.taintTrigger.put(auraWorld.dim, new BlockPos(x * 16, 0, y * 16));
        }
    }

    private void updateRandomChunk(Aspect aspect, AuraWorld auraWorld, AuraChunk auraChunk, int amount) {
        EnumFacing rd = EnumFacing.field_176754_o[this.rand.nextInt(4)];
        PosXY p = new PosXY(auraChunk.loc);
        p.x += rd.func_82601_c() * MathHelper.func_76136_a((Random)this.rand, (int)1, (int)3);
        p.y += rd.func_82599_e() * MathHelper.func_76136_a((Random)this.rand, (int)1, (int)3);
        AuraHandler.addRechargeTicket(auraWorld.dim, p, aspect, amount);
    }

    private void markChunkAsDirty(AuraChunk chunk, int dim) {
        CopyOnWriteArrayList<PosXY> dc;
        if (chunk.isModified()) {
            return;
        }
        PosXY pos = new PosXY(chunk.loc.x, chunk.loc.y);
        if (!AuraHandler.dirtyChunks.containsKey(dim)) {
            AuraHandler.dirtyChunks.put(dim, new CopyOnWriteArrayList());
        }
        if (!(dc = AuraHandler.dirtyChunks.get(dim)).contains(pos)) {
            dc.add(pos);
        }
    }

    public void stop() {
        this.stop = true;
    }
}

