/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.crafting;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.IArcaneWorkbench;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.research.ResearchHelper;
import thaumcraft.api.wands.IWand;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;

public class ArcaneSceptreRecipe
implements IArcaneRecipe {
    private static final int MAX_CRAFT_GRID_WIDTH = 3;
    private static final int MAX_CRAFT_GRID_HEIGHT = 3;
    private boolean mirrored = true;

    @Override
    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack out = null;
        String bc = null;
        String br = null;
        int cc = 0;
        int cr = 0;
        ItemStack cap1 = inv.func_70463_b(1, 0);
        ItemStack cap2 = inv.func_70463_b(2, 1);
        ItemStack cap3 = inv.func_70463_b(0, 2);
        ItemStack rod = inv.func_70463_b(1, 1);
        ItemStack focus = inv.func_70463_b(2, 0);
        if (inv.func_70463_b(0, 0) != null || inv.func_70463_b(0, 1) != null || inv.func_70463_b(1, 2) != null || inv.func_70463_b(2, 2) != null) {
            return null;
        }
        if (cap1 != null && cap2 != null && cap3 != null && rod != null && focus != null && this.checkItemEquals(focus, new ItemStack(ItemsTC.primalCharm)) && this.checkItemEquals(cap1, cap2) && this.checkItemEquals(cap1, cap3)) {
            for (WandCap wc : WandCap.caps.values()) {
                if (!this.checkItemEquals(cap1, wc.getItem())) continue;
                bc = wc.getTag();
                cc = wc.getCraftCost();
                break;
            }
            for (WandRod wr : WandRod.rods.values()) {
                if (!this.checkItemEquals(rod, wr.getItem()) || wr.isStaff()) continue;
                br = wr.getTag();
                cr = wr.getCraftCost();
                break;
            }
            if (bc != null && br != null) {
                int cost = cc * cr * 10;
                out = new ItemStack(ItemsTC.wand);
                ((IWand)out.func_77973_b()).setCap(out, WandCap.caps.get(bc));
                ((IWand)out.func_77973_b()).setRod(out, WandRod.rods.get(br));
                out.func_77983_a("sceptre", (NBTBase)new NBTTagByte(1));
            }
        }
        return out;
    }

    @Override
    public AspectList getAspects(InventoryCrafting inv) {
        AspectList al = new AspectList();
        int cc = -1;
        int cr = -1;
        ItemStack cap1 = inv.func_70463_b(1, 0);
        ItemStack cap2 = inv.func_70463_b(2, 1);
        ItemStack cap3 = inv.func_70463_b(0, 2);
        ItemStack rod = inv.func_70463_b(1, 1);
        ItemStack focus = inv.func_70463_b(2, 0);
        if (inv.func_70463_b(0, 0) != null || inv.func_70463_b(0, 1) != null || inv.func_70463_b(1, 2) != null || inv.func_70463_b(2, 2) != null) {
            return al;
        }
        if (cap1 != null && cap2 != null && cap3 != null && rod != null && focus != null && this.checkItemEquals(focus, new ItemStack(ItemsTC.primalCharm)) && this.checkItemEquals(cap1, cap2) && this.checkItemEquals(cap1, cap3)) {
            for (WandCap wc : WandCap.caps.values()) {
                if (!this.checkItemEquals(cap1, wc.getItem())) continue;
                cc = wc.getCraftCost();
                break;
            }
            for (WandRod wr : WandRod.rods.values()) {
                if (!this.checkItemEquals(rod, wr.getItem()) || wr.isStaff()) continue;
                cr = wr.getCraftCost();
                break;
            }
            if (cc >= 0 && cr >= 0) {
                int cost = cc * cr * 10;
                for (Aspect as : Aspect.getPrimalAspects()) {
                    al.add(as, cost);
                }
            }
        }
        return al;
    }

    @Override
    public ItemStack func_77571_b() {
        return null;
    }

    @Override
    public boolean matches(InventoryCrafting inv, World world, EntityPlayer player) {
        if (player != null && !ResearchHelper.isResearchComplete(player.func_70005_c_(), "SCEPTRE")) {
            return false;
        }
        ItemStack cap1 = inv.func_70463_b(1, 0);
        ItemStack cap2 = inv.func_70463_b(2, 1);
        ItemStack cap3 = inv.func_70463_b(0, 2);
        ItemStack rod = inv.func_70463_b(1, 1);
        ItemStack focus = inv.func_70463_b(2, 0);
        if (inv.func_70463_b(0, 0) != null || inv.func_70463_b(0, 1) != null || inv.func_70463_b(1, 2) != null || inv.func_70463_b(2, 2) != null) {
            return false;
        }
        return this.checkMatch(cap1, cap2, cap3, rod, focus, player);
    }

    private boolean checkMatch(ItemStack cap1, ItemStack cap2, ItemStack cap3, ItemStack rod, ItemStack focus, EntityPlayer player) {
        boolean bc = false;
        boolean br = false;
        if (cap1 != null && cap2 != null && cap3 != null && rod != null && focus != null && this.checkItemEquals(focus, new ItemStack(ItemsTC.primalCharm)) && this.checkItemEquals(cap1, cap2) && this.checkItemEquals(cap1, cap3)) {
            for (WandCap wc : WandCap.caps.values()) {
                if (!this.checkItemEquals(cap1, wc.getItem()) || player != null && !ResearchHelper.isResearchComplete(player.func_70005_c_(), wc.getResearch())) continue;
                bc = true;
                break;
            }
            for (WandRod wr : WandRod.rods.values()) {
                if (!this.checkItemEquals(rod, wr.getItem()) || wr.isStaff() || player != null && !ResearchHelper.isResearchComplete(player.func_70005_c_(), wr.getResearch())) continue;
                br = true;
                break;
            }
        }
        return br && bc;
    }

    private boolean checkItemEquals(ItemStack target, ItemStack input) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return target.func_77973_b() == input.func_77973_b() && target.func_77952_i() == input.func_77952_i();
    }

    @Override
    public int func_77570_a() {
        return 9;
    }

    @Override
    public AspectList getAspects() {
        return null;
    }

    @Override
    public String[] getResearch() {
        return new String[]{""};
    }

    @Override
    public ItemStack[] func_179532_b(InventoryCrafting p_179532_1_) {
        ItemStack[] aitemstack = new ItemStack[p_179532_1_.func_70302_i_()];
        for (int i = 0; i < Math.min(9, aitemstack.length); ++i) {
            ItemStack itemstack = p_179532_1_.func_70301_a(i);
            aitemstack[i] = ForgeHooks.getContainerItem((ItemStack)itemstack);
        }
        return aitemstack;
    }

    @Override
    public boolean func_77569_a(InventoryCrafting inv, World world) {
        return inv instanceof IArcaneWorkbench && this.matches(inv, world, null);
    }
}

