/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.crafting;

import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.research.ResearchHelper;
import thaumcraft.common.items.baubles.ItemBaubles;

public class InfusionVisDiscountCombineRecipe
extends InfusionRecipe {
    private ItemStack[] components;

    public InfusionVisDiscountCombineRecipe() {
        super("", null, 0, null, null, (Object[])new ItemStack[]{new ItemStack(ItemsTC.baubles), new ItemStack(ItemsTC.baubles)});
    }

    @Override
    public boolean matches(ArrayList<ItemStack> input, ItemStack central, World world, EntityPlayer player) {
        if (this.research != null && this.research[0].length() > 0 && !ResearchHelper.isResearchComplete(player.func_70005_c_(), this.research)) {
            return false;
        }
        if (!(central.func_77973_b() instanceof ItemBaubles) || central.func_77952_i() < 3 || central.func_77952_i() > 8) {
            return false;
        }
        int c = 0;
        for (ItemStack is : input) {
            if (is == null) continue;
            if (!(is.func_77973_b() instanceof ItemBaubles) || is.func_77952_i() < 3 || is.func_77952_i() > 8) {
                return false;
            }
            ++c;
        }
        return c == 2;
    }

    private AspectList calcAspects(EntityPlayer player, ItemStack input, ArrayList<ItemStack> comps) {
        AspectList al = new AspectList();
        for (Aspect aspect : Aspect.getPrimalAspects()) {
            int d = ((ItemBaubles)input.func_77973_b()).getVisDiscount(input, player, aspect);
            int c = 0;
            for (ItemStack is : comps) {
                int q = ((ItemBaubles)is.func_77973_b()).getVisDiscount(is, player, aspect);
                if (d > 0 && q == d) {
                    ++c;
                }
                if (q <= d) continue;
                d = q;
            }
            if (c == 2) {
                ++d;
            }
            if (d <= 0) continue;
            al.merge(aspect, d);
        }
        return al;
    }

    @Override
    public Object getRecipeOutput(EntityPlayer player, ItemStack input, ArrayList<ItemStack> comps) {
        ItemStack out = input.func_77946_l();
        AspectList al = this.calcAspects(player, input, comps);
        for (Aspect aspect : al.getAspects()) {
            if (al.getAmount(aspect) <= 0) continue;
            if (out.func_77978_p() == null) {
                out.func_77982_d(new NBTTagCompound());
            }
            out.func_77978_p().func_74768_a(aspect.getTag(), al.getAmount(aspect));
        }
        ((ItemBaubles)out.func_77973_b()).calcColor(out);
        return out;
    }

    @Override
    public AspectList getAspects(EntityPlayer player, ItemStack input, ArrayList<ItemStack> comps) {
        AspectList al = new AspectList();
        int d = 0;
        AspectList al2 = this.calcAspects(player, input, comps);
        for (Aspect aspect : al2.getAspects()) {
            int q = al2.getAmount(aspect) * 2;
            al.merge(aspect, q * q);
            if (q * q <= d) continue;
            d = q * q;
        }
        al.merge(Aspect.EXCHANGE, d);
        return al;
    }

    @Override
    public int getInstability(EntityPlayer player, ItemStack input, ArrayList<ItemStack> comps) {
        return this.instability;
    }

    public ItemStack[] getComponents() {
        return this.components;
    }
}

