/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.events;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.IWand;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.entities.construct.golem.seals.SealHandler;
import thaumcraft.common.entities.construct.golem.tasks.TaskHandler;
import thaumcraft.common.lib.aura.AuraHandler;
import thaumcraft.common.lib.aura.AuraThread;
import thaumcraft.common.lib.events.TaintEvents;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXBlockSparkle;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.utils.InventoryUtils;
import thaumcraft.common.lib.utils.PosXY;
import thaumcraft.common.lib.world.ChunkLoc;
import thaumcraft.common.tiles.devices.TileArcaneEar;

public class ServerTickEventsFML {
    long lastcheck = 0L;
    HashMap<Integer, Integer> serverTicks = new HashMap();
    DecimalFormat myFormatter = new DecimalFormat("#######.##");
    public static Map<Integer, LinkedBlockingQueue<VirtualSwapper>> swapList = new HashMap<Integer, LinkedBlockingQueue<VirtualSwapper>>();
    public static HashMap<Integer, ArrayList<ChunkLoc>> chunksToGenerate = new HashMap();

    @SubscribeEvent
    public void serverWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side == Side.CLIENT) {
            return;
        }
        int dim = event.world.field_73011_w.func_177502_q();
        if (event.phase == TickEvent.Phase.START) {
            if (Thaumcraft.proxy.getAuraThread() == null) {
                Thaumcraft.proxy.setAuraThread(new AuraThread());
            }
        } else {
            if (!this.serverTicks.containsKey(dim)) {
                this.serverTicks.put(dim, 0);
            }
            int ticks = this.serverTicks.get(dim);
            this.tickChunkRegeneration(event);
            this.tickBlockSwap(event.world);
            ArrayList<Integer[]> nbe = TileArcaneEar.noteBlockEvents.get(dim);
            if (nbe != null) {
                nbe.clear();
            }
            if (ticks % 20 == 0) {
                CopyOnWriteArrayList<PosXY> dc = AuraHandler.dirtyChunks.get(dim);
                if (dc != null && dc.size() > 0) {
                    for (PosXY pos : dc) {
                        event.world.func_175646_b(new BlockPos(pos.x * 16, 5, pos.y * 16), null);
                    }
                    dc.clear();
                }
                if (AuraHandler.taintTrigger.containsKey(dim)) {
                    if (!Config.wuss) {
                        TaintEvents.taintEvent(event.world, AuraHandler.taintTrigger.get(dim));
                    }
                    AuraHandler.taintTrigger.remove(dim);
                }
                TaskHandler.clearSuspendedOrExpiredTasks(event.world);
            }
            SealHandler.tickSealEntities(event.world);
            this.serverTicks.put(dim, ticks + 1);
        }
    }

    public void tickChunkRegeneration(TickEvent.WorldTickEvent event) {
        int dim = event.world.field_73011_w.func_177502_q();
        int count = 0;
        ArrayList<ChunkLoc> chunks = chunksToGenerate.get(dim);
        if (chunks != null && chunks.size() > 0) {
            for (int a = 0; a < 10 && (chunks = chunksToGenerate.get(dim)) != null && chunks.size() > 0; ++a) {
                ++count;
                ChunkLoc loc = chunks.get(0);
                long worldSeed = event.world.func_72905_C();
                Random fmlRandom = new Random(worldSeed);
                long xSeed = fmlRandom.nextLong() >> 3;
                long zSeed = fmlRandom.nextLong() >> 3;
                fmlRandom.setSeed(xSeed * (long)loc.chunkXPos + zSeed * (long)loc.chunkZPos ^ worldSeed);
                Thaumcraft.instance.worldGen.worldGeneration(fmlRandom, loc.chunkXPos, loc.chunkZPos, event.world, false);
                chunks.remove(0);
                chunksToGenerate.put(dim, chunks);
            }
        }
        if (count > 0) {
            FMLCommonHandler.instance().getFMLLogger().log(Level.INFO, "[Thaumcraft] Regenerated " + count + " chunks. " + Math.max(0, chunks.size()) + " chunks left");
        }
    }

    private void tickBlockSwap(World world) {
        int dim = world.field_73011_w.func_177502_q();
        LinkedBlockingQueue<VirtualSwapper> queue = swapList.get(dim);
        if (queue != null) {
            boolean didSomething = false;
            while (!didSomething) {
                VirtualSwapper vs = queue.poll();
                if (vs != null) {
                    IBlockState bs = world.func_180495_p(vs.pos);
                    IWand wand = null;
                    ItemFocusBasic focus = null;
                    ItemStack focusStack = null;
                    if (vs.player.field_71071_by.func_70301_a(vs.wand) != null && vs.player.field_71071_by.func_70301_a(vs.wand).func_77973_b() instanceof IWand) {
                        wand = (IWand)vs.player.field_71071_by.func_70301_a(vs.wand).func_77973_b();
                        focusStack = wand.getFocusStack(vs.player.field_71071_by.func_70301_a(vs.wand));
                        focus = wand.getFocus(vs.player.field_71071_by.func_70301_a(vs.wand));
                    }
                    if (!world.canMineBlockBody(vs.player, vs.pos) || !(bs.func_177230_c().func_176195_g(world, vs.pos) >= 0.0f) || vs.target.func_77969_a(new ItemStack(bs.func_177230_c(), 1, bs.func_177230_c().func_176201_c(bs))) || wand == null || focus == null || ForgeEventFactory.onPlayerInteract((EntityPlayer)vs.player, (PlayerInteractEvent.Action)PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, (World)world, (BlockPos)vs.pos, (EnumFacing)EnumFacing.UP).isCanceled() || !wand.consumeAllVis(vs.player.field_71071_by.func_70301_a(vs.wand), vs.player, focus.getVisCost(focusStack), false, false)) continue;
                    int slot = InventoryUtils.isPlayerCarrying(vs.player, vs.target);
                    if (vs.player.field_71075_bZ.field_75098_d) {
                        slot = 1;
                    }
                    if (vs.bSource != null && vs.bSource != bs || slot < 0) continue;
                    didSomething = true;
                    if (!vs.player.field_71075_bZ.field_75098_d) {
                        int fortune = wand.getFocusTreasure(vs.player.field_71071_by.func_70301_a(vs.wand));
                        boolean silk = wand.getFocus(vs.player.field_71071_by.func_70301_a(vs.wand)).isUpgradedWith(wand.getFocusStack(vs.player.field_71071_by.func_70301_a(vs.wand)), FocusUpgradeType.silktouch);
                        vs.player.field_71071_by.func_70298_a(slot, 1);
                        List<ItemStack> ret = new ArrayList();
                        if (silk && bs.func_177230_c().canSilkHarvest(world, vs.pos, bs, vs.player)) {
                            ItemStack itemstack = BlockUtils.createStackedBlock(bs);
                            if (itemstack != null) {
                                ret.add(itemstack);
                            }
                        } else {
                            ret = bs.func_177230_c().getDrops((IBlockAccess)world, vs.pos, bs, fortune);
                        }
                        if (ret.size() > 0) {
                            for (ItemStack is : ret) {
                                if (vs.player.field_71071_by.func_70441_a(is)) continue;
                                world.func_72838_d((Entity)new EntityItem(world, (double)vs.pos.func_177958_n() + 0.5, (double)vs.pos.func_177956_o() + 0.5, (double)vs.pos.func_177952_p() + 0.5, is));
                            }
                        }
                        wand.consumeAllVis(vs.player.field_71071_by.func_70301_a(vs.wand), vs.player, focus.getVisCost(focusStack), true, false);
                    }
                    Block tb = Block.func_149634_a((Item)vs.target.func_77973_b());
                    world.func_180501_a(vs.pos, tb.func_176203_a(vs.target.func_77952_i()), 3);
                    tb.func_180633_a(world, vs.pos, tb.func_176203_a(vs.target.func_77952_i()), (EntityLivingBase)vs.player, vs.target);
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockSparkle(vs.pos, 0xC0C0FF), new NetworkRegistry.TargetPoint(world.field_73011_w.func_177502_q(), (double)vs.pos.func_177958_n(), (double)vs.pos.func_177956_o(), (double)vs.pos.func_177952_p(), 32.0));
                    world.func_175718_b(2001, vs.pos, Block.func_176210_f((IBlockState)bs));
                    if (vs.lifespan <= 0) continue;
                    for (int xx = -1; xx <= 1; ++xx) {
                        for (int yy = -1; yy <= 1; ++yy) {
                            for (int zz = -1; zz <= 1; ++zz) {
                                if (xx == 0 && yy == 0 && zz == 0 || world.func_180495_p(vs.pos.func_177982_a(xx, yy, zz)) != vs.bSource || !BlockUtils.isBlockExposed(world, vs.pos.func_177982_a(xx, yy, zz))) continue;
                                queue.offer(new VirtualSwapper(vs.pos.func_177982_a(xx, yy, zz), vs.bSource, vs.target, vs.lifespan - 1, vs.player, vs.wand));
                            }
                        }
                    }
                    continue;
                }
                didSomething = true;
            }
            swapList.put(dim, queue);
        }
    }

    public static void addSwapper(World world, BlockPos pos, IBlockState bs, ItemStack target, int life, EntityPlayer player, int wand) {
        int dim = world.field_73011_w.func_177502_q();
        if (bs != null && (bs.func_177230_c() == Blocks.field_150350_a || bs.func_177230_c().func_176195_g(world, pos) < 0.0f || target.func_77969_a(new ItemStack(bs.func_177230_c(), 1, bs.func_177230_c().func_176201_c(bs))))) {
            return;
        }
        LinkedBlockingQueue<VirtualSwapper> queue = swapList.get(dim);
        if (queue == null) {
            swapList.put(dim, new LinkedBlockingQueue());
            queue = swapList.get(dim);
        }
        queue.offer(new VirtualSwapper(pos, bs, target, life, player, wand));
        world.func_72956_a((Entity)player, "thaumcraft:wand", 0.25f, 1.0f);
        swapList.put(dim, queue);
    }

    public static class VirtualSwapper {
        int lifespan = 0;
        BlockPos pos;
        IBlockState bSource;
        ItemStack target;
        int wand = 0;
        EntityPlayer player = null;

        VirtualSwapper(BlockPos pos, IBlockState bs, ItemStack t, int life, EntityPlayer p, int wand) {
            this.pos = pos;
            this.bSource = bs;
            this.target = t;
            this.lifespan = life;
            this.player = p;
            this.wand = wand;
        }
    }
}

