/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.playerdata;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.tiles.crafting.TileResearchTable;

public class PacketAspectCombinationToServer
implements IMessage,
IMessageHandler<PacketAspectCombinationToServer, IMessage> {
    private int dim;
    private int x;
    private int y;
    private int z;
    Aspect aspect1;
    Aspect aspect2;

    public PacketAspectCombinationToServer() {
    }

    public PacketAspectCombinationToServer(EntityPlayer player, BlockPos pos, Aspect aspect1, Aspect aspect2) {
        this.dim = player.field_70170_p.field_73011_w.func_177502_q();
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.aspect1 = aspect1;
        this.aspect2 = aspect2;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.dim);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.aspect1.getTag());
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.aspect2.getTag());
    }

    public void fromBytes(ByteBuf buffer) {
        this.dim = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.aspect1 = Aspect.getAspect(ByteBufUtils.readUTF8String((ByteBuf)buffer));
        this.aspect2 = Aspect.getAspect(ByteBufUtils.readUTF8String((ByteBuf)buffer));
    }

    public IMessage onMessage(PacketAspectCombinationToServer message, MessageContext ctx) {
        WorldServer world = DimensionManager.getWorld((int)message.dim);
        if (world == null) {
            return null;
        }
        BlockPos pos = new BlockPos(message.x, message.y, message.z);
        if (message.aspect1 != null && message.aspect2 != null) {
            Aspect combo = ResearchManager.getCombinationResult(message.aspect1, message.aspect2);
            TileEntity rt = world.func_175625_s(pos);
            if (rt != null && rt instanceof TileResearchTable) {
                if (((TileResearchTable)rt).data == null) {
                    ((TileResearchTable)rt).gatherResults();
                }
                if (((TileResearchTable)rt).data != null && ((TileResearchTable)rt).data.aspects != null && ((TileResearchTable)rt).data.aspects.getAmount(message.aspect1) > 0 && ((TileResearchTable)rt).data.aspects.getAmount(message.aspect2) > 0) {
                    ((TileResearchTable)rt).data.aspects.remove(message.aspect1, 1);
                    ((TileResearchTable)rt).data.aspects.remove(message.aspect2, 1);
                    ((TileResearchTable)rt).data.aspects.add(combo, 1);
                    ((TileResearchTable)rt).updateNoteAndConsumeInk();
                }
            }
        }
        return null;
    }
}

