/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.playerdata;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.client.gui.GuiResearchBrowser;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.research.ResearchManager;

public class PacketSyncResearch
implements IMessage,
IMessageHandler<PacketSyncResearch, IMessage> {
    protected String name;
    protected ArrayList<String> data = new ArrayList();
    protected HashMap<String, Byte> flags = new HashMap();

    public PacketSyncResearch() {
    }

    public PacketSyncResearch(EntityPlayer player) {
        this.name = player.func_70005_c_();
        this.data = ResearchManager.getResearchForPlayer(this.name);
        this.flags = ResearchManager.getResearchFlagsForPlayer(this.name);
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.name);
        if (this.data != null && this.data.size() > 0) {
            buffer.writeShort(this.data.size());
            for (String re : this.data) {
                if (re == null) continue;
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)re);
                buffer.writeByte(this.flags.get(re) != null ? (int)this.flags.get(re).byteValue() : 0);
            }
        } else {
            buffer.writeShort(0);
        }
    }

    public void fromBytes(ByteBuf buffer) {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        int size = buffer.readShort();
        this.data = new ArrayList();
        for (int a = 0; a < size; ++a) {
            String s = ByteBufUtils.readUTF8String((ByteBuf)buffer);
            this.data.add(s);
            this.flags.put(s, buffer.readByte());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(PacketSyncResearch message, MessageContext ctx) {
        for (String key : message.data) {
            Thaumcraft.proxy.getResearchManager();
            ResearchManager.completeResearchUnsaved(message.name, key, message.flags.get(key));
        }
        GuiResearchBrowser.completedResearch.put(message.name, message.data);
        return null;
    }
}

