/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.playerdata;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.common.Thaumcraft;

public class PacketSyncWarp
implements IMessage,
IMessageHandler<PacketSyncWarp, IMessage> {
    protected String name;
    protected int data = 0;
    protected byte type = 0;

    public PacketSyncWarp() {
    }

    public PacketSyncWarp(EntityPlayer player, byte type) {
        this.name = player.func_70005_c_();
        if (type == 0) {
            this.data = Thaumcraft.proxy.getPlayerKnowledge().getWarpPerm(this.name);
        }
        if (type == 1) {
            this.data = Thaumcraft.proxy.getPlayerKnowledge().getWarpSticky(this.name);
        }
        if (type == 2) {
            this.data = Thaumcraft.proxy.getPlayerKnowledge().getWarpTemp(this.name);
        }
        this.type = type;
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.name);
        buffer.writeInt(this.data);
        buffer.writeByte((int)this.type);
    }

    public void fromBytes(ByteBuf buffer) {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.data = buffer.readInt();
        this.type = buffer.readByte();
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(PacketSyncWarp message, MessageContext ctx) {
        if (message.type == 0) {
            Thaumcraft.proxy.getPlayerKnowledge().setWarpPerm(message.name, message.data);
        } else if (message.type == 1) {
            Thaumcraft.proxy.getPlayerKnowledge().setWarpSticky(message.name, message.data);
        } else {
            Thaumcraft.proxy.getPlayerKnowledge().setWarpTemp(message.name, message.data);
        }
        return null;
    }
}

