/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.research;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PlayerKnowledge {
    public Map<String, ArrayList<String>> researchCompleted = new HashMap<String, ArrayList<String>>();
    public Map<String, HashMap<String, Byte>> researchCompletedFlags = new HashMap<String, HashMap<String, Byte>>();
    public Map<String, Integer> warpCount = new HashMap<String, Integer>();
    public Map<String, Integer> warp = new HashMap<String, Integer>();
    public Map<String, Integer> warpSticky = new HashMap<String, Integer>();
    public Map<String, Integer> warpTemp = new HashMap<String, Integer>();

    public void wipePlayerKnowledge(String player) {
        this.researchCompleted.remove(player);
        this.warp.remove(player);
        this.warpTemp.remove(player);
        this.warpSticky.remove(player);
    }

    public int getWarpCounter(String player) {
        int known = 0;
        if (!this.warpCount.containsKey(player)) {
            this.warpCount.put(player, 0);
        } else {
            known = this.warpCount.get(player);
        }
        return known;
    }

    public void setWarpCounter(String player, int amount) {
        this.warpCount.put(player, amount);
    }

    public int getWarpTotal(String player) {
        return this.getWarpPerm(player) + this.getWarpTemp(player) + this.getWarpSticky(player);
    }

    public int getWarpPerm(String player) {
        if (player == null) {
            return 0;
        }
        int known = 0;
        try {
            if (!this.warp.containsKey(player)) {
                this.warp.put(player, 0);
            } else {
                known = this.warp.get(player);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return known;
    }

    public int getWarpTemp(String player) {
        if (player == null) {
            return 0;
        }
        int known = 0;
        try {
            if (!this.warpTemp.containsKey(player)) {
                this.warpTemp.put(player, 0);
            } else {
                known = this.warpTemp.get(player);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return known;
    }

    public int getWarpSticky(String player) {
        if (player == null) {
            return 0;
        }
        int known = 0;
        try {
            if (!this.warpSticky.containsKey(player)) {
                this.warpSticky.put(player, 0);
            } else {
                known = this.warpSticky.get(player);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return known;
    }

    public void addWarpTemp(String player, int amount) {
        int er = this.getWarpTemp(player) + amount;
        this.warpTemp.put(player, Math.max(0, er));
    }

    public void addWarpPerm(String player, int amount) {
        int er = this.getWarpPerm(player) + amount;
        this.warp.put(player, Math.max(0, er));
    }

    public void addWarpSticky(String player, int amount) {
        int er = this.getWarpSticky(player) + amount;
        this.warpSticky.put(player, Math.max(0, er));
    }

    public void setWarpSticky(String player, int amount) {
        this.warpSticky.put(player, Math.max(0, amount));
    }

    public void setWarpPerm(String player, int amount) {
        this.warp.put(player, Math.max(0, amount));
    }

    public void setWarpTemp(String player, int amount) {
        this.warpTemp.put(player, Math.max(0, amount));
    }
}

