/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.research;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.SaveHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.internal.EnumWarpType;
import thaumcraft.api.items.IScribeTools;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategoryList;
import thaumcraft.api.research.ResearchHelper;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.lib.research.ResearchNoteData;
import thaumcraft.common.lib.utils.HexUtils;
import thaumcraft.common.lib.utils.Utils;

public class ResearchManager {
    static ArrayList<ResearchItem> allValidResearch = null;
    public static boolean loadingBlocked = false;
    private static final String RESEARCH_TAG = "THAUMCRAFT.RESEARCH";

    public static ItemStack createResearchNoteForPlayer(World world, EntityPlayer player, String key) {
        ItemStack note = null;
        boolean addslot = false;
        int slot = ResearchManager.getResearchSlot(player, key);
        if (slot >= 0) {
            note = player.field_71071_by.func_70301_a(slot);
        } else if (ResearchManager.consumeInkFromPlayer(player, false) && player.field_71071_by.func_146026_a(Items.field_151121_aF)) {
            ResearchManager.consumeInkFromPlayer(player, true);
            note = ResearchManager.createNote(new ItemStack(ItemsTC.researchNotes), key, world);
            if (!player.field_71071_by.func_70441_a(note)) {
                player.func_71019_a(note, false);
            }
            player.field_71069_bz.func_75142_b();
        }
        return note;
    }

    public static String findMatchingResearch(EntityPlayer player, Aspect aspect) {
        String randomMatch = null;
        if (allValidResearch == null) {
            allValidResearch = new ArrayList();
            Collection<ResearchCategoryList> rc = ResearchCategories.researchCategories.values();
            for (ResearchCategoryList cat : rc) {
                Collection<ResearchItem> rl = cat.research.values();
                for (ResearchItem ri : rl) {
                    boolean secondary = ri.isSecondary() && Config.researchDifficulty == 0 || Config.researchDifficulty == -1;
                    if (secondary || ri.isHidden() || ri.isAutoUnlock() || ri.isVirtual() || ri.isStub()) continue;
                    allValidResearch.add(ri);
                }
            }
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (ResearchItem research : allValidResearch) {
            if (ResearchManager.isResearchComplete(player.func_70005_c_(), research.key) || !ResearchManager.doesPlayerHaveRequisites(player.func_70005_c_(), research.key) || research.tags.getAmount(aspect) <= 0) continue;
            keys.add(research.key);
        }
        if (keys.size() > 0) {
            randomMatch = (String)keys.get(player.field_70170_p.field_73012_v.nextInt(keys.size()));
        }
        return randomMatch;
    }

    public static int getResearchSlot(EntityPlayer player, String key) {
        ItemStack[] inv = player.field_71071_by.field_70462_a;
        if (inv == null || inv.length == 0) {
            return -1;
        }
        for (int a = 0; a < inv.length; ++a) {
            if (inv[a] == null || inv[a].func_77973_b() == null || inv[a].func_77973_b() != ItemsTC.researchNotes || ResearchManager.getData(inv[a]) == null || !ResearchManager.getData((ItemStack)inv[a]).key.equals(key)) continue;
            return a;
        }
        return -1;
    }

    public static boolean consumeInkFromPlayer(EntityPlayer player, boolean doit) {
        ItemStack[] inv = player.field_71071_by.field_70462_a;
        for (int a = 0; a < inv.length; ++a) {
            if (inv[a] == null || !(inv[a].func_77973_b() instanceof IScribeTools) || inv[a].func_77952_i() >= inv[a].func_77958_k()) continue;
            if (doit) {
                inv[a].func_77972_a(1, (EntityLivingBase)player);
            }
            return true;
        }
        return false;
    }

    public static boolean consumeInkFromTable(ItemStack stack, boolean doit) {
        if (stack != null && stack.func_77973_b() instanceof IScribeTools && stack.func_77952_i() < stack.func_77958_k()) {
            if (doit) {
                stack.func_77964_b(stack.func_77952_i() + 1);
            }
            return true;
        }
        return false;
    }

    public static boolean checkResearchCompletion(ItemStack contents, ResearchNoteData note, String username) {
        ArrayList<String> checked = new ArrayList<String>();
        ArrayList<String> main = new ArrayList<String>();
        ArrayList<String> remains = new ArrayList<String>();
        for (HexUtils.Hex hex : note.hexes.values()) {
            if (note.hexEntries.get((Object)hex.toString()).type != 1) continue;
            main.add(hex.toString());
        }
        for (HexUtils.Hex hex : note.hexes.values()) {
            if (note.hexEntries.get((Object)hex.toString()).type != 1) continue;
            main.remove(hex.toString());
            ResearchManager.checkConnections(note, hex, checked, main, remains, username);
            break;
        }
        if (main.size() == 0) {
            ArrayList<String> remove = new ArrayList<String>();
            for (HexUtils.Hex hex : note.hexes.values()) {
                if (note.hexEntries.get((Object)hex.toString()).type == 1 || remains.contains(hex.toString())) continue;
                remove.add(hex.toString());
            }
            for (String s : remove) {
                note.hexEntries.remove(s);
                note.hexes.remove(s);
            }
            note.complete = true;
            ResearchManager.updateData(contents, note);
            return true;
        }
        return false;
    }

    private static void checkConnections(ResearchNoteData note, HexUtils.Hex hex, ArrayList<String> checked, ArrayList<String> main, ArrayList<String> remains, String username) {
        checked.add(hex.toString());
        for (int a = 0; a < 6; ++a) {
            HexUtils.Hex target = hex.getNeighbour(a);
            if (checked.contains(target.toString()) || !note.hexEntries.containsKey(target.toString()) || note.hexEntries.get((Object)target.toString()).type < 1) continue;
            Aspect aspect1 = note.hexEntries.get((Object)hex.toString()).aspect;
            Aspect aspect2 = note.hexEntries.get((Object)target.toString()).aspect;
            if ((aspect1.isPrimal() || aspect1.getComponents()[0] != aspect2 && aspect1.getComponents()[1] != aspect2) && (aspect2.isPrimal() || aspect2.getComponents()[0] != aspect1 && aspect2.getComponents()[1] != aspect1)) continue;
            remains.add(target.toString());
            if (note.hexEntries.get((Object)target.toString()).type == 1) {
                main.remove(target.toString());
            }
            ResearchManager.checkConnections(note, target, checked, main, remains, username);
        }
    }

    public static ItemStack createNote(ItemStack stack, String key, World world) {
        ResearchItem rr = ResearchCategories.getResearch(key);
        Aspect primaryaspect = rr.getResearchPrimaryTag();
        AspectList aspects = new AspectList();
        if (primaryaspect == null) {
            return null;
        }
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74778_a("key", key);
        stack.func_77978_p().func_74768_a("color", primaryaspect.getColor());
        stack.func_77978_p().func_74757_a("complete", false);
        stack.func_77978_p().func_74768_a("copies", 0);
        int radius = 1 + Math.min(3, rr.getComplexity());
        HashMap<String, HexUtils.Hex> hexLocs = HexUtils.generateHexes(radius);
        ArrayList<HexUtils.Hex> outerRing = HexUtils.distributeRingRandomly(radius, rr.tags.size(), world.field_73012_v);
        HashMap<String, HexEntry> hexEntries = new HashMap<String, HexEntry>();
        HashMap<String, HexUtils.Hex> hexes = new HashMap<String, HexUtils.Hex>();
        for (HexUtils.Hex hex : hexLocs.values()) {
            hexes.put(hex.toString(), hex);
            hexEntries.put(hex.toString(), new HexEntry(null, 0));
        }
        int count = 0;
        for (HexUtils.Hex hex : outerRing) {
            hexes.put(hex.toString(), hex);
            hexEntries.put(hex.toString(), new HexEntry(rr.tags.getAspects()[count], 1));
            ++count;
        }
        for (Aspect aa : Aspect.getPrimalAspects()) {
            aspects.add(aa, rr.tags.size() + radius + world.field_73012_v.nextInt(radius));
        }
        aspects.writeToNBT(stack.func_77978_p(), "aspects");
        if (rr.getComplexity() > 1) {
            int blanks = rr.getComplexity() * 2;
            HexUtils.Hex[] temp = hexes.values().toArray(new HexUtils.Hex[0]);
            while (blanks > 0) {
                int indx = world.field_73012_v.nextInt(temp.length);
                if (hexEntries.get(temp[indx].toString()) == null || ((HexEntry)hexEntries.get((Object)temp[indx].toString())).type != 0) continue;
                boolean gtg = true;
                for (int n = 0; n < 6; ++n) {
                    HexUtils.Hex neighbour = temp[indx].getNeighbour(n);
                    if (!hexes.containsKey(neighbour.toString()) || ((HexEntry)hexEntries.get((Object)neighbour.toString())).type != 1) continue;
                    int cc = 0;
                    for (int q = 0; q < 6; ++q) {
                        if (hexes.containsKey(((HexUtils.Hex)hexes.get(neighbour.toString())).getNeighbour(q).toString())) {
                            ++cc;
                        }
                        if (cc >= 2) break;
                    }
                    if (cc >= 2) continue;
                    gtg = false;
                    break;
                }
                if (!gtg) continue;
                hexes.remove(temp[indx].toString());
                hexEntries.remove(temp[indx].toString());
                temp = hexes.values().toArray(new HexUtils.Hex[0]);
                --blanks;
            }
        }
        NBTTagList gridtag = new NBTTagList();
        for (HexUtils.Hex hex : hexes.values()) {
            NBTTagCompound gt = new NBTTagCompound();
            gt.func_74774_a("hexq", (byte)hex.q);
            gt.func_74774_a("hexr", (byte)hex.r);
            gt.func_74774_a("type", (byte)((HexEntry)hexEntries.get((Object)hex.toString())).type);
            if (((HexEntry)hexEntries.get((Object)hex.toString())).aspect != null) {
                gt.func_74778_a("aspect", ((HexEntry)hexEntries.get((Object)hex.toString())).aspect.getTag());
            }
            gridtag.func_74742_a((NBTBase)gt);
        }
        stack.func_77978_p().func_74782_a("hexgrid", (NBTBase)gridtag);
        return stack;
    }

    public static ResearchNoteData getData(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        ResearchNoteData data = new ResearchNoteData();
        if (stack.func_77978_p() == null) {
            return null;
        }
        data.key = stack.func_77978_p().func_74779_i("key");
        data.color = stack.func_77978_p().func_74762_e("color");
        data.complete = stack.func_77978_p().func_74767_n("complete");
        data.copies = stack.func_77978_p().func_74762_e("copies");
        data.aspects.readFromNBT(stack.func_77978_p(), "aspects");
        NBTTagList grid = stack.func_77978_p().func_150295_c("hexgrid", 10);
        data.hexEntries = new HashMap();
        for (int x = 0; x < grid.func_74745_c(); ++x) {
            NBTTagCompound nbt = grid.func_150305_b(x);
            byte q = nbt.func_74771_c("hexq");
            byte r = nbt.func_74771_c("hexr");
            byte type = nbt.func_74771_c("type");
            String tag = nbt.func_74779_i("aspect");
            Aspect aspect = tag != null ? Aspect.getAspect(tag) : null;
            HexUtils.Hex hex = new HexUtils.Hex(q, r);
            data.hexEntries.put(hex.toString(), new HexEntry(aspect, type));
            data.hexes.put(hex.toString(), hex);
        }
        return data;
    }

    public static void updateData(ItemStack stack, ResearchNoteData data) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74778_a("key", data.key);
        stack.func_77978_p().func_74768_a("color", data.color);
        stack.func_77978_p().func_74757_a("complete", data.complete);
        stack.func_77978_p().func_74768_a("copies", data.copies);
        data.aspects.writeToNBT(stack.func_77978_p(), "aspects");
        NBTTagList gridtag = new NBTTagList();
        for (HexUtils.Hex hex : data.hexes.values()) {
            NBTTagCompound gt = new NBTTagCompound();
            gt.func_74774_a("hexq", (byte)hex.q);
            gt.func_74774_a("hexr", (byte)hex.r);
            gt.func_74774_a("type", (byte)data.hexEntries.get((Object)hex.toString()).type);
            if (data.hexEntries.get((Object)hex.toString()).aspect != null) {
                gt.func_74778_a("aspect", data.hexEntries.get((Object)hex.toString()).aspect.getTag());
            }
            gridtag.func_74742_a((NBTBase)gt);
        }
        stack.func_77978_p().func_74782_a("hexgrid", (NBTBase)gridtag);
    }

    public static boolean isResearchComplete(String playername, String key) {
        ArrayList<String> completed = ResearchManager.getResearchForPlayer(playername);
        if (completed != null && completed.size() > 0) {
            return completed.contains(key);
        }
        return false;
    }

    public static ArrayList<String> getResearchForPlayer(String playername) {
        ArrayList<String> out = Thaumcraft.proxy.getCompletedResearch().get(playername);
        try {
            if (!loadingBlocked && out == null && Thaumcraft.proxy.getClientWorld() == null && MinecraftServer.func_71276_C() != null) {
                Thaumcraft.proxy.getCompletedResearch().put(playername, new ArrayList());
                if (playername != null) {
                    IPlayerFileData playerNBTManagerObj = MinecraftServer.func_71276_C().func_71218_a(0).func_72860_G().func_75756_e();
                    SaveHandler sh = (SaveHandler)playerNBTManagerObj;
                    File dir = (File)ObfuscationReflectionHelper.getPrivateValue(SaveHandler.class, (Object)sh, (String[])new String[]{"playersDirectory", "field_75771_c", "c"});
                    File file1 = new File(dir, "_" + playername + ".thaum");
                    File file2 = new File(dir, "_" + playername + ".thaumbak");
                    ResearchManager.loadPlayerData(playername, file1, file2);
                }
                out = Thaumcraft.proxy.getCompletedResearch().get(playername);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (out == null) {
            out = new ArrayList();
        }
        return out;
    }

    public static ArrayList<String> getResearchForPlayerSafe(String playername) {
        return Thaumcraft.proxy.getCompletedResearch().get(playername);
    }

    public static HashMap<String, Byte> getResearchFlagsForPlayer(String playername) {
        if (!Thaumcraft.proxy.getCompletedResearchFlags().containsKey(playername)) {
            Thaumcraft.proxy.getCompletedResearchFlags().put(playername, new HashMap());
        }
        return Thaumcraft.proxy.getCompletedResearchFlags().get(playername);
    }

    public static boolean doesPlayerHaveRequisites(String playername, String key) {
        ResearchItem ri = ResearchCategories.getResearch(key);
        if (ri == null) {
            return true;
        }
        boolean out = true;
        String[] parents = ri.parents;
        ArrayList<String> completed = ResearchManager.getResearchForPlayer(playername);
        if (parents != null && parents.length > 0) {
            out = false;
            if (completed != null && completed.size() > 0) {
                out = true;
                for (String item : parents) {
                    if (completed.contains(item)) continue;
                    return false;
                }
            }
        }
        if ((parents = ri.parentsHidden) != null && parents.length > 0) {
            out = false;
            if (completed != null && completed.size() > 0) {
                out = true;
                for (String item : parents) {
                    if (completed.contains(item)) continue;
                    return false;
                }
            }
        }
        return out;
    }

    public static Aspect getCombinationResult(Aspect aspect1, Aspect aspect2) {
        Collection<Aspect> aspects = Aspect.aspects.values();
        for (Aspect aspect : aspects) {
            if (aspect.getComponents() == null || (aspect.getComponents()[0] != aspect1 || aspect.getComponents()[1] != aspect2) && (aspect.getComponents()[0] != aspect2 || aspect.getComponents()[1] != aspect1)) continue;
            return aspect;
        }
        return null;
    }

    public static void setResearchFlags(String username, String key, byte flags) {
        ResearchManager.getResearchFlagsForPlayer(username).put(key, flags);
    }

    public static boolean hasNewResearchFlag(String username, String key) {
        if (ResearchManager.getResearchFlagsForPlayer(username).containsKey(key)) {
            return Utils.getBit(ResearchManager.getResearchFlagsForPlayer(username).get(key).byteValue(), 1);
        }
        return false;
    }

    public static boolean hasNewPageFlag(String username, String key) {
        if (ResearchManager.getResearchFlagsForPlayer(username).containsKey(key)) {
            return Utils.getBit(ResearchManager.getResearchFlagsForPlayer(username).get(key).byteValue(), 2);
        }
        return false;
    }

    public static void setNewPageFlag(String username, String key) {
        if (!ResearchManager.getResearchFlagsForPlayer(username).containsKey(key)) {
            Thaumcraft.proxy.getCompletedResearchFlags().put(username, new HashMap());
        }
        if (ResearchManager.getResearchFlagsForPlayer(username).get(key) == null) {
            ResearchManager.getResearchFlagsForPlayer(username).put(key, (byte)0);
        }
        ResearchManager.getResearchFlagsForPlayer(username).put(key, (byte)Utils.setBit(ResearchManager.getResearchFlagsForPlayer(username).get(key).byteValue(), 2));
    }

    public static void clearNewPageFlag(String username, String key) {
        if (!ResearchManager.getResearchFlagsForPlayer(username).containsKey(key)) {
            Thaumcraft.proxy.getCompletedResearchFlags().put(username, new HashMap());
        }
        if (ResearchManager.getResearchFlagsForPlayer(username).get(key) == null) {
            ResearchManager.getResearchFlagsForPlayer(username).put(key, (byte)0);
        }
        ResearchManager.getResearchFlagsForPlayer(username).put(key, (byte)Utils.clearBit(ResearchManager.getResearchFlagsForPlayer(username).get(key).byteValue(), 2));
    }

    public static void setNewResearchFlag(String username, String key) {
        if (!ResearchManager.getResearchFlagsForPlayer(username).containsKey(key)) {
            Thaumcraft.proxy.getCompletedResearchFlags().put(username, new HashMap());
        }
        if (ResearchManager.getResearchFlagsForPlayer(username).get(key) == null) {
            ResearchManager.getResearchFlagsForPlayer(username).put(key, (byte)0);
        }
        ResearchManager.getResearchFlagsForPlayer(username).put(key, (byte)Utils.setBit(ResearchManager.getResearchFlagsForPlayer(username).get(key).byteValue(), 1));
    }

    public static void clearNewResearchFlag(String username, String key) {
        if (!ResearchManager.getResearchFlagsForPlayer(username).containsKey(key)) {
            Thaumcraft.proxy.getCompletedResearchFlags().put(username, new HashMap());
        }
        if (ResearchManager.getResearchFlagsForPlayer(username).get(key) == null) {
            ResearchManager.getResearchFlagsForPlayer(username).put(key, (byte)0);
        }
        ResearchManager.getResearchFlagsForPlayer(username).put(key, (byte)Utils.clearBit(ResearchManager.getResearchFlagsForPlayer(username).get(key).byteValue(), 1));
    }

    public static boolean completeResearchUnsaved(String username, String key, byte flags) {
        if (!ResearchManager.getResearchForPlayer(username).contains(key)) {
            if (Thaumcraft.proxy.getCompletedResearch().get(username) == null) {
                Thaumcraft.proxy.getCompletedResearch().put(username, new ArrayList());
            }
            Thaumcraft.proxy.getCompletedResearch().get(username).add(key);
            ResearchManager.setResearchFlags(username, key, flags);
            return true;
        }
        return false;
    }

    public void completeResearch(EntityPlayer player, String key, byte flags) {
        int warp;
        if (ResearchManager.completeResearchUnsaved(player.func_70005_c_(), key, flags) && (warp = ThaumcraftApi.getWarp(key)) > 0 && !Config.wuss && !player.field_70170_p.field_72995_K) {
            if (warp > 1) {
                int w2 = warp / 2;
                if (warp - w2 > 0) {
                    ResearchHelper.addWarpToPlayer(player, warp - w2, EnumWarpType.PERMANENT);
                }
                if (w2 > 0) {
                    ResearchHelper.addWarpToPlayer(player, w2, EnumWarpType.NORMAL);
                }
            } else {
                ResearchHelper.addWarpToPlayer(player, warp, EnumWarpType.PERMANENT);
            }
        }
    }

    public static void loadPlayerData(String player, File file1, File file2) {
        try {
            FileInputStream fileinputstream;
            NBTTagCompound data = null;
            if (file1 != null && file1.exists()) {
                try {
                    fileinputstream = new FileInputStream(file1);
                    data = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                    fileinputstream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (file1 == null || !file1.exists() || data == null || data.func_82582_d()) {
                Thaumcraft.log.warn("Thaumcraft data not found for " + player + ". Trying to load backup Thaumcraft data.");
                if (file2 != null && file2.exists()) {
                    try {
                        fileinputstream = new FileInputStream(file2);
                        data = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                        fileinputstream.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (data != null) {
                ResearchManager.loadResearchNBT(data, player);
                if (data.func_74764_b("Thaumcraft.eldritch")) {
                    int warp = data.func_74762_e("Thaumcraft.eldritch");
                    Thaumcraft.proxy.getPlayerKnowledge().setWarpPerm(player, warp);
                }
                if (data.func_74764_b("Thaumcraft.eldritch.temp")) {
                    Thaumcraft.proxy.getPlayerKnowledge().setWarpTemp(player, data.func_74762_e("Thaumcraft.eldritch.temp"));
                }
                if (data.func_74764_b("Thaumcraft.eldritch.sticky")) {
                    Thaumcraft.proxy.getPlayerKnowledge().setWarpSticky(player, data.func_74762_e("Thaumcraft.eldritch.sticky"));
                }
                if (data.func_74764_b("Thaumcraft.eldritch.counter")) {
                    Thaumcraft.proxy.getPlayerKnowledge().setWarpCounter(player, data.func_74762_e("Thaumcraft.eldritch.counter"));
                } else {
                    Thaumcraft.proxy.getPlayerKnowledge().setWarpCounter(player, 0);
                }
            }
        }
        catch (Exception exception1) {
            exception1.printStackTrace();
            Thaumcraft.log.fatal("Error loading Thaumcraft data");
        }
    }

    public static void loadResearchNBT(NBTTagCompound entityData, String player) {
        NBTTagList tagList = entityData.func_150295_c(RESEARCH_TAG, 10);
        for (int j = 0; j < tagList.func_74745_c(); ++j) {
            NBTTagCompound rs = tagList.func_150305_b(j);
            if (!rs.func_74764_b("key")) continue;
            ResearchManager.completeResearchUnsaved(player, rs.func_74779_i("key"), rs.func_74771_c("flags"));
        }
    }

    public static boolean savePlayerData(EntityPlayer player, File file1, File file2) {
        boolean success = true;
        try {
            NBTTagCompound data = new NBTTagCompound();
            ResearchManager.saveResearchNBT(data, player);
            data.func_74782_a("Thaumcraft.eldritch", (NBTBase)new NBTTagInt(Thaumcraft.proxy.getPlayerKnowledge().getWarpPerm(player.func_70005_c_())));
            data.func_74782_a("Thaumcraft.eldritch.temp", (NBTBase)new NBTTagInt(Thaumcraft.proxy.getPlayerKnowledge().getWarpTemp(player.func_70005_c_())));
            data.func_74782_a("Thaumcraft.eldritch.sticky", (NBTBase)new NBTTagInt(Thaumcraft.proxy.getPlayerKnowledge().getWarpSticky(player.func_70005_c_())));
            data.func_74782_a("Thaumcraft.eldritch.counter", (NBTBase)new NBTTagInt(Thaumcraft.proxy.getPlayerKnowledge().getWarpCounter(player.func_70005_c_())));
            if (file1 != null && file1.exists()) {
                try {
                    Files.copy((File)file1, (File)file2);
                }
                catch (Exception e) {
                    Thaumcraft.log.error("Could not backup old research file for player " + player.func_70005_c_());
                }
            }
            try {
                if (file1 != null) {
                    FileOutputStream fileoutputstream = new FileOutputStream(file1);
                    CompressedStreamTools.func_74799_a((NBTTagCompound)data, (OutputStream)fileoutputstream);
                    fileoutputstream.close();
                }
            }
            catch (Exception e) {
                Thaumcraft.log.error("Could not save research file for player " + player.func_70005_c_());
                if (file1.exists()) {
                    try {
                        file1.delete();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                success = false;
            }
        }
        catch (Exception exception1) {
            exception1.printStackTrace();
            Thaumcraft.log.fatal("Error saving Thaumcraft data");
            success = false;
        }
        return success;
    }

    public static void saveResearchNBT(NBTTagCompound entityData, EntityPlayer player) {
        NBTTagList tagList = new NBTTagList();
        ArrayList<String> res = ResearchManager.getResearchForPlayer(player.func_70005_c_());
        HashMap<String, Byte> flags = ResearchManager.getResearchFlagsForPlayer(player.func_70005_c_());
        if (res != null && res.size() > 0) {
            for (String key : res) {
                if (key == null) continue;
                NBTTagCompound f = new NBTTagCompound();
                f.func_74778_a("key", key);
                byte b = 0;
                if (flags.containsKey(key)) {
                    b = flags.get(key);
                }
                f.func_74774_a("flags", b);
                tagList.func_74742_a((NBTBase)f);
            }
        }
        entityData.func_74782_a(RESEARCH_TAG, (NBTBase)tagList);
    }

    public static class HexEntry {
        public Aspect aspect;
        public int type;

        public HexEntry(Aspect aspect, int type) {
            this.aspect = aspect;
            this.type = type;
        }
    }
}

