/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.world.dim;

import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.entities.monster.EntityEldritchGuardian;
import thaumcraft.common.entities.monster.cult.EntityCultistPortalLesser;
import thaumcraft.common.lib.utils.EntityUtils;
import thaumcraft.common.lib.world.dim.Cell;
import thaumcraft.common.lib.world.dim.GenCommon;

public class GenPassageRoom
extends GenCommon {
    static void generateRoom(World world, Random random, int cx, int cz, int y, Cell cell) {
        int x = cx * 16;
        int z = cz * 16;
        if (random.nextBoolean()) {
            GenCommon.generateChamberA(world, random, cx, cz, y, cell);
        } else {
            GenCommon.generateChamberB(world, random, cx, cz, y, cell);
        }
        GenCommon.generateConnections(world, random, cx, cz, y, cell, 3, true);
        int feature = random.nextInt(8);
        switch (feature) {
            default: {
                break;
            }
            case 0: {
                for (int qq = 0; qq < 16; ++qq) {
                    world.func_175656_a(new BlockPos(x + 8 + MathHelper.func_76136_a((Random)world.field_73012_v, (int)-3, (int)3), y + 2 + qq / 2, z + 8 + MathHelper.func_76136_a((Random)world.field_73012_v, (int)-3, (int)3)), BlocksTC.taintDust.func_176223_P().func_177226_a((IProperty)BlockFluidBase.LEVEL, (Comparable)Integer.valueOf(3)));
                }
                break;
            }
            case 1: {
                GenPassageRoom.generateMiniBossGuardians(world, random, x, y, z);
                break;
            }
            case 2: {
                GenPassageRoom.genObelisk(world, new BlockPos(x + 8, y + 4, z + 8));
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                int q = random.nextInt(4);
                for (int qq = -1; qq <= 1; ++qq) {
                    for (int ww = -1; ww <= 1; ++ww) {
                        decoCommon.remove(new BlockPos(x + 8 + qq, y + 1, z + 8 + ww));
                        crabSpawner.remove(new BlockPos(x + 8 + qq, y + 1, z + 8 + ww));
                        decoUrn.remove(new BlockPos(x + 8 + qq, y + 1, z + 8 + ww));
                        world.func_175656_a(new BlockPos(x + 8 + qq, y + 1, z + 8 + ww), q == 0 ? Blocks.field_150353_l.func_176223_P() : (q == 1 ? BlocksTC.liquidDeath.func_176223_P() : (q == 2 ? BlocksTC.purifyingFluid.func_176223_P() : Blocks.field_150355_j.func_176223_P())));
                    }
                }
                break;
            }
            case 6: {
                GenPassageRoom.generateMiniBossPortal(world, random, x, y, z);
            }
        }
    }

    private static void generateMiniBossPortal(World world, Random random, int x, int y, int z) {
        EntityCultistPortalLesser eg = new EntityCultistPortalLesser(world);
        eg.func_70107_b((double)x + 8.5, y + 2, (double)z + 8.5);
        eg.func_180482_a(world.func_175649_E(new BlockPos((Entity)eg)), null);
        world.func_72838_d((Entity)eg);
    }

    private static void generateMiniBossGuardians(World world, Random random, int x, int y, int z) {
        int zz = 1 + (world.func_175659_aa() == EnumDifficulty.HARD ? 2 : (world.func_175659_aa() == EnumDifficulty.NORMAL ? 1 : 0));
        if (random.nextFloat() < (float)zz / 10.0f) {
            GenPassageRoom.genObelisk(world, new BlockPos(x + 8, y + 4, z + 8));
        }
        world.func_175656_a(new BlockPos(x + 8, y + 2, z + 8), BlocksTC.lootUrn.func_176203_a(2));
        for (int qq = 0; qq < zz; ++qq) {
            EntityEldritchGuardian eg = new EntityEldritchGuardian(world);
            double i1 = (double)x + 8.5 + (double)(MathHelper.func_76136_a((Random)world.field_73012_v, (int)1, (int)3) * MathHelper.func_76136_a((Random)world.field_73012_v, (int)-1, (int)1));
            double j1 = y + 3;
            double k1 = (double)z + 8.5 + (double)(MathHelper.func_76136_a((Random)world.field_73012_v, (int)1, (int)3) * MathHelper.func_76136_a((Random)world.field_73012_v, (int)-1, (int)1));
            eg.func_70107_b(i1, j1, k1);
            eg.func_180482_a(world.func_175649_E(new BlockPos((Entity)eg)), null);
            eg.func_175449_a(new BlockPos(x + 8, y + 2, z + 8), 16);
            world.func_72838_d((Entity)eg);
            if (qq != 0) continue;
            EntityUtils.makeChampion(eg, true);
        }
    }
}

