/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles.crafting;

import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.blocks.TileThaumcraft;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.wands.IWandable;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.container.InventoryFake;
import thaumcraft.common.entities.EntitySpecialItem;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;

public class TileCrucible
extends TileThaumcraft
implements ITickable,
IFluidHandler,
IWandable,
IAspectContainer {
    public short heat = 0;
    public AspectList aspects = new AspectList();
    public final int maxTags = 100;
    int bellows = -1;
    private int delay = 0;
    public FluidTank tank = new FluidTank(FluidRegistry.WATER, 0, 1000);
    private long counter = -100L;
    int prevcolor = 0;
    int prevx = 0;
    int prevy = 0;

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.heat = nbttagcompound.func_74765_d("Heat");
        this.tank.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("Empty")) {
            this.tank.setFluid(null);
        }
        this.aspects.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74777_a("Heat", this.heat);
        this.tank.writeToNBT(nbttagcompound);
        this.aspects.writeToNBT(nbttagcompound);
    }

    public void func_73660_a() {
        ++this.counter;
        short prevheat = this.heat;
        if (!this.field_145850_b.field_72995_K) {
            if (this.tank.getFluidAmount() > 0) {
                Block block = this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b()).func_177230_c();
                if (block.func_149688_o() == Material.field_151587_i || block.func_149688_o() == Material.field_151581_o || block == BlocksTC.nitor) {
                    if (this.heat < 200) {
                        this.heat = (short)(this.heat + 1);
                        if (prevheat < 151 && this.heat >= 151) {
                            this.func_70296_d();
                            this.field_145850_b.func_175689_h(this.func_174877_v());
                        }
                    }
                } else if (this.heat > 0) {
                    this.heat = (short)(this.heat - 1);
                    if (this.heat == 149) {
                        this.func_70296_d();
                        this.field_145850_b.func_175689_h(this.func_174877_v());
                    }
                }
            } else if (this.heat > 0) {
                this.heat = (short)(this.heat - 1);
            }
            if (this.aspects.visSize() > 100) {
                this.spillRandom();
            }
            if (this.counter >= 100L && this.heat > 150) {
                this.spillRandom();
                this.counter = 0L;
            }
        } else if (this.tank.getFluidAmount() > 0) {
            this.drawEffects();
        }
        if (this.field_145850_b.field_72995_K && prevheat < 151 && this.heat >= 151) {
            this.heat = (short)(this.heat + 1);
        }
    }

    private void drawEffects() {
        if (this.heat > 150) {
            Thaumcraft.proxy.getFX().crucibleFroth((float)this.field_174879_c.func_177958_n() + 0.2f + this.field_145850_b.field_73012_v.nextFloat() * 0.6f, (float)this.field_174879_c.func_177956_o() + this.getFluidHeight(), (float)this.field_174879_c.func_177952_p() + 0.2f + this.field_145850_b.field_73012_v.nextFloat() * 0.6f);
            if (this.aspects.visSize() > 100) {
                for (int a = 0; a < 2; ++a) {
                    Thaumcraft.proxy.getFX().crucibleFrothDown(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, (float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat());
                    Thaumcraft.proxy.getFX().crucibleFrothDown(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o() + 1, (float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat());
                    Thaumcraft.proxy.getFX().crucibleFrothDown((float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p());
                    Thaumcraft.proxy.getFX().crucibleFrothDown((float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + 1);
                }
            }
        }
        if (this.field_145850_b.field_73012_v.nextInt(6) == 0 && this.aspects.size() > 0) {
            int color = this.aspects.getAspects()[this.field_145850_b.field_73012_v.nextInt(this.aspects.size())].getColor() + -16777216;
            int x = 5 + this.field_145850_b.field_73012_v.nextInt(22);
            int y = 5 + this.field_145850_b.field_73012_v.nextInt(22);
            this.delay = this.field_145850_b.field_73012_v.nextInt(10);
            this.prevcolor = color;
            this.prevx = x;
            this.prevy = y;
            Color c = new Color(color);
            float r = (float)c.getRed() / 255.0f;
            float g = (float)c.getGreen() / 255.0f;
            float b = (float)c.getBlue() / 255.0f;
            Thaumcraft.proxy.getFX().crucibleBubble((float)this.field_174879_c.func_177958_n() + (float)x / 32.0f + 0.015625f, (float)this.field_174879_c.func_177956_o() + 0.05f + this.getFluidHeight(), (float)this.field_174879_c.func_177952_p() + (float)y / 32.0f + 0.015625f, r, g, b);
        }
    }

    public void ejectItem(ItemStack items) {
        boolean stacks = true;
        boolean first = true;
        do {
            ItemStack spitout;
            if (spitout.field_77994_a > (spitout = items.func_77946_l()).func_77976_d()) {
                spitout.field_77994_a = spitout.func_77976_d();
            }
            items.field_77994_a -= spitout.field_77994_a;
            EntitySpecialItem entityitem = new EntitySpecialItem(this.field_145850_b, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.71f, (float)this.field_174879_c.func_177952_p() + 0.5f, spitout);
            entityitem.field_70181_x = 0.1f;
            entityitem.field_70159_w = first ? 0.0 : (double)((this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.01f);
            entityitem.field_70179_y = first ? 0.0 : (double)((this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.01f);
            this.field_145850_b.func_72838_d((Entity)entityitem);
            first = false;
        } while (items.field_77994_a > 0);
    }

    public ItemStack attemptSmelt(ItemStack item, String username) {
        boolean bubble = false;
        boolean event = false;
        int stacksize = item.field_77994_a;
        for (int a = 0; a < stacksize; ++a) {
            CrucibleRecipe rc = ThaumcraftCraftingManager.findMatchingCrucibleRecipe(username, this.aspects, item);
            if (rc != null && this.tank.getFluidAmount() > 0) {
                ItemStack out = rc.getRecipeOutput().func_77946_l();
                EntityPlayer p = this.field_145850_b.func_72924_a(username);
                if (p != null) {
                    FMLCommonHandler.instance().firePlayerCraftingEvent(p, out, (IInventory)new InventoryFake(new ItemStack[]{item}));
                }
                this.aspects = rc.removeMatching(this.aspects);
                this.tank.drain(50, true);
                this.ejectItem(out);
                event = true;
                --stacksize;
                this.counter = -250L;
                continue;
            }
            AspectList ot = ThaumcraftCraftingManager.getObjectTags(item);
            if (ot == null || ot.size() == 0) continue;
            for (Aspect tag : ot.getAspects()) {
                this.aspects.add(tag, ot.getAmount(tag));
            }
            bubble = true;
            --stacksize;
            this.counter = -150L;
        }
        if (bubble) {
            this.field_145850_b.func_72908_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, "thaumcraft:bubble", 0.2f, 1.0f + this.field_145850_b.field_73012_v.nextFloat() * 0.4f);
            this.field_145850_b.func_175689_h(this.field_174879_c);
            this.field_145850_b.func_175641_c(this.field_174879_c, BlocksTC.crucible, 2, 1);
        }
        if (event) {
            this.field_145850_b.func_175689_h(this.field_174879_c);
            this.field_145850_b.func_175641_c(this.field_174879_c, BlocksTC.crucible, 2, 5);
        }
        this.func_70296_d();
        if (stacksize <= 0) {
            return null;
        }
        item.field_77994_a = stacksize;
        return item;
    }

    public void attemptSmelt(EntityItem entity) {
        NBTTagCompound itemData;
        String username;
        ItemStack item = entity.func_92059_d();
        ItemStack res = this.attemptSmelt(item, username = (itemData = entity.getEntityData()).func_74779_i("thrower"));
        if (res == null || res.field_77994_a <= 0) {
            entity.func_70106_y();
        } else {
            item.field_77994_a = res.field_77994_a;
            entity.func_92058_a(item);
        }
    }

    public float getFluidHeight() {
        float base = 0.3f + 0.5f * ((float)this.tank.getFluidAmount() / (float)this.tank.getCapacity());
        float out = base + (float)this.aspects.visSize() / 100.0f * (1.0f - base);
        if (out > 1.0f) {
            out = 1.001f;
        }
        if (out == 1.0f) {
            out = 0.9999f;
        }
        return out;
    }

    public void spillRandom() {
        if (this.aspects.size() > 0) {
            Aspect tag = this.aspects.getAspects()[this.field_145850_b.field_73012_v.nextInt(this.aspects.getAspects().length)];
            this.aspects.remove(tag, 1);
            AuraHelper.pollute(this.field_145850_b, this.func_174877_v(), 1, true);
        }
        this.func_70296_d();
        this.field_145850_b.func_175689_h(this.func_174877_v());
    }

    public void spillRemnants() {
        if (this.tank.getFluidAmount() > 0 || this.aspects.visSize() > 0) {
            this.tank.setFluid(null);
            if (this.aspects.visSize() > 0) {
                AuraHelper.pollute(this.field_145850_b, this.func_174877_v(), this.aspects.visSize(), true);
            }
            this.aspects = new AspectList();
            this.field_145850_b.func_175641_c(this.field_174879_c, BlocksTC.crucible, 2, 5);
            this.func_70296_d();
            this.field_145850_b.func_175689_h(this.func_174877_v());
        }
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 1) {
            if (this.field_145850_b.field_72995_K) {
                Thaumcraft.proxy.getFX().drawBlockSparkle(this.field_174879_c, -9999, 5);
            }
            return true;
        }
        if (i == 2) {
            this.field_145850_b.func_72980_b((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), "thaumcraft:spill", 0.2f, 1.0f, false);
            if (this.field_145850_b.field_72995_K) {
                for (int q = 0; q < 10; ++q) {
                    int x = 5 + this.field_145850_b.field_73012_v.nextInt(22);
                    int y = 5 + this.field_145850_b.field_73012_v.nextInt(22);
                    Thaumcraft.proxy.getFX().crucibleBoil(this.field_174879_c, this, j);
                }
            }
            return true;
        }
        return super.func_145842_c(i, j);
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (resource != null && !FluidRegistry.getFluidName((FluidStack)resource).equals(FluidRegistry.getFluidName((Fluid)FluidRegistry.WATER))) {
            return 0;
        }
        if (doFill) {
            this.func_70296_d();
            this.field_145850_b.func_175689_h(this.func_174877_v());
        }
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        if (doDrain) {
            this.func_70296_d();
            this.field_145850_b.func_175689_h(this.func_174877_v());
        }
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return fluid != null && fluid.getID() == FluidRegistry.WATER.getID();
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public boolean onWandRightClick(World world, ItemStack wandstack, EntityPlayer player, BlockPos pos, EnumFacing side) {
        if (!world.field_72995_K && player.func_70093_af()) {
            this.spillRemnants();
            return true;
        }
        return false;
    }

    @Override
    public void onUsingWandTick(ItemStack wandstack, EntityPlayer player, int count) {
    }

    @Override
    public void onWandStoppedUsing(ItemStack wandstack, World world, EntityPlayer player, int count) {
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_178781_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1));
    }

    @Override
    public AspectList getAspects() {
        return this.aspects;
    }

    @Override
    public void setAspects(AspectList aspects) {
    }

    @Override
    public int addToContainer(Aspect tag, int amount) {
        return 0;
    }

    @Override
    public boolean takeFromContainer(Aspect tag, int amount) {
        return false;
    }

    @Override
    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    @Override
    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return false;
    }

    @Override
    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    @Override
    public int containerContains(Aspect tag) {
        return 0;
    }

    @Override
    public boolean doesContainerAccept(Aspect tag) {
        return true;
    }
}

