/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles.crafting;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.IChatComponent;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.blocks.TileThaumcraft;
import thaumcraft.api.items.IScribeTools;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.config.Config;
import thaumcraft.common.items.resources.ItemResearchNotes;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.lib.research.ResearchNoteData;
import thaumcraft.common.lib.utils.HexUtils;

public class TileResearchTable
extends TileThaumcraft
implements IInventory {
    public ItemStack[] contents = new ItemStack[2];
    EntityPlayer researcher = null;
    public ResearchNoteData data = null;

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        NBTTagList var2 = nbttagcompound.func_150295_c("Inventory", 10);
        this.contents = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < Math.min(2, var2.func_74745_c()); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 < 0 || var5 >= this.contents.length) continue;
            this.contents[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.contents.length; ++var3) {
            if (this.contents[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.contents[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        nbttagcompound.func_74782_a("Inventory", (NBTBase)var2);
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.gatherResults();
    }

    public void gatherResults() {
        this.data = null;
        if (this.contents[1] != null && this.contents[1].func_77973_b() instanceof ItemResearchNotes) {
            this.data = ResearchManager.getData(this.contents[1]);
        }
    }

    public void placeAspect(int q, int r, Aspect aspect, EntityPlayer player) {
        if (this.data == null) {
            this.gatherResults();
        }
        if (!ResearchManager.consumeInkFromTable(this.contents[0], false)) {
            return;
        }
        if (this.contents[1] != null && this.contents[1].func_77973_b() instanceof ItemResearchNotes && this.data != null && this.contents[1].func_77952_i() == 0) {
            boolean r1 = ResearchManager.isResearchComplete(player.func_70005_c_(), "RESEARCHER1");
            boolean r2 = ResearchManager.isResearchComplete(player.func_70005_c_(), "RESEARCHER2");
            HexUtils.Hex hex = new HexUtils.Hex(q, r);
            ResearchManager.HexEntry he = null;
            if (aspect != null) {
                he = new ResearchManager.HexEntry(aspect, 2);
                if (r2 && this.field_145850_b.field_73012_v.nextFloat() < 0.1f) {
                    this.field_145850_b.func_72956_a((Entity)player, "random.orb", 0.2f, 0.9f + player.field_70170_p.field_73012_v.nextFloat() * 0.2f);
                } else {
                    this.data.aspects.remove(aspect, 1);
                }
            } else {
                float f = this.field_145850_b.field_73012_v.nextFloat();
                if (this.data.hexEntries.get((Object)hex.toString()).aspect != null && (r1 && f < 0.25f || r2 && f < 0.5f)) {
                    this.field_145850_b.func_72956_a((Entity)player, "random.orb", 0.2f, 0.9f + player.field_70170_p.field_73012_v.nextFloat() * 0.2f);
                    this.data.aspects.add(this.data.hexEntries.get((Object)hex.toString()).aspect, 1);
                }
                he = new ResearchManager.HexEntry(null, 0);
            }
            this.data.hexEntries.put(hex.toString(), he);
            this.data.hexes.put(hex.toString(), hex);
            this.updateNoteAndConsumeInk();
            if (!this.field_145850_b.field_72995_K && ResearchManager.checkResearchCompletion(this.contents[1], this.data, player.func_70005_c_())) {
                this.contents[1].func_77964_b(1);
                if (Config.researchAmount > 0) {
                    this.contents[1].field_77994_a = Config.researchAmount;
                }
                this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 1, 1);
            }
        }
    }

    public void updateNoteAndConsumeInk() {
        ResearchManager.updateData(this.contents[1], this.data);
        ResearchManager.consumeInkFromTable(this.contents[0], true);
        this.field_145850_b.func_175689_h(this.func_174877_v());
        this.func_70296_d();
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int var1) {
        return this.contents[var1];
    }

    public ItemStack func_70298_a(int var1, int var2) {
        if (this.contents[var1] != null) {
            if (this.contents[var1].field_77994_a <= var2) {
                ItemStack var3 = this.contents[var1];
                this.contents[var1] = null;
                this.func_70296_d();
                return var3;
            }
            ItemStack var3 = this.contents[var1].func_77979_a(var2);
            if (this.contents[var1].field_77994_a == 0) {
                this.contents[var1] = null;
            }
            this.func_70296_d();
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int var1) {
        if (this.contents[var1] != null) {
            ItemStack var2 = this.contents[var1];
            this.contents[var1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.contents[var1] = var2;
        if (var2 != null && var2.field_77994_a > this.func_70297_j_()) {
            var2.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return "Research Table";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) != this ? false : var1.func_174831_c(this.func_174877_v()) <= 64.0;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        switch (i) {
            case 0: {
                if (!(itemstack.func_77973_b() instanceof IScribeTools)) break;
                return true;
            }
            case 1: {
                if (itemstack.func_77973_b() != ItemsTC.researchNotes || itemstack.func_77952_i() != 0) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175689_h(this.func_174877_v());
        }
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 1) {
            if (this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_72980_b((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), "thaumcraft:learn", 1.0f, 1.0f, false);
            }
            return true;
        }
        return super.func_145842_c(i, j);
    }

    public IChatComponent func_145748_c_() {
        return null;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

