/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles.devices;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ITickable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.blocks.TileThaumcraft;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.IWandable;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.BlockTCDevice;
import thaumcraft.common.items.tools.ItemElementalPickaxe;
import thaumcraft.common.items.wands.foci.ItemFocusExcavation;
import thaumcraft.common.lib.events.PlayerEvents;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.misc.PacketBoreDig;
import thaumcraft.common.lib.utils.BlockStateUtils;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.utils.InventoryUtils;
import thaumcraft.common.lib.utils.TCVec3;
import thaumcraft.common.lib.utils.Utils;
import thaumcraft.common.tiles.devices.TileArcaneBoreBase;
import thaumcraft.common.tiles.devices.TileLampArcane;

public class TileArcaneBore
extends TileThaumcraft
implements IInventory,
IWandable,
ITickable {
    public int spiral = 0;
    public float currentRadius = 0.0f;
    public int maxRadius = 2;
    public float vRadX = 0.0f;
    public float vRadZ = 0.0f;
    public float tRadX = 0.0f;
    public float tRadZ = 0.0f;
    public float mRadX = 0.0f;
    public float mRadZ = 0.0f;
    private int count = 0;
    public int topRotation = 0;
    long soundDelay = 0L;
    Object beam1 = null;
    Object beam2 = null;
    int beamlength = 0;
    TileArcaneBoreBase base = null;
    public ItemStack[] contents = new ItemStack[2];
    public int rotX = 0;
    public int rotZ = 0;
    public int tarX = 0;
    public int tarZ = 0;
    public int speedX = 0;
    public int speedZ = 0;
    public boolean hasFocus = false;
    public boolean hasPickaxe = false;
    int lastX = 0;
    int lastZ = 0;
    int lastY = 0;
    boolean toDig = false;
    int digX = 0;
    int digZ = 0;
    int digY = 0;
    Block digBlock = Blocks.field_150350_a;
    int digMd = 0;
    float radInc = 0.0f;
    int paused = 100;
    int maxPause = 100;
    long repairCounter = 0L;
    public boolean refresh = true;
    int powered = 0;
    public EnumFacing baseOrientation = EnumFacing.WEST;
    FakePlayer fakePlayer = null;
    public int fortune = 0;
    public int speed = 0;
    public int area = 0;
    int stick = 0;
    private float speedyTime;
    private final int itemsPerVis = 20;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.speedyTime < 20.0f && this.base != null && this.base.drawEssentia()) {
                this.getClass();
                this.speedyTime += 20.0f;
                this.powered += 20;
            }
            if (this.speedyTime < 1.0f && this.powered < 5) {
                this.powered += AuraHelper.drainAuraAvailable(this.func_145831_w(), this.func_174877_v(), Aspect.ENTROPY, 5);
            }
        }
        if (!this.field_145850_b.field_72995_K && this.fakePlayer == null) {
            this.fakePlayer = FakePlayerFactory.get((WorldServer)((WorldServer)this.field_145850_b), (GameProfile)new GameProfile((UUID)null, "FakeThaumcraftBore"));
        }
        if (this.baseOrientation.func_176736_b() >= 0 || this.refresh) {
            this.baseOrientation = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177230_c() == BlocksTC.arcaneBoreBase ? EnumFacing.UP : EnumFacing.DOWN;
            this.base = null;
        }
        if (this.field_145850_b.field_72995_K && this.refresh) {
            this.setOrientation(BlockStateUtils.getFacing(this.func_145832_p()), true);
            this.refresh = false;
        }
        if (this.rotX < this.tarX) {
            this.rotX += this.speedX;
            this.speedX = this.rotX < this.tarX ? ++this.speedX : (int)((float)this.speedX / 3.0f);
        } else if (this.rotX > this.tarX) {
            this.rotX += this.speedX;
            this.speedX = this.rotX > this.tarX ? --this.speedX : (int)((float)this.speedX / 3.0f);
        } else {
            this.speedX = 0;
        }
        if (this.rotZ < this.tarZ) {
            this.rotZ += this.speedZ;
            this.speedZ = this.rotZ < this.tarZ ? ++this.speedZ : (int)((float)this.speedZ / 3.0f);
        } else if (this.rotZ > this.tarZ) {
            this.rotZ += this.speedZ;
            this.speedZ = this.rotZ > this.tarZ ? --this.speedZ : (int)((float)this.speedZ / 3.0f);
        } else {
            this.speedZ = 0;
        }
        if (this.gettingPower() && this.areItemsValid()) {
            this.dig();
        } else if (this.field_145850_b.field_72995_K) {
            if (this.topRotation % 90 != 0) {
                this.topRotation += Math.min(10, 90 - this.topRotation % 90);
            }
            this.vRadX *= 0.9f;
            this.vRadZ *= 0.9f;
        }
        if (!this.field_145850_b.field_72995_K && this.hasPickaxe && this.func_70301_a(1) != null) {
            if (this.repairCounter++ % 40L == 0L && this.func_70301_a(1).func_77951_h()) {
                PlayerEvents.doRepair(this.func_70301_a(1), (EntityPlayer)this.fakePlayer);
            }
            this.fakePlayer.field_70173_aa = (int)this.repairCounter;
            try {
                this.func_70301_a(1).func_77945_a(this.field_145850_b, (Entity)this.fakePlayer, 0, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean areItemsValid() {
        boolean notNearBroken = true;
        if (this.hasPickaxe && this.func_70301_a(1).func_77952_i() + 1 >= this.func_70301_a(1).func_77958_k()) {
            notNearBroken = false;
        }
        return this.hasFocus && this.hasPickaxe && this.func_70301_a(1).func_77984_f() && notNearBroken;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.fortune = 0;
        this.area = 0;
        this.speed = 0;
        if (this.func_70301_a(0) != null && this.func_70301_a(0).func_77973_b() instanceof ItemFocusExcavation) {
            this.fortune = ((ItemFocusExcavation)this.func_70301_a(0).func_77973_b()).getUpgradeLevel(this.func_70301_a(0), FocusUpgradeType.treasure);
            this.area = ((ItemFocusExcavation)this.func_70301_a(0).func_77973_b()).getUpgradeLevel(this.func_70301_a(0), FocusUpgradeType.enlarge);
            this.speed += ((ItemFocusExcavation)this.func_70301_a(0).func_77973_b()).getUpgradeLevel(this.func_70301_a(0), FocusUpgradeType.potency);
            this.hasFocus = true;
        } else {
            this.hasFocus = false;
        }
        if (this.func_70301_a(1) != null && this.func_70301_a(1).func_77973_b() instanceof ItemPickaxe) {
            this.hasPickaxe = true;
            int f = EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)this.func_70301_a(1));
            if (f > this.fortune) {
                this.fortune = f;
            }
            this.speed += EnchantmentHelper.func_77506_a((int)Enchantment.field_77349_p.field_77352_x, (ItemStack)this.func_70301_a(1));
        } else {
            this.hasPickaxe = false;
        }
    }

    private void dig() {
        if (this.rotX != this.tarX || this.rotZ != this.tarZ) {
            if (this.field_145850_b.field_72995_K) {
                if (this.topRotation % 90 != 0) {
                    this.topRotation += Math.min(10, 90 - this.topRotation % 90);
                }
                this.vRadX *= 0.9f;
                this.vRadZ *= 0.9f;
            }
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            boolean dug = false;
            if (this.base == null) {
                this.base = (TileArcaneBoreBase)this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.baseOrientation));
            }
            if (--this.count > 0 || this.powered < 1) {
                return;
            }
            if (this.toDig) {
                this.toDig = false;
                BlockPos digPos = new BlockPos(this.digX, this.digY, this.digZ);
                IBlockState digBs = this.field_145850_b.func_180495_p(digPos);
                if (!digBs.func_177230_c().isAir((IBlockAccess)this.field_145850_b, digPos)) {
                    int tfortune = this.fortune;
                    boolean silktouch = false;
                    if (this.func_70301_a(1) != null && EnchantmentHelper.func_77506_a((int)Enchantment.field_77348_q.field_77352_x, (ItemStack)this.func_70301_a(1)) > 0 && digBs.func_177230_c().canSilkHarvest(this.field_145850_b, digPos, digBs, null)) {
                        silktouch = true;
                        tfortune = 0;
                    }
                    if (!silktouch && this.func_70301_a(0) != null && ((ItemFocusExcavation)this.func_70301_a(0).func_77973_b()).isUpgradedWith(this.func_70301_a(0), FocusUpgradeType.silktouch) && digBs.func_177230_c().canSilkHarvest(this.field_145850_b, digPos, digBs, null)) {
                        silktouch = true;
                        tfortune = 0;
                    }
                    this.field_145850_b.func_175641_c(this.field_174879_c, BlocksTC.arcaneBore, 99, Block.func_149682_b((Block)digBs.func_177230_c()) + (digBs.func_177230_c().func_176201_c(digBs) << 12));
                    List<ItemStack> items = new ArrayList<ItemStack>();
                    if (silktouch) {
                        ItemStack dropped = BlockUtils.createStackedBlock(digBs);
                        if (dropped != null) {
                            items.add(dropped);
                        }
                    } else {
                        items = digBs.func_177230_c().getDrops((IBlockAccess)this.field_145850_b, digPos, digBs, tfortune);
                    }
                    List targets = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_178781_a((double)this.digX, (double)this.digY, (double)this.digZ, (double)(this.digX + 1), (double)(this.digY + 1), (double)(this.digZ + 1)).func_72314_b(1.0, 1.0, 1.0));
                    if (targets.size() > 0) {
                        for (EntityItem e : targets) {
                            items.add(e.func_92059_d().func_77946_l());
                            e.func_70106_y();
                        }
                    }
                    if (items.size() > 0) {
                        for (ItemStack is : items) {
                            ItemStack dropped = is.func_77946_l();
                            if (!silktouch && (this.func_70301_a(1) != null && this.func_70301_a(1).func_77973_b() instanceof ItemElementalPickaxe || this.func_70301_a(0) != null && this.func_70301_a(0).func_77973_b() instanceof ItemFocusBasic && ((ItemFocusBasic)this.func_70301_a(0).func_77973_b()).isUpgradedWith(this.func_70301_a(0), ItemFocusExcavation.dowsing))) {
                                dropped = Utils.findSpecialMiningResult(is, 0.2f + (float)tfortune * 0.075f, this.field_145850_b.field_73012_v);
                            }
                            if (this.base == null || !(this.base instanceof TileArcaneBoreBase)) continue;
                            TileEntity inventory = this.field_145850_b.func_175625_s(this.base.func_174877_v().func_177972_a(BlockStateUtils.getFacing(this.base.func_145832_p())));
                            if (inventory != null && inventory instanceof IInventory) {
                                dropped = InventoryUtils.placeItemStackIntoInventory(dropped, (IInventory)inventory, BlockStateUtils.getFacing(this.base.func_145832_p()).func_176734_d(), true);
                            }
                            if (dropped == null) continue;
                            EntityItem ei = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5 + (double)BlockStateUtils.getFacing(this.base.func_145832_p()).func_82601_c() * 0.66, (double)this.field_174879_c.func_177956_o() + 0.4 + (double)this.baseOrientation.func_96559_d(), (double)this.field_174879_c.func_177952_p() + 0.5 + (double)BlockStateUtils.getFacing(this.base.func_145832_p()).func_82599_e() * 0.66, dropped.func_77946_l());
                            ei.field_70159_w = 0.075f * (float)BlockStateUtils.getFacing(this.base.func_145832_p()).func_82601_c();
                            ei.field_70181_x = 0.025f;
                            ei.field_70179_y = 0.075f * (float)BlockStateUtils.getFacing(this.base.func_145832_p()).func_82599_e();
                            this.field_145850_b.func_72838_d((Entity)ei);
                        }
                    }
                }
                this.func_70299_a(1, InventoryUtils.damageItem(1, this.func_70301_a(1), this.field_145850_b));
                if (this.func_70301_a((int)1).field_77994_a <= 0) {
                    this.func_70299_a(1, null);
                }
                this.field_145850_b.func_175698_g(digPos);
                if (this.base != null) {
                    for (EnumFacing lbd : EnumFacing.field_176754_o) {
                        BlockPos bp;
                        TileEntity lbte = this.field_145850_b.func_175625_s(this.base.func_174877_v().func_177972_a(lbd));
                        if (lbte == null || !(lbte instanceof TileLampArcane)) continue;
                        int d = this.field_145850_b.field_73012_v.nextInt(32) * 2;
                        int xx = this.field_174879_c.func_177958_n() + BlockStateUtils.getFacing(this.func_145832_p()).func_82601_c() + BlockStateUtils.getFacing(this.func_145832_p()).func_82601_c() * d;
                        int yy = this.field_174879_c.func_177956_o() + BlockStateUtils.getFacing(this.func_145832_p()).func_96559_d() + BlockStateUtils.getFacing(this.func_145832_p()).func_96559_d() * d;
                        int zz = this.field_174879_c.func_177952_p() + BlockStateUtils.getFacing(this.func_145832_p()).func_82599_e() + BlockStateUtils.getFacing(this.func_145832_p()).func_82599_e() * d;
                        int p = d / 2 % 4;
                        if (BlockStateUtils.getFacing(this.func_145832_p()).func_82601_c() != 0) {
                            zz += p == 0 ? 3 : (p == 1 || p == 3 ? 0 : -3);
                        } else {
                            xx += p == 0 ? 3 : (p == 1 || p == 3 ? 0 : -3);
                        }
                        if (p == 3 && BlockStateUtils.getFacing(this.func_145832_p()).func_96559_d() == 0) {
                            yy -= 2;
                        }
                        if (!this.field_145850_b.func_175623_d(bp = new BlockPos(xx, yy, zz)) || this.field_145850_b.func_180495_p(bp) == BlocksTC.effect.func_176203_a(2) || this.field_145850_b.func_175642_b(EnumSkyBlock.BLOCK, bp) >= 11) break;
                        this.field_145850_b.func_180501_a(bp, BlocksTC.effect.func_176203_a(2), 3);
                        break;
                    }
                }
                dug = true;
            }
            this.findNextBlockToDig();
            if (dug) {
                if (this.speedyTime > 0.0f) {
                    this.speedyTime -= 1.0f;
                }
                if (this.powered > 0) {
                    --this.powered;
                }
            }
        } else {
            ++this.paused;
            if (this.field_145850_b.func_175623_d(this.field_174879_c)) {
                this.func_145843_s();
            }
            if (this.paused < this.maxPause && this.soundDelay < System.currentTimeMillis()) {
                this.soundDelay = System.currentTimeMillis() + 1200L + (long)this.field_145850_b.field_73012_v.nextInt(100);
                this.field_145850_b.func_72980_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, "thaumcraft:rumble", 0.25f, 0.9f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f, false);
            }
            if (this.beamlength > 0 && this.paused > this.maxPause) {
                --this.beamlength;
            }
            BlockPos digPos = new BlockPos(this.digX, this.digY, this.digZ);
            if (this.toDig) {
                this.paused = 0;
                this.beamlength = 64;
                IBlockState digBs = this.field_145850_b.func_180495_p(digPos);
                this.maxPause = digBs.func_177230_c() != null ? 10 + Math.max(10 - this.speed, (int)(digBs.func_177230_c().func_176195_g(this.field_145850_b, digPos) * 2.0f) - this.speed * 2) : 20;
                if (this.speedyTime <= 0.0f) {
                    this.maxPause *= 4;
                }
                this.toDig = false;
                double xd = (double)this.field_174879_c.func_177958_n() + 0.5 - ((double)this.digX + 0.5);
                double yd = (double)this.field_174879_c.func_177956_o() + 0.5 - ((double)this.digY + 0.5);
                double zd = (double)this.field_174879_c.func_177952_p() + 0.5 - ((double)this.digZ + 0.5);
                double var12 = MathHelper.func_76133_a((double)(xd * xd + zd * zd));
                float rx = (float)(Math.atan2(zd, xd) * 180.0 / Math.PI);
                float rz = (float)(-(Math.atan2(yd, var12) * 180.0 / Math.PI)) + 90.0f;
                this.tRadX = MathHelper.func_76142_g((float)this.rotX) + rx;
                if (BlockStateUtils.getFacing(this.func_145832_p()).ordinal() == 5) {
                    if (this.tRadX > 180.0f) {
                        this.tRadX -= 360.0f;
                    }
                    if (this.tRadX < -180.0f) {
                        this.tRadX += 360.0f;
                    }
                }
                this.tRadZ = rz - (float)this.rotZ;
                if (BlockStateUtils.getFacing(this.func_145832_p()).ordinal() <= 1) {
                    this.tRadZ += 180.0f;
                    if (this.vRadX - this.tRadX >= 180.0f) {
                        this.vRadX -= 360.0f;
                    }
                    if (this.vRadX - this.tRadX <= -180.0f) {
                        this.vRadX += 360.0f;
                    }
                }
                this.mRadX = Math.abs((this.vRadX - this.tRadX) / 6.0f);
                this.mRadZ = Math.abs((this.vRadZ - this.tRadZ) / 6.0f);
                if (this.speedyTime > 0.0f) {
                    this.speedyTime -= 1.0f;
                }
                if (this.powered > 0) {
                    --this.powered;
                }
            }
            if (this.paused < this.maxPause) {
                if (this.vRadX < this.tRadX) {
                    this.vRadX += this.mRadX;
                } else if (this.vRadX > this.tRadX) {
                    this.vRadX -= this.mRadX;
                }
                if (this.vRadZ < this.tRadZ) {
                    this.vRadZ += this.mRadZ;
                } else if (this.vRadZ > this.tRadZ) {
                    this.vRadZ -= this.mRadZ;
                }
            } else {
                this.vRadX *= 0.9f;
                this.vRadZ *= 0.9f;
            }
            this.mRadX *= 0.9f;
            this.mRadZ *= 0.9f;
            float vx = (float)(this.rotX + 90) - this.vRadX;
            float vz = (float)(this.rotZ + 90) - this.vRadZ;
            float var3 = 1.0f;
            float dX = MathHelper.func_76126_a((float)(vx / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(vz / 180.0f * (float)Math.PI)) * var3;
            float dZ = MathHelper.func_76134_b((float)(vx / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(vz / 180.0f * (float)Math.PI)) * var3;
            float dY = MathHelper.func_76126_a((float)(vz / 180.0f * (float)Math.PI)) * var3;
            Vec3 var13 = new Vec3((double)this.field_174879_c.func_177958_n() + 0.5 + (double)dX, (double)this.func_174877_v().func_177956_o() + 0.5 + (double)dY, (double)this.func_174877_v().func_177952_p() + 0.5 + (double)dZ);
            Vec3 var14 = new Vec3((double)this.field_174879_c.func_177958_n() + 0.5 + (double)(dX * (float)this.beamlength), (double)this.func_174877_v().func_177956_o() + 0.5 + (double)(dY * (float)this.beamlength), (double)this.func_174877_v().func_177952_p() + 0.5 + (double)(dZ * (float)this.beamlength));
            MovingObjectPosition mop = this.field_145850_b.func_147447_a(var13, var14, false, true, false);
            int impact = 0;
            float length = 64.0f;
            double bx = var14.field_72450_a;
            double by = var14.field_72448_b;
            double bz = var14.field_72449_c;
            if (mop != null) {
                double xd = (double)this.func_174877_v().func_177958_n() + 0.5 + (double)dX - mop.field_72307_f.field_72450_a;
                double yd = (double)this.func_174877_v().func_177956_o() + 0.5 + (double)dY - mop.field_72307_f.field_72448_b;
                double zd = (double)this.func_174877_v().func_177952_p() + 0.5 + (double)dZ - mop.field_72307_f.field_72449_c;
                bx = mop.field_72307_f.field_72450_a;
                by = mop.field_72307_f.field_72448_b;
                bz = mop.field_72307_f.field_72449_c;
                length = MathHelper.func_76133_a((double)(xd * xd + yd * yd + zd * zd)) + 0.5f;
                impact = 5;
                int x = MathHelper.func_76128_c((double)bx);
                int y = MathHelper.func_76128_c((double)by);
                int z = MathHelper.func_76128_c((double)bz);
                BlockPos tp = new BlockPos(x, y, z);
                IBlockState ts = this.field_145850_b.func_180495_p(tp);
                if (!this.field_145850_b.func_175623_d(tp)) {
                    Thaumcraft.proxy.getFX().boreDigFx(x, y, z, this.func_174877_v().func_177958_n() + BlockStateUtils.getFacing(this.func_145832_p()).func_82601_c(), this.func_174877_v().func_177956_o() + BlockStateUtils.getFacing(this.func_145832_p()).func_96559_d(), this.func_174877_v().func_177952_p() + BlockStateUtils.getFacing(this.func_145832_p()).func_82599_e(), ts.func_177230_c(), ts.func_177230_c().func_176201_c(ts) >> 12 & 0xFF);
                }
            }
            this.topRotation += this.beamlength / 6;
            this.beam1 = Thaumcraft.proxy.getFX().beamBore((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, bx, by, bz, 1, 65382, true, impact > 0 ? 2.0f : 0.0f, this.beam1, impact);
            this.beam2 = Thaumcraft.proxy.getFX().beamBore((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, bx, by, bz, 2, 0xFF8855, false, impact > 0 ? 2.0f : 0.0f, this.beam2, impact);
            if (this.field_145850_b.func_175623_d(digPos) && this.digBlock != Blocks.field_150350_a) {
                this.field_145850_b.func_72980_b((double)((float)this.digX + 0.5f), (double)((float)this.digY + 0.5f), (double)((float)this.digZ + 0.5f), this.digBlock.field_149762_H.func_150495_a(), (this.digBlock.field_149762_H.func_150497_c() + 1.0f) / 2.0f, this.digBlock.field_149762_H.func_150494_d() * 0.8f, false);
                for (int a = 0; a < Thaumcraft.proxy.getFX().particleCount(10); ++a) {
                    Thaumcraft.proxy.getFX().boreDigFx(this.digX, this.digY, this.digZ, this.func_174877_v().func_177958_n() + BlockStateUtils.getFacing(this.func_145832_p()).func_82601_c(), this.func_174877_v().func_177956_o() + BlockStateUtils.getFacing(this.func_145832_p()).func_96559_d(), this.func_174877_v().func_177952_p() + BlockStateUtils.getFacing(this.func_145832_p()).func_82599_e(), this.digBlock, this.digMd >> 12 & 0xFF);
                }
                this.digBlock = Blocks.field_150350_a;
            }
        }
    }

    private void findNextBlockToDig() {
        if (this.radInc == 0.0f) {
            this.radInc = 1.0f;
        }
        int x = this.lastX;
        int z = this.lastZ;
        int y = this.lastY;
        if (this.stick == 0) {
            while (x == this.lastX && z == this.lastZ && y == this.lastY) {
                this.spiral = (int)((float)this.spiral + (5.0f + (10.0f - Math.abs(this.currentRadius)) * 2.0f));
                if (this.spiral >= 360) {
                    this.spiral -= 360;
                    this.currentRadius += this.radInc;
                    if (this.currentRadius >= (float)(this.maxRadius + this.area) || this.currentRadius <= (float)(-(this.maxRadius + this.area))) {
                        this.radInc *= -1.0f;
                    }
                }
                TCVec3 vsource = TCVec3.createVectorHelper((double)(this.func_174877_v().func_177958_n() + BlockStateUtils.getFacing(this.func_145832_p()).func_82601_c()) + 0.5, (double)(this.func_174877_v().func_177956_o() + BlockStateUtils.getFacing(this.func_145832_p()).func_96559_d()) + 0.5, (double)(this.func_174877_v().func_177952_p() + BlockStateUtils.getFacing(this.func_145832_p()).func_82599_e()) + 0.5);
                TCVec3 vtar = TCVec3.createVectorHelper(0.0, this.currentRadius, 0.0);
                vtar.rotateAroundZ((float)this.spiral / 180.0f * (float)Math.PI);
                vtar.rotateAroundY(1.5707964f * (float)BlockStateUtils.getFacing(this.func_145832_p()).func_82601_c());
                vtar.rotateAroundX(1.5707964f * (float)BlockStateUtils.getFacing(this.func_145832_p()).func_96559_d());
                TCVec3 vres = vsource.addVector(vtar.xCoord, vtar.yCoord, vtar.zCoord);
                x = MathHelper.func_76128_c((double)vres.xCoord);
                y = MathHelper.func_76128_c((double)vres.yCoord);
                z = MathHelper.func_76128_c((double)vres.zCoord);
            }
        }
        this.lastX = x;
        this.lastZ = z;
        this.lastY = y;
        x += BlockStateUtils.getFacing(this.func_145832_p()).func_82601_c();
        y += BlockStateUtils.getFacing(this.func_145832_p()).func_96559_d();
        z += BlockStateUtils.getFacing(this.func_145832_p()).func_82599_e();
        for (int depth = 0; depth < 64; ++depth) {
            x += BlockStateUtils.getFacing(this.func_145832_p()).func_82601_c();
            y += BlockStateUtils.getFacing(this.func_145832_p()).func_96559_d();
            z += BlockStateUtils.getFacing(this.func_145832_p()).func_82599_e();
            if (depth < this.stick) continue;
            BlockPos bp = new BlockPos(x, y, z);
            Block block = this.field_145850_b.func_180495_p(bp).func_177230_c();
            if (block != null && block.func_176195_g(this.field_145850_b, bp) < 0.0f) break;
            if (!this.field_145850_b.func_175623_d(bp) && block != null && block.func_176209_a(this.field_145850_b.func_180495_p(bp), false) && block.func_180640_a(this.field_145850_b, bp, this.field_145850_b.func_180495_p(bp)) != null) {
                Vec3 var14;
                this.digX = x;
                this.digY = y;
                this.digZ = z;
                this.stick = depth;
                this.count = Math.max(10 - this.speed, (int)(block.func_176195_g(this.field_145850_b, bp) * 2.0f) - this.speed * 2);
                if (this.speedyTime < 1.0f) {
                    this.count *= 4;
                }
                this.toDig = true;
                Vec3 var13 = new Vec3((double)this.func_174877_v().func_177958_n() + 0.5 + (double)BlockStateUtils.getFacing(this.func_145832_p()).func_82601_c(), (double)this.func_174877_v().func_177956_o() + 0.5 + (double)BlockStateUtils.getFacing(this.func_145832_p()).func_96559_d(), (double)this.func_174877_v().func_177952_p() + 0.5 + (double)BlockStateUtils.getFacing(this.func_145832_p()).func_82599_e());
                MovingObjectPosition mop = this.field_145850_b.func_147447_a(var13, var14 = new Vec3((double)this.digX + 0.5, (double)this.digY + 0.5, (double)this.digZ + 0.5), false, true, false);
                if (mop != null && (block = this.field_145850_b.func_180495_p(mop.func_178782_a()).func_177230_c()).func_176195_g(this.field_145850_b, mop.func_178782_a()) > -1.0f && block.func_180640_a(this.field_145850_b, mop.func_178782_a(), this.field_145850_b.func_180495_p(mop.func_178782_a())) != null) {
                    this.count = Math.max(10 - this.speed, (int)(block.func_176195_g(this.field_145850_b, mop.func_178782_a()) * 2.0f) - this.speed * 2);
                    if (this.speedyTime < 1.0f) {
                        this.count *= 4;
                    }
                    if (this.digX != mop.func_178782_a().func_177958_n() || this.digY != mop.func_178782_a().func_177956_o() || this.digZ != mop.func_178782_a().func_177952_p()) {
                        this.stick = 0;
                    }
                    this.digX = mop.func_178782_a().func_177958_n();
                    this.digY = mop.func_178782_a().func_177956_o();
                    this.digZ = mop.func_178782_a().func_177952_p();
                }
                this.sendDigEvent();
                return;
            }
            this.stick = 0;
        }
        this.stick = 0;
    }

    @Override
    public boolean gettingPower() {
        return this.field_145850_b.func_175687_A(this.field_174879_c) > 0 || this.field_145850_b.func_175687_A(this.field_174879_c.func_177972_a(this.baseOrientation)) > 0;
    }

    public void setOrientation(EnumFacing or, boolean initial) {
        ((BlockTCDevice)this.func_145838_q()).updateFacing(this.field_145850_b, this.func_174877_v(), or);
        this.lastX = 0;
        this.lastZ = 0;
        switch (or.ordinal()) {
            case 0: {
                this.tarZ = 180;
                this.tarX = 0;
                break;
            }
            case 1: {
                this.tarZ = 0;
                this.tarX = 0;
                break;
            }
            case 2: {
                this.tarZ = 90;
                this.tarX = 270;
                break;
            }
            case 3: {
                this.tarZ = 90;
                this.tarX = 90;
                break;
            }
            case 4: {
                this.tarZ = 90;
                this.tarX = 0;
                break;
            }
            case 5: {
                this.tarZ = 90;
                this.tarX = 180;
            }
        }
        if (initial) {
            this.rotX = this.tarX;
            this.rotZ = this.tarZ;
        }
        this.toDig = false;
        this.radInc = 0.0f;
        this.paused = 100;
        this.tRadX = 0.0f;
        this.tRadZ = 0.0f;
        this.mRadX = 0.0f;
        this.mRadZ = 0.0f;
        this.digX = 0;
        this.digY = 0;
        this.digZ = 0;
        if (this.field_145850_b != null) {
            this.field_145850_b.func_175689_h(this.field_174879_c);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.speedyTime = nbttagcompound.func_74765_d("SpeedyTime");
        this.powered = (int)Math.ceil(this.speedyTime);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("SpeedyTime", (short)this.speedyTime);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        NBTTagList var2 = nbttagcompound.func_150295_c("Inventory", 10);
        this.contents = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 < 0 || var5 >= this.contents.length) continue;
            this.contents[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        this.func_70296_d();
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.contents.length; ++var3) {
            if (this.contents[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.contents[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        nbttagcompound.func_74782_a("Inventory", (NBTBase)var2);
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 99) {
            try {
                Block var40;
                if (this.field_145850_b.field_72995_K && (j & 0xFFF) > 0 && (var40 = Block.func_149729_e((int)(j & 0xFFF))) != null) {
                    this.field_145850_b.func_72980_b((double)((float)this.digX + 0.5f), (double)((float)this.digY + 0.5f), (double)((float)this.digZ + 0.5f), var40.field_149762_H.func_150495_a(), (var40.field_149762_H.func_150497_c() + 1.0f) / 2.0f, var40.field_149762_H.func_150494_d() * 0.8f, false);
                    for (int a = 0; a < Thaumcraft.proxy.getFX().particleCount(10); ++a) {
                        Thaumcraft.proxy.getFX().boreDigFx(this.digX, this.digY, this.digZ, this.field_174879_c.func_177958_n() + BlockStateUtils.getFacing(this.func_145832_p()).func_82601_c(), this.func_174877_v().func_177956_o() + BlockStateUtils.getFacing(this.func_145832_p()).func_96559_d(), this.func_174877_v().func_177952_p() + BlockStateUtils.getFacing(this.func_145832_p()).func_82599_e(), var40, j >> 12 & 0xFF);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return super.func_145842_c(i, j);
    }

    public void getDigEvent(BlockPos blockPos) {
        this.digX = blockPos.func_177958_n();
        this.digY = blockPos.func_177956_o();
        this.digZ = blockPos.func_177952_p();
        this.toDig = true;
        this.digBlock = this.field_145850_b.func_180495_p(new BlockPos(this.digX, this.digY, this.digZ)).func_177230_c();
        this.digMd = this.digBlock.func_176201_c(this.field_145850_b.func_180495_p(new BlockPos(this.digX, this.digY, this.digZ)));
    }

    public void sendDigEvent() {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketBoreDig(this.func_174877_v(), new BlockPos(this.digX, this.digY, this.digZ)), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.func_177502_q(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 64.0));
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int var1) {
        return this.contents[var1];
    }

    public ItemStack func_70298_a(int var1, int var2) {
        if (this.contents[var1] != null) {
            if (this.contents[var1].field_77994_a <= var2) {
                ItemStack var3 = this.contents[var1];
                this.contents[var1] = null;
                this.func_70296_d();
                return var3;
            }
            ItemStack var3 = this.contents[var1].func_77979_a(var2);
            if (this.contents[var1].field_77994_a == 0) {
                this.contents[var1] = null;
            }
            this.func_70296_d();
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int var1) {
        if (this.contents[var1] != null) {
            ItemStack var2 = this.contents[var1];
            this.contents[var1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.contents[var1] = var2;
        if (var2 != null && var2.field_77994_a > this.func_70297_j_()) {
            var2.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : var1.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public boolean onWandRightClick(World world, ItemStack wandstack, EntityPlayer player, BlockPos pos, EnumFacing side) {
        this.setOrientation(side, false);
        player.field_70170_p.func_72980_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, "thaumcraft:tool", 0.5f, 0.9f + player.field_70170_p.field_73012_v.nextFloat() * 0.2f, false);
        player.func_71038_i();
        this.func_70296_d();
        return false;
    }

    @Override
    public void onUsingWandTick(ItemStack wandstack, EntityPlayer player, int count) {
    }

    @Override
    public void onWandStoppedUsing(ItemStack wandstack, World world, EntityPlayer player, int count) {
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public IChatComponent func_145748_c_() {
        return null;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

