/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles.devices;

import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ITickable;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.TileThaumcraft;
import thaumcraft.codechicken.lib.raytracer.IndexedCuboid6;
import thaumcraft.codechicken.lib.vec.Cuboid6;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.lib.aura.AuraChunk;
import thaumcraft.common.lib.aura.AuraHandler;
import thaumcraft.common.lib.aura.AuraWorld;
import thaumcraft.common.lib.utils.BlockStateUtils;

public class TileDioptra
extends TileThaumcraft
implements ITickable {
    public int counter = 0;
    public byte[] grid_amt = new byte[169];
    public byte[] grid_type = new byte[169];
    private byte[] grid_amt_p = new byte[169];
    public byte type = (byte)-1;

    public TileDioptra() {
        Arrays.fill(this.grid_amt, (byte)0);
        Arrays.fill(this.grid_type, (byte)-1);
        Arrays.fill(this.grid_amt_p, (byte)0);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_178781_a((double)((double)this.func_174877_v().func_177958_n() - 0.3), (double)((double)this.func_174877_v().func_177956_o() - 0.3), (double)((double)this.func_174877_v().func_177952_p() - 0.3), (double)((double)this.func_174877_v().func_177958_n() + 1.3), (double)((double)this.func_174877_v().func_177956_o() + 2.3), (double)((double)this.func_174877_v().func_177952_p() + 1.3));
    }

    public void func_73660_a() {
        ++this.counter;
        if (BlockStateUtils.isEnabled(this.func_145832_p()) && this.type >= 0) {
            if (!this.field_145850_b.field_72995_K) {
                if (this.counter % 20 == 0) {
                    Arrays.fill(this.grid_amt, (byte)0);
                    Arrays.fill(this.grid_type, (byte)-1);
                    for (int xx = 0; xx < 13; ++xx) {
                        for (int zz = 0; zz < 13; ++zz) {
                            AspectList al;
                            AuraChunk ac = AuraHandler.getAuraChunk(this.field_145850_b.field_73011_w.func_177502_q(), (this.field_174879_c.func_177958_n() >> 4) + xx - 6, (this.field_174879_c.func_177952_p() >> 4) + zz - 6);
                            if (ac == null || ac.getCurrentAspects().size() <= 0) continue;
                            switch (this.type) {
                                case 0: {
                                    al = ac.getCurrentAspects().copy();
                                    al.remove(Aspect.FLUX);
                                    Aspect as = al.getAspectsSortedByAmount()[0];
                                    this.grid_type[xx + zz * 13] = this.getAspectByte(as);
                                    this.grid_amt[xx + zz * 13] = (byte)Math.min(110.0f, (float)al.getAmount(as) / ((float)Config.AURABASE * 1.5f) * 100.0f);
                                    break;
                                }
                                default: {
                                    this.grid_type[xx + zz * 13] = this.type;
                                    this.grid_amt[xx + zz * 13] = (byte)Math.min(110.0f, (float)ac.getCurrentAspects().getAmount(this.getAspect(this.type)) / ((float)Config.AURABASE * 1.5f) * 100.0f);
                                }
                            }
                            AuraHandler.getAuraWorld(this.field_145850_b.field_73011_w.func_177502_q());
                            al = AuraWorld.getNodeTickets().get(ac.getLoc());
                            if (al == null || al.visSize() <= 0) continue;
                            int n = xx + zz * 13;
                            this.grid_type[n] = (byte)(this.grid_type[n] + 10);
                        }
                    }
                    this.func_70296_d();
                    this.field_145850_b.func_175689_h(this.func_174877_v());
                }
            } else {
                this.drawFX();
            }
        } else {
            this.counter = 0;
        }
    }

    private void drawFX() {
        for (int xx = 0; xx < 13; ++xx) {
            for (int zz = 0; zz < 13; ++zz) {
                if (this.grid_type[xx + zz * 13] > 0 && this.grid_amt[xx + zz * 13] > 0) {
                    int i;
                    boolean sparkle = this.grid_type[xx + zz * 13] > 10;
                    float h = (float)this.grid_amt[xx + zz * 13] / ((float)Config.AURABASE * 1.5f);
                    int n = this.grid_amt_p[xx + zz * 13] > this.grid_amt[xx + zz * 13] ? 8 : (i = this.grid_amt_p[xx + zz * 13] < this.grid_amt[xx + zz * 13] ? 6 : 7);
                    if (i == 7 && xx == 6 && zz == 6) {
                        i = 9;
                    }
                    if (sparkle && this.field_145850_b.field_73012_v.nextInt(3) == 0) {
                        Thaumcraft.proxy.getFX().drawGenericParticles((double)this.field_174879_c.func_177958_n() + 0.5 + (double)((float)(xx - 6) * 0.075f) + (double)((this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.04f), (float)(this.field_174879_c.func_177956_o() + 1) + h + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.04f, (double)this.field_174879_c.func_177952_p() + 0.5 + (double)((float)(zz - 6) * 0.075f) + (double)((this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.04f), (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.01f, this.field_145850_b.field_73012_v.nextFloat() * 0.01f, (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.01f, 0.7f + this.field_145850_b.field_73012_v.nextFloat() * 0.3f, 0.7f + this.field_145850_b.field_73012_v.nextFloat() * 0.3f, 0.7f + this.field_145850_b.field_73012_v.nextFloat() * 0.3f, 0.9f, false, 112, 9, 1, 6 + this.field_145850_b.field_73012_v.nextInt(4), 0, 0.25f, 0.0f, 0);
                    }
                }
                this.grid_amt_p[xx + zz * 13] = this.grid_amt[xx + zz * 13];
            }
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        this.type = nbt.func_74771_c("type");
        if (this.type > 7) {
            this.type = (byte)(this.type % 8);
        }
        if (nbt.func_74764_b("grid_t") && nbt.func_74764_b("grid_a")) {
            this.grid_type = nbt.func_74770_j("grid_t");
            this.grid_amt = nbt.func_74770_j("grid_a");
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        nbt.func_74774_a("type", this.type);
        nbt.func_74773_a("grid_a", this.grid_amt);
        nbt.func_74773_a("grid_t", this.grid_type);
    }

    private byte getAspectByte(Aspect aspect2) {
        if (aspect2 == Aspect.AIR) {
            return 1;
        }
        if (aspect2 == Aspect.FIRE) {
            return 2;
        }
        if (aspect2 == Aspect.WATER) {
            return 3;
        }
        if (aspect2 == Aspect.EARTH) {
            return 4;
        }
        if (aspect2 == Aspect.ORDER) {
            return 5;
        }
        if (aspect2 == Aspect.ENTROPY) {
            return 6;
        }
        if (aspect2 == Aspect.FLUX) {
            return 7;
        }
        return 0;
    }

    public Aspect getAspect(byte b) {
        switch (b) {
            default: {
                return null;
            }
            case 1: {
                return Aspect.AIR;
            }
            case 2: {
                return Aspect.FIRE;
            }
            case 3: {
                return Aspect.WATER;
            }
            case 4: {
                return Aspect.EARTH;
            }
            case 5: {
                return Aspect.ORDER;
            }
            case 6: {
                return Aspect.ENTROPY;
            }
            case 7: 
        }
        return Aspect.FLUX;
    }

    public MovingObjectPosition rayTrace(World world, Vec3 vec3d, Vec3 vec3d1, MovingObjectPosition fullblock) {
        return fullblock;
    }

    public void addTraceableCuboids(List<IndexedCuboid6> cuboids) {
        cuboids.add(new IndexedCuboid6(0, new Cuboid6((double)this.func_174877_v().func_177958_n() + 0.375, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.375, (double)this.func_174877_v().func_177958_n() + 0.625, (double)this.func_174877_v().func_177956_o() + 1.1, (double)this.func_174877_v().func_177952_p() + 0.625)));
    }

    public void switchType(EntityPlayer playerIn, byte type) {
        this.grid_amt = new byte[169];
        this.grid_type = new byte[169];
        this.grid_amt_p = new byte[169];
        if (!this.field_145850_b.field_72995_K) {
            this.type = type;
            this.func_70296_d();
            this.field_145850_b.func_175689_h(this.func_174877_v());
            if (this.getAspect(type) != null) {
                playerIn.func_145747_a((IChatComponent)new ChatComponentText(String.format(StatCollector.func_74838_a((String)"tc.dioptra.1"), this.getAspect(type).getName())));
            } else if (type >= 0) {
                playerIn.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"tc.dioptra.2")));
            }
        }
    }
}

