/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles.devices;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.aura.AuraHandler;
import thaumcraft.common.lib.utils.BlockStateUtils;
import thaumcraft.common.tiles.TileThaumcraftInventory;
import thaumcraft.common.tiles.devices.TileBellows;

public class TileInfernalFurnace
extends TileThaumcraftInventory
implements ITickable {
    public int furnaceCookTime = 0;
    public int furnaceMaxCookTime = 0;
    public int speedyTime = 0;
    public int facingX = -5;
    public int facingZ = -5;

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_178781_a((double)((double)this.func_174877_v().func_177958_n() - 1.3), (double)((double)this.func_174877_v().func_177956_o() - 1.3), (double)((double)this.func_174877_v().func_177952_p() - 1.3), (double)((double)this.func_174877_v().func_177958_n() + 2.3), (double)((double)this.func_174877_v().func_177956_o() + 2.3), (double)((double)this.func_174877_v().func_177952_p() + 2.3));
    }

    public TileInfernalFurnace() {
        this.itemStacks = new ItemStack[32];
    }

    @Override
    public int[] func_180463_a(EnumFacing par1) {
        int[] nArray;
        if (par1 == EnumFacing.UP) {
            int[] nArray2 = new int[32];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray2[2] = 2;
            nArray2[3] = 3;
            nArray2[4] = 4;
            nArray2[5] = 5;
            nArray2[6] = 6;
            nArray2[7] = 7;
            nArray2[8] = 8;
            nArray2[9] = 9;
            nArray2[10] = 10;
            nArray2[11] = 11;
            nArray2[12] = 12;
            nArray2[13] = 13;
            nArray2[14] = 14;
            nArray2[15] = 15;
            nArray2[16] = 16;
            nArray2[17] = 17;
            nArray2[18] = 18;
            nArray2[19] = 19;
            nArray2[20] = 20;
            nArray2[21] = 21;
            nArray2[22] = 22;
            nArray2[23] = 23;
            nArray2[24] = 24;
            nArray2[25] = 25;
            nArray2[26] = 26;
            nArray2[27] = 27;
            nArray2[28] = 28;
            nArray2[29] = 29;
            nArray2[30] = 30;
            nArray = nArray2;
            nArray2[31] = 31;
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    @Override
    public boolean func_180461_b(int par1, ItemStack par2ItemStack, EnumFacing par3) {
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.furnaceCookTime = nbttagcompound.func_74765_d("CookTime");
        this.speedyTime = nbttagcompound.func_74765_d("SpeedyTime");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("CookTime", (short)this.furnaceCookTime);
        nbttagcompound.func_74777_a("SpeedyTime", (short)this.speedyTime);
    }

    public void func_73660_a() {
        if (this.facingX == -5) {
            this.setFacing();
        }
        if (!this.field_145850_b.field_72995_K) {
            int a;
            boolean cookedflag = false;
            if (this.furnaceCookTime > 0) {
                --this.furnaceCookTime;
                cookedflag = true;
            }
            if (this.furnaceMaxCookTime == 0) {
                this.furnaceMaxCookTime = this.calcCookTime();
            }
            if (this.furnaceCookTime > this.furnaceMaxCookTime) {
                this.furnaceCookTime = this.furnaceMaxCookTime;
            }
            if (this.furnaceCookTime == 0 && cookedflag) {
                for (a = 0; a < this.func_70302_i_(); ++a) {
                    ItemStack itemstack;
                    if (this.itemStacks[a] == null || (itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.itemStacks[a])) == null) continue;
                    if (this.speedyTime > 0) {
                        --this.speedyTime;
                    }
                    this.ejectItem(itemstack.func_77946_l(), this.itemStacks[a]);
                    this.field_145850_b.func_175641_c(this.func_174877_v(), BlocksTC.infernalFurnace, 3, 0);
                    if (this.func_145831_w().field_73012_v.nextInt(8) == 0) {
                        AuraHelper.pollute(this.func_145831_w(), this.func_174877_v().func_177972_a(this.getFacing().func_176734_d()), 1, true);
                    }
                    --this.itemStacks[a].field_77994_a;
                    if (this.itemStacks[a].field_77994_a > 0) break;
                    this.itemStacks[a] = null;
                    break;
                }
            }
            if (this.speedyTime <= 0) {
                this.speedyTime = AuraHandler.drainAuraAvailable(this.func_145831_w(), this.func_174877_v(), Aspect.FIRE, 5) * 5;
            }
            if (this.furnaceCookTime == 0 && !cookedflag) {
                for (a = 0; a < this.func_70302_i_(); ++a) {
                    if (this.itemStacks[a] != null && this.canSmelt(a)) {
                        this.furnaceCookTime = this.furnaceMaxCookTime = this.calcCookTime();
                        break;
                    }
                    if (this.itemStacks[a] == null || this.canSmelt(a)) continue;
                    this.destroyItem(a);
                    this.func_70296_d();
                    break;
                }
            }
        }
    }

    private int getBellows() {
        int bellows = 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlockPos p2;
            TileEntity tile;
            if (dir == EnumFacing.UP || (tile = this.field_145850_b.func_175625_s(p2 = this.field_174879_c.func_177967_a(dir, 2))) == null || !(tile instanceof TileBellows) || BlockStateUtils.getFacing(this.field_145850_b.func_180495_p(p2)) != dir.func_176734_d() || this.field_145850_b.func_175687_A(p2) != 0) continue;
            ++bellows;
        }
        return Math.min(3, bellows);
    }

    private int calcCookTime() {
        return (this.speedyTime > 0 ? 80 : 140) - 20 * this.getBellows();
    }

    public boolean addItemsToInventory(ItemStack items) {
        for (int a = 0; a < this.func_70302_i_(); ++a) {
            if (this.itemStacks[a] != null && this.itemStacks[a].func_77969_a(items) && this.itemStacks[a].field_77994_a + items.field_77994_a <= items.func_77976_d()) {
                this.itemStacks[a].field_77994_a += items.field_77994_a;
                if (!this.canSmelt(a)) {
                    this.destroyItem(a);
                }
                this.func_70296_d();
                return true;
            }
            if (this.itemStacks[a] != null) continue;
            this.func_70299_a(a, items);
            if (!this.canSmelt(a)) {
                this.destroyItem(a);
            }
            this.func_70296_d();
            return true;
        }
        return false;
    }

    private void destroyItem(int slot) {
        this.itemStacks[slot] = null;
        this.field_145850_b.func_72980_b((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), "random.fizz", 0.3f, 2.6f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.8f, false);
        double var21 = (float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat();
        double var22 = this.field_174879_c.func_177956_o() + 1;
        double var23 = (float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat();
        this.field_145850_b.func_175688_a(EnumParticleTypes.LAVA, var21, var22, var23, 0.0, 0.0, 0.0, new int[0]);
    }

    public void ejectItem(ItemStack items, ItemStack furnaceItemStack) {
        int var4;
        if (items == null) {
            return;
        }
        ItemStack bit = items.func_77946_l();
        int bellows = this.getBellows();
        float lx = 0.5f;
        float lz = 0.5f;
        float mx = this.facingX == 0 ? (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.03f : (float)this.facingX * 0.13f;
        float mz = this.facingZ == 0 ? (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.03f : (float)this.facingZ * 0.13f;
        EntityItem entityitem = new EntityItem(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + (lx += (float)this.facingX * 1.2f)), (double)((float)this.field_174879_c.func_177956_o() + 0.4f), (double)((float)this.field_174879_c.func_177952_p() + (lz += (float)this.facingZ * 1.2f)), items);
        entityitem.field_70159_w = mx;
        entityitem.field_70179_y = mz;
        entityitem.field_70181_x = 0.0;
        this.field_145850_b.func_72838_d((Entity)entityitem);
        if (ThaumcraftApi.getSmeltingBonus(furnaceItemStack) != null) {
            ItemStack bonus = ThaumcraftApi.getSmeltingBonus(furnaceItemStack).func_77946_l();
            if (bonus != null) {
                if (bellows == 0) {
                    if (this.field_145850_b.field_73012_v.nextInt(4) == 0) {
                        ++bonus.field_77994_a;
                    }
                } else {
                    for (int a = 0; a < bellows; ++a) {
                        if (!(this.field_145850_b.field_73012_v.nextFloat() < 0.44f)) continue;
                        ++bonus.field_77994_a;
                    }
                }
            }
            if (bonus != null && bonus.field_77994_a > 0) {
                mx = this.facingX == 0 ? (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.03f : (float)this.facingX * 0.13f;
                mz = this.facingZ == 0 ? (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.03f : (float)this.facingZ * 0.13f;
                EntityItem entityitem2 = new EntityItem(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + lx), (double)((float)this.field_174879_c.func_177956_o() + 0.4f), (double)((float)this.field_174879_c.func_177952_p() + lz), bonus);
                entityitem2.field_70159_w = mx;
                entityitem2.field_70179_y = mz;
                entityitem2.field_70181_x = 0.0;
                this.field_145850_b.func_72838_d((Entity)entityitem2);
            }
        }
        int var2 = items.field_77994_a;
        float var3 = FurnaceRecipes.func_77602_a().func_151398_b(bit);
        if (var3 == 0.0f) {
            var2 = 0;
        } else if (var3 < 1.0f) {
            var4 = MathHelper.func_76141_d((float)((float)var2 * var3));
            if (var4 < MathHelper.func_76123_f((float)((float)var2 * var3)) && (float)Math.random() < (float)var2 * var3 - (float)var4) {
                ++var4;
            }
            var2 = var4;
        }
        while (var2 > 0) {
            var4 = EntityXPOrb.func_70527_a((int)var2);
            var2 -= var4;
            EntityXPOrb xp = new EntityXPOrb(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + lx), (double)((float)this.field_174879_c.func_177956_o() + 0.4f), (double)((float)this.field_174879_c.func_177952_p() + lz), var4);
            mx = this.facingX == 0 ? (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.025f : (float)this.facingX * 0.13f;
            mz = this.facingZ == 0 ? (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.025f : (float)this.facingZ * 0.13f;
            xp.field_70159_w = mx;
            xp.field_70179_y = mz;
            xp.field_70181_x = 0.0;
            this.field_145850_b.func_72838_d((Entity)xp);
        }
    }

    private boolean canSmelt(int slotIn) {
        if (this.itemStacks[slotIn] == null) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.itemStacks[slotIn]);
        return itemstack != null;
    }

    private void setFacing() {
        this.facingX = 0;
        this.facingZ = 0;
        EnumFacing face = this.getFacing().func_176734_d();
        this.facingX = face.func_82601_c();
        this.facingZ = face.func_82599_e();
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 3) {
            if (this.field_145850_b.field_72995_K) {
                for (int a = 0; a < 5; ++a) {
                    Thaumcraft.proxy.getFX().furnaceLavaFx(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.facingX, this.facingZ);
                    this.field_145850_b.func_72980_b((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), "liquid.lavapop", 0.1f + this.field_145850_b.field_73012_v.nextFloat() * 0.1f, 0.9f + this.field_145850_b.field_73012_v.nextFloat() * 0.15f, false);
                }
            }
            return true;
        }
        return super.func_145842_c(i, j);
    }
}

