/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles.misc;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ITickable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.blocks.TileThaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.entities.monster.boss.EntityCultistPortalGreater;
import thaumcraft.common.entities.monster.boss.EntityEldritchGolem;
import thaumcraft.common.entities.monster.boss.EntityEldritchWarden;
import thaumcraft.common.entities.monster.boss.EntityTaintacleGiant;
import thaumcraft.common.entities.monster.tainted.EntityTaintacle;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXBlockMist;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.utils.EntityUtils;
import thaumcraft.common.lib.utils.Utils;
import thaumcraft.common.lib.world.biomes.BiomeHandler;
import thaumcraft.common.lib.world.dim.Cell;
import thaumcraft.common.lib.world.dim.CellLoc;
import thaumcraft.common.lib.world.dim.GenCommon;
import thaumcraft.common.lib.world.dim.MapBossData;
import thaumcraft.common.lib.world.dim.MazeHandler;

public class TileEldritchLock
extends TileThaumcraft
implements ITickable {
    public int count = -1;
    int[][] ped = new int[][]{{2, 2, 2}, {0, -1, 1}, {3, 3, 3}};
    byte facing = 0;

    public void func_73660_a() {
        if (this.count != -1) {
            ++this.count;
            if (this.count % 5 == 0) {
                this.field_145850_b.func_72908_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), "thaumcraft:pump", 1.0f, 1.0f);
            }
            if (this.count > 100) {
                this.doBossSpawn();
            }
        }
    }

    private void doBossSpawn() {
        this.field_145850_b.func_72908_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), "thaumcraft:ice", 1.0f, 1.0f);
        if (!this.field_145850_b.field_72995_K) {
            int cx = this.field_174879_c.func_177958_n() >> 4;
            int cz = this.field_174879_c.func_177952_p() >> 4;
            int centerx = this.field_174879_c.func_177958_n() >> 4;
            int centerz = this.field_174879_c.func_177952_p() >> 4;
            byte exit = 0;
            for (int a = -2; a <= 2; ++a) {
                for (int b = -2; b <= 2; ++b) {
                    Cell c = MazeHandler.getFromHashMap(new CellLoc(cx + a, cz + b));
                    if (c != null && c.feature == 2) {
                        centerx = cx + a;
                        centerz = cz + b;
                    }
                    if (c == null || c.feature < 2 || c.feature > 5 || !c.north && !c.south && !c.east && !c.west) continue;
                    exit = c.feature;
                }
            }
            MapBossData mbd = (MapBossData)this.field_145850_b.func_72943_a(MapBossData.class, "BossMapData");
            if (mbd == null) {
                mbd = new MapBossData("BossMapData");
                mbd.bossCount = 0;
                mbd.func_76185_a();
                this.field_145850_b.func_72823_a("BossMapData", (WorldSavedData)mbd);
            }
            ++mbd.bossCount;
            if (this.field_145850_b.field_73012_v.nextFloat() < 0.25f) {
                ++mbd.bossCount;
            }
            mbd.func_76185_a();
            switch (mbd.bossCount % 4) {
                case 0: {
                    this.spawnGolemBossRoom(centerx, centerz, exit);
                    break;
                }
                case 1: {
                    this.spawnWardenBossRoom(centerx, centerz, exit);
                    break;
                }
                case 2: {
                    this.spawnCultistBossRoom(centerx, centerz, exit);
                    break;
                }
                case 3: {
                    this.spawnTaintBossRoom(centerx, centerz, exit);
                }
            }
            for (int a = -2; a <= 2; ++a) {
                for (int b = -2; b <= 2; ++b) {
                    for (int c = -2; c <= 2; ++c) {
                        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(a, b, c)) != BlocksTC.eldritch.func_176203_a(5)) continue;
                        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockMist(this.field_174879_c.func_177982_a(a, b, c), 0x400040), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.func_177502_q(), (double)(this.field_174879_c.func_177958_n() + a), (double)(this.field_174879_c.func_177956_o() + b), (double)(this.field_174879_c.func_177952_p() + c), 32.0));
                        this.field_145850_b.func_175698_g(this.field_174879_c.func_177982_a(a, b, c));
                    }
                }
            }
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
    }

    private void spawnWardenBossRoom(int cx, int cz, int exit) {
        int b;
        int a;
        for (int i = 0; i < this.field_145850_b.field_73010_i.size(); ++i) {
            EntityPlayer ep = (EntityPlayer)this.field_145850_b.field_73010_i.get(i);
            if (!(ep.func_174818_b(this.field_174879_c) < 300.0)) continue;
            ep.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"tc.boss.warden")));
        }
        int x = cx * 16 + 16;
        int y = 50;
        int z = cz * 16 + 16;
        int x2 = x;
        int z2 = z;
        switch (exit) {
            case 2: {
                x2 += 8;
                z2 += 8;
                break;
            }
            case 3: {
                x2 -= 8;
                z2 += 8;
                break;
            }
            case 4: {
                x2 += 8;
                z2 -= 8;
                break;
            }
            case 5: {
                x2 -= 8;
                z2 -= 8;
            }
        }
        GenCommon.genObelisk(this.field_145850_b, new BlockPos(x2, y + 4, z));
        GenCommon.genObelisk(this.field_145850_b, new BlockPos(x, y + 4, z2));
        this.field_145850_b.func_175656_a(new BlockPos(x2, y + 2, z), BlocksTC.eldritch.func_176203_a(1));
        this.field_145850_b.func_175656_a(new BlockPos(x, y + 2, z2), BlocksTC.eldritch.func_176203_a(1));
        for (a = -1; a <= 1; ++a) {
            for (b = -1; b <= 1; ++b) {
                int md;
                float rr;
                if (a != 0 && b != 0 && this.field_145850_b.field_73012_v.nextFloat() < 0.9f) {
                    rr = this.field_145850_b.field_73012_v.nextFloat();
                    md = rr < 0.1f ? 2 : (rr < 0.3f ? 1 : 0);
                    this.field_145850_b.func_175656_a(new BlockPos(x2 + a, y + 2, z + b), BlocksTC.lootUrn.func_176203_a(md));
                }
                if (a == 0 || b == 0 || !(this.field_145850_b.field_73012_v.nextFloat() < 0.9f)) continue;
                rr = this.field_145850_b.field_73012_v.nextFloat();
                md = rr < 0.1f ? 2 : (rr < 0.3f ? 1 : 0);
                this.field_145850_b.func_175656_a(new BlockPos(x + a, y + 2, z2 + b), BlocksTC.lootUrn.func_176203_a(md));
            }
        }
        this.field_145850_b.func_175656_a(new BlockPos(x - 2, y + 2, z - 2), BlocksTC.pedestal.func_176203_a(2));
        this.field_145850_b.func_175656_a(new BlockPos(x - 2, y + 2, z + 2), BlocksTC.pedestal.func_176203_a(2));
        this.field_145850_b.func_175656_a(new BlockPos(x + 2, y + 2, z + 2), BlocksTC.pedestal.func_176203_a(2));
        this.field_145850_b.func_175656_a(new BlockPos(x + 2, y + 2, z - 2), BlocksTC.pedestal.func_176203_a(2));
        for (a = 0; a < 3; ++a) {
            for (b = 0; b < 3; ++b) {
                if (this.ped[a][b] < 0) {
                    this.field_145850_b.func_175656_a(new BlockPos(x2 - 1 + b, y + 2, z2 - 1 + a), BlocksTC.stone.func_176203_a(7));
                    continue;
                }
                this.field_145850_b.func_175656_a(new BlockPos(x2 - 1 + b, y + 2, z2 - 1 + a), BlocksTC.stairsAncient.func_176203_a(this.ped[a][b]));
            }
        }
        EntityEldritchWarden boss = new EntityEldritchWarden(this.field_145850_b);
        double d0 = (double)this.field_174879_c.func_177958_n() - ((double)x2 + 0.5);
        double d1 = (float)this.field_174879_c.func_177956_o() - ((float)(y + 3) + boss.func_70047_e());
        double d2 = (double)this.field_174879_c.func_177952_p() - ((double)z2 + 0.5);
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float f = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
        float f1 = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
        boss.func_70012_b((double)x2 + 0.5, y + 3, (double)z2 + 0.5, f, f1);
        boss.func_180482_a(this.field_145850_b.func_175649_E(this.field_174879_c), null);
        boss.func_175449_a(new BlockPos(x, y + 2, z), 32);
        this.field_145850_b.func_72838_d((Entity)boss);
    }

    private void spawnGolemBossRoom(int cx, int cz, int exit) {
        int b;
        int a;
        for (int i = 0; i < this.field_145850_b.field_73010_i.size(); ++i) {
            EntityPlayer ep = (EntityPlayer)this.field_145850_b.field_73010_i.get(i);
            if (!(ep.func_174818_b(this.field_174879_c) < 300.0)) continue;
            ep.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"tc.boss.golem")));
        }
        int x = cx * 16 + 16;
        int y = 50;
        int z = cz * 16 + 16;
        int x2 = 0;
        int z2 = 0;
        switch (exit) {
            case 2: {
                x2 = 8;
                z2 = 8;
                break;
            }
            case 3: {
                x2 = -8;
                z2 = 8;
                break;
            }
            case 4: {
                x2 = 8;
                z2 = -8;
                break;
            }
            case 5: {
                x2 = -8;
                z2 = -8;
            }
        }
        GenCommon.genObelisk(this.field_145850_b, new BlockPos(x + x2, y + 4, z + z2));
        GenCommon.genObelisk(this.field_145850_b, new BlockPos(x - x2, y + 4, z + z2));
        GenCommon.genObelisk(this.field_145850_b, new BlockPos(x + x2, y + 4, z - z2));
        this.field_145850_b.func_175656_a(new BlockPos(x + x2, y + 2, z + z2), BlocksTC.eldritch.func_176203_a(1));
        this.field_145850_b.func_175656_a(new BlockPos(x - x2, y + 2, z + z2), BlocksTC.eldritch.func_176203_a(1));
        this.field_145850_b.func_175656_a(new BlockPos(x + x2, y + 2, z - z2), BlocksTC.eldritch.func_176203_a(1));
        for (a = 0; a < 3; ++a) {
            for (b = 0; b < 3; ++b) {
                if (this.ped[a][b] < 0) {
                    this.field_145850_b.func_175656_a(new BlockPos(x - 1 + b, y + 2, z - 1 + a), BlocksTC.stone.func_176203_a(7));
                    continue;
                }
                this.field_145850_b.func_175656_a(new BlockPos(x - 1 + b, y + 2, z - 1 + a), BlocksTC.stairsAncient.func_176203_a(this.ped[a][b]));
            }
        }
        for (a = -10; a <= 10; ++a) {
            for (b = -10; b <= 10; ++b) {
                if (!(a < -2 && b < -2 || a > 2 && b > 2 || a < -2 && b > 2) && (a <= 2 || b >= -2) || !(this.field_145850_b.field_73012_v.nextFloat() < 0.15f) || !this.field_145850_b.func_175623_d(new BlockPos(x + a, y + 2, z + b))) continue;
                float rr = this.field_145850_b.field_73012_v.nextFloat();
                int md = rr < 0.05f ? 2 : (rr < 0.2f ? 1 : 0);
                this.field_145850_b.func_175656_a(new BlockPos(x + a, y + 2, z + b), this.field_145850_b.field_73012_v.nextFloat() < 0.3f ? BlocksTC.lootCrate.func_176203_a(md) : BlocksTC.lootUrn.func_176203_a(md));
            }
        }
        EntityEldritchGolem boss = new EntityEldritchGolem(this.field_145850_b);
        double d0 = (double)this.field_174879_c.func_177958_n() - ((double)x + 0.5);
        double d1 = (float)this.field_174879_c.func_177956_o() - ((float)(y + 3) + boss.func_70047_e());
        double d2 = (double)this.field_174879_c.func_177952_p() - ((double)z + 0.5);
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float f = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
        float f1 = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
        boss.func_70012_b((double)x + 0.5, y + 3, (double)z + 0.5, f, f1);
        boss.func_180482_a(this.field_145850_b.func_175649_E(this.field_174879_c), null);
        this.field_145850_b.func_72838_d((Entity)boss);
    }

    private void spawnCultistBossRoom(int cx, int cz, int exit) {
        int b;
        int a;
        for (int i = 0; i < this.field_145850_b.field_73010_i.size(); ++i) {
            EntityPlayer ep = (EntityPlayer)this.field_145850_b.field_73010_i.get(i);
            if (!(ep.func_174818_b(this.field_174879_c) < 300.0)) continue;
            ep.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"tc.boss.crimson")));
        }
        int x = cx * 16 + 16;
        int y = 50;
        int z = cz * 16 + 16;
        for (a = -4; a <= 4; ++a) {
            for (b = -4; b <= 4; ++b) {
                if ((Math.abs(a) == 2 || Math.abs(b) == 2) && this.field_145850_b.field_73012_v.nextBoolean() || (Math.abs(a) == 3 || Math.abs(b) == 3) && this.field_145850_b.field_73012_v.nextFloat() > 0.33f || (Math.abs(a) == 4 || Math.abs(b) == 4) && this.field_145850_b.field_73012_v.nextFloat() > 0.25f) continue;
                this.field_145850_b.func_175656_a(new BlockPos(x + b, y + 1, z + a), BlocksTC.stone.func_176203_a(10));
            }
        }
        for (a = 0; a < 5; ++a) {
            for (b = 0; b < 5; ++b) {
                if (a != 0 && a != 4 && b != 0 && b != 4) continue;
                this.field_145850_b.func_175656_a(new BlockPos(x - 8 + b * 4, y + 2, z - 8 + a * 4), BlocksTC.stone.func_176203_a(2));
                this.field_145850_b.func_175656_a(new BlockPos(x - 8 + b * 4, y + 3, z - 8 + a * 4), BlocksTC.stone.func_176203_a(11));
                this.field_145850_b.func_175656_a(new BlockPos(x - 8 + b * 4, y + 4, z - 8 + a * 4), BlocksTC.slabStone.func_176203_a(2));
                this.field_145850_b.func_175656_a(new BlockPos(x - 8 + b * 4, y + 10, z - 8 + a * 4), BlocksTC.stone.func_176203_a(2));
                this.field_145850_b.func_175656_a(new BlockPos(x - 8 + b * 4, y + 9, z - 8 + a * 4), BlocksTC.stone.func_176203_a(11));
                this.field_145850_b.func_175656_a(new BlockPos(x - 8 + b * 4, y + 8, z - 8 + a * 4), BlocksTC.slabStone.func_176203_a(10));
            }
        }
        EntityCultistPortalGreater boss = new EntityCultistPortalGreater(this.field_145850_b);
        boss.func_70012_b((double)x + 0.5, y + 2, (double)z + 0.5, 0.0f, 0.0f);
        this.field_145850_b.func_72838_d((Entity)boss);
    }

    private void spawnTaintBossRoom(int cx, int cz, int exit) {
        for (int i = 0; i < this.field_145850_b.field_73010_i.size(); ++i) {
            EntityPlayer ep = (EntityPlayer)this.field_145850_b.field_73010_i.get(i);
            if (!(ep.func_174818_b(this.field_174879_c) < 300.0)) continue;
            ep.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"tc.boss.taint")));
        }
        int x = cx * 16 + 16;
        int y = 50;
        int z = cz * 16 + 16;
        AuraHelper.addAura(this.func_145831_w(), new BlockPos(x, y, z), Aspect.FLUX, Config.AURABASE * 4);
        for (int a = -12; a <= 12; ++a) {
            for (int b = -12; b <= 12; ++b) {
                Utils.setBiomeAt(this.field_145850_b, new BlockPos(x + b, 0, z + a), BiomeHandler.biomeTaint);
                for (int c = 0; c < 9; ++c) {
                    if (!this.field_145850_b.func_175623_d(new BlockPos(x + b, y + 2 + c, z + a)) || !BlockUtils.isAdjacentToSolidBlock(this.field_145850_b, new BlockPos(x + b, y + 2 + c, z + a)) || this.field_145850_b.field_73012_v.nextInt(3) == 0) continue;
                    this.field_145850_b.func_175656_a(new BlockPos(x + b, y + 2 + c, z + a), BlocksTC.taintFibre.func_176223_P());
                }
                if ((double)this.field_145850_b.field_73012_v.nextFloat() < 0.15) {
                    this.field_145850_b.func_175656_a(new BlockPos(x + b, y + 2, z + a), BlocksTC.taintBlock.func_176203_a(1));
                    if ((double)this.field_145850_b.field_73012_v.nextFloat() < 0.2) {
                        this.field_145850_b.func_175656_a(new BlockPos(x + b, y + 3, z + a), BlocksTC.taintBlock.func_176203_a(1));
                    }
                }
                if ((Math.abs(a) == 4 || Math.abs(b) == 4) && this.field_145850_b.field_73012_v.nextBoolean() || (Math.abs(a) >= 5 || Math.abs(b) >= 5) && this.field_145850_b.field_73012_v.nextFloat() > 0.33f || (Math.abs(a) >= 7 || Math.abs(b) >= 7) && this.field_145850_b.field_73012_v.nextFloat() > 0.25f) continue;
                this.field_145850_b.func_175656_a(new BlockPos(x + b, y + 1, z + a), BlocksTC.taintBlock.func_176203_a(0));
            }
        }
        EntityTaintacle boss1 = this.field_145850_b.func_175659_aa() != EnumDifficulty.HARD ? new EntityTaintacle(this.field_145850_b) : new EntityTaintacleGiant(this.field_145850_b);
        boss1.func_70012_b((double)x + 0.5, y + 3, (double)z + 0.5, 0.0f, 0.0f);
        EntityUtils.makeChampion(boss1, true);
        this.field_145850_b.func_72838_d((Entity)boss1);
        EntityTaintacle boss2 = this.field_145850_b.field_73012_v.nextBoolean() ? new EntityTaintacle(this.field_145850_b) : new EntityTaintacleGiant(this.field_145850_b);
        boss2.func_70012_b((double)x + 3.5, y + 3, (double)z + 3.5, 0.0f, 0.0f);
        EntityUtils.makeChampion(boss2, true);
        this.field_145850_b.func_72838_d((Entity)boss2);
        EntityTaintacle boss3 = boss2 instanceof EntityTaintacleGiant ? new EntityTaintacle(this.field_145850_b) : new EntityTaintacleGiant(this.field_145850_b);
        boss3.func_70012_b((double)x - 2.5, y + 3, (double)z + 3.5, 0.0f, 0.0f);
        EntityUtils.makeChampion(boss3, true);
        this.field_145850_b.func_72838_d((Entity)boss3);
        EntityTaintacle boss4 = this.field_145850_b.field_73012_v.nextBoolean() ? new EntityTaintacle(this.field_145850_b) : new EntityTaintacleGiant(this.field_145850_b);
        boss4.func_70012_b((double)x + 3.5, y + 3, (double)z - 2.5, 0.0f, 0.0f);
        EntityUtils.makeChampion(boss4, true);
        this.field_145850_b.func_72838_d((Entity)boss4);
        EntityTaintacle boss5 = boss4 instanceof EntityTaintacleGiant ? new EntityTaintacle(this.field_145850_b) : new EntityTaintacleGiant(this.field_145850_b);
        boss5.func_70012_b((double)x - 2.5, y + 3, (double)z - 2.5, 0.0f, 0.0f);
        EntityUtils.makeChampion(boss5, true);
        this.field_145850_b.func_72838_d((Entity)boss5);
    }

    public double func_145833_n() {
        return 9216.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_178781_a((double)((double)this.func_174877_v().func_177958_n() - 2.25), (double)((double)this.func_174877_v().func_177956_o() - 2.25), (double)((double)this.func_174877_v().func_177952_p() - 2.25), (double)((double)this.func_174877_v().func_177958_n() + 3.25), (double)((double)this.func_174877_v().func_177956_o() + 3.25), (double)((double)this.func_174877_v().func_177952_p() + 3.25));
    }

    public byte getLockFacing() {
        return this.facing;
    }

    public void setLockFacing(byte face) {
        this.facing = face;
        this.field_145850_b.func_175689_h(this.field_174879_c);
        this.func_70296_d();
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.facing = nbttagcompound.func_74771_c("facing");
        this.count = nbttagcompound.func_74765_d("count");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74774_a("facing", this.facing);
        nbttagcompound.func_74777_a("count", (short)this.count);
    }
}

