/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.crafting.Part;
import thaumcraft.api.crafting.RecipeMisc;
import thaumcraft.api.internal.CommonInternals;
import thaumcraft.api.internal.DummyInternalMethodHandler;
import thaumcraft.api.internal.IInternalMethodHandler;
import thaumcraft.api.internal.WeightedRandomLoot;

public class ThaumcraftApi {
    public static IInternalMethodHandler internalMethods = new DummyInternalMethodHandler();

    public static void registerResearchLocation(ResourceLocation loc) {
        if (!CommonInternals.jsonLocs.containsKey(loc.toString())) {
            CommonInternals.jsonLocs.put(loc.toString(), loc);
        }
    }

    public static void addSmeltingBonus(Object in, ItemStack out, float chance) {
        if (in instanceof ItemStack || in instanceof String) {
            CommonInternals.smeltingBonus.add(new SmeltBonus(in, out, chance));
        }
    }

    public static void addSmeltingBonus(Object in, ItemStack out) {
        if (in instanceof ItemStack || in instanceof String) {
            CommonInternals.smeltingBonus.add(new SmeltBonus(in, out, 0.33f));
        }
    }

    public static HashMap<String, Object> getCraftingRecipes() {
        return CommonInternals.craftingRecipeCatalog;
    }

    public static void addRecipeUnlinked(String recipeKey) {
        CommonInternals.craftingRecipesUnlinked.add(recipeKey);
    }

    public static void addIRecipeToCatalog(String name, boolean fake, IRecipe ... recipes) {
        ThaumcraftApi.getCraftingRecipes().put(name, recipes);
        if (fake) {
            CommonInternals.craftingRecipesCatalogFake.add(name);
        }
    }

    public static void addMiscRecipeToCatalog(String name, RecipeMisc ... recipes) {
        ThaumcraftApi.getCraftingRecipes().put(name, recipes);
        CommonInternals.craftingRecipesCatalogFake.add(name);
    }

    public static void addMultiblockRecipeToCatalog(String name, BluePrint ... recipes) {
        ThaumcraftApi.getCraftingRecipes().put(name, recipes);
        CommonInternals.craftingRecipesCatalogFake.add(name);
    }

    public static void addArcaneCraftingRecipe(String name, boolean fake, IArcaneRecipe ... recipes) {
        ThaumcraftApi.getCraftingRecipes().put(name, recipes);
        for (IArcaneRecipe recipe : recipes) {
            recipe.setRecipeName(name);
            if (!fake) {
                CraftingManager.func_77594_a().func_180302_a((IRecipe)recipe);
                continue;
            }
            CommonInternals.craftingRecipesCatalogFake.add(name);
        }
    }

    public static void addInfusionCraftingRecipe(String name, boolean fake, InfusionRecipe ... recipes) {
        ThaumcraftApi.getCraftingRecipes().put(name, recipes);
        if (fake) {
            CommonInternals.craftingRecipesCatalogFake.add(name);
        }
    }

    public static InfusionRecipe getInfusionRecipe(ItemStack res) {
        for (Object r : ThaumcraftApi.getCraftingRecipes().values()) {
            if (!(r instanceof InfusionRecipe[])) continue;
            for (InfusionRecipe recipe : (InfusionRecipe[])r) {
                if (!(recipe.getRecipeOutput() instanceof ItemStack) || !((ItemStack)recipe.getRecipeOutput()).func_77969_a(res)) continue;
                return recipe;
            }
        }
        return null;
    }

    public static void addCrucibleRecipe(String name, boolean fake, CrucibleRecipe ... recipes) {
        ThaumcraftApi.getCraftingRecipes().put(name, recipes);
        if (fake) {
            CommonInternals.craftingRecipesCatalogFake.add(name);
        }
    }

    public static CrucibleRecipe getCrucibleRecipe(ItemStack stack) {
        for (Object r : ThaumcraftApi.getCraftingRecipes().values()) {
            if (!(r instanceof CrucibleRecipe[])) continue;
            for (CrucibleRecipe recipe : (CrucibleRecipe[])r) {
                if (!recipe.getRecipeOutput().func_77969_a(stack)) continue;
                return recipe;
            }
        }
        return null;
    }

    public static CrucibleRecipe getCrucibleRecipeFromHash(int hash) {
        for (Object r : ThaumcraftApi.getCraftingRecipes().values()) {
            if (!(r instanceof CrucibleRecipe[])) continue;
            for (CrucibleRecipe recipe : (CrucibleRecipe[])r) {
                if (recipe.hash != hash) continue;
                return recipe;
            }
        }
        return null;
    }

    public static boolean exists(ItemStack item) {
        ItemStack stack = item.func_77946_l();
        stack.field_77994_a = 1;
        AspectList tmp = CommonInternals.objectTags.get(stack.serializeNBT().toString());
        if (tmp == null) {
            stack.func_77964_b(Short.MAX_VALUE);
            tmp = CommonInternals.objectTags.get(stack.serializeNBT().toString());
            if (item.func_77952_i() == Short.MAX_VALUE && tmp == null) {
                int index = 0;
                do {
                    stack.func_77964_b(index);
                    tmp = CommonInternals.objectTags.get(stack.serializeNBT().toString());
                } while (++index < 16 && tmp == null);
            }
            if (tmp == null) {
                return false;
            }
        }
        return true;
    }

    public static void registerObjectTag(ItemStack item, AspectList aspects) {
        if (aspects == null) {
            aspects = new AspectList();
        }
        try {
            item.field_77994_a = 1;
            NBTTagCompound nbt = new NBTTagCompound();
            aspects.writeToNBT(nbt);
            CommonInternals.objectTags.put(item.serializeNBT().toString(), aspects);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void registerObjectTag(ItemStack item, int[] meta, AspectList aspects) {
        if (aspects == null) {
            aspects = new AspectList();
        }
        try {
            item.field_77994_a = 1;
            String s = item.serializeNBT().toString();
            CommonInternals.objectTags.put(s, aspects);
            for (int m : meta) {
                CommonInternals.groupedObjectTags.put(m + ":" + s, meta);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void registerObjectTag(String oreDict, AspectList aspects) {
        List<ItemStack> ores;
        if (aspects == null) {
            aspects = new AspectList();
        }
        if ((ores = ThaumcraftApiHelper.getOresWithWildCards(oreDict)) != null && ores.size() > 0) {
            for (ItemStack ore : ores) {
                try {
                    ItemStack oc = ore.func_77946_l();
                    oc.field_77994_a = 1;
                    ThaumcraftApi.registerObjectTag(oc, aspects.copy());
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void registerComplexObjectTag(ItemStack item, AspectList aspects) {
        if (!ThaumcraftApi.exists(item)) {
            AspectList tmp = AspectHelper.generateTags(item);
            if (tmp != null && tmp.size() > 0) {
                for (Aspect tag : tmp.getAspects()) {
                    aspects.add(tag, tmp.getAmount(tag));
                }
            }
            ThaumcraftApi.registerObjectTag(item, aspects);
        } else {
            AspectList tmp = AspectHelper.getObjectAspects(item);
            for (Aspect tag : aspects.getAspects()) {
                tmp.merge(tag, tmp.getAmount(tag));
            }
            ThaumcraftApi.registerObjectTag(item, tmp);
        }
    }

    public static void registerComplexObjectTag(String oreDict, AspectList aspects) {
        List<ItemStack> ores;
        if (aspects == null) {
            aspects = new AspectList();
        }
        if ((ores = ThaumcraftApiHelper.getOresWithWildCards(oreDict)) != null && ores.size() > 0) {
            for (ItemStack ore : ores) {
                try {
                    ItemStack oc = ore.func_77946_l();
                    oc.field_77994_a = 1;
                    ThaumcraftApi.registerComplexObjectTag(oc, aspects.copy());
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void registerEntityTag(String entityName, AspectList aspects, EntityTagsNBT ... nbt) {
        CommonInternals.scanEntities.add(new EntityTags(entityName, aspects, nbt));
    }

    public static void addWarpToItem(ItemStack craftresult, int amount) {
        CommonInternals.warpMap.put(Arrays.asList(craftresult.func_77973_b(), craftresult.func_77952_i()), amount);
    }

    public static int getWarp(ItemStack in) {
        if (in == null) {
            return 0;
        }
        if (in instanceof ItemStack && CommonInternals.warpMap.containsKey(Arrays.asList(in.func_77973_b(), in.func_77952_i()))) {
            return CommonInternals.warpMap.get(Arrays.asList(in.func_77973_b(), in.func_77952_i()));
        }
        return 0;
    }

    public static void addLootBagItem(ItemStack item, int weight, int ... bagTypes) {
        if (bagTypes == null || bagTypes.length == 0) {
            WeightedRandomLoot.lootBagCommon.add(new WeightedRandomLoot(item, weight));
        } else {
            block5: for (int rarity : bagTypes) {
                switch (rarity) {
                    case 0: {
                        WeightedRandomLoot.lootBagCommon.add(new WeightedRandomLoot(item, weight));
                        continue block5;
                    }
                    case 1: {
                        WeightedRandomLoot.lootBagUncommon.add(new WeightedRandomLoot(item, weight));
                        continue block5;
                    }
                    case 2: {
                        WeightedRandomLoot.lootBagRare.add(new WeightedRandomLoot(item, weight));
                    }
                }
            }
        }
    }

    public static void registerSeed(Block block, ItemStack seed) {
        CommonInternals.seedList.put(block.func_149739_a(), seed);
    }

    public static ItemStack getSeed(Block block) {
        return CommonInternals.seedList.get(block.func_149739_a());
    }

    public static class EntityTags {
        public String entityName;
        public EntityTagsNBT[] nbts;
        public AspectList aspects;

        public EntityTags(String entityName, AspectList aspects, EntityTagsNBT ... nbts) {
            this.entityName = entityName;
            this.nbts = nbts;
            this.aspects = aspects;
        }
    }

    public static class EntityTagsNBT {
        public String name;
        public Object value;

        public EntityTagsNBT(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class BluePrint {
        Part[][][] parts;
        String research;
        ItemStack displayStack;
        ItemStack[] ingredientList;

        public BluePrint(String research, Part[][][] parts, ItemStack ... ingredientList) {
            this.parts = parts;
            this.research = research;
            this.ingredientList = ingredientList;
        }

        public BluePrint(String research, ItemStack display, Part[][][] parts, ItemStack ... ingredientList) {
            this.parts = parts;
            this.research = research;
            this.displayStack = display;
            this.ingredientList = ingredientList;
        }

        public Part[][][] getParts() {
            return this.parts;
        }

        public String getResearch() {
            return this.research;
        }

        public ItemStack[] getIngredientList() {
            return this.ingredientList;
        }

        public ItemStack getDisplayStack() {
            return this.displayStack;
        }
    }

    public static class SmeltBonus {
        public Object in;
        public ItemStack out;
        public float chance;

        public SmeltBonus(Object in, ItemStack out, float chance) {
            this.in = in;
            this.out = out;
            this.chance = chance;
        }
    }
}

