/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.casters;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import thaumcraft.api.casters.FocusHelper;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartEffect;
import thaumcraft.api.casters.IFocusPartMedium;

public class FocusCore {
    public IFocusPartMedium medium;
    public IFocusPart[] mediumModifiers;
    public FocusEffect[] effects;
    public float cost;
    public LinkedHashMap<String, IFocusPart> partsRaw;

    public FocusCore(IFocusPartMedium medium, IFocusPart[] mediumModifiers, FocusEffect[] effects) {
        this.medium = medium;
        this.mediumModifiers = mediumModifiers;
        this.effects = effects;
    }

    public FocusCore() {
        this.medium = FocusHelper.TOUCH;
        FocusEffect fe = new FocusEffect();
        fe.effect = FocusHelper.FIRE;
        fe.costMultipler = FocusHelper.TOUCH.getCostMultiplier();
        fe.effectMultipler = FocusHelper.TOUCH.getEffectMultiplier();
        this.effects = new FocusEffect[]{fe};
        this.generate();
    }

    public IFocusPartMedium.EnumFocusCastMethod getFinalCastMethod() {
        if (this.mediumModifiers != null) {
            for (IFocusPart part : this.mediumModifiers) {
                if (part != FocusHelper.CHARGE) continue;
                return IFocusPartMedium.EnumFocusCastMethod.CHARGE;
            }
        }
        return this.medium.getCastMethod();
    }

    public int getFinalChargeTime() {
        if (this.mediumModifiers != null) {
            for (IFocusPart part : this.mediumModifiers) {
                if (part != FocusHelper.CHARGE) continue;
                return this.medium.getChargeTime() * 10;
            }
        }
        return this.medium.getChargeTime();
    }

    public void generate() {
        this.partsRaw = new LinkedHashMap();
        if (this.medium == null) {
            return;
        }
        this.partsRaw.put(this.medium.getKey(), this.medium);
        this.cost = 0.0f;
        if (this.mediumModifiers != null) {
            for (IFocusPart p : this.mediumModifiers) {
                this.partsRaw.put(p.getKey(), p);
            }
        }
        for (FocusEffect fe : this.effects) {
            this.partsRaw.put(fe.effect.getKey(), fe.effect);
            float cost2 = fe.effect.getBaseCost();
            cost2 *= fe.costMultipler;
            if (fe.modifiers != null) {
                for (IFocusPart p : fe.modifiers) {
                    this.partsRaw.put(p.getKey(), p);
                }
            }
            this.cost += cost2;
        }
    }

    public NBTTagCompound serialize() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("medium", this.medium.getKey());
        if (this.mediumModifiers != null && this.mediumModifiers.length > 0) {
            String s = "";
            for (IFocusPart p : this.mediumModifiers) {
                s = s + "~" + p.getKey();
            }
            s = s.replaceFirst("~", "");
            nbt.func_74778_a("mediumMods", s);
        }
        NBTTagList efflist = new NBTTagList();
        for (FocusEffect fe : this.effects) {
            NBTTagCompound gt = new NBTTagCompound();
            gt.func_74778_a("effect", fe.effect.getKey());
            gt.func_74776_a("costMod", fe.costMultipler);
            gt.func_74776_a("effMod", fe.effectMultipler);
            if (fe.modifiers != null && fe.modifiers.length > 0) {
                String s = "";
                for (IFocusPart p : fe.modifiers) {
                    s = s + "~" + p.getKey();
                }
                s = s.replaceFirst("~", "");
                gt.func_74778_a("mods", s);
            }
            efflist.func_74742_a((NBTBase)gt);
        }
        nbt.func_74782_a("effects", (NBTBase)efflist);
        return nbt;
    }

    public void deserialize(NBTTagCompound nbt) {
        IFocusPart mp = FocusHelper.getFocusPart(nbt.func_74779_i("medium"));
        if (mp == null) {
            return;
        }
        this.medium = (IFocusPartMedium)mp;
        String s = nbt.func_74779_i("mediumMods");
        String[] ss = s.split("~");
        if (ss.length > 0) {
            ArrayList<IFocusPart> li = new ArrayList<IFocusPart>();
            for (int a = 0; a < ss.length; ++a) {
                IFocusPart p = FocusHelper.getFocusPart(ss[a]);
                if (p == null) continue;
                li.add(p);
            }
            this.mediumModifiers = li.toArray(new IFocusPart[li.size()]);
        }
        NBTTagList efflist = nbt.func_150295_c("effects", 10);
        ArrayList<FocusEffect> fes = new ArrayList<FocusEffect>();
        for (int x = 0; x < efflist.func_74745_c(); ++x) {
            NBTTagCompound nbtdata = efflist.func_150305_b(x);
            FocusEffect fe = new FocusEffect();
            fe.effect = (IFocusPartEffect)FocusHelper.getFocusPart(nbtdata.func_74779_i("effect"));
            fe.costMultipler = nbtdata.func_74760_g("costMod");
            fe.effectMultipler = nbtdata.func_74760_g("effMod");
            String mods = nbtdata.func_74779_i("mods");
            if (!mods.isEmpty()) {
                String[] modlist = mods.split("~");
                ArrayList<IFocusPart> li = new ArrayList<IFocusPart>();
                for (int a = 0; a < modlist.length; ++a) {
                    IFocusPart p = FocusHelper.getFocusPart(modlist[a]);
                    if (p == null) continue;
                    li.add(p);
                }
                fe.modifiers = li.toArray(new IFocusPart[li.size()]);
            }
            fes.add(fe);
        }
        this.effects = fes.toArray(new FocusEffect[fes.size()]);
        this.generate();
    }

    public String getSortingHelper() {
        String s = this.medium.getKey();
        for (FocusEffect ef : this.effects) {
            s = s + ef.effect.getKey();
        }
        return s;
    }

    public static class FocusEffect {
        public IFocusPartEffect effect;
        public IFocusPart[] modifiers;
        public float effectMultipler;
        public float costMultipler;
    }
}

