/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.casters;

import java.util.HashMap;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartEffect;
import thaumcraft.api.casters.IFocusPartMedium;

public class FocusHelper {
    public static IFocusPartMedium TOUCH;
    public static IFocusPartMedium BOLT;
    public static IFocusPartMedium PROJECTILE;
    public static IFocusPartEffect FIRE;
    public static IFocusPartEffect FROST;
    public static IFocusPartEffect MAGIC;
    public static IFocusPartEffect CURSE;
    public static IFocusPartEffect BREAK;
    public static IFocusPartEffect RIFT;
    public static IFocusPartEffect EXCHANGE;
    public static IFocusPart FRUGAL;
    public static IFocusPart POTENCY;
    public static IFocusPart LINGERING;
    public static IFocusPart SCATTER;
    public static IFocusPart CHAIN;
    public static IFocusPart SILKTOUCH;
    public static IFocusPart FORTUNE;
    public static IFocusPart CHARGE;
    public static HashMap<String, IFocusPart> focusParts;
    public static HashMap<String, IFocusPart[]> focusPartsConnections;

    public static boolean registerFocusPart(IFocusPart part, IFocusPart ... connections) {
        if (focusParts.containsKey(part.getKey())) {
            return false;
        }
        focusParts.put(part.getKey(), part);
        if (connections != null) {
            focusPartsConnections.put(part.getKey(), connections);
        }
        return true;
    }

    public static IFocusPart getFocusPart(String key) {
        return focusParts.get(key);
    }

    public static boolean canPartsConnect(IFocusPart part1, IFocusPart part2) {
        if (part1 == null || part2 == null) {
            return false;
        }
        if (part1.getType() == part2.getType()) {
            return false;
        }
        if (!part1.canConnectTo(part2) || !part2.canConnectTo(part1)) {
            return false;
        }
        if (part1.getType() == IFocusPart.EnumFocusPartType.MEDIUM && part2.getType() == IFocusPart.EnumFocusPartType.EFFECT || part2.getType() == IFocusPart.EnumFocusPartType.MEDIUM && part1.getType() == IFocusPart.EnumFocusPartType.EFFECT) {
            return true;
        }
        IFocusPart[] conns = focusPartsConnections.get(part1.getKey());
        if (conns != null) {
            for (IFocusPart pc : conns) {
                if (pc != part2) continue;
                return true;
            }
        }
        if ((conns = focusPartsConnections.get(part2.getKey())) != null) {
            for (IFocusPart pc : conns) {
                if (pc != part1) continue;
                return true;
            }
        }
        return false;
    }

    static {
        focusParts = new HashMap();
        focusPartsConnections = new HashMap();
    }
}

