/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.crafting;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.ITCRecipe;

public class CrucibleRecipe
implements ITCRecipe {
    private ItemStack recipeOutput;
    public Object catalyst;
    public AspectList aspects;
    public String[] research;
    private String name;
    public int hash;

    public CrucibleRecipe(String researchKey, ItemStack result, Object cat, AspectList tags) {
        this(new String[]{researchKey}, result, cat, tags);
    }

    public CrucibleRecipe(String[] researchKey, ItemStack result, Object cat, AspectList tags) {
        this.recipeOutput = result;
        this.name = "";
        this.aspects = tags;
        this.research = researchKey;
        this.catalyst = cat;
        if (cat instanceof String) {
            this.catalyst = OreDictionary.getOres((String)((String)cat), (boolean)false);
        }
        String hc = "";
        for (String ss : this.research) {
            hc = hc + ss;
        }
        hc = hc + result.toString();
        for (Aspect tag : tags.getAspects()) {
            hc = hc + tag.getTag() + tags.getAmount(tag);
        }
        if (cat instanceof ItemStack) {
            hc = hc + ((ItemStack)cat).toString();
        } else if (cat instanceof List && ((List)this.catalyst).size() > 0) {
            for (ItemStack is : (List)this.catalyst) {
                hc = hc + is.toString();
            }
        }
        this.hash = hc.hashCode();
    }

    public boolean matches(AspectList itags, ItemStack cat) {
        if (this.catalyst instanceof ItemStack && !OreDictionary.itemMatches((ItemStack)((ItemStack)this.catalyst), (ItemStack)cat, (boolean)false)) {
            return false;
        }
        if (this.catalyst instanceof List && ((List)this.catalyst).size() > 0 && !ThaumcraftApiHelper.containsMatch(false, new ItemStack[]{cat}, (List)this.catalyst)) {
            return false;
        }
        if (itags == null) {
            return false;
        }
        for (Aspect tag : this.aspects.getAspects()) {
            if (itags.getAmount(tag) >= this.aspects.getAmount(tag)) continue;
            return false;
        }
        return true;
    }

    public boolean catalystMatches(ItemStack cat) {
        if (this.catalyst instanceof ItemStack && OreDictionary.itemMatches((ItemStack)((ItemStack)this.catalyst), (ItemStack)cat, (boolean)false)) {
            return true;
        }
        return this.catalyst instanceof List && ((List)this.catalyst).size() > 0 && ThaumcraftApiHelper.containsMatch(false, new ItemStack[]{cat}, (List)this.catalyst);
    }

    public AspectList removeMatching(AspectList itags) {
        AspectList temptags = new AspectList();
        temptags.aspects.putAll(itags.aspects);
        for (Aspect tag : this.aspects.getAspects()) {
            temptags.remove(tag, this.aspects.getAmount(tag));
        }
        itags = temptags;
        return itags;
    }

    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    @Override
    public String getRecipeName() {
        return this.name;
    }

    @Override
    public void setRecipeName(String name) {
        this.name = name;
    }
}

