/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.crafting;

import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.IArcaneWorkbench;

public class ShapedArcaneRecipe
implements IArcaneRecipe {
    private static final int MAX_CRAFT_GRID_WIDTH = 3;
    private static final int MAX_CRAFT_GRID_HEIGHT = 3;
    public ItemStack output = null;
    public Object[] input = null;
    public ItemStack[] inputCrystals = null;
    public int vis = 0;
    public String research;
    public int width = 0;
    public int height = 0;
    private boolean mirrored = true;
    private String name;

    public ShapedArcaneRecipe(String research, ItemStack result, int vis, ItemStack[] crystals, Object ... recipe) {
        this.inputCrystals = crystals;
        this.output = result.func_77946_l();
        this.research = research;
        this.vis = vis;
        String shape = "";
        this.name = "";
        int idx = 0;
        if (recipe[idx] instanceof Boolean) {
            this.mirrored = (Boolean)recipe[idx];
            if (recipe[idx + 1] instanceof Object[]) {
                recipe = (Object[])recipe[idx + 1];
            } else {
                idx = 1;
            }
        }
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                this.width = s.length();
                shape = shape + (String)s;
            }
            this.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape = shape + s;
                this.width = s.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            String ret = "Invalid shaped ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
        HashMap<Character, Object> itemMap = new HashMap<Character, Object>();
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            if (in instanceof ItemStack) {
                itemMap.put(chr, ((ItemStack)in).func_77946_l());
            } else if (in instanceof Item) {
                itemMap.put(chr, new ItemStack((Item)in));
            } else if (in instanceof Block) {
                itemMap.put(chr, new ItemStack((Block)in, 1, Short.MAX_VALUE));
            } else if (in instanceof String) {
                itemMap.put(chr, OreDictionary.getOres((String)((String)in), (boolean)false));
            } else {
                String ret = "Invalid shaped ore recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
            idx += 2;
        }
        this.input = new Object[this.width * this.height];
        int x = 0;
        for (char chr : shape.toCharArray()) {
            this.input[x++] = itemMap.get(Character.valueOf(chr));
        }
    }

    @Override
    public ItemStack func_77572_b(InventoryCrafting var1) {
        return this.output.func_77946_l();
    }

    @Override
    public int func_77570_a() {
        return this.input.length;
    }

    @Override
    public ItemStack func_77571_b() {
        return this.output;
    }

    @Override
    public boolean func_77569_a(InventoryCrafting inv, World world) {
        return inv instanceof IArcaneWorkbench && this.matches(inv, world, null);
    }

    @Override
    public boolean matches(InventoryCrafting inv, World world, EntityPlayer player) {
        if (player != null && !ThaumcraftCapabilities.knowsResearch(player, this.research)) {
            return false;
        }
        if (this.inputCrystals != null && this.inputCrystals.length > 0) {
            block0: for (ItemStack crystal : this.inputCrystals) {
                for (int q = 0; q < 6; ++q) {
                    ItemStack is = inv.func_70301_a(q + 9);
                    if (this.checkItemEquals(crystal, is) && is.field_77994_a >= crystal.field_77994_a) continue block0;
                }
                return false;
            }
        }
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                ItemStack slot = inv.func_70463_b(x, y);
                if (target instanceof ItemStack) {
                    if (this.checkItemEquals((ItemStack)target, slot)) continue;
                    return false;
                }
                if (target instanceof List) {
                    boolean matched = false;
                    for (ItemStack item : (List)target) {
                        matched = matched || this.checkItemEquals(item, slot);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot == null) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkItemEquals(ItemStack target, ItemStack input) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return !(target.func_77973_b() != input.func_77973_b() || target.func_77942_o() && !ThaumcraftApiHelper.areItemStackTagsEqualForCrafting(input, target) || target.func_77952_i() != Short.MAX_VALUE && target.func_77952_i() != input.func_77952_i());
    }

    public ShapedArcaneRecipe setMirrored(boolean mirror) {
        this.mirrored = mirror;
        return this;
    }

    public Object[] getInput() {
        return this.input;
    }

    @Override
    public int getVis() {
        return this.vis;
    }

    @Override
    public int getVis(InventoryCrafting inv) {
        return this.vis;
    }

    @Override
    public String getResearch() {
        return this.research;
    }

    @Override
    public ItemStack[] func_179532_b(InventoryCrafting p_179532_1_) {
        ItemStack[] aitemstack = new ItemStack[p_179532_1_.func_70302_i_()];
        for (int i = 0; i < Math.min(9, aitemstack.length); ++i) {
            ItemStack itemstack = p_179532_1_.func_70301_a(i);
            aitemstack[i] = ForgeHooks.getContainerItem((ItemStack)itemstack);
        }
        return aitemstack;
    }

    @Override
    public ItemStack[] getCrystals() {
        return this.inputCrystals;
    }

    @Override
    public String getRecipeName() {
        return this.name;
    }

    @Override
    public void setRecipeName(String name) {
        this.name = name;
    }
}

