/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.gui;

import java.awt.Color;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.FocusHelper;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartEffect;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.gui.plugins.GuiHoverButton;
import thaumcraft.client.gui.plugins.GuiImageButton;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.container.ContainerFocalManipulator;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.playerdata.PacketFocusPlaceToServer;
import thaumcraft.common.lib.utils.HexUtils;
import thaumcraft.common.lib.utils.InventoryUtils;
import thaumcraft.common.tiles.crafting.TileFocalManipulator;

@SideOnly(value=Side.CLIENT)
public class GuiFocalManipulator
extends GuiContainer {
    private TileFocalManipulator table;
    private float xSize_lo;
    private float ySize_lo;
    private int isMouseButtonDown = 0;
    private String draggedPart = "";
    ResourceLocation tex = new ResourceLocation("thaumcraft", "textures/gui/gui_wandtable.png");
    GuiImageButton buttonConfirm = new GuiImageButton((GuiScreen)this, 0, this.field_147003_i + 60, this.field_147009_r + 112, 24, 16, null, I18n.func_74838_a((String)"wandtable.text3"), this.tex, 219, 27, 34, 26);
    GuiImageButton buttonScrollUp = new GuiImageButton((GuiScreen)this, 1, this.field_147003_i + 4, this.field_147009_r + 72 - 48, 10, 10, null, I18n.func_74838_a((String)"button.up"), this.tex, 224, 72, 16, 16);
    GuiImageButton buttonScrollDown = new GuiImageButton((GuiScreen)this, 2, this.field_147003_i + 4, this.field_147009_r + 72 + 48, 10, 10, null, I18n.func_74838_a((String)"button.down"), this.tex, 224, 88, 16, 16);
    long time;
    long nextSparkle = 0L;
    int lastSize = 0;
    DecimalFormat myFormatter = new DecimalFormat("#######.##");
    ArrayList<String> shownParts = new ArrayList();
    int partsStart = 0;
    FocusCore tempCore = null;
    ItemStack[] components = null;
    boolean valid = false;
    private final int HEX_SIZE = 17;
    final int tableCenterX = 96;
    final int tableCenterY = 72;
    ResourceLocation texh1 = new ResourceLocation("thaumcraft", "textures/gui/hex1.png");
    ResourceLocation texh2 = new ResourceLocation("thaumcraft", "textures/gui/hex2.png");
    static ResourceLocation iMedium = new ResourceLocation("thaumcraft", "textures/foci/_medium.png");
    static ResourceLocation iEffect = new ResourceLocation("thaumcraft", "textures/foci/_effect.png");
    static ResourceLocation iModifier = new ResourceLocation("thaumcraft", "textures/foci/_modifier.png");

    public GuiFocalManipulator(InventoryPlayer par1InventoryPlayer, TileFocalManipulator table) {
        super((Container)new ContainerFocalManipulator(par1InventoryPlayer, table));
        this.table = table;
        this.field_146999_f = 192;
        this.field_147000_g = 233;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.gatherInfo();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 0) {
            this.field_146297_k.field_71442_b.func_78756_a(this.field_147002_h.field_75152_c, 0);
        } else if (button.field_146127_k == 1 && this.partsStart > 0) {
            --this.partsStart;
        } else if (button.field_146127_k == 2 && this.partsStart < this.shownParts.size() - 4) {
            ++this.partsStart;
        } else {
            super.func_146284_a(button);
        }
    }

    public void func_73863_a(int mx, int my, float par3) {
        HexUtils.Hex h;
        List list;
        super.func_73863_a(mx, my, par3);
        GL11.glBlendFunc((int)770, (int)771);
        this.xSize_lo = mx;
        this.ySize_lo = my;
        int baseX = this.field_147003_i;
        int baseY = this.field_147009_r;
        int gx = (this.field_146294_l - this.field_146999_f) / 2;
        int gy = (this.field_146295_m - this.field_147000_g) / 2;
        int mposx = 0;
        int mposy = 0;
        int count = 0;
        int index = 0;
        if (this.shownParts.isEmpty()) {
            this.buttonScrollDown.field_146125_m = false;
            this.buttonScrollUp.field_146125_m = false;
        } else {
            this.buttonScrollDown.field_146125_m = true;
            this.buttonScrollUp.field_146125_m = true;
        }
        for (String sk : this.shownParts) {
            if (++count - 1 < this.partsStart) continue;
            GL11.glTranslated((double)0.0, (double)0.0, (double)5.0);
            GuiFocalManipulator.drawPart(FocusHelper.getFocusPart(sk), gx + 8, 28 + gy + 30 * index, 32.0f, 220);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-5.0);
            if (++index <= 3) continue;
            break;
        }
        count = 0;
        index = 0;
        for (String sk : this.shownParts) {
            if (++count - 1 < this.partsStart) continue;
            mposx = mx - (baseX - 4);
            mposy = my - (baseY + 16 + 30 * index);
            if (mposx >= 0 && mposy >= 0 && mposx < 24 && mposy < 24) {
                list = this.genPartText(FocusHelper.getFocusPart(sk), false);
                this.drawHoveringTextFixed(list, gx + 8, 28 + gy + 30 * index, this.field_146289_q, this.field_146294_l - (baseX + this.field_146999_f - 16));
            }
            if (++index <= 3) continue;
            break;
        }
        if (this.draggedPart.isEmpty()) {
            h = this.checkMouseOverHex(mx, my, gx, gy);
            if (this.table.data != null && h != null && !this.table.data.hexes.get(h.toString()).isEmpty()) {
                HexUtils.Pixel pix = h.toPixel(17);
                list = this.genPartText(FocusHelper.getFocusPart(this.table.data.hexes.get(h.toString())), true);
                this.drawHoveringTextFixed(list, gx + this.tableCenterX + (int)pix.x, gy + this.tableCenterY + (int)pix.y, this.field_146289_q, this.field_146294_l - (baseX + this.field_146999_f - 16));
            }
        }
        RenderHelper.func_74518_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean bl = this.buttonConfirm.active = this.table.vis <= 0.0f && this.valid;
        if (this.table.vis <= 0.0f) {
            if (Mouse.isButtonDown((int)0)) {
                if (this.isMouseButtonDown == 0 && !this.shownParts.isEmpty()) {
                    for (int mod = 0; mod < 4; ++mod) {
                        int sx = gx - 8;
                        int sy = gy + 12 + 30 * mod;
                        if (mx < sx || mx >= sx + 30 || my < sy || my >= sy + 30) continue;
                        this.playSocketSound(0.9f);
                        this.isMouseButtonDown = 1;
                        this.draggedPart = this.shownParts.get(mod + this.partsStart);
                    }
                } else if (this.isMouseButtonDown == 1 && !this.draggedPart.isEmpty()) {
                    h = this.checkMouseOverHex(mx, my, gx, gy);
                    if (this.table.data != null && h != null && this.table.data.hexes.get(h.toString()).isEmpty()) {
                        this.drawHexHighlight(h, gx + this.tableCenterX, gy + this.tableCenterY);
                    }
                    GL11.glTranslated((double)0.0, (double)0.0, (double)5.0);
                    GuiFocalManipulator.drawPart(FocusHelper.getFocusPart(this.draggedPart), mx, my, 32.0f, 220);
                    GL11.glTranslated((double)0.0, (double)0.0, (double)-5.0);
                    if (this.table.data != null && h != null && this.table.data.hexes.get(h.toString()).isEmpty()) {
                        for (int a = 0; a < 6; ++a) {
                            IFocusPart p2;
                            IFocusPart p1;
                            HexUtils.Hex target = h.getNeighbour(a);
                            String key = this.table.data.hexes.get(target.toString());
                            if (key == null || key.isEmpty() || !FocusHelper.canPartsConnect(p1 = FocusHelper.getFocusPart(key), p2 = FocusHelper.getFocusPart(this.draggedPart))) continue;
                            this.drawHexLink(gx, gy, h, target, 0.5f);
                        }
                    }
                }
            } else {
                int mouseY;
                int mouseX;
                HexUtils.Hex hp;
                if (this.isMouseButtonDown == 1 && !this.draggedPart.isEmpty() && this.table.data != null && this.table.data.hexes.containsKey((hp = new HexUtils.Pixel(mouseX = mx - (gx + 96), mouseY = my - (gy + 72)).toHex(17)).toString()) && this.table.data.hexes.get(hp.toString()).isEmpty() && this.validHex(hp, this.draggedPart)) {
                    this.playSocketSound(1.0f);
                    this.table.data.hexes.put(hp.toString(), this.draggedPart);
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketFocusPlaceToServer((byte)hp.q, (byte)hp.r, this.table.func_174877_v(), this.draggedPart));
                    this.draggedPart = "";
                    this.gatherInfo();
                }
                this.isMouseButtonDown = 0;
                this.draggedPart = "";
            }
        }
        GlStateManager.func_179084_k();
    }

    private List genPartText(IFocusPart fp, boolean placed) {
        ArrayList<String> list = new ArrayList<String>();
        if (fp != null) {
            list.add(fp.getName());
            list.add(TextFormatting.DARK_PURPLE + fp.getText());
            if (fp.getEffectMultiplier() != 1.0f) {
                list.add(TextFormatting.GOLD + I18n.func_74838_a((String)"focuspart.eff") + (fp.getEffectMultiplier() < 1.0f ? TextFormatting.RED : TextFormatting.GREEN) + " x" + this.myFormatter.format(fp.getEffectMultiplier()));
            }
            if (fp instanceof IFocusPartEffect && ((IFocusPartEffect)fp).getBaseCost() > 0.0f) {
                list.add(TextFormatting.AQUA + I18n.func_74838_a((String)"focuspart.base") + " " + this.myFormatter.format(((IFocusPartEffect)fp).getBaseCost()));
            }
            if (fp.getCostMultiplier() != 1.0f) {
                list.add(TextFormatting.AQUA + I18n.func_74838_a((String)"focuspart.mult") + (fp.getCostMultiplier() > 1.0f ? TextFormatting.RED : TextFormatting.GREEN) + " x" + this.myFormatter.format(fp.getCostMultiplier()));
            }
            if (placed && this.tempCore != null && fp instanceof IFocusPartEffect) {
                for (FocusCore.FocusEffect fe : this.tempCore.effects) {
                    if (fe.effect != fp) continue;
                    float cost = fe.effect.getBaseCost() * fe.costMultipler;
                    float eff = fe.effectMultipler;
                    list.add("");
                    list.add(TextFormatting.GOLD + I18n.func_74838_a((String)"focuspart.finalCost") + " " + (cost > 1.0f ? TextFormatting.RED : TextFormatting.GREEN) + this.myFormatter.format(cost));
                    list.add(TextFormatting.GOLD + I18n.func_74838_a((String)"focuspart.finalEffect") + (eff < 1.0f ? TextFormatting.RED : TextFormatting.GREEN) + " x" + this.myFormatter.format(eff));
                    break;
                }
            }
        }
        return list;
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        this.time = System.currentTimeMillis();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.tex);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.table.func_70301_a(0) == null || this.table.doGuiReset) {
            this.table.doGuiReset = false;
            this.gatherInfo();
        }
        if (this.table.castCost > 0.0f) {
            this.field_146289_q.func_175063_a(TextFormatting.AQUA + I18n.func_74838_a((String)"item.Focus.cost1") + ": " + this.table.castCost, (float)(k + 168), (float)(l + 16), 10092429);
        }
        if (this.components != null && this.components.length > 0) {
            this.field_146289_q.func_175063_a(TextFormatting.GOLD + I18n.func_74838_a((String)"wandtable.text4"), (float)(k + 168), (float)(l + 35), 10092429);
        }
        int dispVis = (int)(this.table.vis > 0.0f ? this.table.vis : this.table.visCost);
        this.field_146289_q.func_175063_a(TextFormatting.AQUA + "" + dispVis, (float)(k + 124), (float)(l + 27), 10092429);
        int dispXp = this.table.vis > 0.0f ? 0 : this.table.xpCost;
        this.field_146289_q.func_175063_a("" + dispXp, (float)(k + 60), (float)(l + 27), dispXp > this.field_146297_k.field_71439_g.field_71068_ca ? 16151160 : 10092429);
        GL11.glDisable((int)3042);
        this.drawStuff(this.field_147003_i, this.field_147009_r, par2, par3);
    }

    private void drawStuff(int x, int y, int mx, int my) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GlStateManager.func_179140_f();
        ArrayList<String> temp = new ArrayList<String>();
        if (this.table.data != null) {
            for (String hl : this.table.data.hexes.keySet()) {
                IFocusPart p;
                HexUtils.Hex hex = HexUtils.Hex.fromString(hl);
                String key = this.table.data.hexes.get(hl);
                if (hex == null || key == null || key.isEmpty() || (p = FocusHelper.getFocusPart(key)) == null) continue;
                HexUtils.Pixel pix = hex.toPixel(17);
                GuiFocalManipulator.drawPart(p, x + 96 + (int)pix.x, y + 72 + (int)pix.y, 32.0f, 220);
                for (int a = 0; a < 6; ++a) {
                    IFocusPart p1;
                    HexUtils.Hex target = hex.getNeighbour(a);
                    String key2 = this.table.data.hexes.get(target.toString());
                    if (key2 == null || key2.isEmpty() || temp.contains(hex.toString() + target.toString()) || !FocusHelper.canPartsConnect(p1 = FocusHelper.getFocusPart(key2), p)) continue;
                    this.drawHexLink(x, y, hex, target, 0.66f);
                    temp.add(hex.toString() + target.toString());
                    temp.add(target.toString() + hex.toString());
                }
            }
        }
        GlStateManager.func_179145_e();
        RenderHelper.func_74518_a();
        GL11.glPopMatrix();
    }

    private void gatherInfo() {
        boolean bl;
        this.tempCore = null;
        this.field_146292_n.clear();
        this.field_146292_n.add(this.buttonConfirm);
        this.buttonConfirm.field_146128_h = this.field_147003_i + 61;
        this.buttonConfirm.field_146129_i = this.field_147009_r + 114;
        this.field_146292_n.add(this.buttonScrollUp);
        this.buttonScrollUp.field_146128_h = this.field_147003_i + 8;
        this.buttonScrollUp.field_146129_i = this.field_147009_r + 72 - 64;
        this.field_146292_n.add(this.buttonScrollDown);
        this.buttonScrollDown.field_146128_h = this.field_147003_i + 8;
        this.buttonScrollDown.field_146129_i = this.field_147009_r + 72 + 66;
        this.field_146292_n.add(new GuiHoverButton((GuiScreen)this, 3, this.field_147003_i + 60, this.field_147009_r + 30, 32, 16, I18n.func_74838_a((String)"wandtable.text2"), null, new ResourceLocation("thaumcraft", "textures/gui/costxp.png")));
        this.field_146292_n.add(new GuiHoverButton((GuiScreen)this, 4, this.field_147003_i + 125, this.field_147009_r + 30, 32, 16, I18n.func_74838_a((String)"wandtable.text1"), null, new ResourceLocation("thaumcraft", "textures/gui/costvis.png")));
        this.shownParts.clear();
        AspectList crystals = new AspectList();
        this.components = null;
        if (this.table.func_70301_a(0) == null) {
            return;
        }
        ArrayList<String> pMed = new ArrayList<String>();
        ArrayList<String> pEff = new ArrayList<String>();
        ArrayList<String> pMod = new ArrayList<String>();
        block5: for (IFocusPart part : FocusHelper.focusParts.values()) {
            if (!ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)this.field_146297_k.field_71439_g, part.getResearch())) continue;
            if (this.table.data != null) {
                if (part.getType() == IFocusPart.EnumFocusPartType.MEDIUM && !this.table.data.hexes.get("0:0").isEmpty()) continue;
                for (String string : this.table.data.hexes.values()) {
                    if (!part.getKey().equals(string)) continue;
                    continue block5;
                }
            }
            switch (part.getType()) {
                case EFFECT: {
                    pEff.add(part.getKey());
                    break;
                }
                case MEDIUM: {
                    pMed.add(part.getKey());
                    break;
                }
                case MODIFIER: {
                    pMod.add(part.getKey());
                }
            }
        }
        Collections.sort(pMed);
        Collections.sort(pEff);
        Collections.sort(pMod);
        this.shownParts.addAll(pMed);
        this.shownParts.addAll(pEff);
        this.shownParts.addAll(pMod);
        boolean m = false;
        boolean e = false;
        boolean o = true;
        if (this.table.data != null) {
            for (String hexKey : this.table.data.hexes.keySet()) {
                IFocusPart part = FocusHelper.getFocusPart(this.table.data.hexes.get(hexKey));
                if (part == null) continue;
                crystals.add(part.getAspect(), 1);
                if (part.getType() == IFocusPart.EnumFocusPartType.MEDIUM) {
                    m = true;
                }
                if (part.getType() == IFocusPart.EnumFocusPartType.EFFECT) {
                    e = true;
                }
                HexUtils.Hex h = HexUtils.Hex.fromString(hexKey);
                int con = 0;
                for (int a = 0; a < 6; ++a) {
                    IFocusPart p1;
                    HexUtils.Hex target = h.getNeighbour(a);
                    String key = this.table.data.hexes.get(target.toString());
                    if (key == null || key.isEmpty() || !FocusHelper.canPartsConnect(p1 = FocusHelper.getFocusPart(key), part)) continue;
                    con = 1;
                    break;
                }
                if (con != 0) continue;
                o = false;
                break;
            }
            this.tempCore = this.table.calcCosts();
        }
        boolean bl2 = false;
        if (crystals.getAspects().length > 0) {
            boolean bl3 = true;
            this.components = new ItemStack[crystals.getAspects().length];
            int r = 0;
            for (Aspect as : crystals.getAspects()) {
                this.components[r] = ThaumcraftApiHelper.makeCrystal(as, crystals.getAmount(as));
                ++r;
            }
            if (this.components.length >= 0) {
                boolean[] owns = new boolean[this.components.length];
                for (int a = 0; a < this.components.length; ++a) {
                    owns[a] = InventoryUtils.isPlayerCarryingAmount((EntityPlayer)this.field_146297_k.field_71439_g, this.components[a], false);
                    if (owns[a]) continue;
                    bl = false;
                }
            }
            if (this.components != null && this.components.length > 0) {
                int i = 0;
                int q = 0;
                int z = 0;
                for (ItemStack stack : this.components) {
                    this.field_146292_n.add(new GuiHoverButton((GuiScreen)this, 11 + z, this.field_147003_i + 174 + i * 16, this.field_147009_r + 54 + 16 * q, 16, 16, stack.func_82833_r(), null, stack));
                    if (++i > 4) {
                        i = 0;
                        ++q;
                    }
                    ++z;
                }
            }
        }
        this.valid = bl && m && e && o && this.table.xpCost <= this.field_146297_k.field_71439_g.field_71068_ca;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        RenderHelper.func_74518_a();
        for (GuiButton guibutton : this.field_146292_n) {
            if (!guibutton.func_146115_a()) continue;
            guibutton.func_146111_b(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            break;
        }
        RenderHelper.func_74520_c();
    }

    protected void func_184098_a(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        super.func_184098_a(slotIn, slotId, mouseButton, type);
        if (this.draggedPart == null || this.draggedPart.isEmpty()) {
            this.gatherInfo();
        }
    }

    protected void func_73864_a(int mx, int my, int par3) {
        try {
            super.func_73864_a(mx, my, par3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int gx = (this.field_146294_l - this.field_146999_f) / 2;
        int gy = (this.field_146295_m - this.field_147000_g) / 2;
        HexUtils.Hex h = this.checkMouseOverHex(mx, my, gx, gy);
        if (this.table.vis <= 0.0f && this.table.data != null && h != null && !this.table.data.hexes.get(h.toString()).isEmpty()) {
            if (par3 == 0) {
                this.draggedPart = "" + this.table.data.hexes.get(h.toString());
                this.isMouseButtonDown = 1;
            }
            this.playSocketSound(0.8f);
            this.table.data.hexes.put(h.toString(), "");
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketFocusPlaceToServer((byte)h.q, (byte)h.r, this.table.func_174877_v(), ""));
            this.gatherInfo();
        }
    }

    private void playButtonClick() {
        this.field_146297_k.func_175606_aa().func_184185_a(SoundsTC.clack, 0.4f, 1.0f);
    }

    private void playSocketSound(float pitch) {
        this.field_146297_k.func_175606_aa().func_184185_a(SoundsTC.crystal, 0.4f, pitch);
    }

    protected void drawHoveringTextFixed(List listin, int x, int y, FontRenderer font, int width) {
        if (!listin.isEmpty()) {
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            ArrayList<String> list = new ArrayList<String>();
            for (Object o : listin) {
                String s = (String)o;
                s = this.trimStringNewline(s);
                List list2 = font.func_78271_c(s, width);
                for (String s1 : list2) {
                    list.add(s1);
                }
            }
            int k = 0;
            for (String s : list) {
                int l = font.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int j2 = x + 12;
            int k2 = y - 12;
            int i1 = 8;
            if (list.size() > 1) {
                i1 += 2 + (list.size() - 1) * 10;
            }
            this.field_73735_i = 300.0f;
            this.field_146296_j.field_77023_b = 300.0f;
            int j1 = -267386864;
            this.func_73733_a(j2 - 3, k2 - 4, j2 + k + 3, k2 - 3, j1, j1);
            this.func_73733_a(j2 - 3, k2 + i1 + 3, j2 + k + 3, k2 + i1 + 4, j1, j1);
            this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 + i1 + 3, j1, j1);
            this.func_73733_a(j2 - 4, k2 - 3, j2 - 3, k2 + i1 + 3, j1, j1);
            this.func_73733_a(j2 + k + 3, k2 - 3, j2 + k + 4, k2 + i1 + 3, j1, j1);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            this.func_73733_a(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + i1 + 3 - 1, k1, l1);
            this.func_73733_a(j2 + k + 2, k2 - 3 + 1, j2 + k + 3, k2 + i1 + 3 - 1, k1, l1);
            this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 - 3 + 1, k1, k1);
            this.func_73733_a(j2 - 3, k2 + i1 + 2, j2 + k + 3, k2 + i1 + 3, l1, l1);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String s1 = (String)list.get(i2);
                font.func_175063_a(s1, (float)j2, (float)k2, -1);
                if (i2 == 0) {
                    k2 += 2;
                }
                k2 += 10;
            }
            this.field_73735_i = 0.0f;
            this.field_146296_j.field_77023_b = 0.0f;
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
        }
    }

    private String trimStringNewline(String text) {
        while (text != null && text.endsWith("\n")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    private HexUtils.Hex checkMouseOverHex(int mx, int my, int gx, int gy) {
        int mouseX = mx - (gx + 96);
        int mouseY = my - (gy + 72);
        HexUtils.Hex hp = new HexUtils.Pixel(mouseX, mouseY).toHex(17);
        if (this.table.data != null && this.table.data.hexes.containsKey(hp.toString())) {
            return this.draggedPart != null && !this.validHex(hp, this.draggedPart) ? null : hp;
        }
        return null;
    }

    private boolean validHex(HexUtils.Hex hp, String part) {
        return part.isEmpty() || !(FocusHelper.getFocusPart(part).getType() == IFocusPart.EnumFocusPartType.MEDIUM ? hp.q != 0 || hp.r != 0 : hp.q == 0 && hp.r == 0);
    }

    public static void drawPart(IFocusPart part, int x, int y, float scale, int bright) {
        GL11.glPushMatrix();
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        GL11.glTranslated((double)x, (double)y, (double)0.0);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
        float bob = MathHelper.func_76126_a((float)((float)(Minecraft.func_71410_x().field_71439_g.field_70173_aa + x * y * 10) / 6.0f)) * 0.1f;
        Color color = new Color(part.getGemColor());
        float r = (float)color.getRed() / 255.0f * ((float)bright / 220.0f);
        float g = (float)color.getGreen() / 255.0f * ((float)bright / 220.0f);
        float b = (float)color.getBlue() / 255.0f * ((float)bright / 220.0f);
        switch (part.getType()) {
            case EFFECT: {
                UtilsFX.renderQuadCentered(iEffect, scale, r, g, b, 220, 771, 1.0f);
                break;
            }
            case MEDIUM: {
                UtilsFX.renderQuadCentered(iMedium, scale, r, g, b, 220, 771, 1.0f);
                break;
            }
            case MODIFIER: {
                UtilsFX.renderQuadCentered(iModifier, scale, r, g, b, 220, 771, 1.0f);
            }
        }
        color = new Color(part.getIconColor());
        r = (float)color.getRed() / 255.0f * ((float)bright / 220.0f);
        g = (float)color.getGreen() / 255.0f * ((float)bright / 220.0f);
        b = (float)color.getBlue() / 255.0f * ((float)bright / 220.0f);
        GL11.glTranslated((double)0.0, (double)0.0, (double)1.0);
        UtilsFX.renderQuadCentered(part.getIcon(), 16.0f, MathHelper.func_76131_a((float)(r + bob), (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)(g + bob), (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)(b + bob), (float)0.0f, (float)1.0f), bright, 1, 0.75f);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glPopMatrix();
    }

    private void drawHexLink(int x, int y, HexUtils.Hex hex1, HexUtils.Hex hex2, float opacity) {
        HexUtils.Pixel pix1 = hex1.toPixel(17);
        HexUtils.Pixel pix2 = hex2.toPixel(17);
        double xx = (pix1.x + pix2.x) / 2.0;
        double yy = (pix1.y + pix2.y) / 2.0;
        double theta = Math.atan2(pix1.y - pix2.y, pix1.x - pix2.x);
        double angle = Math.toDegrees(theta);
        if (angle < 0.0) {
            angle += 360.0;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)((double)(x + 96) + xx), (double)((double)(y + 72) + yy), (double)8.0);
        GL11.glRotated((double)angle, (double)0.0, (double)0.0, (double)1.0);
        GL11.glScaled((double)1.5, (double)1.0, (double)1.0);
        this.field_146297_k.field_71446_o.func_110577_a(ParticleEngine.particleTexture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        UtilsFX.renderQuadCentered(64, 64, 576 + (int)(128.0 + ((double)this.field_146297_k.func_175606_aa().field_70173_aa + xx + yy * 10.0) % 12.0), 7.0f, 0.75f, 0.125f, 1.0f, 220, 1, opacity);
        GL11.glPopMatrix();
    }

    private void drawHexHighlight(HexUtils.Hex hex, int x, int y) {
        GL11.glPushMatrix();
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        this.field_146297_k.field_71446_o.func_110577_a(this.texh2);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        HexUtils.Pixel pix = hex.toPixel(17);
        GL11.glTranslated((double)((double)x + pix.x), (double)((double)y + pix.y), (double)0.0);
        float bob = MathHelper.func_76126_a((float)((float)this.field_146297_k.field_71439_g.field_70173_aa / 3.0f));
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181711_k);
        int i = 200;
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        tessellator.func_178180_c().func_181662_b((double)(-15.0f - bob), (double)(15.0f + bob), (double)this.field_73735_i).func_187315_a(0.0, 1.0).func_187314_a(j, k).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(15.0f + bob), (double)(15.0f + bob), (double)this.field_73735_i).func_187315_a(1.0, 1.0).func_187314_a(j, k).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(15.0f + bob), (double)(-15.0f - bob), (double)this.field_73735_i).func_187315_a(1.0, 0.0).func_187314_a(j, k).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(-15.0f - bob), (double)(-15.0f - bob), (double)this.field_73735_i).func_187315_a(0.0, 0.0).func_187314_a(j, k).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
        tessellator.func_78381_a();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glPopMatrix();
    }
}

