/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.gui;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.ITCRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.crafting.Part;
import thaumcraft.api.crafting.RecipeMisc;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumcraft.api.internal.CommonInternals;
import thaumcraft.api.research.ResearchAddendum;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategory;
import thaumcraft.api.research.ResearchEntry;
import thaumcraft.api.research.ResearchStage;
import thaumcraft.client.gui.GuiResearchBrowser;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.client.lib.events.HudHandler;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.crafting.InfusionEnchantmentRecipe;
import thaumcraft.common.lib.crafting.InfusionRunicAugmentRecipe;
import thaumcraft.common.lib.crafting.Matrix;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.playerdata.PacketSyncProgressToServer;
import thaumcraft.common.lib.utils.InventoryUtils;
import thaumcraft.common.lib.utils.PosXY;

@SideOnly(value=Side.CLIENT)
public class GuiResearchPage
extends GuiScreen {
    public static LinkedList<String> history = new LinkedList();
    protected int paneWidth = 256;
    protected int paneHeight = 181;
    protected double guiMapX;
    protected double guiMapY;
    protected int mouseX = 0;
    protected int mouseY = 0;
    private GuiButton button;
    private ResearchEntry research;
    private int currentStage = 0;
    int lastStage = 0;
    boolean hold = false;
    private int page = 0;
    private int maxPages = 0;
    private int maxAspectPages = 0;
    AspectList knownPlayerAspects;
    IPlayerKnowledge playerKnowledge;
    int rhash = 0;
    float transX = 0.0f;
    float transY = 0.0f;
    float rotX = 0.0f;
    float rotY = 0.0f;
    float rotZ = 0.0f;
    long lastCheck = 0L;
    float pt;
    ResourceLocation tex1 = new ResourceLocation("thaumcraft", "textures/gui/gui_researchbook.png");
    ResourceLocation tex2 = new ResourceLocation("thaumcraft", "textures/gui/gui_researchbook_overlay.png");
    ResourceLocation tex3 = new ResourceLocation("thaumcraft", "textures/aspects/_back.png");
    ResourceLocation tex4 = new ResourceLocation("thaumcraft", "textures/gui/paper.png");
    ResourceLocation dummyResearch = new ResourceLocation("thaumcraft", "textures/aspects/_unknown.png");
    ResourceLocation dummyMap = new ResourceLocation("thaumcraft", "textures/research/rd_map.png");
    ResourceLocation dummyFlask = new ResourceLocation("thaumcraft", "textures/research/rd_flask.png");
    ResourceLocation dummyChest = new ResourceLocation("thaumcraft", "textures/research/rd_chest.png");
    int hrx = 0;
    int hry = 0;
    static String shownRecipe;
    int recipePage = 0;
    int recipePageMax = 0;
    private long lastCycle = 0L;
    private boolean showingAspects = false;
    private static int aspectsPage;
    LinkedHashMap<String, ArrayList> recipeLists = new LinkedHashMap();
    LinkedHashMap<String, ArrayList> recipeOutputs = new LinkedHashMap();
    LinkedHashMap<String, ArrayList> drilldownLists = new LinkedHashMap();
    boolean hasRecipePages;
    boolean renderingCompound = false;
    static boolean cycleMultiblockLines;
    BlueprintBlockAccess blockAccess = null;
    HashMap<String, BlueprintBlockAccess> blockAccessIcons = new HashMap();
    ArrayList<List> reference = new ArrayList();
    private int cycle = -1;
    boolean allowWithPagePopup = false;
    List tipText = null;
    private static final int PAGEWIDTH = 140;
    private static final int PAGEHEIGHT = 210;
    private static final PageImage PILINE;
    private static final PageImage PIDIV;
    private ArrayList<Page> pages = new ArrayList();
    boolean isComplete = false;
    boolean hasAllRequisites = false;
    boolean[] hasItem = null;
    boolean[] hasCraft = null;
    boolean[] hasResearch = null;
    boolean[] hasKnow = null;
    boolean[] hasStats = null;
    public HashMap<Integer, String> keyCache = new HashMap();

    public GuiResearchPage(ResearchEntry research, String recipe, double x, double y) {
        this.research = research;
        this.guiMapX = x;
        this.guiMapY = y;
        this.field_146297_k = Minecraft.func_71410_x();
        this.playerKnowledge = ThaumcraftCapabilities.getKnowledge((EntityPlayer)this.field_146297_k.field_71439_g);
        this.parsePages();
        this.knownPlayerAspects = new AspectList();
        for (Aspect a : Aspect.aspects.values()) {
            if (!ThaumcraftCapabilities.knowsResearch((EntityPlayer)this.field_146297_k.field_71439_g, "!" + a.getTag().toLowerCase())) continue;
            this.knownPlayerAspects.add(a, 1);
        }
        this.maxAspectPages = this.knownPlayerAspects != null ? MathHelper.func_76123_f((float)((float)this.knownPlayerAspects.size() / 5.0f)) : 0;
        this.page = 0;
        if (recipe != null) {
            shownRecipe = recipe;
        }
    }

    public void func_73866_w_() {
        this.rotX = 25.0f;
        this.rotY = -45.0f;
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.hasRecipePages = false;
        long nano = System.nanoTime();
        if (nano > this.lastCheck) {
            this.parsePages();
            this.lastCheck = this.hold ? nano + 250000000L : nano + 2000000000L;
            if (this.currentStage > this.lastStage) {
                this.hold = false;
            }
        }
        this.pt = par3;
        this.func_146276_q_();
        this.genResearchBackground(par1, par2, par3);
        int sw = (this.field_146294_l - this.paneWidth) / 2;
        int sh = (this.field_146295_m - this.paneHeight) / 2;
        if (!history.isEmpty()) {
            int mx = par1 - (sw + 118);
            int my = par2 - (sh + 190);
            if (mx >= 0 && my >= 0 && mx < 20 && my < 12) {
                this.field_146297_k.field_71466_p.func_175063_a(I18n.func_74838_a((String)"recipe.return"), (float)par1, (float)par2, 0xFFFFFF);
            }
        }
    }

    protected void genResearchBackground(int par1, int par2, float par3) {
        int sw = (this.field_146294_l - this.paneWidth) / 2;
        int sh = (this.field_146295_m - this.paneHeight) / 2;
        float var10 = ((float)this.field_146294_l - (float)this.paneWidth * 1.3f) / 2.0f;
        float var11 = ((float)this.field_146295_m - (float)this.paneHeight * 1.3f) / 2.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.tex1);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)var10, (float)var11, (float)0.0f);
        GL11.glScalef((float)1.3f, (float)1.3f, (float)1.0f);
        this.func_73729_b(0, 0, 0, 0, this.paneWidth, this.paneHeight);
        GL11.glPopMatrix();
        this.reference.clear();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        int current = 0;
        for (int a = 0; a < this.pages.size(); ++a) {
            if ((current == this.page || current == this.page + 1) && current < this.maxPages) {
                this.drawPage(this.pages.get(a), current % 2, sw, sh - 10, par1, par2);
            }
            if (++current > this.page + 1) break;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.tex1);
        float bob = MathHelper.func_76126_a((float)((float)this.field_146297_k.field_71439_g.field_70173_aa / 3.0f)) * 0.2f + 0.1f;
        if (!history.isEmpty()) {
            this.drawTexturedModalRectScaled(sw + 118, sh + 190, 38, 202, 20, 12, bob);
        }
        if (this.page > 0 && shownRecipe == null) {
            this.drawTexturedModalRectScaled(sw - 16, sh + 190, 0, 184, 12, 8, bob);
        }
        if (this.page < this.maxPages - 2 && shownRecipe == null) {
            this.drawTexturedModalRectScaled(sw + 262, sh + 190, 12, 184, 12, 8, bob);
        }
        if (this.tipText != null) {
            UtilsFX.drawCustomTooltip(this, this.field_146297_k.field_71466_p, this.tipText, par1, par2 + 12, 11);
            this.tipText = null;
        }
    }

    private void drawPage(Page pageParm, int side, int x, int y, int mx, int my) {
        ResearchStage stage;
        if (this.lastCycle < System.currentTimeMillis()) {
            ++this.cycle;
            this.lastCycle = System.currentTimeMillis() + 1000L;
            if (cycleMultiblockLines && this.blockAccess != null) {
                ++this.blockAccess.sliceLine;
            }
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (this.page == 0 && side == 0) {
            this.func_73729_b(x + 4, y - 7, 24, 184, 96, 4);
            this.func_73729_b(x + 4, y + 10, 24, 184, 96, 4);
            int offset = this.field_146297_k.field_71466_p.func_78256_a(this.research.getLocalizedName());
            if (offset <= 140) {
                this.field_146297_k.field_71466_p.func_78276_b(this.research.getLocalizedName(), x - 15 + 140 / 2 - offset / 2, y, 0x202020);
            } else {
                float vv = 140.0f / (float)offset;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)(x - 15 + 140 / 2) - (float)(offset / 2) * vv), (float)((float)y + 1.0f * vv), (float)0.0f);
                GL11.glScalef((float)vv, (float)vv, (float)vv);
                this.field_146297_k.field_71466_p.func_78276_b(this.research.getLocalizedName(), 0, 0, 0x202020);
                GL11.glPopMatrix();
            }
            y += 28;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        for (Object content : pageParm.contents) {
            if (content instanceof String) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                String ss = ((String)content).replace("\u00ef\u00bf\u00bd", "");
                this.field_146297_k.field_71466_p.func_78276_b(ss, x - 15 + side * 152, y - 6, 0);
                y += this.field_146297_k.field_71466_p.field_78288_b;
                if (!((String)content).endsWith("\u00ef\u00bf\u00bd")) continue;
                y = (int)((double)y + (double)this.field_146297_k.field_71466_p.field_78288_b * 0.66);
                continue;
            }
            if (!(content instanceof PageImage)) continue;
            PageImage pi = (PageImage)content;
            GL11.glPushMatrix();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(pi.loc);
            int pad = (140 - pi.aw) / 2;
            GL11.glTranslatef((float)(x - 15 + side * 152 + pad), (float)(y - 5), (float)0.0f);
            GL11.glScalef((float)pi.scale, (float)pi.scale, (float)pi.scale);
            this.func_73729_b(0, 0, pi.x, pi.y, pi.w, pi.h);
            GL11.glPopMatrix();
            y += pi.ah + 2;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (this.playerKnowledge.isResearchComplete("FIRSTSTEPS")) {
            y = (this.field_146295_m - this.paneHeight) / 2 + 9;
            this.field_146297_k.field_71446_o.func_110577_a(this.tex1);
            int le = this.mouseInside(x - 48, y, 25, 16, mx, my) ? 0 : 3;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawPopupAt(x - 48, y, 25, 16, mx, my, "tc.aspect.name");
            this.func_73729_b(x - 48 + le, y, 76, 232, 24 - le, 16);
            this.func_73729_b(x - 28, y, 100, 232, 4, 16);
        }
        if ((stage = this.research.getStages()[this.currentStage]).getRecipes() != null) {
            this.drawRecipeBookmarks(x, mx, my, stage);
        }
        if (this.page == 0 && side == 0 && !this.isComplete) {
            this.drawRequirements(x, mx, my, stage);
        }
        if (this.playerKnowledge.isResearchComplete("KNOWLEDGETYPES") && this.research.getKey().equals("KNOWLEDGETYPES")) {
            this.drawKnowledges(x, mx, my);
        }
        this.renderingCompound = false;
        if (this.showingAspects) {
            this.drawAspects(mx, my);
        } else if (shownRecipe != null) {
            this.drawRecipe(mx, my);
        } else if (stage.getWarp() > 0 && !this.isComplete) {
            int warp = stage.getWarp();
            if (warp > 5) {
                warp = 5;
            }
            GuiResearchBrowser.drawForbidden(x - 45, y - 20);
            String s = I18n.func_74838_a((String)("tc.forbidden.level." + warp));
            this.field_146297_k.field_71466_p.func_78276_b(s, x - 44 - this.field_146297_k.field_71466_p.func_78256_a(s) / 2, y - 23, 0xAA99FF);
            String text = I18n.func_74838_a((String)"tc.warp.warn");
            this.drawPopupAt(x - 55, y - 30, 20, 20, mx, my, text.replaceAll("%n", s));
        }
    }

    private void drawKnowledges(int x, int mx, int my) {
        int y = (this.field_146295_m - this.paneHeight) / 2 - 16 + 210;
        y -= 18;
        boolean drewSomething = false;
        int amt = this.playerKnowledge.getKnowledge(IPlayerKnowledge.EnumKnowledgeType.EPIPHANY, null);
        int par = this.playerKnowledge.getKnowledgeRaw(IPlayerKnowledge.EnumKnowledgeType.EPIPHANY, null) % IPlayerKnowledge.EnumKnowledgeType.EPIPHANY.getProgression();
        if (amt > 0) {
            drewSomething = true;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPushMatrix();
            this.field_146297_k.field_71446_o.func_110577_a(HudHandler.KNOW_TYPE[IPlayerKnowledge.EnumKnowledgeType.EPIPHANY.ordinal()]);
            GL11.glTranslatef((float)(x - 10), (float)y, (float)0.0f);
            GL11.glScaled((double)0.0625, (double)0.0625, (double)0.0625);
            this.func_73729_b(0, 0, 0, 0, 255, 255);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)5.0f);
            String s = "" + amt;
            int m = this.field_146297_k.field_71466_p.func_78256_a(s);
            this.field_146297_k.field_71466_p.func_175063_a(s, (float)(x - 10 + 16 - m), (float)(y + 8), 0xFFFFFF);
            s = I18n.func_74838_a((String)("tc.type." + IPlayerKnowledge.EnumKnowledgeType.EPIPHANY.toString().toLowerCase()));
            this.drawPopupAt(x - 10, y, mx, my, s);
            if (par > 0) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
                this.field_146297_k.field_71446_o.func_110577_a(this.tex1);
                int l = (int)((float)par / (float)IPlayerKnowledge.EnumKnowledgeType.EPIPHANY.getProgression() * 16.0f);
                this.func_73729_b(x - 10, y + 17, 0, 232, l, 2);
                this.func_73729_b(x - 10 + l, y + 17, l, 234, 16 - l, 2);
            }
            GL11.glPopMatrix();
            y -= 20;
        }
        int tc = 0;
        for (IPlayerKnowledge.EnumKnowledgeType type : IPlayerKnowledge.EnumKnowledgeType.values()) {
            int fc = 0;
            boolean b = false;
            for (ResearchCategory category : ResearchCategories.researchCategories.values()) {
                if (!type.hasFields() && category != null) continue;
                amt = this.playerKnowledge.getKnowledge(type, category);
                par = this.playerKnowledge.getKnowledgeRaw(type, category) % type.getProgression();
                if (amt <= 0 && par <= 0) continue;
                drewSomething = true;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPushMatrix();
                this.field_146297_k.field_71446_o.func_110577_a(HudHandler.KNOW_TYPE[type.ordinal()]);
                GL11.glTranslatef((float)(x - 10 + 18 * fc), (float)(y - tc * 20), (float)0.0f);
                GL11.glScaled((double)0.0625, (double)0.0625, (double)0.0625);
                this.func_73729_b(0, 0, 0, 0, 255, 255);
                if (type.hasFields() && category != null) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
                    this.field_146297_k.field_71446_o.func_110577_a(category.icon);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glScaled((double)0.66, (double)0.66, (double)0.66);
                    this.func_73729_b(66, 66, 0, 0, 255, 255);
                }
                GL11.glPopMatrix();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)5.0f);
                String s = "" + amt;
                int m = this.field_146297_k.field_71466_p.func_78256_a(s);
                this.field_146297_k.field_71466_p.func_175063_a(s, (float)(x - 10 + 16 - m + 18 * fc), (float)(y - tc * 20 + 8), 0xFFFFFF);
                s = I18n.func_74838_a((String)("tc.type." + type.toString().toLowerCase()));
                if (type.hasFields() && category != null) {
                    s = s + ": " + ResearchCategories.getCategoryName(category.key);
                }
                this.drawPopupAt(x - 10 + 18 * fc, y - tc * 20, mx, my, s);
                if (par > 0) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
                    this.field_146297_k.field_71446_o.func_110577_a(this.tex1);
                    int l = (int)((float)par / (float)type.getProgression() * 16.0f);
                    this.func_73729_b(x - 10 + 18 * fc, y + 17 - tc * 20, 0, 232, l, 2);
                    this.func_73729_b(x - 10 + 18 * fc + l, y + 17 - tc * 20, l, 234, 16 - l, 2);
                }
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-5.0f);
                ++fc;
                b = true;
            }
            if (!b) continue;
            ++tc;
        }
        if (drewSomething) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(this.tex1);
            this.func_73729_b(x + 4, y - tc * 20 + 12, 24, 184, 96, 8);
        }
    }

    private void drawRequirements(int x, int mx, int my, ResearchStage stage) {
        int idx;
        int shift;
        int y = (this.field_146295_m - this.paneHeight) / 2 - 16 + 210;
        GL11.glPushMatrix();
        boolean b = false;
        if (stage.getResearch() != null) {
            b = true;
            shift = 24;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
            this.field_146297_k.field_71446_o.func_110577_a(this.tex1);
            this.func_73729_b(x - 12, (y -= 18) - 1, 200, 232, 56, 16);
            this.drawPopupAt(x - 15, y, mx, my, "tc.need.research");
            Object loc = null;
            if (this.hasResearch != null) {
                if (this.hasResearch.length != stage.getResearch().length) {
                    this.hasResearch = new boolean[stage.getResearch().length];
                }
                int ss = 18;
                if (stage.getResearch().length > 6) {
                    ss = 110 / stage.getResearch().length;
                }
                for (int a = 0; a < stage.getResearch().length; ++a) {
                    String k;
                    Aspect as;
                    String key = stage.getResearch()[a];
                    loc = this.dummyResearch;
                    String text = I18n.func_74838_a((String)("research." + key + ".text"));
                    if (key.startsWith("!") && (as = Aspect.aspects.get(k = key.replaceAll("!", ""))) != null) {
                        loc = as;
                        text = as.getName();
                    }
                    ResearchEntry re = ResearchCategories.getResearch(key);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (re != null && re.getIcons() != null) {
                        int idx2 = (int)(System.currentTimeMillis() / 1000L % (long)re.getIcons().length);
                        loc = re.getIcons()[idx2];
                        text = re.getLocalizedName();
                    } else if (key.startsWith("m_")) {
                        loc = this.dummyMap;
                    } else if (key.startsWith("c_")) {
                        loc = this.dummyChest;
                    } else if (key.startsWith("f_")) {
                        loc = this.dummyFlask;
                    } else {
                        GlStateManager.func_179131_c((float)0.5f, (float)0.75f, (float)1.0f, (float)1.0f);
                    }
                    GL11.glPushMatrix();
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    if (loc instanceof Aspect) {
                        this.field_146297_k.field_71446_o.func_110577_a(((Aspect)loc).getImage());
                        Color cc = new Color(((Aspect)loc).getColor());
                        GlStateManager.func_179131_c((float)((float)cc.getRed() / 255.0f), (float)((float)cc.getGreen() / 255.0f), (float)((float)cc.getBlue() / 255.0f), (float)1.0f);
                        UtilsFX.drawTexturedQuadFull(x - 15 + shift, y, this.field_73735_i);
                    } else if (loc instanceof ResourceLocation) {
                        this.field_146297_k.field_71446_o.func_110577_a(loc);
                        UtilsFX.drawTexturedQuadFull(x - 15 + shift, y, this.field_73735_i);
                    } else if (loc instanceof ItemStack) {
                        RenderHelper.func_74520_c();
                        GL11.glDisable((int)2896);
                        GL11.glEnable((int)32826);
                        GL11.glEnable((int)2903);
                        GL11.glEnable((int)2896);
                        this.field_146296_j.func_180450_b(InventoryUtils.cycleItemStack(loc), x - 15 + shift, y);
                        GL11.glDisable((int)2896);
                        GL11.glDepthMask((boolean)true);
                        GL11.glEnable((int)2929);
                    }
                    GL11.glPopMatrix();
                    if (this.hasResearch[a]) {
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        this.field_146297_k.field_71446_o.func_110577_a(this.tex1);
                        GlStateManager.func_179097_i();
                        this.func_73729_b(x - 15 + shift + 8, y, 159, 207, 10, 10);
                        GlStateManager.func_179126_j();
                    }
                    this.drawPopupAt(x - 15 + shift, y, mx, my, text);
                    shift += ss;
                }
            }
        }
        if (stage.getObtain() != null) {
            b = true;
            shift = 24;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
            this.field_146297_k.field_71446_o.func_110577_a(this.tex1);
            this.func_73729_b(x - 12, (y -= 18) - 1, 200, 216, 56, 16);
            this.drawPopupAt(x - 15, y, mx, my, "tc.need.obtain");
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.hasItem != null) {
                if (this.hasItem.length != stage.getObtain().length) {
                    this.hasItem = new boolean[stage.getObtain().length];
                }
                int ss = 18;
                if (stage.getObtain().length > 6) {
                    ss = 110 / stage.getObtain().length;
                }
                for (idx = 0; idx < stage.getObtain().length; ++idx) {
                    ItemStack stack = stage.getObtain()[idx];
                    this.drawStackAt(stack, x - 15 + shift, y, mx, my, true);
                    if (this.hasItem[idx]) {
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        this.field_146297_k.field_71446_o.func_110577_a(this.tex1);
                        GlStateManager.func_179097_i();
                        this.func_73729_b(x - 15 + shift + 8, y, 159, 207, 10, 10);
                        GlStateManager.func_179126_j();
                    }
                    shift += ss;
                }
            }
        }
        if (stage.getCraft() != null) {
            b = true;
            shift = 24;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
            this.field_146297_k.field_71446_o.func_110577_a(this.tex1);
            this.func_73729_b(x - 12, (y -= 18) - 1, 200, 200, 56, 16);
            this.drawPopupAt(x - 15, y, mx, my, "tc.need.craft");
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.hasCraft != null) {
                if (this.hasCraft.length != stage.getCraft().length) {
                    this.hasCraft = new boolean[stage.getCraft().length];
                }
                int ss = 18;
                if (stage.getCraft().length > 6) {
                    ss = 110 / stage.getCraft().length;
                }
                for (idx = 0; idx < stage.getCraft().length; ++idx) {
                    ItemStack stack = stage.getCraft()[idx];
                    this.drawStackAt(stack, x - 15 + shift, y, mx, my, true);
                    if (this.hasCraft[idx]) {
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        this.field_146297_k.field_71446_o.func_110577_a(this.tex1);
                        GlStateManager.func_179097_i();
                        this.func_73729_b(x - 15 + shift + 8, y, 159, 207, 10, 10);
                        GlStateManager.func_179126_j();
                    }
                    shift += ss;
                }
            }
        }
        if (stage.getKnow() != null) {
            b = true;
            shift = 24;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
            this.field_146297_k.field_71446_o.func_110577_a(this.tex1);
            this.func_73729_b(x - 12, (y -= 18) - 1, 200, 184, 56, 16);
            this.drawPopupAt(x - 15, y, mx, my, "tc.need.know");
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.hasKnow != null) {
                if (this.hasKnow.length != stage.getKnow().length) {
                    this.hasKnow = new boolean[stage.getKnow().length];
                }
                int ss = 18;
                if (stage.getKnow().length > 6) {
                    ss = 110 / stage.getKnow().length;
                }
                for (idx = 0; idx < stage.getKnow().length; ++idx) {
                    ResearchStage.Knowledge kn = stage.getKnow()[idx];
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glPushMatrix();
                    this.field_146297_k.field_71446_o.func_110577_a(HudHandler.KNOW_TYPE[kn.type.ordinal()]);
                    GL11.glTranslatef((float)(x - 15 + shift), (float)y, (float)0.0f);
                    GL11.glScaled((double)0.0625, (double)0.0625, (double)0.0625);
                    this.func_73729_b(0, 0, 0, 0, 255, 255);
                    if (kn.type.hasFields() && kn.category != null) {
                        this.field_146297_k.field_71446_o.func_110577_a(kn.category.icon);
                        GL11.glTranslatef((float)32.0f, (float)32.0f, (float)1.0f);
                        GL11.glPushMatrix();
                        GL11.glScaled((double)0.75, (double)0.75, (double)0.75);
                        this.func_73729_b(0, 0, 0, 0, 255, 255);
                        GL11.glPopMatrix();
                    }
                    GL11.glPopMatrix();
                    String am = "" + (!this.hasKnow[idx] ? TextFormatting.RED : "") + kn.amount;
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)(x - 15 + shift + 16 - this.field_146297_k.field_71466_p.func_78256_a(am) / 2), (float)(y + 12), (float)5.0f);
                    GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                    this.field_146297_k.field_71466_p.func_175063_a(am, 0.0f, 0.0f, 0xFFFFFF);
                    GL11.glPopMatrix();
                    if (this.hasKnow[idx]) {
                        GL11.glPushMatrix();
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)1.0f);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        this.field_146297_k.field_71446_o.func_110577_a(this.tex1);
                        this.func_73729_b(x - 15 + shift + 8, y, 159, 207, 10, 10);
                        GL11.glPopMatrix();
                    }
                    String s = I18n.func_74838_a((String)("tc.type." + kn.type.toString().toLowerCase()));
                    if (kn.type.hasFields() && kn.category != null) {
                        s = s + ": " + ResearchCategories.getCategoryName(kn.category.key);
                    }
                    this.drawPopupAt(x - 15 + shift, y, mx, my, s);
                    shift += ss;
                }
            }
        }
        if (b) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(this.tex1);
            this.func_73729_b(x + 4, (y -= 12) - 2, 24, 184, 96, 8);
            if (this.hasAllRequisites) {
                this.hrx = x + 20;
                this.hry = y - 6;
                if (this.hold) {
                    String s = I18n.func_74838_a((String)"tc.stage.hold");
                    int m = this.field_146297_k.field_71466_p.func_78256_a(s);
                    this.field_146297_k.field_71466_p.func_175063_a(s, (float)(x + 52) - (float)m / 2.0f, (float)(y - 4), 0xFFFFFF);
                } else {
                    if (this.mouseInside(this.hrx, this.hry, 64, 12, mx, my)) {
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    } else {
                        GlStateManager.func_179131_c((float)0.8f, (float)0.8f, (float)0.9f, (float)1.0f);
                    }
                    this.field_146297_k.field_71446_o.func_110577_a(this.tex1);
                    this.func_73729_b(this.hrx, this.hry, 84, 216, 64, 12);
                    String s = I18n.func_74838_a((String)"tc.stage.complete");
                    int m = this.field_146297_k.field_71466_p.func_78256_a(s);
                    this.field_146297_k.field_71466_p.func_175063_a(s, (float)(x + 52) - (float)m / 2.0f, (float)(y - 4), 0xFFFFFF);
                }
            }
        }
        GL11.glPopMatrix();
    }

    private void drawRecipeBookmarks(int x, int mx, int my, ResearchStage stage) {
        Random rng = new Random(this.rhash);
        GL11.glPushMatrix();
        int y = (this.field_146295_m - this.paneHeight) / 2 + 4;
        this.allowWithPagePopup = true;
        for (String rk : this.recipeOutputs.keySet()) {
            int i;
            List list = this.recipeOutputs.get(rk);
            if (list == null || list.size() <= 0 || list.get(i = this.cycle % list.size()) == null) continue;
            int sh = rng.nextInt(3);
            int le = rng.nextInt(3) + (this.mouseInside(x + 280, y - 1, 30, 16, mx, my) ? 0 : 3);
            this.field_146297_k.field_71446_o.func_110577_a(this.tex1);
            if (rk.equals(shownRecipe)) {
                GlStateManager.func_179131_c((float)1.0f, (float)0.5f, (float)0.5f, (float)1.0f);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            this.func_73729_b(x + 280 + sh, y - 1, 120 + le, 232, 28, 16);
            this.func_73729_b(x + 280 + sh, y - 1, 116, 232, 4, 16);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            UtilsFX.hideStackOverlay = true;
            if (list.get(i) instanceof ItemStack) {
                this.drawStackAt((ItemStack)list.get(i), x + 287 + sh - le, y - 1, mx, my, false);
            } else if (list.get(i) instanceof Part[][][]) {
                BlueprintBlockAccess ba = this.blockAccessIcons.get(rk + i);
                if (ba == null) {
                    ba = new BlueprintBlockAccess((Part[][][])list.get(i), true);
                    this.blockAccessIcons.put(rk + i, ba);
                }
                int h = ((Part[][][])list.get(i)).length;
                this.renderBluePrint(ba, x + 295 + sh - le, y + 6 + h, 4.0f, (Part[][][])list.get(i), -5000, -5000, null);
            }
            UtilsFX.hideStackOverlay = false;
            y += 24;
        }
        this.allowWithPagePopup = false;
        GL11.glPopMatrix();
    }

    private void generateRecipesLists(ResearchStage stage, ResearchAddendum[] addenda) {
        this.recipeLists.clear();
        this.recipeOutputs.clear();
        if (stage == null || stage.getRecipes() == null) {
            return;
        }
        for (String rk : stage.getRecipes()) {
            this.addRecipesToList(rk, this.recipeLists, this.recipeOutputs);
        }
        if (addenda == null) {
            return;
        }
        for (ResearchAddendum addendum : addenda) {
            if (addendum.getRecipes() == null || !ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)this.field_146297_k.field_71439_g, addendum.getResearch())) continue;
            for (String rk : addendum.getRecipes()) {
                this.addRecipesToList(rk, this.recipeLists, this.recipeOutputs);
            }
        }
    }

    private void addRecipesToList(String rk, LinkedHashMap<String, ArrayList> recipeLists2, LinkedHashMap<String, ArrayList> recipeOutputs2) {
        Object recipes = CommonInternals.getCatalogRecipe(rk);
        if (recipes != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            ArrayList<Object> outputs = new ArrayList<Object>();
            if (recipes instanceof ThaumcraftApi.BluePrint[]) {
                ThaumcraftApi.BluePrint[] r;
                for (ThaumcraftApi.BluePrint re : r = (ThaumcraftApi.BluePrint[])recipes) {
                    if (!ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)this.field_146297_k.field_71439_g, re.getResearch())) continue;
                    list.add(re);
                    if (re.getDisplayStack() != null) {
                        outputs.add(re.getDisplayStack());
                        continue;
                    }
                    outputs.add(re.getParts());
                }
            } else if (recipes instanceof CrucibleRecipe[]) {
                CrucibleRecipe[] r;
                for (CrucibleRecipe re : r = (CrucibleRecipe[])recipes) {
                    ItemStack is = InventoryUtils.cycleItemStack(re.catalyst, 0);
                    if (is == null || !ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)this.field_146297_k.field_71439_g, re.research)) continue;
                    list.add(re);
                    outputs.add(re.getRecipeOutput());
                }
            } else if (recipes instanceof InfusionRecipe[]) {
                InfusionRecipe[] r;
                for (InfusionRecipe re : r = (InfusionRecipe[])recipes) {
                    ItemStack is = null;
                    if (re instanceof InfusionEnchantmentRecipe) {
                        is = InventoryUtils.cycleItemStack(re.getRecipeOutput((EntityPlayer)this.field_146297_k.field_71439_g, (ItemStack)re.getRecipeInput(), null), 0);
                    } else if (re instanceof InfusionRunicAugmentRecipe) {
                        ArrayList<ItemStack> cl = new ArrayList<ItemStack>(Arrays.asList(((InfusionRunicAugmentRecipe)re).getComponents((ItemStack)re.getRecipeInput())));
                        is = InventoryUtils.cycleItemStack(re.getRecipeOutput((EntityPlayer)this.field_146297_k.field_71439_g, (ItemStack)re.getRecipeInput(), cl), 0);
                    } else if (re.getRecipeOutput() instanceof ItemStack) {
                        is = InventoryUtils.cycleItemStack(re.getRecipeOutput(), 0);
                    } else {
                        is = InventoryUtils.cycleItemStack(re.getRecipeInput()).func_77946_l();
                        try {
                            Object[] obj = (Object[])re.getRecipeOutput();
                            NBTBase tag = (NBTBase)obj[1];
                            is.func_77983_a((String)obj[0], tag);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (is == null || !ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)this.field_146297_k.field_71439_g, re.research)) continue;
                    list.add(re);
                    outputs.add(is);
                }
            } else if (recipes instanceof IArcaneRecipe[]) {
                IArcaneRecipe[] r;
                for (IArcaneRecipe re : r = (IArcaneRecipe[])recipes) {
                    ItemStack is = InventoryUtils.cycleItemStack(re.func_77571_b(), 0);
                    if (is == null || !ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)this.field_146297_k.field_71439_g, re.getResearch())) continue;
                    list.add(re);
                    outputs.add(re.func_77571_b());
                }
            } else if (recipes instanceof IRecipe[]) {
                IRecipe[] r;
                for (IRecipe re : r = (IRecipe[])recipes) {
                    list.add(re);
                    outputs.add(re.func_77571_b());
                }
            } else if (recipes instanceof RecipeMisc[]) {
                RecipeMisc[] r;
                for (RecipeMisc re : r = (RecipeMisc[])recipes) {
                    list.add(re);
                    outputs.add(re.getOutput());
                }
            }
            if (list.size() > 0) {
                recipeLists2.put(rk, list);
                if (recipeOutputs2 != null) {
                    recipeOutputs2.put(rk, outputs);
                }
            }
        }
    }

    private void drawRecipe(int mx, int my) {
        this.allowWithPagePopup = true;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.tex4);
        int x = (this.field_146294_l - 256) / 2;
        int y = (this.field_146295_m - 256) / 2;
        GlStateManager.func_179097_i();
        this.func_73729_b(x, y, 0, 0, 255, 255);
        GlStateManager.func_179126_j();
        List list = this.recipeLists.get(shownRecipe);
        if (list == null || list.size() == 0) {
            list = this.drilldownLists.get(shownRecipe);
        }
        if (list != null && list.size() > 0) {
            Object recipe;
            this.hasRecipePages = list.size() > 1;
            this.recipePageMax = list.size() - 1;
            if (this.recipePage > this.recipePageMax) {
                this.recipePage = this.recipePageMax;
            }
            if ((recipe = list.get(this.recipePage % list.size())) != null) {
                if (recipe instanceof IArcaneRecipe) {
                    this.drawArcaneCraftingPage(x + 128, y + 128, mx, my, (IArcaneRecipe)recipe);
                } else if (recipe instanceof IRecipe) {
                    this.drawCraftingPage(x + 128, y + 128, mx, my, (IRecipe)recipe);
                } else if (recipe instanceof CrucibleRecipe) {
                    this.drawCruciblePage(x + 128, y + 128, mx, my, (CrucibleRecipe)recipe);
                } else if (recipe instanceof InfusionRecipe) {
                    this.drawInfusionPage(x + 128, y + 128, mx, my, (InfusionRecipe)recipe);
                } else if (recipe instanceof ThaumcraftApi.BluePrint) {
                    this.drawCompoundCraftingPage(x + 128, y + 128, mx, my, (ThaumcraftApi.BluePrint)recipe);
                    this.renderingCompound = true;
                }
            }
            if (this.hasRecipePages) {
                this.field_146297_k.field_71446_o.func_110577_a(this.tex1);
                float bob = MathHelper.func_76126_a((float)((float)this.field_146297_k.field_71439_g.field_70173_aa / 3.0f)) * 0.2f + 0.1f;
                if (this.recipePage > 0) {
                    this.drawTexturedModalRectScaled(x + 40, y + 232, 0, 184, 12, 8, bob);
                }
                if (this.recipePage < this.recipePageMax) {
                    this.drawTexturedModalRectScaled(x + 204, y + 232, 12, 184, 12, 8, bob);
                }
            }
        }
        this.allowWithPagePopup = false;
    }

    private void drawCompoundCraftingPage(int x, int y, int mx, int my, ThaumcraftApi.BluePrint recipe) {
        if (recipe.getParts() == null) {
            return;
        }
        if (this.blockAccess == null) {
            this.blockAccess = new BlueprintBlockAccess(recipe.getParts(), false);
        }
        int ySize = recipe.getParts().length;
        int xSize = recipe.getParts()[0].length;
        int zSize = recipe.getParts()[0][0].length;
        String text = I18n.func_74838_a((String)"recipe.type.construct");
        int offset = this.field_146297_k.field_71466_p.func_78256_a(text);
        this.field_146297_k.field_71466_p.func_78276_b(text, x - offset / 2, y - 104, 0x505050);
        int s = Math.max(Math.max(xSize, zSize), ySize) * 2;
        float scale = 38 - s;
        this.renderBluePrint(this.blockAccess, x, y, scale, recipe.getParts(), mx, my, recipe.getIngredientList());
        this.field_146297_k.field_71446_o.func_110577_a(this.tex1);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.mouseInside(x + 80, y + 100, 8, 8, mx, my) ? 1.0f : 0.75f));
        this.func_73729_b(x + 80, y + 100, cycleMultiblockLines ? 168 : 160, 224, 8, 8);
    }

    private void renderBluePrint(BlueprintBlockAccess ba, int x, int y, float scale, Part[][][] blueprint, int mx, int my, ItemStack[] ingredients) {
        BlockRendererDispatcher blockRender = Minecraft.func_71410_x().func_175602_ab();
        int ySize = blueprint.length;
        int xSize = blueprint[0].length;
        int zSize = blueprint[0][0].length;
        this.transX = x - xSize / 2;
        this.transY = (float)y - (float)Math.sqrt(ySize * ySize + xSize * xSize + zSize * zSize) / 2.0f;
        GlStateManager.func_179091_B();
        GlStateManager.func_179094_E();
        RenderHelper.func_74518_a();
        GlStateManager.func_179109_b((float)this.transX, (float)this.transY, (float)Math.max(ySize, Math.max(xSize, zSize)));
        GlStateManager.func_179152_a((float)scale, (float)(-scale), (float)1.0f);
        GlStateManager.func_179114_b((float)this.rotX, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.rotY, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)((float)zSize / -2.0f), (float)((float)ySize / -2.0f), (float)((float)xSize / -2.0f));
        GlStateManager.func_179140_f();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        ArrayList blocks = new ArrayList();
        for (int h = 0; h < ySize; ++h) {
            for (int l = 0; l < xSize; ++l) {
                for (int w = 0; w < zSize; ++w) {
                    BlockPos pos = new BlockPos(l, h, w);
                    if (ba.func_175623_d(pos)) continue;
                    GlStateManager.func_179109_b((float)l, (float)h, (float)w);
                    GlStateManager.func_179109_b((float)(-l), (float)(-h), (float)(-w));
                    IBlockState state = ba.func_180495_p(pos);
                    Tessellator tessellator = Tessellator.func_178181_a();
                    VertexBuffer buffer = tessellator.func_178180_c();
                    buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                    boolean b = blockRender.func_175018_a(state, pos, (IBlockAccess)ba, buffer);
                    tessellator.func_78381_a();
                    try {
                        if (b || !state.func_177230_c().hasTileEntity(state)) continue;
                        TileEntity te = state.func_177230_c().createTileEntity((World)this.field_146297_k.field_71441_e, state);
                        RenderHelper.func_74519_b();
                        int i = 250;
                        int j = i % 65536;
                        int k = i / 65536;
                        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        TileEntityRendererDispatcher.field_147556_a.func_147549_a(te, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), this.field_146297_k.func_184121_ak());
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        GlStateManager.func_179121_F();
        if (ingredients != null) {
            for (int a = 0; a < ingredients.length; ++a) {
                if (ingredients[a] == null || ingredients[a].func_77973_b() == null) continue;
                RenderHelper.func_74520_c();
                GL11.glDisable((int)2896);
                GL11.glEnable((int)32826);
                GL11.glEnable((int)2903);
                GL11.glEnable((int)2896);
                this.drawStackAt(ingredients[a], x - 85 + a * 17, y + 90, mx, my, true);
                GL11.glDisable((int)2896);
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)2929);
            }
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179147_l();
        RenderHelper.func_74518_a();
    }

    private void drawAspects(int mx, int my) {
        this.allowWithPagePopup = true;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.tex4);
        int x = (this.field_146294_l - 256) / 2;
        int y = (this.field_146295_m - 256) / 2;
        GlStateManager.func_179097_i();
        this.func_73729_b(x, y, 0, 0, 255, 255);
        GlStateManager.func_179126_j();
        this.drawAspectPage(x + 60, y + 24, mx, my);
        this.allowWithPagePopup = false;
    }

    private void drawAspectPage(int x, int y, int mx, int my) {
        if (this.knownPlayerAspects != null && this.knownPlayerAspects.size() > 0) {
            GL11.glPushMatrix();
            int mposx = mx;
            int mposy = my;
            int count = -1;
            int start = aspectsPage * 5;
            for (Aspect aspect : this.knownPlayerAspects.getAspectsSortedByName()) {
                if (++count < start) continue;
                if (count > start + 4) break;
                if (aspect.getImage() == null) continue;
                int tx = x;
                int ty = y + count % 5 * 40;
                if (mposx >= tx && mposy >= ty && mposx < tx + 40 && mposy < ty + 40) {
                    this.field_146297_k.field_71446_o.func_110577_a(this.tex3);
                    GL11.glPushMatrix();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179112_b((int)770, (int)771);
                    GL11.glTranslated((double)(x - 2), (double)(y + count % 5 * 40 - 2), (double)0.0);
                    GL11.glScaled((double)2.0, (double)2.0, (double)0.0);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                    UtilsFX.drawTexturedQuadFull(0.0f, 0.0f, this.field_73735_i);
                    GL11.glPopMatrix();
                }
                GL11.glPushMatrix();
                GL11.glTranslated((double)(x + 2), (double)(y + 2 + count % 5 * 40), (double)0.0);
                GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
                UtilsFX.drawTag(0, 0, aspect, 0.0f, 0, this.field_73735_i);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslated((double)(x + 16), (double)(y + 29 + count % 5 * 40), (double)0.0);
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                String text = aspect.getName();
                int offset = this.field_146297_k.field_71466_p.func_78256_a(text) / 2;
                this.field_146297_k.field_71466_p.func_78276_b(text, -offset, 0, 0x505050);
                GL11.glPopMatrix();
                if (aspect.getComponents() != null) {
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)(x + 60), (double)(y + 4 + count % 5 * 40), (double)0.0);
                    GL11.glScalef((float)1.25f, (float)1.25f, (float)1.25f);
                    if (this.playerKnowledge.isResearchKnown("!" + aspect.getComponents()[0].getTag().toLowerCase())) {
                        UtilsFX.drawTag(0, 0, aspect.getComponents()[0], 0.0f, 0, this.field_73735_i);
                    } else {
                        this.field_146297_k.field_71446_o.func_110577_a(this.dummyResearch);
                        GlStateManager.func_179131_c((float)0.8f, (float)0.8f, (float)0.8f, (float)1.0f);
                        UtilsFX.drawTexturedQuadFull(0.0f, 0.0f, this.field_73735_i);
                    }
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)(x + 102), (double)(y + 4 + count % 5 * 40), (double)0.0);
                    GL11.glScalef((float)1.25f, (float)1.25f, (float)1.25f);
                    if (this.playerKnowledge.isResearchKnown("!" + aspect.getComponents()[1].getTag().toLowerCase())) {
                        UtilsFX.drawTag(0, 0, aspect.getComponents()[1], 0.0f, 0, this.field_73735_i);
                    } else {
                        this.field_146297_k.field_71446_o.func_110577_a(this.dummyResearch);
                        GlStateManager.func_179131_c((float)0.8f, (float)0.8f, (float)0.8f, (float)1.0f);
                        UtilsFX.drawTexturedQuadFull(0.0f, 0.0f, this.field_73735_i);
                    }
                    GL11.glPopMatrix();
                    if (this.playerKnowledge.isResearchKnown("!" + aspect.getComponents()[0].getTag().toLowerCase())) {
                        text = aspect.getComponents()[0].getName();
                        offset = this.field_146297_k.field_71466_p.func_78256_a(text) / 2;
                        GL11.glPushMatrix();
                        GL11.glTranslated((double)(x + 22 + 50), (double)(y + 29 + count % 5 * 40), (double)0.0);
                        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                        this.field_146297_k.field_71466_p.func_78276_b(text, -offset, 0, 0x505050);
                        GL11.glPopMatrix();
                    }
                    if (this.playerKnowledge.isResearchKnown("!" + aspect.getComponents()[1].getTag().toLowerCase())) {
                        text = aspect.getComponents()[1].getName();
                        offset = this.field_146297_k.field_71466_p.func_78256_a(text) / 2;
                        GL11.glPushMatrix();
                        GL11.glTranslated((double)(x + 22 + 92), (double)(y + 29 + count % 5 * 40), (double)0.0);
                        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                        this.field_146297_k.field_71466_p.func_78276_b(text, -offset, 0, 0x505050);
                        GL11.glPopMatrix();
                    }
                    this.field_146297_k.field_71466_p.func_78276_b("=", x + 9 + 32, y + 12 + count % 5 * 40, 0x999999);
                    this.field_146297_k.field_71466_p.func_78276_b("+", x + 10 + 79, y + 12 + count % 5 * 40, 0x999999);
                    continue;
                }
                this.field_146297_k.field_71466_p.func_78276_b(I18n.func_74838_a((String)"tc.aspect.primal"), x + 54, y + 12 + count % 5 * 40, 0x777777);
            }
            this.field_146297_k.field_71446_o.func_110577_a(this.tex1);
            float bob = MathHelper.func_76126_a((float)((float)this.field_146297_k.field_71439_g.field_70173_aa / 3.0f)) * 0.2f + 0.1f;
            if (aspectsPage > 0) {
                this.drawTexturedModalRectScaled(x - 20, y + 208, 0, 184, 12, 8, bob);
            }
            if (aspectsPage < this.maxAspectPages - 1) {
                this.drawTexturedModalRectScaled(x + 144, y + 208, 12, 184, 12, 8, bob);
            }
            GL11.glPopMatrix();
        }
    }

    private void drawArcaneCraftingPage(int x, int y, int mx, int my, IArcaneRecipe recipe) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glPushMatrix();
        this.field_146297_k.field_71446_o.func_110577_a(this.tex2);
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
        this.func_73729_b(-26, -26, 112, 15, 52, 52);
        this.func_73729_b(-8, -46, 20, 3, 16, 16);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
        this.func_73729_b(-6, 40, 68, 76, 12, 12);
        GL11.glPopMatrix();
        String text = "" + recipe.getVis();
        int offset = this.field_146297_k.field_71466_p.func_78256_a(text);
        this.field_146297_k.field_71466_p.func_78276_b(text, x - offset / 2, y + 90, 0x505050);
        this.drawPopupAt(x - offset / 2 - 15, y + 75, 30, 30, mx, my, "wandtable.text1");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslated((double)0.0, (double)0.0, (double)100.0);
        this.drawStackAt(InventoryUtils.cycleItemStack(recipe.func_77571_b(), 0), x - 8, y - 84, mx, my, false);
        ItemStack[] crystals = recipe.getCrystals();
        if (crystals != null) {
            int a = 0;
            int sz = crystals.length;
            for (ItemStack crystal : crystals) {
                this.drawStackAt(InventoryUtils.cycleItemStack(crystal, a), x + 4 - sz * 10 + a * 20, y + 59, mx, my, true);
                ++a;
            }
        }
        if (recipe != null && recipe instanceof ShapedArcaneRecipe) {
            text = I18n.func_74838_a((String)"recipe.type.arcane");
            offset = this.field_146297_k.field_71466_p.func_78256_a(text);
            this.field_146297_k.field_71466_p.func_78276_b(text, x - offset / 2, y - 104, 0x505050);
            int rw = ((ShapedArcaneRecipe)recipe).width;
            int rh = ((ShapedArcaneRecipe)recipe).height;
            Object[] items = ((ShapedArcaneRecipe)recipe).getInput();
            for (int i = 0; i < rw && i < 3; ++i) {
                for (int j = 0; j < rh && j < 3; ++j) {
                    if (items[i + j * rw] == null) continue;
                    this.drawStackAt(InventoryUtils.cycleItemStack(items[i + j * rw], i + j * rw), x - 40 + i * 32, y - 40 + j * 32, mx, my, true);
                }
            }
        }
        if (recipe != null && recipe instanceof ShapelessArcaneRecipe) {
            text = I18n.func_74838_a((String)"recipe.type.arcane.shapeless");
            offset = this.field_146297_k.field_71466_p.func_78256_a(text);
            this.field_146297_k.field_71466_p.func_78276_b(text, x - offset / 2, y - 104, 0x505050);
            ArrayList items = ((ShapelessArcaneRecipe)recipe).getInput();
            for (int i = 0; i < items.size() && i < 9; ++i) {
                if (items.get(i) == null) continue;
                this.drawStackAt(InventoryUtils.cycleItemStack(items.get(i), i), x - 40 + i % 3 * 32, y - 40 + i / 3 * 32, mx, my, true);
            }
        }
        GL11.glPopMatrix();
    }

    private void drawCraftingPage(int x, int y, int mx, int my, IRecipe recipe) {
        int offset;
        String text;
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (recipe == null) {
            return;
        }
        GL11.glPushMatrix();
        this.field_146297_k.field_71446_o.func_110577_a(this.tex2);
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
        this.func_73729_b(-26, -26, 60, 15, 51, 52);
        this.func_73729_b(-8, -46, 20, 3, 16, 16);
        GL11.glPopMatrix();
        this.drawStackAt(InventoryUtils.cycleItemStack(recipe.func_77571_b(), 0), x - 8, y - 84, mx, my, false);
        if (recipe != null && (recipe instanceof ShapedRecipes || recipe instanceof ShapedOreRecipe)) {
            text = I18n.func_74838_a((String)"recipe.type.workbench");
            offset = this.field_146297_k.field_71466_p.func_78256_a(text);
            this.field_146297_k.field_71466_p.func_78276_b(text, x - offset / 2, y - 104, 0x505050);
            int rw = 0;
            int rh = 0;
            Object[] items = null;
            if (recipe instanceof ShapedRecipes) {
                rw = ((ShapedRecipes)recipe).field_77576_b;
                rh = ((ShapedRecipes)recipe).field_77577_c;
                items = ((ShapedRecipes)recipe).field_77574_d;
            } else {
                rw = (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)((ShapedOreRecipe)recipe), (String[])new String[]{"width"});
                rh = (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)((ShapedOreRecipe)recipe), (String[])new String[]{"height"});
                items = ((ShapedOreRecipe)recipe).getInput();
            }
            for (int i = 0; i < rw && i < 3; ++i) {
                for (int j = 0; j < rh && j < 3; ++j) {
                    if (items[i + j * rw] == null) continue;
                    this.drawStackAt(InventoryUtils.cycleItemStack(items[i + j * rw], i + j * rw), x - 40 + i * 32, y - 40 + j * 32, mx, my, true);
                }
            }
        }
        if (recipe != null && (recipe instanceof ShapelessRecipes || recipe instanceof ShapelessOreRecipe)) {
            text = I18n.func_74838_a((String)"recipe.type.workbenchshapeless");
            offset = this.field_146297_k.field_71466_p.func_78256_a(text);
            this.field_146297_k.field_71466_p.func_78276_b(text, x - offset / 2, y - 104, 0x505050);
            ArrayList items = null;
            if (recipe instanceof ShapelessRecipes) {
                items = new ArrayList();
                items.addAll(((ShapelessRecipes)recipe).field_77579_b);
            } else {
                items = ((ShapelessOreRecipe)recipe).getInput();
            }
            for (int i = 0; i < items.size() && i < 9; ++i) {
                if (items.get(i) == null) continue;
                this.drawStackAt(InventoryUtils.cycleItemStack(items.get(i), i), x + -40 + i % 3 * 32, y - 40 + i / 3 * 32, mx, my, true);
            }
        }
        GL11.glPopMatrix();
    }

    private void drawCruciblePage(int x, int y, int mx, int my, CrucibleRecipe rc) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (rc != null) {
            int vy;
            int vx;
            int m;
            GL11.glPushMatrix();
            String text = I18n.func_74838_a((String)"recipe.type.crucible");
            int offset = this.field_146297_k.field_71466_p.func_78256_a(text);
            this.field_146297_k.field_71466_p.func_78276_b(text, x - offset / 2, y - 104, 0x505050);
            this.field_146297_k.field_71446_o.func_110577_a(this.tex2);
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GL11.glTranslatef((float)x, (float)y, (float)0.0f);
            GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
            this.func_73729_b(-28, -29, 0, 3, 56, 17);
            GL11.glTranslatef((float)0.0f, (float)32.0f, (float)0.0f);
            this.func_73729_b(-28, -44, 0, 20, 56, 48);
            GL11.glTranslatef((float)0.0f, (float)-8.0f, (float)0.0f);
            this.func_73729_b(-25, -50, 100, 84, 11, 13);
            GL11.glPopMatrix();
            int mposx = mx;
            int mposy = my;
            int total = 0;
            int rows = (rc.aspects.size() - 1) / 3;
            int shift = (3 - rc.aspects.size() % 3) * 10;
            int sx = x - 28;
            int sy = y + 8 - 10 * rows;
            for (Aspect tag : rc.aspects.getAspectsSortedByName()) {
                m = 0;
                if (total / 3 >= rows && (rows > 1 || rc.aspects.size() < 3)) {
                    m = 1;
                }
                vx = sx + total % 3 * 20 + shift * m;
                vy = sy + total / 3 * 20;
                UtilsFX.drawTag(vx, vy, tag, rc.aspects.getAmount(tag), 0, this.field_73735_i);
                ++total;
            }
            this.drawStackAt(rc.getRecipeOutput(), x - 8, y - 50, mx, my, false);
            this.drawStackAt(InventoryUtils.cycleItemStack(rc.catalyst, 0), x - 64, y - 56, mx, my, true);
            total = 0;
            for (Aspect tag : rc.aspects.getAspectsSortedByName()) {
                m = 0;
                if (total / 3 >= rows && (rows > 1 || rc.aspects.size() < 3)) {
                    m = 1;
                }
                vx = sx + total % 3 * 20 + shift * m;
                vy = sy + total / 3 * 20;
                if (mposx >= vx && mposy >= vy && mposx < vx + 16 && mposy < vy + 16) {
                    this.tipText = Arrays.asList(tag.getName(), tag.getLocalizedDescription());
                }
                ++total;
            }
            GL11.glPopMatrix();
        }
    }

    private void drawInfusionPage(int x, int y, int mx, int my, InfusionRecipe ri) {
        if (ri != null) {
            Object[] components = ri.getComponents();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GL11.glPushMatrix();
            AspectList aspects = ri.getAspects();
            Object output = ri.getRecipeOutput();
            if (ri instanceof InfusionRunicAugmentRecipe) {
                ItemStack[] c = ((InfusionRunicAugmentRecipe)ri).getComponents((ItemStack)ri.getRecipeInput());
                components = c;
                ArrayList com = new ArrayList();
                ItemStack[] itemStackArray = c;
                int n = itemStackArray.length;
                for (int i = 0; i < n; ++i) {
                    ItemStack s = itemStackArray[i];
                    com.add(s);
                }
                aspects = ri.getAspects((EntityPlayer)this.field_146297_k.field_71439_g, (ItemStack)ri.getRecipeInput(), com);
                output = ((InfusionRunicAugmentRecipe)ri).getRecipeOutput((EntityPlayer)this.field_146297_k.field_71439_g, (ItemStack)ri.getRecipeInput(), com);
            }
            if (ri instanceof InfusionEnchantmentRecipe) {
                ArrayList<ItemStack> com = new ArrayList<ItemStack>();
                for (Object s : components) {
                    if (!(s instanceof ItemStack)) continue;
                    com.add((ItemStack)s);
                }
                aspects = ri.getAspects((EntityPlayer)this.field_146297_k.field_71439_g, (ItemStack)ri.getRecipeInput(), com);
                output = ((InfusionEnchantmentRecipe)ri).getRecipeOutput(null, (ItemStack)ri.getRecipeInput(), com);
            }
            String text = I18n.func_74838_a((String)"recipe.type.infusion");
            int offset = this.field_146297_k.field_71466_p.func_78256_a(text);
            this.field_146297_k.field_71466_p.func_78276_b(text, x - offset / 2, y - 104, 0x505050);
            this.field_146297_k.field_71446_o.func_110577_a(this.tex2);
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GL11.glTranslatef((float)x, (float)(y + 20), (float)0.0f);
            GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
            this.func_73729_b(-28, -56, 0, 3, 56, 17);
            GL11.glTranslatef((float)0.0f, (float)19.0f, (float)0.0f);
            this.func_73729_b(-28, -55, 200, 77, 60, 44);
            GL11.glPopMatrix();
            int mposx = mx;
            int mposy = my;
            int total = 0;
            int rows = (aspects.size() - 1) / 5;
            int shift = (5 - aspects.size() % 5) * 10;
            int sx = x - 48;
            int sy = y + 50 - 10 * rows;
            for (Aspect tag : aspects.getAspectsSortedByName()) {
                int m = 0;
                if (total / 5 >= rows && (rows > 1 || aspects.size() < 5)) {
                    m = 1;
                }
                int vx = sx + total % 5 * 20 + shift * m;
                int vy = sy + total / 5 * 20;
                UtilsFX.drawTag(vx, vy, tag, aspects.getAmount(tag), 0, this.field_73735_i);
                ++total;
            }
            ItemStack idisp = null;
            if (output instanceof ItemStack) {
                idisp = InventoryUtils.cycleItemStack((ItemStack)output);
            } else {
                idisp = InventoryUtils.cycleItemStack(ri.getRecipeInput()).func_77946_l();
                try {
                    Object[] obj = (Object[])output;
                    NBTBase tag = (NBTBase)obj[1];
                    idisp.func_77983_a((String)obj[0], tag);
                }
                catch (Exception obj) {
                    // empty catch block
                }
            }
            this.drawStackAt(idisp, x - 8, y - 85, mx, my, false);
            ItemStack rinp = InventoryUtils.cycleItemStack(ri.getRecipeInput()).func_77946_l();
            this.drawStackAt(rinp, x - 8, y - 16, mx, my, true);
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)0.0, (double)100.0);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int le = components.length;
            ArrayList<PosXY> coords = new ArrayList<PosXY>();
            float pieSlice = 360 / le;
            float currentRot = -90.0f;
            for (int a = 0; a < le; ++a) {
                int xx = (int)(MathHelper.func_76134_b((float)(currentRot / 180.0f * (float)Math.PI)) * 40.0f) - 8;
                int yy = (int)(MathHelper.func_76126_a((float)(currentRot / 180.0f * (float)Math.PI)) * 40.0f) - 8;
                currentRot += pieSlice;
                coords.add(new PosXY(xx, yy));
            }
            ArrayList<ItemStack> cmps = new ArrayList<ItemStack>();
            total = 0;
            sx = x;
            sy = y - 8;
            for (Object ingredient : components) {
                int vx = sx + ((PosXY)coords.get((int)total)).x;
                int vy = sy + ((PosXY)coords.get((int)total)).y;
                ItemStack is = InventoryUtils.cycleItemStack(ingredient);
                this.drawStackAt(is.func_77946_l().func_77979_a(1), vx, vy, mx, my, true);
                ++total;
                cmps.add(is.func_77946_l());
            }
            GL11.glPopMatrix();
            int inst = Math.min(5, ri.getInstability((EntityPlayer)this.field_146297_k.field_71439_g, rinp, cmps) / 2);
            text = I18n.func_74838_a((String)"tc.inst") + " " + I18n.func_74838_a((String)("tc.inst." + inst));
            offset = this.field_146297_k.field_71466_p.func_78256_a(text);
            this.field_146297_k.field_71466_p.func_78276_b(text, x - offset / 2, y + 94, 0x505050);
            total = 0;
            rows = (aspects.size() - 1) / 5;
            shift = (5 - aspects.size() % 5) * 10;
            sx = x - 48;
            sy = y + 50 - 10 * rows;
            for (Aspect tag : aspects.getAspectsSortedByName()) {
                int m = 0;
                if (total / 5 >= rows && (rows > 1 || aspects.size() < 5)) {
                    m = 1;
                }
                int vx = sx + total % 5 * 20 + shift * m;
                int vy = sy + total / 5 * 20;
                if (mposx >= vx && mposy >= vy && mposx < vx + 16 && mposy < vy + 16) {
                    this.tipText = Arrays.asList(tag.getName(), tag.getLocalizedDescription());
                }
                ++total;
            }
            GL11.glPopMatrix();
        }
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        if (par2 == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i() || par2 == 1) {
            history.clear();
            if (shownRecipe != null || this.showingAspects) {
                shownRecipe = null;
                this.blockAccess = null;
                this.showingAspects = false;
                Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundsTC.page, 0.4f, 1.1f);
            } else {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiResearchBrowser(this.guiMapX, this.guiMapY));
            }
        } else if (par2 == 203 || par2 == 200 || par2 == 201) {
            this.prevPage();
        } else if (par2 == 205 || par2 == 208 || par2 == 209) {
            this.nextPage();
        } else if (par2 == 14) {
            this.goBack();
        } else {
            super.func_73869_a(par1, par2);
        }
    }

    private void nextPage() {
        if (this.page < this.maxPages - 2) {
            this.page += 2;
            this.lastCycle = 0L;
            this.cycle = -1;
            Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundsTC.page, 0.66f, 1.0f);
        }
    }

    private void prevPage() {
        if (this.page >= 2) {
            this.page -= 2;
            this.lastCycle = 0L;
            this.cycle = -1;
            Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundsTC.page, 0.66f, 1.0f);
        }
    }

    private void goBack() {
        if (!history.isEmpty()) {
            Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundsTC.page, 0.66f, 1.0f);
            shownRecipe = history.pop();
            this.blockAccess = null;
            if (history.isEmpty()) {
                shownRecipe = null;
            }
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        this.checkRequisites();
        int var4 = (this.field_146294_l - this.paneWidth) / 2;
        int var5 = (this.field_146295_m - this.paneHeight) / 2;
        int mx = par1 - this.hrx;
        int my = par2 - this.hry;
        if (shownRecipe == null && !this.hold && this.hasAllRequisites && mx >= 0 && my >= 0 && mx < 64 && my < 12) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSyncProgressToServer(this.research.getKey(), false, true, true));
            Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundsTC.write, 0.66f, 1.0f);
            this.lastCheck = 0L;
            this.lastStage = this.currentStage;
            this.hold = true;
            this.keyCache.clear();
            this.drilldownLists.clear();
        }
        if (this.knownPlayerAspects != null && this.playerKnowledge.isResearchComplete("FIRSTSTEPS")) {
            mx = par1 - (var4 - 48);
            my = par2 - (var5 + 8);
            if (mx >= 0 && my >= 0 && mx < 25 && my < 16) {
                shownRecipe = null;
                this.showingAspects = !this.showingAspects;
                this.blockAccess = null;
                history.clear();
                if (aspectsPage > this.maxAspectPages) {
                    aspectsPage = 0;
                }
                Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundsTC.page, 0.7f, 0.9f);
            }
        }
        mx = par1 - (var4 + 205);
        my = par2 - (var5 + 192);
        if (this.showingAspects && aspectsPage < this.maxAspectPages - 1 && mx >= 0 && my >= 0 && mx < 14 && my < 14) {
            ++aspectsPage;
            Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundsTC.page, 0.7f, 0.9f);
        }
        mx = par1 - (var4 + 38);
        my = par2 - (var5 + 192);
        if (this.showingAspects && aspectsPage > 0 && mx >= 0 && my >= 0 && mx < 14 && my < 14) {
            --aspectsPage;
            Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundsTC.page, 0.7f, 0.9f);
        }
        int aa = 0;
        for (String rk : this.recipeLists.keySet()) {
            mx = par1 - (var4 + 280);
            my = par2 - (var5 + 3 + aa * 24);
            if (mx >= 0 && my >= 0 && mx < 30 && my < 16) {
                shownRecipe = rk.equals(shownRecipe) ? null : rk;
                this.showingAspects = false;
                this.blockAccess = null;
                history.clear();
                Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundsTC.page, 0.7f, 0.9f);
                break;
            }
            ++aa;
        }
        mx = par1 - (var4 + 205);
        my = par2 - (var5 + 192);
        if (this.hasRecipePages && this.recipePage < this.recipePageMax && mx >= 0 && my >= 0 && mx < 14 && my < 14) {
            ++this.recipePage;
            Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundsTC.page, 0.7f, 0.9f);
        }
        mx = par1 - (var4 + 38);
        my = par2 - (var5 + 192);
        if (this.hasRecipePages && this.recipePage > 0 && mx >= 0 && my >= 0 && mx < 14 && my < 14) {
            --this.recipePage;
            Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundsTC.page, 0.7f, 0.9f);
        }
        mx = par1 - (var4 + 261);
        my = par2 - (var5 + 189);
        if (shownRecipe == null && mx >= 0 && my >= 0 && mx < 14 && my < 10) {
            this.nextPage();
        }
        mx = par1 - (var4 - 17);
        my = par2 - (var5 + 189);
        if (shownRecipe == null && mx >= 0 && my >= 0 && mx < 14 && my < 10) {
            this.prevPage();
        }
        mx = par1 - (var4 + 118);
        my = par2 - (var5 + 190);
        if (mx >= 0 && my >= 0 && mx < 20 && my < 12) {
            this.goBack();
        }
        mx = par1 - (var4 + 210);
        my = par2 - (var5 + 190);
        if (this.renderingCompound && mx >= 0 && my >= 0 && mx < 10 && my < 10) {
            Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundsTC.clack, 0.66f, 1.0f);
            boolean bl = cycleMultiblockLines = !cycleMultiblockLines;
        }
        if (this.reference.size() > 0) {
            for (List coords : this.reference) {
                if (par1 < (Integer)coords.get(0) || par2 < (Integer)coords.get(1) || par1 >= (Integer)coords.get(0) + 16 || par2 >= (Integer)coords.get(1) + 16) continue;
                Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundsTC.page, 0.66f, 1.0f);
                history.push(shownRecipe);
                this.recipePage = Integer.parseInt((String)coords.get(2));
                shownRecipe = (String)coords.get(3);
                if (!this.drilldownLists.containsKey(shownRecipe)) {
                    this.addRecipesToList(shownRecipe, this.drilldownLists, null);
                }
                this.blockAccess = null;
            }
        }
        try {
            super.func_73864_a(par1, par2, par3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    void drawPopupAt(int x, int y, int mx, int my, String text) {
        if ((shownRecipe == null || this.allowWithPagePopup) && mx >= x && my >= y && mx < x + 16 && my < y + 16) {
            ArrayList<String> s = new ArrayList<String>();
            s.add(I18n.func_74838_a((String)text));
            this.tipText = s;
        }
    }

    void drawPopupAt(int x, int y, int w, int h, int mx, int my, String text) {
        if ((shownRecipe == null || this.allowWithPagePopup) && mx >= x && my >= y && mx < x + w && my < y + h) {
            ArrayList<String> s = new ArrayList<String>();
            s.add(I18n.func_74838_a((String)text));
            this.tipText = s;
        }
    }

    boolean mouseInside(int x, int y, int w, int h, int mx, int my) {
        return mx >= x && my >= y && mx < x + w && my < y + h;
    }

    void drawStackAt(ItemStack itemstack, int x, int y, int mx, int my, boolean clickthrough) {
        UtilsFX.renderItemStack(this.field_146297_k, itemstack, x, y, null);
        if ((shownRecipe == null || this.allowWithPagePopup) && mx >= x && my >= y && mx < x + 16 && my < y + 16 && itemstack != null && itemstack.func_77973_b() != null) {
            if (clickthrough) {
                List addtext = itemstack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x);
                String ref = this.getCraftingRecipeKey((EntityPlayer)this.field_146297_k.field_71439_g, itemstack);
                if (ref != null) {
                    if (ref.equals("UNKNOWN")) {
                        addtext.add(TextFormatting.DARK_RED + "" + TextFormatting.ITALIC + I18n.func_74838_a((String)"recipe.unknown"));
                    } else {
                        addtext.add(TextFormatting.BLUE + "" + TextFormatting.ITALIC + I18n.func_74838_a((String)"recipe.clickthrough"));
                        String[] q = ref.split(";", 2);
                        this.reference.add(Arrays.asList(mx, my, q[0], q[1]));
                    }
                }
                this.tipText = addtext;
            } else {
                this.tipText = itemstack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x);
            }
        }
    }

    public void drawTexturedModalRectScaled(int par1, int par2, int par3, int par4, int par5, int par6, float scale) {
        GL11.glPushMatrix();
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator var9 = Tessellator.func_178181_a();
        GL11.glTranslatef((float)((float)par1 + (float)par5 / 2.0f), (float)((float)par2 + (float)par6 / 2.0f), (float)0.0f);
        GL11.glScalef((float)(1.0f + scale), (float)(1.0f + scale), (float)1.0f);
        var9.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        var9.func_178180_c().func_181662_b((double)((float)(-par5) / 2.0f), (double)((float)par6 / 2.0f), (double)this.field_73735_i).func_187315_a((double)((float)(par3 + 0) * var7), (double)((float)(par4 + par6) * var8)).func_181675_d();
        var9.func_178180_c().func_181662_b((double)((float)par5 / 2.0f), (double)((float)par6 / 2.0f), (double)this.field_73735_i).func_187315_a((double)((float)(par3 + par5) * var7), (double)((float)(par4 + par6) * var8)).func_181675_d();
        var9.func_178180_c().func_181662_b((double)((float)par5 / 2.0f), (double)((float)(-par6) / 2.0f), (double)this.field_73735_i).func_187315_a((double)((float)(par3 + par5) * var7), (double)((float)(par4 + 0) * var8)).func_181675_d();
        var9.func_178180_c().func_181662_b((double)((float)(-par5) / 2.0f), (double)((float)(-par6) / 2.0f), (double)this.field_73735_i).func_187315_a((double)((float)(par3 + 0) * var7), (double)((float)(par4 + 0) * var8)).func_181675_d();
        var9.func_78381_a();
        GL11.glPopMatrix();
    }

    private void parsePages() {
        String[] imgSplit;
        this.checkRequisites();
        this.pages.clear();
        if (this.research.getStages() == null) {
            return;
        }
        boolean complete = false;
        this.currentStage = ThaumcraftCapabilities.getKnowledge((EntityPlayer)this.field_146297_k.field_71439_g).getResearchStage(this.research.getKey()) - 1;
        while (this.currentStage >= this.research.getStages().length) {
            --this.currentStage;
            complete = true;
        }
        if (this.currentStage < 0) {
            this.currentStage = 0;
        }
        ResearchStage stage = this.research.getStages()[this.currentStage];
        ResearchAddendum[] addenda = null;
        if (this.research.getAddenda() != null && complete) {
            addenda = this.research.getAddenda();
        }
        this.generateRecipesLists(stage, addenda);
        String rawText = stage.getTextLocalized();
        if (addenda != null) {
            int ac = 0;
            for (ResearchAddendum addendum : addenda) {
                if (!ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)this.field_146297_k.field_71439_g, addendum.getResearch())) continue;
                TextComponentTranslation text = new TextComponentTranslation("tc.addendumtext", new Object[]{++ac});
                rawText = rawText + "<PAGE>" + text.func_150254_d() + "<BR>" + addendum.getTextLocalized();
            }
        }
        rawText = rawText.replaceAll("<BR>", "\u00ef\u00bf\u00bd\n\n");
        rawText = rawText.replaceAll("<BR/>", "\u00ef\u00bf\u00bd\n\n");
        rawText = rawText.replaceAll("<LINE>", "\u00ef\u00bf\u00bd");
        rawText = rawText.replaceAll("<LINE/>", "\u00ef\u00bf\u00bd");
        rawText = rawText.replaceAll("<DIV>", "\u00ef\u00bf\u00bd");
        rawText = rawText.replaceAll("<DIV/>", "\u00ef\u00bf\u00bd");
        rawText = rawText.replaceAll("<PAGE>", "\u00ef\u00bf\u00bd");
        rawText = rawText.replaceAll("<PAGE/>", "\u00ef\u00bf\u00bd");
        ArrayList<PageImage> images = new ArrayList<PageImage>();
        for (String s : imgSplit = rawText.split("<IMG>")) {
            int i = s.indexOf("</IMG>");
            if (i < 0) continue;
            String clean = s.substring(0, i);
            PageImage pi = PageImage.parse(clean);
            if (pi == null) {
                rawText = rawText.replaceFirst(clean, "\n");
                continue;
            }
            images.add(pi);
            rawText = rawText.replaceFirst(clean, "\u00ef\u00bf\u00bd");
        }
        rawText = rawText.replaceAll("<IMG>", "");
        rawText = rawText.replaceAll("</IMG>", "");
        ArrayList<String> firstPassText = new ArrayList<String>();
        String[] temp = rawText.split("\u00ef\u00bf\u00bd");
        for (int a = 0; a < temp.length; ++a) {
            String t = temp[a];
            String[] temp1 = t.split("\u00ef\u00bf\u00bd");
            for (int x = 0; x < temp1.length; ++x) {
                String t1 = temp1[x];
                String[] temp2 = t1.split("\u00ef\u00bf\u00bd");
                for (int b = 0; b < temp2.length; ++b) {
                    String t2 = temp2[b];
                    String[] temp3 = t2.split("\u00ef\u00bf\u00bd");
                    for (int c = 0; c < temp3.length; ++c) {
                        String t3 = temp3[c];
                        firstPassText.add(t3);
                        if (c == temp3.length - 1) continue;
                        firstPassText.add("\u00ef\u00bf\u00bd");
                    }
                    if (b == temp2.length - 1) continue;
                    firstPassText.add("\u00ef\u00bf\u00bd");
                }
                if (x == temp1.length - 1) continue;
                firstPassText.add("\u00ef\u00bf\u00bd");
            }
            if (a == temp.length - 1) continue;
            firstPassText.add("\u00ef\u00bf\u00bd");
        }
        ArrayList<String> parsedText = new ArrayList<String>();
        for (String s : firstPassText) {
            List pt1 = this.field_146297_k.field_71466_p.func_78271_c(s, 140);
            for (String ln : pt1) {
                parsedText.add(ln);
            }
        }
        int lineHeight = this.field_146297_k.field_71466_p.field_78288_b;
        int heightRemaining = 182;
        int dividerSpace = 0;
        if (this.research.getKey().equals("KNOWLEDGETYPES")) {
            heightRemaining -= 2;
            int tc = 0;
            int amt = this.playerKnowledge.getKnowledge(IPlayerKnowledge.EnumKnowledgeType.EPIPHANY, null);
            if (amt > 0) {
                ++tc;
            }
            block9: for (IPlayerKnowledge.EnumKnowledgeType type : IPlayerKnowledge.EnumKnowledgeType.values()) {
                for (ResearchCategory category : ResearchCategories.researchCategories.values()) {
                    if (!type.hasFields() && category != null || (amt = this.playerKnowledge.getKnowledge(type, category)) <= 0) continue;
                    ++tc;
                    continue block9;
                }
            }
            heightRemaining -= 20 * tc;
            dividerSpace = 12;
        }
        if (!this.isComplete) {
            if (stage.getCraft() != null) {
                heightRemaining -= 18;
                dividerSpace = 15;
            }
            if (stage.getObtain() != null) {
                heightRemaining -= 18;
                dividerSpace = 15;
            }
            if (stage.getKnow() != null) {
                heightRemaining -= 18;
                dividerSpace = 15;
            }
            if (stage.getResearch() != null) {
                heightRemaining -= 18;
                dividerSpace = 15;
            }
        }
        heightRemaining -= dividerSpace;
        Page page1 = new Page();
        ArrayList tempImages = new ArrayList();
        for (String line : parsedText) {
            if (line.contains("\u00ef\u00bf\u00bd")) {
                if (!images.isEmpty()) {
                    tempImages.add(images.remove(0));
                }
                line = "";
            }
            if (line.contains("\u00ef\u00bf\u00bd")) {
                tempImages.add(PILINE);
                line = "";
            }
            if (line.contains("\u00ef\u00bf\u00bd")) {
                tempImages.add(PIDIV);
                line = "";
            }
            if (line.contains("\u00ef\u00bf\u00bd")) {
                heightRemaining = 210;
                this.pages.add(page1.copy());
                page1 = new Page();
                line = "";
            }
            if (!line.isEmpty()) {
                line = line.trim();
                page1.contents.add(line);
                heightRemaining -= lineHeight;
                if (line.endsWith("\u00ef\u00bf\u00bd")) {
                    heightRemaining = (int)((double)heightRemaining - (double)lineHeight * 0.66);
                }
            }
            while (!tempImages.isEmpty() && heightRemaining >= ((PageImage)tempImages.get((int)0)).ah + 2) {
                heightRemaining -= ((PageImage)tempImages.get((int)0)).ah + 2;
                page1.contents.add(tempImages.remove(0));
            }
            if (heightRemaining >= lineHeight || page1.contents.isEmpty()) continue;
            heightRemaining = 210;
            this.pages.add(page1.copy());
            page1 = new Page();
        }
        if (!page1.contents.isEmpty()) {
            this.pages.add(page1.copy());
        }
        page1 = new Page();
        heightRemaining = 210;
        while (!tempImages.isEmpty()) {
            if (heightRemaining < ((PageImage)tempImages.get((int)0)).ah + 2) {
                heightRemaining = 210;
                this.pages.add(page1.copy());
                page1 = new Page();
                continue;
            }
            heightRemaining -= ((PageImage)tempImages.get((int)0)).ah + 2;
            page1.contents.add(tempImages.remove(0));
        }
        if (!page1.contents.isEmpty()) {
            this.pages.add(page1.copy());
        }
        this.rhash = this.research.getKey().hashCode() + this.currentStage * 50;
        this.maxPages = this.pages.size();
    }

    private void checkRequisites() {
        if (this.research.getStages() != null) {
            ResearchStage.Knowledge[] k;
            String[] r;
            ItemStack[] c;
            this.isComplete = this.playerKnowledge.isResearchComplete(this.research.getKey());
            while (this.currentStage >= this.research.getStages().length) {
                --this.currentStage;
            }
            if (this.currentStage < 0) {
                return;
            }
            this.hasAllRequisites = true;
            this.hasItem = null;
            this.hasCraft = null;
            this.hasResearch = null;
            this.hasKnow = null;
            ResearchStage stage = this.research.getStages()[this.currentStage];
            ItemStack[] o = stage.getObtain();
            if (o != null) {
                this.hasItem = new boolean[o.length];
                for (int a = 0; a < o.length; ++a) {
                    this.hasItem[a] = InventoryUtils.isPlayerCarryingAmount((EntityPlayer)this.field_146297_k.field_71439_g, o[a], false);
                    if (this.hasItem[a]) continue;
                    this.hasAllRequisites = false;
                }
            }
            if ((c = stage.getCraft()) != null) {
                this.hasCraft = new boolean[c.length];
                for (int a = 0; a < c.length; ++a) {
                    if (!this.playerKnowledge.isResearchKnown("[#]" + stage.getCraftReference()[a])) {
                        this.hasAllRequisites = false;
                        this.hasCraft[a] = false;
                        continue;
                    }
                    this.hasCraft[a] = true;
                }
            }
            if ((r = stage.getResearch()) != null) {
                this.hasResearch = new boolean[r.length];
                for (int a = 0; a < r.length; ++a) {
                    if (!ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)this.field_146297_k.field_71439_g, r[a])) {
                        this.hasAllRequisites = false;
                        this.hasResearch[a] = false;
                        continue;
                    }
                    this.hasResearch[a] = true;
                }
            }
            if ((k = stage.getKnow()) != null) {
                this.hasKnow = new boolean[k.length];
                for (int a = 0; a < k.length; ++a) {
                    int pk = this.playerKnowledge.getKnowledge(k[a].type, k[a].category);
                    if (pk < k[a].amount) {
                        this.hasAllRequisites = false;
                        this.hasKnow[a] = false;
                        continue;
                    }
                    this.hasKnow[a] = true;
                }
            }
        }
    }

    private int findRecipe(String rec, ItemStack stack) {
        int page1;
        Object recipe = CommonInternals.craftingRecipeCatalog.get(rec);
        if (recipe instanceof CrucibleRecipe[]) {
            page1 = 0;
            for (ITCRecipe iTCRecipe : (CrucibleRecipe[])recipe) {
                if (((CrucibleRecipe)iTCRecipe).getRecipeOutput().func_77969_a(stack)) {
                    if (!ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)this.field_146297_k.field_71439_g, ((CrucibleRecipe)iTCRecipe).research)) {
                        return -99;
                    }
                    return page1;
                }
                ++page1;
            }
        }
        if (recipe instanceof InfusionRecipe[]) {
            page1 = 0;
            for (InfusionRecipe infusionRecipe : (InfusionRecipe[])recipe) {
                if (infusionRecipe.getRecipeOutput() instanceof ItemStack && ((ItemStack)infusionRecipe.getRecipeOutput()).func_77969_a(stack)) {
                    if (!ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)this.field_146297_k.field_71439_g, infusionRecipe.getResearch())) {
                        return -99;
                    }
                    return page1;
                }
                ++page1;
            }
        }
        if (recipe instanceof IRecipe[]) {
            page1 = 0;
            for (IRecipe iRecipe : (IRecipe[])recipe) {
                if (iRecipe.func_77571_b().func_77969_a(stack)) {
                    if (iRecipe instanceof IArcaneRecipe && !ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)this.field_146297_k.field_71439_g, ((IArcaneRecipe)iRecipe).getResearch())) {
                        return -99;
                    }
                    return page1;
                }
                ++page1;
            }
        }
        if (recipe instanceof RecipeMisc[]) {
            page1 = 0;
            for (RecipeMisc recipeMisc : (RecipeMisc[])recipe) {
                if (recipeMisc.getOutput().func_77969_a(stack)) {
                    return page1;
                }
                ++page1;
            }
        }
        return -1;
    }

    private String getCraftingRecipeKey(EntityPlayer player, ItemStack stack) {
        int key = stack.serializeNBT().toString().hashCode();
        if (this.keyCache.containsKey(key)) {
            return this.keyCache.get(key);
        }
        for (ResearchCategory rcl : ResearchCategories.researchCategories.values()) {
            for (ResearchEntry ri : rcl.research.values()) {
                if (ri.getStages() == null) continue;
                for (int a = 0; a < ri.getStages().length; ++a) {
                    ResearchStage stage = ri.getStages()[a];
                    if (stage.getRecipes() == null) continue;
                    for (String rec : stage.getRecipes()) {
                        int page1 = this.findRecipe(rec, stack);
                        if (page1 == -1) continue;
                        String s = page1 + ";" + rec;
                        if (page1 == -99) {
                            s = "UNKNOWN";
                        }
                        this.keyCache.put(key, s);
                        return s;
                    }
                }
                for (String rec : CommonInternals.craftingRecipesUnlinked) {
                    int page1 = this.findRecipe(rec, stack);
                    if (page1 == -1) continue;
                    this.keyCache.put(key, page1 + ";" + rec);
                    return page1 + ";" + rec;
                }
            }
        }
        this.keyCache.put(key, null);
        return null;
    }

    static {
        aspectsPage = 0;
        cycleMultiblockLines = false;
        PILINE = PageImage.parse("thaumcraft:textures/gui/gui_researchbook.png:24:184:95:6:1");
        PIDIV = PageImage.parse("thaumcraft:textures/gui/gui_researchbook.png:28:192:140:6:1");
    }

    public static class BlueprintBlockAccess
    implements IBlockAccess {
        private final Part[][][] data;
        private IBlockState[][][] structure;
        public int sliceLine = 0;

        public BlueprintBlockAccess(Part[][][] data, boolean target) {
            int z;
            int y;
            this.data = new Part[data.length][data[0].length][data[0][0].length];
            for (y = 0; y < data.length; ++y) {
                for (int x = 0; x < data[0].length; ++x) {
                    for (z = 0; z < data[0][0].length; ++z) {
                        this.data[y][x][z] = data[y][x][z];
                    }
                }
            }
            this.structure = new IBlockState[data.length][data[0].length][data[0][0].length];
            if (target) {
                for (y = 0; y < this.data.length; ++y) {
                    Matrix matrix2 = new Matrix(this.data[y]);
                    matrix2.Rotate90DegRight(3);
                    this.data[y] = matrix2.getMatrix();
                }
            }
            for (y = 0; y < data.length; ++y) {
                for (int x = 0; x < data[0].length; ++x) {
                    for (z = 0; z < data[0][0].length; ++z) {
                        this.structure[data.length - y - 1][x][z] = target ? this.convertTarget(x, y, z) : this.convert(x, y, z);
                    }
                }
            }
        }

        private IBlockState convert(int x, int y, int z) {
            if (this.data[y][x][z] == null || this.data[y][x][z].getSource() == null) {
                return Blocks.field_150350_a.func_176223_P();
            }
            if (this.data[y][x][z].getSource() instanceof ItemStack && Block.func_149634_a((Item)((ItemStack)this.data[y][x][z].getSource()).func_77973_b()) != null) {
                return Block.func_149634_a((Item)((ItemStack)this.data[y][x][z].getSource()).func_77973_b()).func_176203_a(((ItemStack)this.data[y][x][z].getSource()).func_77952_i());
            }
            if (this.data[y][x][z].getSource() instanceof Block) {
                return ((Block)this.data[y][x][z].getSource()).func_176223_P();
            }
            if (this.data[y][x][z].getSource() instanceof IBlockState) {
                return (IBlockState)this.data[y][x][z].getSource();
            }
            if (this.data[y][x][z].getSource() instanceof Material) {
                if ((Material)this.data[y][x][z].getSource() == Material.field_151587_i) {
                    return Blocks.field_150353_l.func_176223_P();
                }
                if ((Material)this.data[y][x][z].getSource() == Material.field_151586_h) {
                    return Blocks.field_150355_j.func_176223_P();
                }
            }
            return Blocks.field_150350_a.func_176223_P();
        }

        private IBlockState convertTarget(int x, int y, int z) {
            if (this.data[y][x][z] == null) {
                return Blocks.field_150350_a.func_176223_P();
            }
            if (this.data[y][x][z].getTarget() == null) {
                return this.convert(x, y, z);
            }
            if (this.data[y][x][z].getTarget() instanceof ItemStack && Block.func_149634_a((Item)((ItemStack)this.data[y][x][z].getTarget()).func_77973_b()) != null) {
                return Block.func_149634_a((Item)((ItemStack)this.data[y][x][z].getTarget()).func_77973_b()).func_176203_a(((ItemStack)this.data[y][x][z].getTarget()).func_77952_i());
            }
            if (this.data[y][x][z].getTarget() instanceof Block) {
                return ((Block)this.data[y][x][z].getTarget()).func_176223_P();
            }
            if (this.data[y][x][z].getTarget() instanceof IBlockState) {
                return (IBlockState)this.data[y][x][z].getTarget();
            }
            if (this.data[y][x][z].getTarget() instanceof Material) {
                if ((Material)this.data[y][x][z].getTarget() == Material.field_151587_i) {
                    return Blocks.field_150353_l.func_176223_P();
                }
                if ((Material)this.data[y][x][z].getTarget() == Material.field_151586_h) {
                    return Blocks.field_150355_j.func_176223_P();
                }
            }
            return Blocks.field_150350_a.func_176223_P();
        }

        @Nullable
        public TileEntity func_175625_s(BlockPos pos) {
            return null;
        }

        public int func_175626_b(BlockPos pos, int lightValue) {
            return 0xF000F0;
        }

        public IBlockState func_180495_p(BlockPos pos) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            if (this.sliceLine > this.structure.length) {
                this.sliceLine = 0;
            }
            if (y >= 0 && y < this.structure.length - this.sliceLine && x >= 0 && x < this.structure[y].length && z >= 0 && z < this.structure[y][x].length) {
                return this.structure[y][x][z];
            }
            return Blocks.field_150350_a.func_176223_P();
        }

        public boolean func_175623_d(BlockPos pos) {
            return this.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a;
        }

        public int func_175627_a(BlockPos pos, EnumFacing direction) {
            return 0;
        }

        public WorldType func_175624_G() {
            return null;
        }

        public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
            return false;
        }

        public Biome func_180494_b(BlockPos pos) {
            return null;
        }
    }

    private static class PageImage {
        int x;
        int y;
        int w;
        int h;
        int aw;
        int ah;
        float scale;
        ResourceLocation loc;

        private PageImage() {
        }

        public static PageImage parse(String text) {
            String[] s = text.split(":");
            if (s.length != 7) {
                return null;
            }
            try {
                PageImage pi = new PageImage();
                pi.loc = new ResourceLocation(s[0], s[1]);
                pi.x = Integer.parseInt(s[2]);
                pi.y = Integer.parseInt(s[3]);
                pi.w = Integer.parseInt(s[4]);
                pi.h = Integer.parseInt(s[5]);
                pi.scale = Float.parseFloat(s[6]);
                pi.aw = (int)((float)pi.w * pi.scale);
                pi.ah = (int)((float)pi.h * pi.scale);
                if (pi.ah > 208 || pi.aw > 140) {
                    return null;
                }
                return pi;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private class Page {
        ArrayList contents = new ArrayList();

        private Page() {
        }

        public Page copy() {
            Page p = new Page();
            p.contents.addAll(this.contents);
            return p;
        }
    }
}

