/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.tile;

import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.renderers.models.ModelCube;
import thaumcraft.common.blocks.basic.BlockPillar;
import thaumcraft.common.tiles.crafting.TileInfusionMatrix;

@SideOnly(value=Side.CLIENT)
public class TileInfusionMatrixRenderer
extends TileEntitySpecialRenderer<TileInfusionMatrix> {
    private ModelCube model = new ModelCube(0);
    private ModelCube model_over = new ModelCube(32);
    int type = 0;
    private static final ResourceLocation tex1 = new ResourceLocation("thaumcraft", "textures/blocks/infuser_normal.png");
    private static final ResourceLocation tex2 = new ResourceLocation("thaumcraft", "textures/blocks/infuser_ancient.png");
    private static final ResourceLocation tex3 = new ResourceLocation("thaumcraft", "textures/blocks/infuser_eldritch.png");

    public TileInfusionMatrixRenderer(int type) {
        this.type = type;
    }

    private void drawHalo(TileEntity is, double x, double y, double z, float par8, int count) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        int q = !FMLClientHandler.instance().getClient().field_71474_y.field_74347_j ? 10 : 20;
        Tessellator tessellator = Tessellator.func_178181_a();
        RenderHelper.func_74518_a();
        float f1 = (float)count / 500.0f;
        float f3 = 0.9f;
        float f2 = 0.0f;
        Random random = new Random(245L);
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)2884);
        GL11.glDepthMask((boolean)false);
        GL11.glPushMatrix();
        for (int i = 0; i < q; ++i) {
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f + f1 * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            tessellator.func_178180_c().func_181668_a(6, DefaultVertexFormats.field_181706_f);
            float fa = random.nextFloat() * 20.0f + 5.0f + f2 * 10.0f;
            float f4 = random.nextFloat() * 2.0f + 1.0f + f2 * 2.0f;
            tessellator.func_178180_c().func_181662_b(0.0, 0.0, 0.0).func_181669_b(255, 255, 255, (int)(255.0f * (1.0f - f1))).func_181675_d();
            tessellator.func_178180_c().func_181662_b(-0.866 * (double)(f4 /= 20.0f / ((float)Math.min(count, 50) / 50.0f)), (double)(fa /= 20.0f / ((float)Math.min(count, 50) / 50.0f)), (double)(-0.5f * f4)).func_181669_b(255, 0, 255, 0).func_181675_d();
            tessellator.func_178180_c().func_181662_b(0.866 * (double)f4, (double)fa, (double)(-0.5f * f4)).func_181669_b(255, 0, 255, 0).func_181675_d();
            tessellator.func_178180_c().func_181662_b(0.0, (double)fa, (double)(1.0f * f4)).func_181669_b(255, 0, 255, 0).func_181675_d();
            tessellator.func_178180_c().func_181662_b(-0.866 * (double)f4, (double)fa, (double)(-0.5f * f4)).func_181669_b(255, 0, 255, 0).func_181675_d();
            tessellator.func_78381_a();
        }
        GL11.glPopMatrix();
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glShadeModel((int)7424);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        RenderHelper.func_74519_b();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPopMatrix();
    }

    public void renderInfusionMatrix(TileInfusionMatrix is, double par2, double par4, double par6, float par8) {
        int c;
        int b;
        int a;
        GL11.glPushMatrix();
        ResourceLocation t = tex1;
        GL11.glTranslatef((float)((float)par2 + 0.5f), (float)((float)par4 + 0.5f), (float)((float)par6 + 0.5f));
        float ticks = (float)Minecraft.func_71410_x().func_175606_aa().field_70173_aa + par8;
        int inst = 0;
        int craftcount = 0;
        float startup = 0.0f;
        boolean active = false;
        boolean crafting = false;
        if (is != null && is.func_145831_w() != null) {
            GL11.glRotatef((float)(ticks % 360.0f * is.startUp), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(35.0f * is.startUp), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(45.0f * is.startUp), (float)0.0f, (float)0.0f, (float)1.0f);
            IBlockState bs = is.func_145831_w().func_180495_p(is.func_174877_v().func_177982_a(-1, -2, -1));
            if (bs.func_177228_b().containsKey((Object)BlockPillar.VARIANT)) {
                Comparable p = bs.func_177229_b((IProperty)BlockPillar.VARIANT);
                if (p == BlockPillar.PillarType.ANCIENT) {
                    t = tex2;
                }
                if (p == BlockPillar.PillarType.ELDRITCH) {
                    t = tex3;
                }
            }
            inst = is.instability;
            craftcount = is.craftCount;
            startup = is.startUp;
            active = is.active;
            crafting = is.crafting;
        }
        this.func_147499_a(t);
        float instability = Math.min(6.0f, 1.0f + (float)inst * 0.66f * ((float)Math.min(craftcount, 50) / 50.0f));
        float b1 = 0.0f;
        float b2 = 0.0f;
        float b3 = 0.0f;
        int aa = 0;
        int bb = 0;
        int cc = 0;
        for (a = 0; a < 2; ++a) {
            for (b = 0; b < 2; ++b) {
                for (c = 0; c < 2; ++c) {
                    if (active) {
                        b1 = MathHelper.func_76126_a((float)((ticks + (float)(a * 10)) / (15.0f - instability / 2.0f))) * 0.01f * startup * instability;
                        b2 = MathHelper.func_76126_a((float)((ticks + (float)(b * 10)) / (14.0f - instability / 2.0f))) * 0.01f * startup * instability;
                        b3 = MathHelper.func_76126_a((float)((ticks + (float)(c * 10)) / (13.0f - instability / 2.0f))) * 0.01f * startup * instability;
                    }
                    aa = a == 0 ? -1 : 1;
                    bb = b == 0 ? -1 : 1;
                    cc = c == 0 ? -1 : 1;
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)(b1 + (float)aa * 0.25f), (float)(b2 + (float)bb * 0.25f), (float)(b3 + (float)cc * 0.25f));
                    if (a > 0) {
                        GL11.glRotatef((float)90.0f, (float)a, (float)0.0f, (float)0.0f);
                    }
                    if (b > 0) {
                        GL11.glRotatef((float)90.0f, (float)0.0f, (float)b, (float)0.0f);
                    }
                    if (c > 0) {
                        GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)c);
                    }
                    GL11.glScaled((double)0.45, (double)0.45, (double)0.45);
                    this.model.render();
                    GL11.glPopMatrix();
                }
            }
        }
        if (active) {
            GL11.glPushMatrix();
            GL11.glAlphaFunc((int)516, (float)0.003921569f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            for (a = 0; a < 2; ++a) {
                for (b = 0; b < 2; ++b) {
                    for (c = 0; c < 2; ++c) {
                        b1 = MathHelper.func_76126_a((float)((ticks + (float)(a * 10)) / (15.0f - instability / 2.0f))) * 0.01f * startup * instability;
                        b2 = MathHelper.func_76126_a((float)((ticks + (float)(b * 10)) / (14.0f - instability / 2.0f))) * 0.01f * startup * instability;
                        b3 = MathHelper.func_76126_a((float)((ticks + (float)(c * 10)) / (13.0f - instability / 2.0f))) * 0.01f * startup * instability;
                        aa = a == 0 ? -1 : 1;
                        bb = b == 0 ? -1 : 1;
                        cc = c == 0 ? -1 : 1;
                        GL11.glPushMatrix();
                        GL11.glTranslatef((float)(b1 + (float)aa * 0.25f), (float)(b2 + (float)bb * 0.25f), (float)(b3 + (float)cc * 0.25f));
                        if (a > 0) {
                            GL11.glRotatef((float)90.0f, (float)a, (float)0.0f, (float)0.0f);
                        }
                        if (b > 0) {
                            GL11.glRotatef((float)90.0f, (float)0.0f, (float)b, (float)0.0f);
                        }
                        if (c > 0) {
                            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)c);
                        }
                        GL11.glScaled((double)0.45, (double)0.45, (double)0.45);
                        int j = 0xF000F0;
                        int k = j % 65536;
                        int l = j / 65536;
                        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)k / 1.0f), (float)((float)l / 1.0f));
                        GL11.glColor4f((float)0.8f, (float)0.1f, (float)1.0f, (float)((MathHelper.func_76126_a((float)((ticks + (float)(a * 2) + (float)(b * 3) + (float)(c * 4)) / 4.0f)) * 0.1f + 0.2f) * startup));
                        this.model_over.render();
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GL11.glPopMatrix();
                    }
                }
            }
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        if (crafting) {
            this.drawHalo(is, par2, par4, par6, par8, craftcount);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void renderTileEntityAt(TileInfusionMatrix par1TileEntity, double par2, double par4, double par6, float par8, int q) {
        switch (this.type) {
            case 0: {
                this.renderInfusionMatrix(par1TileEntity, par2, par4, par6, par8);
                break;
            }
            case 1: {
                this.renderTileEntityAt(par1TileEntity, par2, par4, par6, par8, q);
            }
        }
    }
}

