/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks.basic;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.blocks.IBlockTypes;
import thaumcraft.common.config.ConfigItems;

public class BlockStoneSlabTC
extends BlockSlab
implements IBlockTypes {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"type", StoneType.class);

    public BlockStoneSlabTC() {
        super(Material.field_151576_e);
        IBlockState iblockstate = this.field_176227_L.func_177621_b();
        if (!this.func_176552_j()) {
            iblockstate = iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
            this.func_149647_a(ConfigItems.TABTC);
        }
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(iblockstate.func_177226_a((IProperty)VARIANT, (Comparable)((Object)StoneType.ARCANE)));
        this.field_149783_u = !this.func_176552_j();
    }

    @Override
    public String getTypeName(IBlockState state) {
        IStringSerializable type = (IStringSerializable)state.func_177229_b((IProperty)VARIANT);
        return type.func_176610_l();
    }

    @Override
    public boolean hasTypes() {
        return true;
    }

    @Override
    public IProperty[] getTypes() {
        return new IProperty[]{VARIANT};
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)BlocksTC.slabStone);
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return StoneType.values()[stack.func_77960_j() & 7];
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(BlocksTC.slabStone, 1, this.func_180651_a(state));
    }

    public String func_150002_b(int meta) {
        return this.func_149739_a();
    }

    public IProperty<?> func_176551_l() {
        return VARIANT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List list) {
        if (itemIn != Item.func_150898_a((Block)BlocksTC.doubleSlabStone)) {
            for (StoneType enumtype : StoneType.values()) {
                list.add(new ItemStack(itemIn, 1, enumtype.ordinal()));
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)StoneType.values()[meta & 7]));
        if (!this.func_176552_j()) {
            iblockstate = iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        }
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int b0 = 0;
        int i = b0 | ((StoneType)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
        if (!this.func_176552_j() && state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return this.func_176552_j() ? new BlockStateContainer((Block)this, new IProperty[]{VARIANT}) : new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, VARIANT});
    }

    public int func_180651_a(IBlockState state) {
        return ((StoneType)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
    }

    public boolean func_176552_j() {
        return this == BlocksTC.doubleSlabStone;
    }

    @Override
    public boolean isType(IBlockState state, IStringSerializable type) {
        return false;
    }

    public static enum StoneType implements IStringSerializable
    {
        ARCANE,
        ARCANE_BRICK,
        ANCIENT,
        ELDRITCH;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

