/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks.world.taint;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.ThaumcraftMaterials;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.potions.PotionFluxTaint;
import thaumcraft.common.blocks.world.taint.ITaintBlock;
import thaumcraft.common.blocks.world.taint.TaintHelper;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.lib.SoundsTC;

public class BlockTaintFibre
extends Block
implements ITaintBlock {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool GROWTH1 = PropertyBool.func_177716_a((String)"growth1");
    public static final PropertyBool GROWTH2 = PropertyBool.func_177716_a((String)"growth2");
    public static final PropertyBool GROWTH3 = PropertyBool.func_177716_a((String)"growth3");
    public static final PropertyBool GROWTH4 = PropertyBool.func_177716_a((String)"growth4");
    protected static final AxisAlignedBB AABB_UP = new AxisAlignedBB(0.0, (double)0.95f, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_DOWN = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.05f, 1.0);
    protected static final AxisAlignedBB AABB_EAST = new AxisAlignedBB((double)0.95f, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.05f, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_SOUTH = new AxisAlignedBB(0.0, 0.0, (double)0.95f, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, (double)0.05f);

    public BlockTaintFibre() {
        super(ThaumcraftMaterials.MATERIAL_TAINT);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundsTC.GORE);
        this.func_149675_a(true);
        this.func_149647_a(ConfigItems.TABTC);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)GROWTH1, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)GROWTH2, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)GROWTH3, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)GROWTH4, (Comparable)Boolean.valueOf(false)));
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 3;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 3;
    }

    public MapColor func_180659_g(IBlockState state) {
        return MapColor.field_151678_z;
    }

    @Override
    public void die(World world, BlockPos pos, IBlockState blockState) {
        world.func_175698_g(pos);
    }

    protected boolean func_149700_E() {
        return false;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150899_d((int)0);
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if ((state = this.func_176221_a(state, (IBlockAccess)worldIn, pos)) instanceof IBlockState && ((Boolean)state.func_177229_b((IProperty)GROWTH3)).booleanValue()) {
            if (worldIn.field_73012_v.nextInt(5) <= fortune) {
                BlockTaintFibre.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)ConfigItems.FLUX_CRYSTAL.func_77946_l());
            }
            AuraHelper.polluteAura(worldIn, pos, 1.0f, true);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (!world.field_72995_K && (state = this.func_176221_a(state, (IBlockAccess)world, pos)) instanceof IBlockState) {
            if (!(((Boolean)state.func_177229_b((IProperty)GROWTH1)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)GROWTH2)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)GROWTH3)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)GROWTH4)).booleanValue() || !BlockTaintFibre.isOnlyAdjacentToTaint(world, pos))) {
                this.die(world, pos, state);
            } else if (!TaintHelper.isNearTaintSeed(world, pos)) {
                this.die(world, pos, state);
            } else {
                TaintHelper.spreadFibres(world, pos);
            }
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        if ((state = this.func_176221_a(state, (IBlockAccess)worldIn, pos)) instanceof IBlockState && !((Boolean)state.func_177229_b((IProperty)GROWTH1)).booleanValue() && !((Boolean)state.func_177229_b((IProperty)GROWTH2)).booleanValue() && !((Boolean)state.func_177229_b((IProperty)GROWTH3)).booleanValue() && !((Boolean)state.func_177229_b((IProperty)GROWTH4)).booleanValue() && BlockTaintFibre.isOnlyAdjacentToTaint(worldIn, pos)) {
            worldIn.func_175698_g(pos);
        }
    }

    public static int getAdjacentTaint(IBlockAccess world, BlockPos pos) {
        int count = 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (world.func_180495_p(pos.func_177972_a(dir)).func_185904_a() == ThaumcraftMaterials.MATERIAL_TAINT) continue;
            ++count;
        }
        return count;
    }

    public static boolean isOnlyAdjacentToTaint(World world, BlockPos pos) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (world.func_175623_d(pos.func_177972_a(dir)) || world.func_180495_p(pos.func_177972_a(dir)).func_185904_a() == ThaumcraftMaterials.MATERIAL_TAINT || !world.func_180495_p(pos.func_177972_a(dir)).func_177230_c().func_176212_b((IBlockAccess)world, pos.func_177972_a(dir), dir.func_176734_d())) continue;
            return false;
        }
        return true;
    }

    public static boolean isHemmedByTaint(World world, BlockPos pos) {
        int c = 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            IBlockState block = world.func_180495_p(pos.func_177972_a(dir));
            if (block.func_185904_a() == ThaumcraftMaterials.MATERIAL_TAINT) {
                ++c;
                continue;
            }
            if (world.func_175623_d(pos.func_177972_a(dir))) {
                --c;
                continue;
            }
            if (block.func_185904_a().func_76224_d() || block.isSideSolid((IBlockAccess)world, pos.func_177972_a(dir), dir.func_176734_d())) continue;
            --c;
        }
        return c > 0;
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        if (!world.field_72995_K && entity instanceof EntityLivingBase && !((EntityLivingBase)entity).func_70662_br() && world.field_73012_v.nextInt(750) == 0) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect((Potion)PotionFluxTaint.instance, 200, 0, false, true));
        }
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int eventID, int eventParam) {
        if (eventID == 1) {
            if (worldIn.field_72995_K) {
                worldIn.func_184133_a(null, pos, SoundEvents.field_187540_ab, SoundCategory.BLOCKS, 0.1f, 0.9f + worldIn.field_73012_v.nextFloat() * 0.2f);
            }
            return true;
        }
        return super.func_189539_a(state, worldIn, pos, eventID, eventParam);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_176212_b(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return false;
    }

    private boolean drawAt(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        Block b = worldIn.func_180495_p(pos).func_177230_c();
        return b != BlocksTC.taintFibre && b != BlocksTC.taintFeature && b.func_176212_b(worldIn, pos, side.func_176734_d());
    }

    public AxisAlignedBB func_185496_a(IBlockState s, IBlockAccess iblockaccess, BlockPos pos) {
        IBlockState state = this.func_176221_a(iblockaccess.func_180495_p(pos), iblockaccess, pos);
        if (state.func_177230_c() == this && state instanceof IBlockState) {
            int c = 0;
            if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
                ++c;
            }
            if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
                ++c;
            }
            if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
                ++c;
            }
            if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
                ++c;
            }
            if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
                ++c;
            }
            if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
                ++c;
            }
            if (c > 1) {
                return field_185505_j;
            }
            if (((Boolean)state.func_177229_b((IProperty)GROWTH1)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)GROWTH2)).booleanValue()) {
                return new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, (double)0.8f, (double)0.8f);
            }
            if (((Boolean)state.func_177229_b((IProperty)GROWTH3)).booleanValue()) {
                return new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, 0.375, (double)0.8f);
            }
            if (((Boolean)state.func_177229_b((IProperty)GROWTH4)).booleanValue()) {
                return new AxisAlignedBB((double)0.2f, (double)0.2f, (double)0.2f, (double)0.8f, 1.0, (double)0.8f);
            }
            if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
                return new AxisAlignedBB(0.0, (double)0.95f, 0.0, 1.0, 1.0, 1.0);
            }
            if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.05f, 1.0);
            }
            if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
                return new AxisAlignedBB((double)0.95f, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
            if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
                return new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.05f, 1.0, 1.0);
            }
            if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
                return new AxisAlignedBB(0.0, 0.0, (double)0.95f, 1.0, 1.0, 1.0);
            }
            if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, (double)0.05f);
            }
        }
        return super.func_185496_a(s, iblockaccess, pos);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn) {
        if (this.drawAt((IBlockAccess)worldIn, pos.func_177984_a(), EnumFacing.UP)) {
            BlockTaintFibre.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_UP);
        }
        if (this.drawAt((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.DOWN)) {
            BlockTaintFibre.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_DOWN);
        }
        if (this.drawAt((IBlockAccess)worldIn, pos.func_177974_f(), EnumFacing.EAST)) {
            BlockTaintFibre.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_EAST);
        }
        if (this.drawAt((IBlockAccess)worldIn, pos.func_177976_e(), EnumFacing.WEST)) {
            BlockTaintFibre.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WEST);
        }
        if (this.drawAt((IBlockAccess)worldIn, pos.func_177968_d(), EnumFacing.SOUTH)) {
            BlockTaintFibre.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_SOUTH);
        }
        if (this.drawAt((IBlockAccess)worldIn, pos.func_177978_c(), EnumFacing.NORTH)) {
            BlockTaintFibre.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_NORTH);
        }
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public int getLightValue(IBlockState state2, IBlockAccess world, BlockPos pos) {
        IBlockState state = this.func_176221_a(world.func_180495_p(pos), world, pos);
        if (state.func_177230_c() == this && state instanceof IBlockState) {
            return (Boolean)state.func_177229_b((IProperty)GROWTH3) != false ? 12 : ((Boolean)state.func_177229_b((IProperty)GROWTH2) != false || (Boolean)state.func_177229_b((IProperty)GROWTH4) != false ? 6 : super.getLightValue(state2, world, pos));
        }
        return super.getLightValue(state2, world, pos);
    }

    private Boolean[] makeConnections(IBlockState state, IBlockAccess world, BlockPos pos) {
        Boolean[] cons = new Boolean[]{false, false, false, false, false, false};
        int a = 0;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (this.drawAt(world, pos.func_177972_a(face), face)) {
                cons[a] = true;
            }
            ++a;
        }
        return cons;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        Boolean[] cons = this.makeConnections(state, worldIn, pos);
        boolean d = this.drawAt(worldIn, pos.func_177977_b(), EnumFacing.DOWN);
        boolean u = this.drawAt(worldIn, pos.func_177984_a(), EnumFacing.UP);
        int growth = 0;
        Random rand = new Random(pos.func_177986_g());
        int q = rand.nextInt(50);
        if (d) {
            if (q < 4) {
                growth = 1;
            } else if (q == 4 || q == 5) {
                growth = 2;
            } else if (q == 6) {
                growth = 3;
            }
        }
        if (u && q > 47) {
            growth = 4;
        }
        try {
            return state.func_177226_a((IProperty)DOWN, (Comparable)cons[0]).func_177226_a((IProperty)UP, (Comparable)cons[1]).func_177226_a((IProperty)NORTH, (Comparable)cons[2]).func_177226_a((IProperty)SOUTH, (Comparable)cons[3]).func_177226_a((IProperty)WEST, (Comparable)cons[4]).func_177226_a((IProperty)EAST, (Comparable)cons[5]).func_177226_a((IProperty)GROWTH1, (Comparable)Boolean.valueOf(growth == 1)).func_177226_a((IProperty)GROWTH2, (Comparable)Boolean.valueOf(growth == 2)).func_177226_a((IProperty)GROWTH3, (Comparable)Boolean.valueOf(growth == 3)).func_177226_a((IProperty)GROWTH4, (Comparable)Boolean.valueOf(growth == 4));
        }
        catch (Exception e) {
            return state;
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, GROWTH1, GROWTH2, GROWTH3, GROWTH4});
    }
}

