/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.config;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.Thaumcraft;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.potions.PotionFluxTaint;
import thaumcraft.api.potions.PotionVisExhaust;
import thaumcraft.common.config.ConfigRecipes;
import thaumcraft.common.entities.EntityFallingTaint;
import thaumcraft.common.entities.construct.EntityOwnedConstruct;
import thaumcraft.common.entities.monster.EntityEldritchCrab;
import thaumcraft.common.entities.monster.EntityEldritchGuardian;
import thaumcraft.common.entities.monster.EntityInhabitedZombie;
import thaumcraft.common.entities.monster.EntityPech;
import thaumcraft.common.entities.monster.EntityWisp;
import thaumcraft.common.entities.monster.boss.EntityCultistLeader;
import thaumcraft.common.entities.monster.boss.EntityCultistPortalGreater;
import thaumcraft.common.entities.monster.boss.EntityEldritchGolem;
import thaumcraft.common.entities.monster.boss.EntityEldritchWarden;
import thaumcraft.common.entities.monster.cult.EntityCultistCleric;
import thaumcraft.common.entities.monster.cult.EntityCultistKnight;
import thaumcraft.common.entities.monster.cult.EntityCultistPortalLesser;
import thaumcraft.common.lib.potions.PotionBlurredVision;
import thaumcraft.common.lib.potions.PotionDeathGaze;
import thaumcraft.common.lib.potions.PotionInfectiousVisExhaust;
import thaumcraft.common.lib.potions.PotionSunScorned;
import thaumcraft.common.lib.potions.PotionThaumarhia;
import thaumcraft.common.lib.potions.PotionUnnaturalHunger;
import thaumcraft.common.lib.potions.PotionWarpWard;
import thaumcraft.common.lib.utils.CropUtils;
import thaumcraft.common.lib.utils.Utils;
import thaumcraft.common.world.biomes.BiomeGenEerie;
import thaumcraft.common.world.biomes.BiomeGenEldritch;
import thaumcraft.common.world.biomes.BiomeGenMagicalForest;
import thaumcraft.common.world.biomes.BiomeHandler;

public class Config {
    public static Configuration config;
    public static final String CATEGORY_GRAPHICS = "Graphics";
    public static final String CATEGORY_ENCH = "Enchantments";
    public static final String CATEGORY_ENTITIES = "Entities";
    public static final String CATEGORY_BIOMES = "Biomes";
    public static final String CATEGORY_RESEARCH = "Research";
    public static final String CATEGORY_WORLD = "World_Generation";
    public static final String CATEGORY_REGEN = "World_Regeneration";
    public static final String CATEGORY_SPAWN = "Monster_Spawning";
    public static final String CATEGORY_RUNIC = "Runic_Shielding";
    public static int overworldDim;
    public static int biomeMagicalForestID;
    public static int biomeEerieID;
    public static int biomeEldritchID;
    public static int biomeMagicalForestWeight;
    public static float taintSpreadRate;
    public static int taintSpreadArea;
    public static boolean wuss;
    public static int dimensionOuterId;
    public static boolean championMobs;
    public static int oreDensity;
    public static int shieldRecharge;
    public static int shieldWait;
    public static int shieldCost;
    public static boolean largeTagText;
    public static boolean colorBlind;
    public static boolean shaders;
    public static boolean nostress;
    public static boolean crooked;
    public static boolean showTags;
    public static boolean blueBiome;
    public static boolean dialBottom;
    public static boolean showGolemEmotes;
    public static int nodeRefresh;
    public static final float auraSize = 4.0f;
    public static boolean genAura;
    public static boolean genStructure;
    public static boolean genCinnibar;
    public static boolean genQuartz;
    public static boolean genAmber;
    public static boolean genCrystals;
    public static boolean genTrees;
    public static boolean genMagicForest;
    public static boolean regenAura;
    public static boolean regenStructure;
    public static boolean regenQuartz;
    public static boolean regenCinnibar;
    public static boolean regenAmber;
    public static boolean regenCrystals;
    public static boolean regenTrees;
    public static String regenKey;
    public static boolean allowCheatSheet;
    public static boolean golemChestInteract;
    public static int nodeRarity;
    public static int specialNodeRarity;
    public static int chargeBarPos;
    public static int researchDifficulty;
    public static boolean CallowCheatSheet;
    public static boolean ChardNode;
    public static boolean Cwuss;
    public static int CresearchDifficulty;
    public static boolean spawnAngryZombie;
    public static boolean spawnFireBat;
    public static boolean spawnTaintacle;
    public static boolean spawnWisp;
    public static boolean spawnPech;
    public static boolean spawnElder;
    public static ArrayList<Aspect> aspectOrder;
    public static boolean foundCopperIngot;
    public static boolean foundTinIngot;
    public static boolean foundSilverIngot;
    public static boolean foundLeadIngot;
    public static boolean foundCopperOre;
    public static boolean foundTinOre;
    public static boolean foundSilverOre;
    public static boolean foundLeadOre;
    public static boolean isHalloween;

    public static void initialize(File file) {
        config = new Configuration(file);
        config.addCustomCategoryComment(CATEGORY_GRAPHICS, CATEGORY_GRAPHICS);
        config.addCustomCategoryComment(CATEGORY_ENCH, "Custom enchantments");
        config.addCustomCategoryComment(CATEGORY_SPAWN, "Will these mobs spawn");
        config.addCustomCategoryComment(CATEGORY_RESEARCH, "Various research related things.");
        config.addCustomCategoryComment(CATEGORY_WORLD, "Settings to turn certain world-gen on or off.");
        config.addCustomCategoryComment(CATEGORY_REGEN, "If a chunk is encountered that skipped TC worldgen, then the game will attempt to regenerate certain world features if they are set to true. CAUTION: Best used for worlds created before you added this mod, and only if you know what you are doing. Backups are advised.");
        config.addCustomCategoryComment(CATEGORY_BIOMES, "Biomes and effects");
        config.addCustomCategoryComment(CATEGORY_RUNIC, "Runic Shielding");
        config.load();
        Config.syncConfigurable();
        Property mfcp = config.get(CATEGORY_BIOMES, "magical_forest_biome_weight", 3);
        mfcp.setComment("higher values increases number of magical forest biomes. If you are using biome addon mods you probably want to increase this weight quite a bit");
        biomeMagicalForestWeight = mfcp.getInt();
        Property biomeMFProp = config.get(CATEGORY_BIOMES, "biome_magical_forest", biomeMagicalForestID);
        biomeMFProp.setComment("Magical Forest biome id");
        biomeMagicalForestID = biomeMFProp.getInt();
        if (Biome.func_150568_d((int)biomeMagicalForestID) != null) {
            biomeMagicalForestID = BiomeHandler.getFirstFreeBiomeSlot(biomeMagicalForestID);
            biomeMFProp.set(biomeMagicalForestID);
        }
        try {
            Biome.func_185354_a((int)biomeMagicalForestID, (String)"magical_forest", (Biome)new BiomeGenMagicalForest(new Biome.BiomeProperties("Magical Forest").func_185398_c(0.2f).func_185400_d(0.3f).func_185410_a(0.8f).func_185395_b(0.4f)));
            BiomeHandler.MAGICAL_FOREST = Biome.func_150568_d((int)biomeMagicalForestID);
        }
        catch (Exception e) {
            Thaumcraft.log.fatal("Could not register Magical Forest Biome");
        }
        Property biomeEerieProp = config.get(CATEGORY_BIOMES, "biome_eerie", biomeEerieID);
        biomeEerieProp.setComment("Eerie biome id");
        biomeEerieID = biomeEerieProp.getInt();
        if (Biome.func_150568_d((int)biomeEerieID) != null) {
            biomeEerieID = BiomeHandler.getFirstFreeBiomeSlot(biomeEerieID);
            biomeEerieProp.set(biomeEerieID);
        }
        try {
            Biome.func_185354_a((int)biomeEerieID, (String)"eerie", (Biome)new BiomeGenEerie(new Biome.BiomeProperties("Eerie").func_185398_c(0.125f).func_185400_d(0.4f).func_185410_a(0.8f).func_185396_a()));
            BiomeHandler.EERIE = Biome.func_150568_d((int)biomeEerieID);
        }
        catch (Exception e) {
            Thaumcraft.log.fatal("Could not register Eerie Biome");
        }
        Property biomeEldritchProp = config.get(CATEGORY_BIOMES, "biome_eldritch", biomeEldritchID);
        biomeEldritchProp.setComment("Eldritch Lands biome id");
        biomeEldritchID = biomeEldritchProp.getInt();
        if (Biome.func_150568_d((int)biomeEldritchID) != null) {
            biomeEldritchID = BiomeHandler.getFirstFreeBiomeSlot(biomeEldritchID);
            biomeEldritchProp.set(biomeEldritchID);
        }
        try {
            Biome.func_185354_a((int)biomeEldritchID, (String)"eldritch", (Biome)new BiomeGenEldritch(new Biome.BiomeProperties("Outer Lands").func_185398_c(0.125f).func_185400_d(0.15f).func_185410_a(0.8f).func_185395_b(0.2f)));
            BiomeHandler.ELDRITCH = Biome.func_150568_d((int)biomeEldritchID);
        }
        catch (Exception e) {
            Thaumcraft.log.fatal("Could not register Eldritch Lands Biome");
        }
        Property dimEldritch = config.get(CATEGORY_BIOMES, "outer_lands_dim", dimensionOuterId);
        dimensionOuterId = dimEldritch.getInt();
        Property mdim = config.get(CATEGORY_BIOMES, "main_dim", overworldDim);
        mdim.setComment("The dimension considered to be your 'overworld'. Certain TC structures will only spawn in this dim.");
        overworldDim = mdim.getInt();
        config.save();
        MinecraftForge.EVENT_BUS.register(ConfigChangeListener.class);
    }

    public static void save() {
        config.save();
    }

    public static void postInitPotions() {
        PotionFluxTaint.instance = new PotionFluxTaint(true, 0x663377);
        PotionVisExhaust.instance = new PotionVisExhaust(true, 0x664477);
        PotionInfectiousVisExhaust.instance = new PotionInfectiousVisExhaust(true, 0x665577);
        PotionUnnaturalHunger.instance = new PotionUnnaturalHunger(true, 0x446633);
        PotionWarpWard.instance = new PotionWarpWard(false, 14742263);
        PotionDeathGaze.instance = new PotionDeathGaze(true, 0x664433);
        PotionBlurredVision.instance = new PotionBlurredVision(true, 0x808080);
        PotionSunScorned.instance = new PotionSunScorned(true, 16308330);
        PotionThaumarhia.instance = new PotionThaumarhia(true, 0x664477);
        Potion.field_188414_b.func_177775_a(-1, (Object)new ResourceLocation("fluxTaint"), (Object)PotionFluxTaint.instance);
        Potion.field_188414_b.func_177775_a(-1, (Object)new ResourceLocation("visExhaust"), (Object)PotionVisExhaust.instance);
        Potion.field_188414_b.func_177775_a(-1, (Object)new ResourceLocation("infectiousVisExhaust"), (Object)PotionInfectiousVisExhaust.instance);
        Potion.field_188414_b.func_177775_a(-1, (Object)new ResourceLocation("unnaturalHunger"), (Object)PotionUnnaturalHunger.instance);
        Potion.field_188414_b.func_177775_a(-1, (Object)new ResourceLocation("warpWard"), (Object)PotionWarpWard.instance);
        Potion.field_188414_b.func_177775_a(-1, (Object)new ResourceLocation("deathGaze"), (Object)PotionDeathGaze.instance);
        Potion.field_188414_b.func_177775_a(-1, (Object)new ResourceLocation("blurredVision"), (Object)PotionBlurredVision.instance);
        Potion.field_188414_b.func_177775_a(-1, (Object)new ResourceLocation("sunScorned"), (Object)PotionSunScorned.instance);
        Potion.field_188414_b.func_177775_a(-1, (Object)new ResourceLocation("thaumarhia"), (Object)PotionThaumarhia.instance);
    }

    public static void syncConfigurable() {
        Property cbp = config.get(CATEGORY_GRAPHICS, "charge_bar_pos", chargeBarPos);
        cbp.setComment("The location of the HUD for item vis charge levels. 0 = left (default), 1 = right, 2 = top");
        chargeBarPos = MathHelper.func_76125_a((int)cbp.getInt(), (int)0, (int)2);
        Property cb = config.get(CATEGORY_GRAPHICS, "color_blind", colorBlind);
        cb.setComment("Setting this to true will make certain colors higher contrast or darker to prevent them from being 'invisible' to color blind people.");
        colorBlind = cb.getBoolean(false);
        Property ltt = config.get(CATEGORY_GRAPHICS, "large_tag_text", largeTagText);
        ltt.setComment("Setting this to true will make the amount text in aspect tags twice as large. Useful for certain resolutions and custom fonts.");
        largeTagText = ltt.getBoolean(false);
        Property shad = config.get(CATEGORY_GRAPHICS, "shaders", shaders);
        shad.setComment("This setting will disable certain thaumcraft shaders for those who experience FPS drops.");
        shaders = shad.getBoolean(false);
        Property nost = config.get(CATEGORY_GRAPHICS, "no_stress", nostress);
        nost.setComment("Set to true to disable anxiety triggers like the heartbeat sound.");
        nostress = nost.getBoolean(false);
        Property ocd = config.get(CATEGORY_GRAPHICS, "crooked", crooked);
        ocd.setComment("Hate crooked labels, kittens, puppies and all things awesome? If yes, set this to false.");
        crooked = ocd.getBoolean(true);
        Property dbp = config.get(CATEGORY_GRAPHICS, "wand_dial_bottom", dialBottom);
        dbp.setComment("Set to true to have the wand dial display in the bottom left instead of the top left.");
        dialBottom = dbp.getBoolean(false);
        Property showtags = config.get(CATEGORY_GRAPHICS, "display_aspects", false);
        showtags.setComment("Item aspects are hidden by default and pressing shift reveals them. Changing this setting to 'true' will reverse this behaviour and always display aspects unless shift is pressed.");
        showTags = showtags.getBoolean(false);
        Property blueb = config.get(CATEGORY_GRAPHICS, "blue_magical_forest", blueBiome);
        blueb.setComment("Set this to true to get the old blue magical forest back.");
        blueBiome = blueb.getBoolean(false);
        Property sge = config.get(CATEGORY_GRAPHICS, "show_golem_emotes", showGolemEmotes);
        sge.setComment("Will golems display emote particles if they recieve orders or encounter problems");
        showGolemEmotes = sge.getBoolean(true);
        genAura = config.get(CATEGORY_WORLD, "generate_aura_nodes", true).getBoolean(true);
        genStructure = config.get(CATEGORY_WORLD, "generate_structures", true).getBoolean(true);
        genCinnibar = config.get(CATEGORY_WORLD, "generate_cinnibar_ore", true).getBoolean(true);
        genAmber = config.get(CATEGORY_WORLD, "generate_amber_ore", true).getBoolean(true);
        genQuartz = config.get(CATEGORY_WORLD, "generate_quartz_ore", true).getBoolean(true);
        genCrystals = config.get(CATEGORY_WORLD, "generate_vis_crystals", true).getBoolean(true);
        genTrees = config.get(CATEGORY_WORLD, "generate_trees", true).getBoolean(true);
        Property gt = config.get(CATEGORY_WORLD, "generate_magic_forest", genMagicForest);
        gt.setComment("Can magic forest biomes generate at worldgen");
        genMagicForest = gt.getBoolean(true);
        Property nodRare = config.get(CATEGORY_WORLD, "node_rarity", nodeRarity);
        nodRare.setComment("How rare nodes are in the world. The number means there will be (on average) one node per N chunks.");
        nodeRarity = nodRare.getInt();
        Property nodSpec = config.get(CATEGORY_WORLD, "special_node_rarity", specialNodeRarity);
        nodSpec.setComment("The chance of a node being special (pure, dark, unstable, etc.). The number means roughly 1 in N nodes will be special, so setting the number to 5 will mean 1 in 5 nodes may be special.");
        specialNodeRarity = nodSpec.getInt();
        if (specialNodeRarity < 3) {
            specialNodeRarity = 3;
        }
        Property regKey = config.get(CATEGORY_REGEN, "regen_key", "DEFAULT");
        regKey.setComment("This key is used to keep track of which chunk have been generated/regenerated. Changing it will cause the regeneration code to run again, so only change it if you want it to happen. Useful to regen only one world feature at a time.");
        regenKey = regKey.getString();
        regenAura = config.get(CATEGORY_REGEN, "aura_nodes", false).getBoolean(false);
        regenStructure = config.get(CATEGORY_REGEN, "structures", false).getBoolean(false);
        regenCinnibar = config.get(CATEGORY_REGEN, "cinnibar_ore", false).getBoolean(false);
        regenAmber = config.get(CATEGORY_REGEN, "amber_ore", false).getBoolean(false);
        regenQuartz = config.get(CATEGORY_REGEN, "Quartz_ore", false).getBoolean(false);
        regenCrystals = config.get(CATEGORY_REGEN, "vis_crystals", false).getBoolean(false);
        regenTrees = config.get(CATEGORY_REGEN, "trees", false).getBoolean(false);
        Property resDif = config.get(CATEGORY_RESEARCH, "research_difficulty", 0);
        resDif.setComment("0 = normal, -1 = easy (all research items are directly purchased with levels), 1 = Hard (all research items need to be solved via the research table)");
        CresearchDifficulty = researchDifficulty = resDif.getInt(0);
        Property resAmt = config.get(CATEGORY_RESEARCH, "research_amount", 1);
        resAmt.setComment("This setting is useful for cooperative or team play. When a research is completed this is the amount of discoveries that will be created (default 1, max 64) Setting it less than 1 will create a discovery that will not be used up when learned.");
        if (resAmt.getInt(0) > 64) {
            resAmt.set(64);
        }
        if (resAmt.getInt(0) < 0) {
            resAmt.set(0);
        }
        spawnAngryZombie = config.get(CATEGORY_SPAWN, "spawn_angry_zombies", true).getBoolean(true);
        spawnFireBat = config.get(CATEGORY_SPAWN, "spawn_fire_bats", true).getBoolean(true);
        spawnWisp = config.get(CATEGORY_SPAWN, "spawn_wisps", true).getBoolean(true);
        spawnTaintacle = config.get(CATEGORY_SPAWN, "spawn_taintacles", true).getBoolean(true);
        spawnPech = config.get(CATEGORY_SPAWN, "spawn_pechs", true).getBoolean(true);
        spawnElder = config.get(CATEGORY_SPAWN, "spawn_eldercreatures", true).getBoolean(true);
        Property cm = config.get(CATEGORY_SPAWN, "champion_mobs", championMobs);
        cm.setComment("Setting this to false will disable spawning champion mobs. Even when false they will still have a greatly reduced chance of spawning in certain dangerous places.");
        championMobs = cm.getBoolean(true);
        Property wm = config.get("general", "wuss_mode", wuss);
        wm.setComment("Setting this to true disables Warp, Taint spread and similar mechanics. You wuss.");
        Cwuss = wuss = wm.getBoolean(false);
        Property cheatsheet = config.get("general", "allow_cheat_sheet", false);
        cheatsheet.setComment("Enables a version of the Thauminomicon in creative mode that grants you all the research when you first use it.");
        CallowCheatSheet = allowCheatSheet = cheatsheet.getBoolean(false);
        Property ts = config.get("general", "taint_spread", (int)(taintSpreadRate * 100.0f));
        ts.setComment("The % chance of taint fibres spreading on a block tick. Setting this to 0 will effectively stop taint fibre spread. Default 100%");
        taintSpreadRate = (float)ts.getInt() / 100.0f;
        Property tsa = config.get("general", "taint_spread_area", taintSpreadArea);
        tsa.setComment("The range at which taint can spread from a taint seed. This value is only a base and will be modified by flux levels. (valid values are 8-256, default 32)");
        taintSpreadArea = MathHelper.func_76125_a((int)tsa.getInt(), (int)8, (int)256);
        Property od = config.get(CATEGORY_WORLD, "ore_density", oreDensity);
        od.setComment("The % of normal ore amounts that will be spawned. For example 50 will spawn half the ores while 200 will spawn double. Default 100");
        oreDensity = Math.max(1, od.getInt());
        Property rss = config.get(CATEGORY_RUNIC, "runic_shield_recharge_speed", shieldRecharge);
        rss.setComment("How many milliseconds passes between runic shielding recharge ticks. Lower values equals faster recharge. Minimum of 500.");
        shieldRecharge = Math.max(500, rss.getInt());
        Property rsd = config.get(CATEGORY_RUNIC, "runic_shield_recharge_delay", shieldWait);
        rsd.setComment("How many milliseconds passes after a shield has been reduced to zero before it can start recharging again. Minimum of 0.");
        shieldWait = Math.max(0, rsd.getInt());
        Property rsc = config.get(CATEGORY_RUNIC, "runic_shield_cost", shieldCost);
        rsc.setComment("How much aer and terra vis it costs to reacharge a single unit of shielding. Minimum of 0.");
        shieldCost = Math.max(0, rsc.getInt());
    }

    public static void postInitLoot() {
        boolean COMMON = false;
        boolean UNCOMMON = true;
        int RARE = 2;
        Random rand = new Random(System.currentTimeMillis());
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151074_bl, 1), 2500, 0);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151074_bl, 2), 2250, 1);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151074_bl, 3), 2000, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.salisMundus), 3, 0);
        ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.salisMundus), 6, 1);
        ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.salisMundus), 9, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_185161_cS), 5, 0, 1, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151111_aL), 5, 0, 1, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151106_aX), 5, 0, 1, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_185160_cR), 5, 1);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_185160_cR), 10, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.primordialPearl, 0), 1, 0);
        ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.primordialPearl, 0), 3, 1);
        ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.primordialPearl, 1), 1, 1);
        ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.primordialPearl, 0), 9, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.primordialPearl, 1), 3, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.primordialPearl, 2), 1, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151156_bN), 1, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151045_i), 10, 0);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151045_i), 50, 1, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151166_bC), 15, 0);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151166_bC), 75, 1, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151043_k), 100, 0, 1, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151079_bi), 100, 0, 1, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.amuletVis, 1, 0), 6, 1, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.baubles, 1, 0), 10, 0);
        ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.baubles, 1, 1), 10, 0);
        ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.baubles, 1, 2), 10, 0);
        ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.baubles, 1, 3), 5, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.baubles, 1, 4), 5, 1);
        ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.baubles, 1, 5), 5, 1);
        ThaumcraftApi.addLootBagItem(new ItemStack(ItemsTC.baubles, 1, 6), 5, 1);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151062_by), 5, 0);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151062_by), 10, 1);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151062_by), 20, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151153_ao, 1, 1), 1, 0);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151153_ao, 1, 1), 2, 1);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151153_ao, 1, 1), 3, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151153_ao, 1, 0), 3, 0);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151153_ao, 1, 0), 6, 1);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151153_ao, 1, 0), 9, 2);
        ThaumcraftApi.addLootBagItem(new ItemStack(Items.field_151122_aG), 10, 0, 1, 2);
        for (PotionType pt : PotionType.field_185176_a) {
            ThaumcraftApi.addLootBagItem(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)pt), 2, 0, 1, 2);
            ThaumcraftApi.addLootBagItem(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)pt), 2, 0, 1, 2);
            ThaumcraftApi.addLootBagItem(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185156_bI), (PotionType)pt), 2, 1, 2);
        }
        ItemStack[] commonLoot = new ItemStack[]{new ItemStack(ItemsTC.lootBag, 1, 0), new ItemStack(ItemsTC.ingots), new ItemStack(ItemsTC.amber)};
        ItemStack[] uncommonLoot = new ItemStack[]{new ItemStack(ItemsTC.lootBag, 1, 1), new ItemStack(ItemsTC.baubles, 1, 0), new ItemStack(ItemsTC.baubles, 1, 1), new ItemStack(ItemsTC.baubles, 1, 2)};
        ItemStack[] rareLoot = new ItemStack[]{new ItemStack(ItemsTC.lootBag, 1, 2), new ItemStack(ItemsTC.thaumonomicon), new ItemStack(ItemsTC.thaumiumSword), new ItemStack(ItemsTC.thaumiumAxe), new ItemStack(ItemsTC.thaumiumHoe), new ItemStack(ItemsTC.thaumiumPick), new ItemStack(ItemsTC.baubles, 1, 3), new ItemStack(ItemsTC.baubles, 1, 4), new ItemStack(ItemsTC.baubles, 1, 5), new ItemStack(ItemsTC.baubles, 1, 6), new ItemStack(ItemsTC.amuletVis, 1, 0)};
    }

    public static void postInitModCompatibility() {
        String[] ores;
        for (String ore : ores = OreDictionary.getOreNames()) {
            if (ore == null) continue;
            if (ore.equals("oreCopper") && OreDictionary.getOres((String)ore, (boolean)false).size() > 0) {
                foundCopperOre = true;
                for (ItemStack is : OreDictionary.getOres((String)ore, (boolean)false)) {
                    Utils.addSpecialMiningResult(is, new ItemStack(ItemsTC.clusters, 1, 2), 1.0f);
                }
            }
            if (ore.equals("oreTin") && OreDictionary.getOres((String)ore, (boolean)false).size() > 0) {
                foundTinOre = true;
                for (ItemStack is : OreDictionary.getOres((String)ore, (boolean)false)) {
                    Utils.addSpecialMiningResult(is, new ItemStack(ItemsTC.clusters, 1, 3), 1.0f);
                }
            }
            if (ore.equals("oreSilver") && OreDictionary.getOres((String)ore, (boolean)false).size() > 0) {
                foundSilverOre = true;
                for (ItemStack is : OreDictionary.getOres((String)ore, (boolean)false)) {
                    Utils.addSpecialMiningResult(is, new ItemStack(ItemsTC.clusters, 1, 4), 1.0f);
                }
            }
            if (ore.equals("oreLead") && OreDictionary.getOres((String)ore, (boolean)false).size() > 0) {
                foundLeadOre = true;
                for (ItemStack is : OreDictionary.getOres((String)ore, (boolean)false)) {
                    Utils.addSpecialMiningResult(is, new ItemStack(ItemsTC.clusters, 1, 5), 1.0f);
                }
            }
            if (ore.equals("ingotCopper")) {
                boolean first = true;
                for (ItemStack is : OreDictionary.getOres((String)ore, (boolean)false)) {
                    if (is.field_77994_a > 1) {
                        is.field_77994_a = 1;
                    }
                    foundCopperIngot = true;
                    CraftingManager.func_77594_a().func_92103_a(new ItemStack(ItemsTC.nuggets, 9, 1), new Object[]{"#", Character.valueOf('#'), is});
                    if (!first) continue;
                    first = false;
                    FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(ItemsTC.clusters, 1, 2), new ItemStack(is.func_77973_b(), 2, is.func_77952_i()), 1.0f);
                    ConfigRecipes.oreDictRecipe(is, new Object[]{"###", "###", "###", Character.valueOf('#'), new ItemStack(ItemsTC.nuggets, 1, 1)});
                }
                continue;
            }
            if (ore.equals("ingotTin")) {
                boolean first = true;
                for (ItemStack is : OreDictionary.getOres((String)ore, (boolean)false)) {
                    if (is.field_77994_a > 1) {
                        is.field_77994_a = 1;
                    }
                    foundTinIngot = true;
                    CraftingManager.func_77594_a().func_92103_a(new ItemStack(ItemsTC.nuggets, 9, 2), new Object[]{"#", Character.valueOf('#'), is});
                    if (!first) continue;
                    first = false;
                    FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(ItemsTC.clusters, 1, 3), new ItemStack(is.func_77973_b(), 2, is.func_77952_i()), 1.0f);
                    ConfigRecipes.oreDictRecipe(is, new Object[]{"###", "###", "###", Character.valueOf('#'), new ItemStack(ItemsTC.nuggets, 1, 2)});
                }
                continue;
            }
            if (ore.equals("ingotSilver")) {
                boolean first = true;
                for (ItemStack is : OreDictionary.getOres((String)ore, (boolean)false)) {
                    if (is.field_77994_a > 1) {
                        is.field_77994_a = 1;
                    }
                    foundSilverIngot = true;
                    CraftingManager.func_77594_a().func_92103_a(new ItemStack(ItemsTC.nuggets, 9, 3), new Object[]{"#", Character.valueOf('#'), is});
                    if (!first) continue;
                    first = false;
                    FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(ItemsTC.clusters, 1, 4), new ItemStack(is.func_77973_b(), 2, is.func_77952_i()), 1.0f);
                    ConfigRecipes.oreDictRecipe(is, new Object[]{"###", "###", "###", Character.valueOf('#'), new ItemStack(ItemsTC.nuggets, 1, 3)});
                }
                continue;
            }
            if (!ore.equals("ingotLead")) continue;
            boolean first = true;
            for (ItemStack is : OreDictionary.getOres((String)ore, (boolean)false)) {
                if (is.field_77994_a > 1) {
                    is.field_77994_a = 1;
                }
                foundLeadIngot = true;
                CraftingManager.func_77594_a().func_92103_a(new ItemStack(ItemsTC.nuggets, 9, 4), new Object[]{"#", Character.valueOf('#'), is});
                if (!first) continue;
                first = false;
                FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(ItemsTC.clusters, 1, 5), new ItemStack(is.func_77973_b(), 2, is.func_77952_i()), 1.0f);
                ConfigRecipes.oreDictRecipe(is, new Object[]{"###", "###", "###", Character.valueOf('#'), new ItemStack(ItemsTC.nuggets, 1, 4)});
            }
        }
        Thaumcraft.log.info("Adding entities to MFR safari net blacklist.");
        Config.registerSafariNetBlacklist(EntityOwnedConstruct.class);
        Config.registerSafariNetBlacklist(EntityFallingTaint.class);
        Config.registerSafariNetBlacklist(EntityWisp.class);
        Config.registerSafariNetBlacklist(EntityPech.class);
        Config.registerSafariNetBlacklist(EntityEldritchGuardian.class);
        Config.registerSafariNetBlacklist(EntityEldritchWarden.class);
        Config.registerSafariNetBlacklist(EntityEldritchGolem.class);
        Config.registerSafariNetBlacklist(EntityCultistCleric.class);
        Config.registerSafariNetBlacklist(EntityCultistKnight.class);
        Config.registerSafariNetBlacklist(EntityCultistLeader.class);
        Config.registerSafariNetBlacklist(EntityCultistPortalGreater.class);
        Config.registerSafariNetBlacklist(EntityCultistPortalLesser.class);
        Config.registerSafariNetBlacklist(EntityEldritchCrab.class);
        Config.registerSafariNetBlacklist(EntityInhabitedZombie.class);
    }

    public static void registerSafariNetBlacklist(Class<?> blacklistedEntity) {
        try {
            Class<?> registry = Class.forName("powercrystals.minefactoryreloaded.MFRRegistry");
            if (registry != null) {
                Method reg = registry.getMethod("registerSafariNetBlacklist", Class.class);
                reg.invoke(registry, blacklistedEntity);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void postInitMisc() {
        for (Item item : GameData.getItemRegistry().typeSafeIterable()) {
            IBlockState bs;
            if (item == null || !(item instanceof IPlantable) || (bs = ((IPlantable)item).getPlant(null, null)) == null) continue;
            ThaumcraftApi.registerSeed(bs.func_177230_c(), new ItemStack(item));
        }
        CropUtils.addStandardCrop(Blocks.field_150440_ba, Short.MAX_VALUE);
        CropUtils.addStandardCrop(Blocks.field_150423_aK, Short.MAX_VALUE);
        CropUtils.addStackedCrop((Block)Blocks.field_150436_aH, Short.MAX_VALUE);
        CropUtils.addStackedCrop((Block)Blocks.field_150434_aF, Short.MAX_VALUE);
        CropUtils.addStandardCrop(Blocks.field_150388_bm, 3);
        ThaumcraftApi.registerSeed(Blocks.field_150375_by, new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BROWN.func_176767_b()));
        Utils.addSpecialMiningResult(new ItemStack(Blocks.field_150366_p), new ItemStack(ItemsTC.clusters, 1, 0), 1.0f);
        Utils.addSpecialMiningResult(new ItemStack(Blocks.field_150352_o), new ItemStack(ItemsTC.clusters, 1, 1), 1.0f);
        Utils.addSpecialMiningResult(new ItemStack(BlocksTC.oreCinnabar), new ItemStack(ItemsTC.clusters, 1, 6), 1.0f);
        Utils.addSpecialMiningResult(new ItemStack(Items.field_151128_bU), new ItemStack(ItemsTC.clusters, 1, 7), 1.0f);
        Collection<Aspect> pa = Aspect.aspects.values();
        for (Aspect aspect : pa) {
            aspectOrder.add(aspect);
        }
    }

    static {
        overworldDim = 0;
        biomeMagicalForestID = 193;
        biomeEerieID = 194;
        biomeEldritchID = 195;
        biomeMagicalForestWeight = 5;
        taintSpreadRate = 1.0f;
        taintSpreadArea = 32;
        wuss = false;
        dimensionOuterId = -42;
        championMobs = true;
        oreDensity = 100;
        shieldRecharge = 2000;
        shieldWait = 4000;
        shieldCost = 1;
        largeTagText = false;
        colorBlind = false;
        shaders = true;
        nostress = false;
        crooked = true;
        showTags = false;
        blueBiome = false;
        dialBottom = false;
        showGolemEmotes = true;
        nodeRefresh = 10;
        genAura = true;
        genStructure = true;
        genCinnibar = true;
        genQuartz = true;
        genAmber = true;
        genCrystals = true;
        genTrees = true;
        genMagicForest = true;
        regenAura = false;
        regenStructure = false;
        regenQuartz = false;
        regenCinnibar = false;
        regenAmber = false;
        regenCrystals = false;
        regenTrees = false;
        regenKey = "DEFAULT";
        allowCheatSheet = true;
        golemChestInteract = true;
        nodeRarity = 33;
        specialNodeRarity = 10;
        chargeBarPos = 0;
        researchDifficulty = 0;
        CallowCheatSheet = true;
        ChardNode = true;
        Cwuss = false;
        CresearchDifficulty = 0;
        spawnAngryZombie = true;
        spawnFireBat = true;
        spawnTaintacle = true;
        spawnWisp = true;
        spawnPech = true;
        spawnElder = true;
        aspectOrder = new ArrayList();
        foundCopperIngot = false;
        foundTinIngot = false;
        foundSilverIngot = false;
        foundLeadIngot = false;
        foundCopperOre = false;
        foundTinOre = false;
        foundSilverOre = false;
        foundLeadOre = false;
    }

    public static class ConfigChangeListener {
        @SubscribeEvent
        public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
            if (eventArgs.getModID().equals("thaumcraft")) {
                Config.syncConfigurable();
                if (config != null && config.hasChanged()) {
                    Config.save();
                }
            }
        }
    }
}

