/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.config;

import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.blocks.BlockTC;
import thaumcraft.common.blocks.IBlockTypes;
import thaumcraft.common.blocks.ItemBlockTC;
import thaumcraft.common.blocks.basic.BlockBannerTC;
import thaumcraft.common.blocks.basic.BlockBannerTCItem;
import thaumcraft.common.blocks.basic.BlockCandle;
import thaumcraft.common.blocks.basic.BlockMetalTC;
import thaumcraft.common.blocks.basic.BlockPavingStone;
import thaumcraft.common.blocks.basic.BlockPillar;
import thaumcraft.common.blocks.basic.BlockPlanksTC;
import thaumcraft.common.blocks.basic.BlockStairsTC;
import thaumcraft.common.blocks.basic.BlockStonePorous;
import thaumcraft.common.blocks.basic.BlockStoneSlabTC;
import thaumcraft.common.blocks.basic.BlockStoneSlabTCItem;
import thaumcraft.common.blocks.basic.BlockStoneTC;
import thaumcraft.common.blocks.basic.BlockTable;
import thaumcraft.common.blocks.basic.BlockTranslucent;
import thaumcraft.common.blocks.basic.BlockWoodSlabTC;
import thaumcraft.common.blocks.basic.BlockWoodSlabTCItem;
import thaumcraft.common.blocks.crafting.BlockArcaneWorkbench;
import thaumcraft.common.blocks.crafting.BlockArcaneWorkbenchCharger;
import thaumcraft.common.blocks.crafting.BlockCrucible;
import thaumcraft.common.blocks.crafting.BlockFocalManipulator;
import thaumcraft.common.blocks.crafting.BlockGolemBuilder;
import thaumcraft.common.blocks.crafting.BlockInfusionMatrix;
import thaumcraft.common.blocks.crafting.BlockPatternCrafter;
import thaumcraft.common.blocks.crafting.BlockResearchTable;
import thaumcraft.common.blocks.crafting.BlockThaumatorium;
import thaumcraft.common.blocks.devices.BlockArcaneEar;
import thaumcraft.common.blocks.devices.BlockBellows;
import thaumcraft.common.blocks.devices.BlockBrainBox;
import thaumcraft.common.blocks.devices.BlockDioptra;
import thaumcraft.common.blocks.devices.BlockHungryChest;
import thaumcraft.common.blocks.devices.BlockInfernalFurnace;
import thaumcraft.common.blocks.devices.BlockLamp;
import thaumcraft.common.blocks.devices.BlockLevitator;
import thaumcraft.common.blocks.devices.BlockMirror;
import thaumcraft.common.blocks.devices.BlockMirrorItem;
import thaumcraft.common.blocks.devices.BlockPedestal;
import thaumcraft.common.blocks.devices.BlockRechargePedestal;
import thaumcraft.common.blocks.devices.BlockRedstoneRelay;
import thaumcraft.common.blocks.devices.BlockSpa;
import thaumcraft.common.blocks.devices.BlockWaterJug;
import thaumcraft.common.blocks.essentia.BlockAlembic;
import thaumcraft.common.blocks.essentia.BlockCentrifuge;
import thaumcraft.common.blocks.essentia.BlockEssentiaTransport;
import thaumcraft.common.blocks.essentia.BlockJar;
import thaumcraft.common.blocks.essentia.BlockJarBrainItem;
import thaumcraft.common.blocks.essentia.BlockJarItem;
import thaumcraft.common.blocks.essentia.BlockSmelter;
import thaumcraft.common.blocks.essentia.BlockSmelterAux;
import thaumcraft.common.blocks.essentia.BlockSmelterVent;
import thaumcraft.common.blocks.essentia.BlockTube;
import thaumcraft.common.blocks.misc.BlockBarrier;
import thaumcraft.common.blocks.misc.BlockEffect;
import thaumcraft.common.blocks.misc.BlockFluidDeath;
import thaumcraft.common.blocks.misc.BlockFluidPure;
import thaumcraft.common.blocks.misc.BlockHole;
import thaumcraft.common.blocks.misc.BlockNitor;
import thaumcraft.common.blocks.misc.BlockPlaceholder;
import thaumcraft.common.blocks.world.BlockGrassAmbient;
import thaumcraft.common.blocks.world.BlockLoot;
import thaumcraft.common.blocks.world.ore.BlockCrystal;
import thaumcraft.common.blocks.world.ore.BlockCrystalItem;
import thaumcraft.common.blocks.world.ore.BlockOreTC;
import thaumcraft.common.blocks.world.ore.ShardType;
import thaumcraft.common.blocks.world.plants.BlockLeavesTC;
import thaumcraft.common.blocks.world.plants.BlockLeavesTCItem;
import thaumcraft.common.blocks.world.plants.BlockLogsTC;
import thaumcraft.common.blocks.world.plants.BlockPlantCinderpearl;
import thaumcraft.common.blocks.world.plants.BlockPlantShimmerleaf;
import thaumcraft.common.blocks.world.plants.BlockPlantVishroom;
import thaumcraft.common.blocks.world.plants.BlockSaplingTC;
import thaumcraft.common.blocks.world.plants.BlockSaplingTCItem;
import thaumcraft.common.blocks.world.taint.BlockFluxGoo;
import thaumcraft.common.blocks.world.taint.BlockTaint;
import thaumcraft.common.blocks.world.taint.BlockTaintFeature;
import thaumcraft.common.blocks.world.taint.BlockTaintFibre;
import thaumcraft.common.blocks.world.taint.BlockTaintLog;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.tiles.crafting.TileArcaneWorkbench;
import thaumcraft.common.tiles.crafting.TileCrucible;
import thaumcraft.common.tiles.crafting.TileFocalManipulator;
import thaumcraft.common.tiles.crafting.TileGolemBuilder;
import thaumcraft.common.tiles.crafting.TileInfusionMatrix;
import thaumcraft.common.tiles.crafting.TilePatternCrafter;
import thaumcraft.common.tiles.crafting.TilePedestal;
import thaumcraft.common.tiles.crafting.TileResearchTable;
import thaumcraft.common.tiles.crafting.TileThaumatorium;
import thaumcraft.common.tiles.crafting.TileThaumatoriumTop;
import thaumcraft.common.tiles.devices.TileArcaneEar;
import thaumcraft.common.tiles.devices.TileBellows;
import thaumcraft.common.tiles.devices.TileDioptra;
import thaumcraft.common.tiles.devices.TileHungryChest;
import thaumcraft.common.tiles.devices.TileInfernalFurnace;
import thaumcraft.common.tiles.devices.TileJarBrain;
import thaumcraft.common.tiles.devices.TileLampArcane;
import thaumcraft.common.tiles.devices.TileLampFertility;
import thaumcraft.common.tiles.devices.TileLampGrowth;
import thaumcraft.common.tiles.devices.TileLevitator;
import thaumcraft.common.tiles.devices.TileMirror;
import thaumcraft.common.tiles.devices.TileMirrorEssentia;
import thaumcraft.common.tiles.devices.TileRechargePedestal;
import thaumcraft.common.tiles.devices.TileRedstoneRelay;
import thaumcraft.common.tiles.devices.TileSpa;
import thaumcraft.common.tiles.devices.TileWaterJug;
import thaumcraft.common.tiles.essentia.TileAlembic;
import thaumcraft.common.tiles.essentia.TileCentrifuge;
import thaumcraft.common.tiles.essentia.TileEssentiaInput;
import thaumcraft.common.tiles.essentia.TileEssentiaOutput;
import thaumcraft.common.tiles.essentia.TileJarFillable;
import thaumcraft.common.tiles.essentia.TileJarFillableVoid;
import thaumcraft.common.tiles.essentia.TileSmelter;
import thaumcraft.common.tiles.essentia.TileTube;
import thaumcraft.common.tiles.essentia.TileTubeBuffer;
import thaumcraft.common.tiles.essentia.TileTubeFilter;
import thaumcraft.common.tiles.essentia.TileTubeOneway;
import thaumcraft.common.tiles.essentia.TileTubeRestrict;
import thaumcraft.common.tiles.essentia.TileTubeValve;
import thaumcraft.common.tiles.misc.TileBanner;
import thaumcraft.common.tiles.misc.TileBarrierStone;
import thaumcraft.common.tiles.misc.TileHole;
import thaumcraft.common.tiles.misc.TileNitor;

public class ConfigBlocks {
    static ArrayList<Block> blocks = new ArrayList();

    public static void preInit() {
        ConfigBlocks.initializeBlocks();
        ConfigBlocks.registerTileEntities();
        BlocksTC.oreAmber.setHarvestLevel("pickaxe", 1);
        BlocksTC.oreCinnabar.setHarvestLevel("pickaxe", 2);
        BlockUtils.portableHoleBlackList.add("minecraft:bed");
        BlockUtils.portableHoleBlackList.add("minecraft:piston");
        BlockUtils.portableHoleBlackList.add("minecraft:piston_head");
        BlockUtils.portableHoleBlackList.add("minecraft:sticky_piston");
        BlockUtils.portableHoleBlackList.add("minecraft:piston_extension");
        BlockUtils.portableHoleBlackList.add("minecraft:wooden_door");
        BlockUtils.portableHoleBlackList.add("minecraft:spruce_door");
        BlockUtils.portableHoleBlackList.add("minecraft:birch_door");
        BlockUtils.portableHoleBlackList.add("minecraft:jungle_door");
        BlockUtils.portableHoleBlackList.add("minecraft:acacia_door");
        BlockUtils.portableHoleBlackList.add("minecraft:dark_oak_door");
        BlockUtils.portableHoleBlackList.add("minecraft:iron_door");
        BlockUtils.portableHoleBlackList.add("thaumcraft:infernal_furnace");
    }

    private static void initializeBlocks() {
        BlocksTC.oreAmber = ConfigBlocks.initBlock(new BlockOreTC(), "ore_amber").func_149711_c(1.5f);
        BlocksTC.oreCinnabar = ConfigBlocks.initBlock(new BlockOreTC(), "ore_cinnabar").func_149711_c(2.0f);
        BlocksTC.oreQuartz = ConfigBlocks.initBlock(new BlockOreTC(), "ore_quartz").func_149711_c(3.0f);
        BlocksTC.crystalAir = ConfigBlocks.initBlock(new BlockCrystal(Aspect.AIR), "crystal_aer", BlockCrystalItem.class);
        BlocksTC.crystalFire = ConfigBlocks.initBlock(new BlockCrystal(Aspect.FIRE), "crystal_ignis", BlockCrystalItem.class);
        BlocksTC.crystalWater = ConfigBlocks.initBlock(new BlockCrystal(Aspect.WATER), "crystal_aqua", BlockCrystalItem.class);
        BlocksTC.crystalEarth = ConfigBlocks.initBlock(new BlockCrystal(Aspect.EARTH), "crystal_terra", BlockCrystalItem.class);
        BlocksTC.crystalOrder = ConfigBlocks.initBlock(new BlockCrystal(Aspect.ORDER), "crystal_ordo", BlockCrystalItem.class);
        BlocksTC.crystalEntropy = ConfigBlocks.initBlock(new BlockCrystal(Aspect.ENTROPY), "crystal_perditio", BlockCrystalItem.class);
        BlocksTC.crystalTaint = ConfigBlocks.initBlock(new BlockCrystal(Aspect.FLUX), "crystal_vitium", BlockCrystalItem.class);
        ShardType.AIR.setOre(BlocksTC.crystalAir);
        ShardType.FIRE.setOre(BlocksTC.crystalFire);
        ShardType.WATER.setOre(BlocksTC.crystalWater);
        ShardType.EARTH.setOre(BlocksTC.crystalEarth);
        ShardType.ORDER.setOre(BlocksTC.crystalOrder);
        ShardType.ENTROPY.setOre(BlocksTC.crystalEntropy);
        ShardType.FLUX.setOre(BlocksTC.crystalTaint);
        BlocksTC.stoneArcane = ConfigBlocks.initBlock(new BlockStoneTC(true), "stone_arcane");
        BlocksTC.stoneArcaneBrick = ConfigBlocks.initBlock(new BlockStoneTC(true), "stone_arcane_brick");
        BlocksTC.stoneAncient = ConfigBlocks.initBlock(new BlockStoneTC(true), "stone_ancient");
        BlocksTC.stoneAncientTile = ConfigBlocks.initBlock(new BlockStoneTC(false), "stone_ancient_tile");
        BlocksTC.stoneAncientRock = ConfigBlocks.initBlock((BlockTC)new BlockStoneTC(false).func_149711_c(-1.0f), "stone_ancient_rock");
        BlocksTC.stoneAncientGlyphed = ConfigBlocks.initBlock(new BlockStoneTC(false), "stone_ancient_glyphed");
        BlocksTC.stoneAncientDoorway = ConfigBlocks.initBlock((BlockTC)new BlockStoneTC(false).func_149711_c(-1.0f), "stone_ancient_doorway");
        BlocksTC.stoneEldritchTile = ConfigBlocks.initBlock((BlockTC)new BlockStoneTC(true).func_149711_c(15.0f).func_149752_b(1000.0f), "stone_eldritch_tile");
        BlocksTC.stonePorous = ConfigBlocks.initBlock(new BlockStonePorous(), "stone_porous");
        BlocksTC.stairsArcane = ConfigBlocks.initBlock((Block)new BlockStairsTC(BlocksTC.stoneArcane.func_176223_P()), "arcane_stairs", ItemBlock.class);
        BlocksTC.stairsArcaneBrick = ConfigBlocks.initBlock((Block)new BlockStairsTC(BlocksTC.stoneArcaneBrick.func_176223_P()), "arcane_brick_stairs", ItemBlock.class);
        BlocksTC.stairsAncient = ConfigBlocks.initBlock((Block)new BlockStairsTC(BlocksTC.stoneAncient.func_176223_P()), "ancient_stairs", ItemBlock.class);
        BlocksTC.slabStone = new BlockStoneSlabTC().func_149711_c(2.0f).func_149752_b(10.0f);
        BlocksTC.doubleSlabStone = new BlockStoneSlabTC().func_149711_c(2.0f).func_149752_b(10.0f);
        BlocksTC.slabStone = ConfigBlocks.initBlock(BlocksTC.slabStone, "slab_stone", BlockStoneSlabTCItem.class);
        BlocksTC.doubleSlabStone = ConfigBlocks.initBlock(BlocksTC.doubleSlabStone, "slab_stone_double", null);
        BlocksTC.sapling = ConfigBlocks.initBlock((Block)new BlockSaplingTC(), "sapling", BlockSaplingTCItem.class);
        BlocksTC.log = ConfigBlocks.initBlock(new BlockLogsTC(), "log");
        BlocksTC.leaf = ConfigBlocks.initBlock((Block)new BlockLeavesTC(), "leaf", BlockLeavesTCItem.class);
        BlocksTC.shimmerleaf = ConfigBlocks.initBlock((Block)new BlockPlantShimmerleaf(), "shimmerleaf", ItemBlock.class);
        BlocksTC.cinderpearl = ConfigBlocks.initBlock((Block)new BlockPlantCinderpearl(), "cinderpearl", ItemBlock.class);
        BlocksTC.vishroom = ConfigBlocks.initBlock((Block)new BlockPlantVishroom(), "vishroom", ItemBlock.class);
        BlocksTC.plank = ConfigBlocks.initBlock(new BlockPlanksTC(), "plank");
        BlocksTC.stairsGreatwood = ConfigBlocks.initBlock((Block)new BlockStairsTC(BlocksTC.plank.func_176203_a(0)), "greatwood_stairs", ItemBlock.class);
        BlocksTC.stairsSilverwood = ConfigBlocks.initBlock((Block)new BlockStairsTC(BlocksTC.plank.func_176203_a(1)), "silverwood_stairs", ItemBlock.class);
        BlocksTC.slabWood = new BlockWoodSlabTC().func_149711_c(2.0f).func_149752_b(5.0f);
        BlocksTC.doubleSlabWood = new BlockWoodSlabTC().func_149711_c(2.0f).func_149752_b(5.0f);
        BlocksTC.slabWood = ConfigBlocks.initBlock(BlocksTC.slabWood, "slab_wood", BlockWoodSlabTCItem.class);
        BlocksTC.doubleSlabWood = ConfigBlocks.initBlock(BlocksTC.doubleSlabWood, "slab_wood_double", null);
        BlocksTC.translucent = ConfigBlocks.initBlock(new BlockTranslucent(), "translucent");
        BlocksTC.fleshBlock = ConfigBlocks.initBlock(new BlockTC(Material.field_151583_m, SoundsTC.GORE), "flesh_block").func_149711_c(0.25f);
        BlocksTC.lootCrate = ConfigBlocks.initBlock(new BlockLoot(Material.field_151575_d, SoundType.field_185848_a), "loot_crate");
        BlocksTC.lootUrn = ConfigBlocks.initBlock(new BlockLoot(Material.field_151576_e, SoundsTC.URN), "loot_urn");
        BlocksTC.taintFibre = ConfigBlocks.initBlock(new BlockTaintFibre(), "taint_fibre", BlockCrystalItem.class);
        BlocksTC.taintBlock = ConfigBlocks.initBlock(new BlockTaint(), "taint");
        BlocksTC.taintFeature = ConfigBlocks.initBlock(new BlockTaintFeature(), "taint_feature");
        BlocksTC.taintLog = ConfigBlocks.initBlock(new BlockTaintLog(), "taint_log");
        BlocksTC.grassAmbient = ConfigBlocks.initBlock((Block)new BlockGrassAmbient(), "grass_ambient", ItemBlock.class);
        BlocksTC.tableWood = ConfigBlocks.initBlock(new BlockTable(Material.field_151575_d, SoundType.field_185848_a), "table_wood").func_149711_c(2.0f);
        BlocksTC.tableStone = ConfigBlocks.initBlock(new BlockTable(Material.field_151576_e, SoundType.field_185851_d), "table_stone").func_149711_c(2.5f);
        BlocksTC.candle = ConfigBlocks.initBlock(new BlockCandle(), "candle");
        BlocksTC.nitor = ConfigBlocks.initBlock(new BlockNitor(), "nitor");
        BlocksTC.pedestal = ConfigBlocks.initBlock(new BlockPedestal(), "pedestal");
        BlocksTC.metal = ConfigBlocks.initBlock(new BlockMetalTC(), "metal");
        BlocksTC.pavingStone = ConfigBlocks.initBlock(new BlockPavingStone(), "paving_stone");
        BlocksTC.barrier = ConfigBlocks.initBlock(new BlockBarrier(), "barrier", ItemBlock.class);
        BlocksTC.pillar = ConfigBlocks.initBlock(new BlockPillar(), "pillar");
        BlocksTC.banner = ConfigBlocks.initBlock(new BlockBannerTC(), "banner", BlockBannerTCItem.class);
        BlocksTC.matrixSpeed = ConfigBlocks.initBlock(new BlockStoneTC(false), "matrix_speed");
        BlocksTC.matrixCost = ConfigBlocks.initBlock(new BlockStoneTC(false), "matrix_cost");
        BlocksTC.arcaneWorkbench = ConfigBlocks.initBlock(new BlockArcaneWorkbench(), "arcane_workbench");
        BlocksTC.arcaneWorkbenchCharger = ConfigBlocks.initBlock(new BlockArcaneWorkbenchCharger(), "arcane_workbench_charger");
        BlocksTC.dioptra = ConfigBlocks.initBlock(new BlockDioptra(), "dioptra");
        BlocksTC.researchTable = ConfigBlocks.initBlock(new BlockResearchTable(), "research_table");
        BlocksTC.crucible = ConfigBlocks.initBlock(new BlockCrucible(), "crucible");
        BlocksTC.arcaneEar = ConfigBlocks.initBlock(new BlockArcaneEar(), "arcane_ear");
        BlocksTC.lampArcane = ConfigBlocks.initBlock(new BlockLamp(TileLampArcane.class), "lamp_arcane");
        BlocksTC.lampFertility = ConfigBlocks.initBlock(new BlockLamp(TileLampFertility.class), "lamp_fertility");
        BlocksTC.lampGrowth = ConfigBlocks.initBlock(new BlockLamp(TileLampGrowth.class), "lamp_growth");
        BlocksTC.levitator = ConfigBlocks.initBlock(new BlockLevitator(), "levitator");
        BlocksTC.centrifuge = ConfigBlocks.initBlock(new BlockCentrifuge(), "centrifuge");
        BlocksTC.bellows = ConfigBlocks.initBlock(new BlockBellows(), "bellows");
        BlocksTC.smelterBasic = ConfigBlocks.initBlock(new BlockSmelter(), "smelter_basic");
        BlocksTC.smelterThaumium = ConfigBlocks.initBlock(new BlockSmelter(), "smelter_thaumium");
        BlocksTC.smelterVoid = ConfigBlocks.initBlock(new BlockSmelter(), "smelter_void");
        BlocksTC.smelterAux = ConfigBlocks.initBlock(new BlockSmelterAux(), "smelter_aux");
        BlocksTC.smelterVent = ConfigBlocks.initBlock(new BlockSmelterVent(), "smelter_vent");
        BlocksTC.alembic = ConfigBlocks.initBlock(new BlockAlembic(), "alembic");
        BlocksTC.rechargePedestal = ConfigBlocks.initBlock(new BlockRechargePedestal(), "recharge_pedestal");
        BlocksTC.wandWorkbench = ConfigBlocks.initBlock(new BlockFocalManipulator(), "wand_workbench");
        BlocksTC.hungryChest = new BlockHungryChest();
        BlocksTC.hungryChest = ConfigBlocks.initBlock(BlocksTC.hungryChest, "hungry_chest", ItemBlock.class);
        BlocksTC.tube = ConfigBlocks.initBlock(new BlockTube(TileTube.class), "tube");
        BlocksTC.tubeValve = ConfigBlocks.initBlock(new BlockTube(TileTubeValve.class), "tube_valve");
        BlocksTC.tubeRestrict = ConfigBlocks.initBlock(new BlockTube(TileTubeRestrict.class), "tube_restrict");
        BlocksTC.tubeOneway = ConfigBlocks.initBlock(new BlockTube(TileTubeOneway.class), "tube_oneway");
        BlocksTC.tubeFilter = ConfigBlocks.initBlock(new BlockTube(TileTubeFilter.class), "tube_filter");
        BlocksTC.tubeBuffer = ConfigBlocks.initBlock(new BlockTube(TileTubeBuffer.class), "tube_buffer");
        BlocksTC.jarNormal = ConfigBlocks.initBlock(new BlockJar(TileJarFillable.class), "jar_normal", BlockJarItem.class);
        BlocksTC.jarVoid = ConfigBlocks.initBlock(new BlockJar(TileJarFillableVoid.class), "jar_void", BlockJarItem.class);
        BlocksTC.jarBrain = ConfigBlocks.initBlock(new BlockJar(TileJarBrain.class), "jar_brain", BlockJarBrainItem.class);
        BlocksTC.infusionMatrix = ConfigBlocks.initBlock(new BlockInfusionMatrix(), "infusion_matrix");
        BlocksTC.infernalFurnace = ConfigBlocks.initBlock(new BlockInfernalFurnace(), "infernal_furnace");
        BlocksTC.everfullUrn = ConfigBlocks.initBlock(new BlockWaterJug(), "everfull_urn");
        BlocksTC.thaumatorium = ConfigBlocks.initBlock(new BlockThaumatorium(false), "thaumatorium");
        BlocksTC.thaumatoriumTop = ConfigBlocks.initBlock(new BlockThaumatorium(true), "thaumatorium_top");
        BlocksTC.brainBox = ConfigBlocks.initBlock(new BlockBrainBox(), "brain_box");
        BlocksTC.spa = ConfigBlocks.initBlock(new BlockSpa(), "spa");
        BlocksTC.golemBuilder = ConfigBlocks.initBlock(new BlockGolemBuilder(), "golem_builder");
        BlocksTC.mirror = ConfigBlocks.initBlock(new BlockMirror(TileMirror.class), "mirror", BlockMirrorItem.class);
        BlocksTC.mirrorEssentia = ConfigBlocks.initBlock(new BlockMirror(TileMirrorEssentia.class), "mirror_essentia", BlockMirrorItem.class);
        BlocksTC.essentiaTransportInput = ConfigBlocks.initBlock(new BlockEssentiaTransport(TileEssentiaInput.class), "essentia_input");
        BlocksTC.essentiaTransportOutput = ConfigBlocks.initBlock(new BlockEssentiaTransport(TileEssentiaOutput.class), "essentia_output");
        BlocksTC.redstoneRelay = ConfigBlocks.initBlock(new BlockRedstoneRelay(), "redstone_relay");
        BlocksTC.patternCrafter = ConfigBlocks.initBlock(new BlockPatternCrafter(), "pattern_crafter");
        BlocksTC.activatorRail = ConfigBlocks.initBlock(new BlockRailPowered().func_149711_c(0.7f).func_149647_a(ConfigItems.TABTC).func_149663_c("activator_rail"), "activator_rail", ItemBlock.class);
        FluidRegistry.registerFluid((Fluid)FluidFluxGoo.instance);
        BlocksTC.fluxGoo = new BlockFluxGoo();
        GameRegistry.registerBlock((Block)BlocksTC.fluxGoo, (String)"flux_goo");
        FluidRegistry.registerFluid((Fluid)FluidDeath.instance);
        BlocksTC.liquidDeath = new BlockFluidDeath();
        GameRegistry.registerBlock((Block)BlocksTC.liquidDeath, (String)"liquid_death");
        FluidRegistry.registerFluid((Fluid)FluidPure.instance);
        BlocksTC.purifyingFluid = new BlockFluidPure();
        GameRegistry.registerBlock((Block)BlocksTC.purifyingFluid, (String)"purifying_fluid");
        BlocksTC.hole = ConfigBlocks.initBlock((Block)new BlockHole(), "hole", ItemBlock.class);
        BlocksTC.effect = ConfigBlocks.initBlock(new BlockEffect(), "effect");
        BlocksTC.placeholder = ConfigBlocks.initBlock(new BlockPlaceholder(), "placeholder");
    }

    private static void registerTileEntities() {
        GameRegistry.registerTileEntity(TileArcaneWorkbench.class, (String)"thaumcraft:TileArcaneWorkbench");
        GameRegistry.registerTileEntity(TileDioptra.class, (String)"thaumcraft:TileDioptra");
        GameRegistry.registerTileEntity(TileArcaneEar.class, (String)"thaumcraft:TileArcaneEar");
        GameRegistry.registerTileEntity(TileLevitator.class, (String)"thaumcraft:TileLevitator");
        GameRegistry.registerTileEntity(TileCrucible.class, (String)"thaumcraft:TileCrucible");
        GameRegistry.registerTileEntity(TileNitor.class, (String)"thaumcraft:TileNitor");
        GameRegistry.registerTileEntity(TileFocalManipulator.class, (String)"thaumcraft:TileFocalManipulator");
        GameRegistry.registerTileEntity(TilePedestal.class, (String)"thaumcraft:TilePedestal");
        GameRegistry.registerTileEntity(TileRechargePedestal.class, (String)"thaumcraft:TileRechargePedestal");
        GameRegistry.registerTileEntity(TileResearchTable.class, (String)"thaumcraft:TileResearchTable");
        GameRegistry.registerTileEntity(TileTube.class, (String)"thaumcraft:TileTube");
        GameRegistry.registerTileEntity(TileTubeValve.class, (String)"thaumcraft:TileTubeValve");
        GameRegistry.registerTileEntity(TileTubeFilter.class, (String)"thaumcraft:TileTubeFilter");
        GameRegistry.registerTileEntity(TileTubeRestrict.class, (String)"thaumcraft:TileTubeRestrict");
        GameRegistry.registerTileEntity(TileTubeOneway.class, (String)"thaumcraft:TileTubeOneway");
        GameRegistry.registerTileEntity(TileTubeBuffer.class, (String)"thaumcraft:TileTubeBuffer");
        GameRegistry.registerTileEntity(TileHungryChest.class, (String)"thaumcraft:TileChestHungry");
        GameRegistry.registerTileEntity(TileCentrifuge.class, (String)"thaumcraft:TileCentrifuge");
        GameRegistry.registerTileEntity(TileJarFillable.class, (String)"thaumcraft:TileJar");
        GameRegistry.registerTileEntity(TileJarFillableVoid.class, (String)"thaumcraft:TileJarVoid");
        GameRegistry.registerTileEntity(TileJarBrain.class, (String)"thaumcraft:TileJarBrain");
        GameRegistry.registerTileEntity(TileBellows.class, (String)"thaumcraft:TileBellows");
        GameRegistry.registerTileEntity(TileSmelter.class, (String)"thaumcraft:TileSmelter");
        GameRegistry.registerTileEntity(TileAlembic.class, (String)"thaumcraft:TileAlembic");
        GameRegistry.registerTileEntity(TileInfusionMatrix.class, (String)"thaumcraft:TileInfusionMatrix");
        GameRegistry.registerTileEntity(TileWaterJug.class, (String)"thaumcraft:TileWaterJug");
        GameRegistry.registerTileEntity(TileInfernalFurnace.class, (String)"thaumcraft:TileInfernalFurnace");
        GameRegistry.registerTileEntity(TileThaumatorium.class, (String)"thaumcraft:TileThaumatorium");
        GameRegistry.registerTileEntity(TileThaumatoriumTop.class, (String)"thaumcraft:TileThaumatoriumTop");
        GameRegistry.registerTileEntity(TileSpa.class, (String)"thaumcraft:TileSpa");
        GameRegistry.registerTileEntity(TileLampGrowth.class, (String)"thaumcraft:TileLampGrowth");
        GameRegistry.registerTileEntity(TileLampArcane.class, (String)"thaumcraft:TileLampArcane");
        GameRegistry.registerTileEntity(TileLampFertility.class, (String)"thaumcraft:TileLampFertility");
        GameRegistry.registerTileEntity(TileMirror.class, (String)"thaumcraft:TileMirror");
        GameRegistry.registerTileEntity(TileMirrorEssentia.class, (String)"thaumcraft:TileMirrorEssentia");
        GameRegistry.registerTileEntity(TileRedstoneRelay.class, (String)"thaumcraft:TileRedstoneRelay");
        GameRegistry.registerTileEntity(TileGolemBuilder.class, (String)"thaumcraft:TileGolemBuilder");
        GameRegistry.registerTileEntity(TileEssentiaInput.class, (String)"thaumcraft:TileEssentiaInput");
        GameRegistry.registerTileEntity(TileEssentiaOutput.class, (String)"thaumcraft:TileEssentiaOutput");
        GameRegistry.registerTileEntity(TilePatternCrafter.class, (String)"thaumcraft:TilePatternCrafter");
        GameRegistry.registerTileEntity(TileBanner.class, (String)"thaumcraft:TileBanner");
        GameRegistry.registerTileEntity(TileHole.class, (String)"thaumcraft:TileHole");
        GameRegistry.registerTileEntity(TileBarrierStone.class, (String)"thaumcraft:TileBarrierStone");
    }

    public static void init() {
    }

    public static void initModelsAndVariants() {
        for (Block block : blocks) {
            Item blockItem = Item.func_150898_a((Block)block);
            ResourceLocation loc = GameData.getBlockRegistry().getNameForObject((IForgeRegistryEntry)block);
            String location = loc.toString();
            if (block instanceof IBlockTypes && ((IBlockTypes)block).hasTypes()) {
                BlockStateContainer bsc = block.func_176194_O();
                IBlockState state = bsc.func_177621_b();
                for (IProperty prop : ((IBlockTypes)block).getTypes()) {
                    for (Object value : prop.func_177700_c()) {
                        int meta = block.func_180651_a(state);
                        String stateName = ((IBlockTypes)block).getTypeName(state);
                        String type = "type=" + stateName.toLowerCase(Locale.US);
                        ModelLoader.setCustomModelResourceLocation((Item)blockItem, (int)meta, (ModelResourceLocation)new ModelResourceLocation(location, type));
                        state = state.func_177231_a(prop);
                    }
                }
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)blockItem, (int)0, (ModelResourceLocation)new ModelResourceLocation(loc, "inventory"));
        }
    }

    private static Block initBlock(BlockTC block, String name) {
        return ConfigBlocks.initBlock(block, name, null, false);
    }

    private static Block initBlock(Block block, String name, Class ib) {
        return ConfigBlocks.initBlock(block, name, ib, false);
    }

    private static Block initBlock(Block block, String name, Class ib, boolean noReg) {
        if (!noReg) {
            blocks.add(block);
        }
        block.func_149663_c(name);
        if (ib != null) {
            ConfigBlocks.registerBlock(block, ib, name);
        } else if (block instanceof BlockTC && ((BlockTC)block).hasTypes()) {
            ConfigBlocks.registerBlock(block, ItemBlockTC.class, name);
        } else {
            ConfigBlocks.registerBlock(block, ItemBlock.class, name);
        }
        return block;
    }

    public static Block registerBlock(Block block, ItemBlock itemBlock, String name) {
        block = ConfigBlocks.register(block, name);
        ConfigBlocks.register(itemBlock, name);
        return block;
    }

    public static Block registerBlock(Block block, Class<? extends ItemBlock> itemBlock, String name) {
        try {
            return ConfigBlocks.registerBlock(block, itemBlock.getConstructor(Block.class).newInstance(block), name);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T extends IForgeRegistryEntry<?>> T register(T object, String name) {
        object.setRegistryName(new ResourceLocation("thaumcraft", name));
        return (T)GameRegistry.register(object);
    }

    public static final class FluidTaintDust
    extends Fluid {
        public static final String name = "taint_dust";
        public static final FluidTaintDust instance = new FluidTaintDust();

        private FluidTaintDust() {
            super(name, new ResourceLocation("thaumcraft:blocks/taint_dust"), new ResourceLocation("thaumcraft:blocks/taint_dust"));
            this.setViscosity(8000);
            this.setDensity(2000);
        }
    }

    public static final class FluidFluxGoo
    extends Fluid {
        public static final String name = "flux_goo";
        public static final FluidFluxGoo instance = new FluidFluxGoo();

        private FluidFluxGoo() {
            super(name, new ResourceLocation("thaumcraft:blocks/flux_goo"), new ResourceLocation("thaumcraft:blocks/flux_goo"));
            this.setViscosity(6000);
            this.setDensity(8);
        }
    }

    public static final class FluidDeath
    extends Fluid {
        public static final String name = "liquid_death";
        public static final FluidDeath instance = new FluidDeath();

        private FluidDeath() {
            super(name, new ResourceLocation("thaumcraft:blocks/animatedglow"), new ResourceLocation("thaumcraft:blocks/animatedglow"));
            this.setViscosity(1500);
            this.setRarity(EnumRarity.RARE);
        }

        public int getColor() {
            return -263978855;
        }
    }

    public static final class FluidPure
    extends Fluid {
        public static final String name = "purifying_fluid";
        public static final FluidPure instance = new FluidPure();

        private FluidPure() {
            super(name, new ResourceLocation("blocks/water_still"), new ResourceLocation("blocks/water_flow"));
            this.setLuminosity(5);
            this.setRarity(EnumRarity.RARE);
        }

        public int getColor() {
            return 2013252778;
        }
    }
}

